/*************************************************************************
 *
 *  $RCSfile: flstitem.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UCB_FOLDERLIST_HPP_
#include <com/sun/star/ucb/FolderList.hpp>
#endif

#ifndef CHAOS_FLSTITEM_HXX
#include <flstitem.hxx>
#endif

using namespace chaos;

//============================================================================
//
//  class CntFolderList
//
//============================================================================

sal_Bool CntFolderList::find(const String & rTitle, const String & rID,
							 ULONG & rIndex)
{
	ULONG nBegin = 0;
	ULONG nEnd = Count();
	for (;;)
	{
		rIndex = (nBegin + nEnd) / 2;
		if (nBegin == nEnd)
			break;
		switch (GetObject(rIndex)->Compare(rTitle, rID))
		{
			case COMPARE_EQUAL:
				return sal_True;

			case COMPARE_LESS:
				nEnd = rIndex;
				break;

			case COMPARE_GREATER:
				nBegin = rIndex + 1;
				break;
		}
	}
	return sal_False;
}

//============================================================================
void CntFolderList::Insert(CntFolderEntry * pEntry)
{
	ULONG nIndex;
	if (!find(*pEntry, pEntry->getID(), nIndex))
		List::Insert(pEntry, nIndex);
}

//============================================================================
void CntFolderList::SaveFlags()
{
	for (ULONG i = 0; i < Count(); ++i)
		GetObject(i)->SaveFlags();
}

//============================================================================
void CntFolderList::RestoreFlags()
{
	for (ULONG i = 0; i < Count(); ++i)
		GetObject(i)->RestoreFlags();
}

//============================================================================
//
//  class CntFolderListItem
//
//============================================================================

void CntFolderListItem::clear()
{
	if (m_pList)
		while (m_pList->Count() > 0)
			delete m_pList->Remove(m_pList->Count() - 1);
}

//============================================================================
TYPEINIT1(CntFolderListItem, SfxPoolItem);

//============================================================================
CntFolderListItem::CntFolderListItem(const CntFolderListItem & rItem):
	SfxPoolItem(rItem)
{
	m_eCommand = rItem.m_eCommand;
	if (rItem.m_pList)
	{
		m_pList = new CntFolderList;
		for (ULONG i = 0; i < rItem.m_pList->Count(); ++i)
			m_pList->Insert(new CntFolderEntry(*rItem.m_pList->GetObject(i)));
	}
	else
		m_pList = 0;
}

//============================================================================
// virtual
CntFolderListItem::~CntFolderListItem()
{
	clear();
	delete m_pList;
}

//============================================================================
// virtual
int	CntFolderListItem::operator ==(const SfxPoolItem & rItem) const
{
	const CntFolderListItem * pListItem = PTR_CAST(CntFolderListItem, &rItem);
	return pListItem && pListItem->m_eCommand == m_eCommand
	       && pListItem->m_pList == m_pList;
}

//============================================================================
// virtual
BOOL CntFolderListItem::QueryValue(com::sun::star::uno::Any& rVal, BYTE) const
{
	com::sun::star::ucb::FolderList aFolderList;
	switch (m_eCommand)
	{
		case GET:
			aFolderList.Command = com::sun::star::ucb::FolderListCommand_GET;
			break;

		case GET_SUBSCRIBED:
			aFolderList.Command =
				com::sun::star::ucb::FolderListCommand_GET_SUBSCRIBED;
			break;

		case SET:
		{
			ULONG nCount = m_pList ? m_pList->Count() : 0;
			if (nCount > 0x7FFFFFFF)
				return FALSE;
			aFolderList.Command = com::sun::star::ucb::FolderListCommand_SET;
			aFolderList.List.realloc(sal_Int32(nCount));
			com::sun::star::ucb::FolderListEntry * p
			= aFolderList.List.getArray();
			for (ULONG i = 0; i < nCount; ++i)
			{
				const CntFolderEntry * pEntry = m_pList->GetObject(i);
				p->Title = rtl::OUString(*pEntry);
				p->ID = pEntry->getID();
				p->Subscribed = pEntry->IsSubscribed();
				p->New = (pEntry->GetFlags() & CNTFOLDER_NEW) != 0;
				p->Removed = (pEntry->GetFlags() & CNTFOLDER_REMOVED) != 0;
				p->Purge = FALSE;
				++p;
			}
			break;
		}
	}
	rVal <<= aFolderList;
	return TRUE;
}

//============================================================================
// virtual
BOOL CntFolderListItem::PutValue(const com::sun::star::uno::Any& rVal, BYTE)
{
	com::sun::star::ucb::FolderList aFolderList;
	if ( rVal >>= aFolderList )
	{
		clear();
		delete m_pList;
		switch (aFolderList.Command)
		{
			case com::sun::star::ucb::FolderListCommand_GET:
				m_eCommand = GET;
				m_pList = 0;
				break;

			case com::sun::star::ucb::FolderListCommand_GET_SUBSCRIBED:
				m_eCommand = GET_SUBSCRIBED;
				m_pList = 0;
				break;

			case com::sun::star::ucb::FolderListCommand_SET:
			{
				m_eCommand = SET;
				m_pList = new CntFolderList;
				const com::sun::star::ucb::FolderListEntry * p
				= aFolderList.List.getConstArray();
				for (sal_Int32 nCount = aFolderList.List.getLength();
					 nCount-- > 0;
					 ++p)
				{
					CntFolderEntry * pEntry = new CntFolderEntry(p->Title,
																 p->ID);
					USHORT nFlags = p->Subscribed ? CNTFOLDER_SUBSCR : 0;
					if (p->New)
						nFlags |= CNTFOLDER_NEW;
					if (p->Removed)
						nFlags |= CNTFOLDER_REMOVED;
					if (p->Purge)
						nFlags |= CNTFOLDER_DO_PURGE;
					pEntry->SetFlags(nFlags);
					m_pList->Insert(pEntry);
				}
				break;
			}
		}

		return TRUE;
	}

	DBG_ERROR( "CntFolderListItem::PutValue - Wrong type!" );
	return FALSE;
}

