/*************************************************************************
 *
 *  $RCSfile: widsitem.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CHAOS_WIDSITEM_HXX
#define _CHAOS_WIDSITEM_HXX

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#ifndef _REF_HXX //autogen
#include <tools/ref.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

namespace chaos {

//============================================================================
class CntWIDRangesList: virtual public SvRefBase, public List
{};

//============================================================================
SV_DECL_IMPL_REF(CntWIDRangesList);

//============================================================================
class CntWIDSetItem: public SfxPoolItem
{
	friend class CntWIDSetItemIterator;

	CntWIDRangesListRef m_xRanges;

#if defined DBG_UTIL
	BOOL checkRanges() const;
#endif // DBG_UTIL

	inline void modifyRanges();
	void addRange_Impl(USHORT nLowerBound, USHORT nUpperBound);

public:
	TYPEINFO();

	CntWIDSetItem(USHORT nWhich = 0): SfxPoolItem(nWhich) {}
	 // create a set containing all WIDs from WID_CHAOS_START to WID_CHAOS_END
	CntWIDSetItem(USHORT nWhich, const USHORT * pRanges);
	 // create a set containing just the WIDs in the ranges

	virtual int operator ==(const SfxPoolItem & rItem) const;

	virtual SfxPoolItem * Create(SvStream & rStream, USHORT) const;
	virtual SvStream & Store(SvStream & rStream, USHORT) const;
	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const;
	virtual	BOOL QueryValue(com::sun::star::uno::Any& rVal,
							BYTE nMemberId = 0) const;
	virtual	BOOL PutValue(const com::sun::star::uno::Any& rVal,
						  BYTE nMemberId = 0);

	inline void addRange(USHORT nLowerBound, USHORT nUpperBound);
	void addRanges(const USHORT * pRanges);
	void addElement(USHORT nElement) { addRange(nElement, nElement); }
	void addElements(const USHORT * pElements);
	void addElements(ULONG nCount, const USHORT * pElements);

	BOOL isFullRanges() const;
	BOOL contains(USHORT nWID) const;
};

inline void CntWIDSetItem::modifyRanges()
{
	if (m_xRanges->GetRefCount() > 1)
		m_xRanges = new CntWIDRangesList(*m_xRanges);
}

inline void CntWIDSetItem::addRange(USHORT nLowerBound, USHORT nUpperBound)
{
	if (m_xRanges.Is())
	{
		modifyRanges();
		addRange_Impl(nLowerBound, nUpperBound);
	}
}

//============================================================================
class CntWIDSetItemIterator
{
	CntWIDSetItem & m_rItem;
	ULONG m_nIndex;
	USHORT m_nWID;

public:
	CntWIDSetItemIterator(CntWIDSetItem & rTheItem);

	USHORT getNext();
};

}

#endif // _CHAOS_WIDSITEM_HXX

