/*************************************************************************
 *
 *  $RCSfile: imapmitm.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CHAOS_IMAPMITM_HXX
#define _CHAOS_IMAPMITM_HXX

#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

namespace chaos {

//============================================================================
class CntIMAPMboxDataItem: public SfxPoolItem
{
	UINT32 m_nUIDValidity;
	UINT8 m_naHierarchySeparator;
	BOOL m_bHasData;
	BOOL m_bFlagInferiors;
	BOOL m_bFlagSelect;

public:
	TYPEINFO();

	/** Default constructor.

		Set all members to 'null' (except for a specified 'which ID').
	 */
	inline CntIMAPMboxDataItem(USHORT nWhich = 0);

	/** Copy constructor.

		@param rMboxData Some instance to copy from.
	 */
	inline CntIMAPMboxDataItem(const CntIMAPMboxDataItem & rMboxData);

	/** Assignment operator.

		@param rItem Some item to copy from, in case it is a
		CntIMAPMboxDataItem.

		@return This instance.
	 */
	virtual SfxPoolItem & operator =(const SfxPoolItem & rItem);

	/** Equality operator.

		@param rItem Some item to compare with.

		@return TRUE iff rItem is a CntIMAPMboxDataItem which has data
		('inferiors' and 'select' flags and hierarchy separator) and UID
		validity equal to this instance.
	 */
	virtual int operator ==(const SfxPoolItem & rItem) const;

	/** Create instance from stream.

		@param rStream Some stream to read a CntIMAPMboxDataItem
		representation from.

		@return A new CntIMAPMboxDataItem instance.
	 */
	virtual SfxPoolItem * Create(SvStream & rStream, USHORT) const;

	/** Write this instance to stream.

		@param rStream Some stream to write a representation of this instance
		to.

		@return The supplied rStream.
	 */
	virtual SvStream & Store(SvStream & rStream, USHORT) const;

	/** Create a copy of this instance.

		@return A new CntIMAPMboxDataItem instance equal to this instance.
	 */
	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const;

	/** Set the data section ('inferiors' and 'select' flag and hierarchy
		separator).

		@param bTheFlagInferiors Flag representing the negated value of some
		IMAP4 '\Noinferiors' mailbox attribute.

		@param bTheFlagSelect Flag representing the negated value of some
		IMAP4 '\Noselect' mailbox attribute.

		@param naTheHierarchySeparator Either 0 (representing the 'NIL'
		hierarchy separator), or a non-null US-ASCII character.
	 */
	inline void setData(BOOL bTheFlagInferiors, BOOL bTheFlagSelect,
						UINT8 naTheHierarchySeparator);

	/** Set the UID validity.

		@param nTheUIDValidity A non-null IMAP4 UID validity.
	 */
	inline void setUIDValidity(UINT32 nTheUIDValidity);

	/** Get data section availability.

		@return TRUE iff the data section is available (setData() has been
		called).
	 */
	BOOL hasData() const { return m_bHasData; }

	/** Get the 'inferiors' flag's value.

		May only be called if hasData() returns TRUE.

		@return The value of the 'inferiors' flag.
	 */
	inline BOOL getFlagInferiors() const;

	/** Get the 'select' flag's value.

		May only be called if hasData() returns TRUE.

		@return The value of the 'select' flag.
	 */
	inline BOOL getFlagSelect() const;

	/** Get the hierarchy separator.

		May only be called if hasData() returns TRUE.

		@return Either 0 (representing the 'NIL' hierarchy separator), or a
		non-null US-ASCII character.
	 */
	inline UINT8 getHierarchySeparator() const;

	/** Get the UID validity.

		@return Either 0 (no UID validity set), or a non-null IMAP4 UID
		validity value.
	 */
	UINT32 getUIDValidity() const { return m_nUIDValidity; }
};

inline CntIMAPMboxDataItem::CntIMAPMboxDataItem(USHORT nWhich):
	SfxPoolItem(nWhich),
	m_bHasData(FALSE),
	m_naHierarchySeparator(0),
	m_bFlagInferiors(FALSE),
	m_bFlagSelect(FALSE),
	m_nUIDValidity(0)
{}

inline CntIMAPMboxDataItem::CntIMAPMboxDataItem(const CntIMAPMboxDataItem &
												 rMboxData):
	SfxPoolItem(rMboxData),
	m_bHasData(rMboxData.m_bHasData),
	m_nUIDValidity(rMboxData.m_nUIDValidity)
{
	if (m_bHasData)
	{
		m_bFlagInferiors = rMboxData.m_bFlagInferiors;
		m_bFlagSelect = rMboxData.m_bFlagSelect;
		m_naHierarchySeparator = rMboxData.m_naHierarchySeparator;
	}
}

inline
void CntIMAPMboxDataItem::setData(BOOL bTheFlagInferiors, BOOL bTheFlagSelect,
								  UINT8 naTheHierarchySeparator)
{
	m_bHasData = TRUE;
	m_bFlagInferiors = bTheFlagInferiors;
	m_bFlagSelect = bTheFlagSelect;
	m_naHierarchySeparator = naTheHierarchySeparator;
}

inline void CntIMAPMboxDataItem::setUIDValidity(UINT32 nTheUIDValidity)
{
	DBG_ASSERT(nTheUIDValidity,
			   "CntIMAPMboxDataItem::setUIDValidity(): Zero");

	m_nUIDValidity = nTheUIDValidity;
}

inline BOOL CntIMAPMboxDataItem::getFlagInferiors() const
{
	DBG_ASSERT(m_bHasData,
			   "CntIMAPMboxDataItem::getFlagInferiors(): No data");

	return m_bFlagInferiors;
}

inline BOOL CntIMAPMboxDataItem::getFlagSelect() const
{
	DBG_ASSERT(m_bHasData, "CntIMAPMboxDataItem::getFlagSelect(): No data");

	return m_bFlagSelect;
}

inline UINT8 CntIMAPMboxDataItem::getHierarchySeparator() const
{
	DBG_ASSERT(m_bHasData,
			   "CntIMAPMboxDataItem::getHierarchySeparator(): None");

	return m_naHierarchySeparator;
}

}

#endif // _CHAOS_IMAPMITM_HXX

