/*************************************************************************
 *
 *  $RCSfile: cntthrd.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _CNTTHRD_HXX
#define _CNTTHRD_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _THRDITEM_HXX
#include <thrditem.hxx>
#endif

#ifndef _CNTAPI_HXX
#include <cntapi.hxx>
#endif

namespace chaos {

#define THREADITEM_ANZ 3

struct ItemListData
{
	BOOL			bIsReal		: 1;
	BOOL			bIsVirtual	: 1;
	BOOL			bIsCopy		: 1;
	String			sValue;
	CntAnchor		*pAnchor;
	ItemListData	*pParent;
	ItemListData	*pChild;

					ItemListData( const String &rValue );
	BOOL			SetParent( ItemListData* pNewParent );
};

class CntThreadList : private List
{
	CntAnchor			*pRoot;
	USHORT				nIsEnabledWID;
	USHORT				nParentWID;
	USHORT				nChildWID;
	USHORT				nTitleWID;
	CntThreadingType	eType;
    char		        cDelimiter;
public:
                    	CntThreadList(): List( 32, 32 ) {};
                        ~CntThreadList();

	void				SetRoot( CntAnchor *pAnchor, const CntThreadingInfo& rInfo );
	ItemListData* 		FindAnchor( CntAnchor *pAnchor );
	ItemListData* 		FindEntry( const String &rData, ULONG &rPos );
	CntAnchor*			FindFirstParent( ItemListData *pStart );
	CntAnchor*			FindFirstChild( ItemListData *pStart );
	void				CleanUpLists( CntAnchor *pAnchor );
	void				CheckLists( CntAnchor *pOld, CntAnchor*pNew );
	void				CheckParents( String &rParents, ItemListData* pFirstParent, CntNodeJob* pJob );
	String				CutFirstParent( String &rParents );
	void				CutReply( String &rParents );
	void				InsertInBetween( ItemListData *pSelf,
										 CntAnchor *_pChildAnchor,
									 	 CntAnchor *pNewAnchor,
										 CntNodeJob* pJob );
	BOOL				InsertInList( const String &rSelf,
									  const String &rParents,
									  ItemListData** pItem,
									  ItemListData** pParent,
									  CntNodeJob* pJob );
	BOOL				InsertAnchor( CntAnchor **pAnchor,
								 	  CntAnchor *pNewAnchor,
									  ItemListData **pLastNode,
									  BOOL &bIsInserted,
									  CntNodeJob* pJob );
	static BOOL			IsUniqueType( CntThreadingType eType )
								{ if ( eType == CNT_THREADING_BY_PROPVALUE ) return FALSE;
								  else return TRUE;
								}
	USHORT				GetEnabledWID() { return nIsEnabledWID; }
	USHORT				GetChildWID() { return nChildWID; }
	CntThreadingType	GetType() { return eType; }
						List::Remove;
						List::First;
						List::Next;
						List::GetCurPos;
};


struct CntThreadData
{
	ULONG			nAnzTypes;
    CntThreadList	*pItemLists[ THREADITEM_ANZ ];

					CntThreadData();
					~CntThreadData();
};

void Cnt_CutReply( String& rStr );

class ImplOpenData
{
	CntAnchorRef	xViewRoot;
	CntAnchorRef	xParent;
	CntNodeJob		*pOpenJob;
	List			*pChildList;
	ULONG			nTicks;
	BOOL			bLocked			: 1;
	BOOL			bFirst			: 1;
	BOOL			bCollectAnchors	: 1;

public:
					ImplOpenData( CntAnchor *pAnchor, BOOL bOpen = TRUE );
					~ImplOpenData();

	CntAnchorRef	GetRoot() const { return xViewRoot; }
	CntNodeJob*		GetOpenJob() const { return pOpenJob; }
	void			SetOpenJob( CntNodeJob* pJob ) { pOpenJob = pJob; }

	BOOL			IsLocked() const { return bLocked; }
	BOOL			InsertAnchor( CntAnchor* pChild );
	void			ProcessList();
	void			ClearList();
	BOOL			CheckOpenData();
};

}

#endif

