/*************************************************************************
 *
 *  $RCSfile: imaptask.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_IMAPTASK_HXX
#define CHAOS_IMAPTASK_HXX

#ifndef _INET_IMAPCLNT_HXX
#include <inet/imapclnt.hxx>
#endif

#ifndef CHAOS_THRDTASK_HXX
#include <thrdtask.hxx>
#endif

#ifndef CHAOS_IMAPLIST_HXX
#include <imaplist.hxx>
#endif

class SfxBroadcaster;

namespace chaos {

class CntIMAPAcnt;
class CntIMAPMbox;
class CntIMAPTask;
class CntStorageIterator;

//============================================================================
class CntIMAPStatusInformation
{
public:
	enum { NO_PROGRESS = 0xFFFFFFFF };

	enum Tag
	{
		TAG_NONE,
		TAG_OPENING
	};

private:
	enum State { STATE_ENABLED, STATE_DISABLED, STATE_CLEARED };

	String m_aText;
	CntIMAPStatusInformation * m_pNext;
	ULONG m_nProgressMin;
	ULONG m_nProgressMax;
	ULONG m_nProgress;
	Tag m_eTag;
	State m_eState;
	USHORT m_nID;
	bool m_bPopOnError;

public:
	CntIMAPStatusInformation(SfxBroadcaster & rBroadcaster,
							 String const & rTheText, Tag eTheTag,
							 bool bThePopOnError,
							 CntIMAPStatusInformation * pTheNext);

	CntIMAPStatusInformation(SfxBroadcaster & rBroadcaster,
							 String const & rTheText, ULONG nTheProgressMin,
							 ULONG nTheProgressMax, Tag eTheTag,
							 bool bThePopOnError,
							 CntIMAPStatusInformation * pTheNext);

	void disable(SfxBroadcaster & rBroadcaster);

	void enable(SfxBroadcaster & rBroadcaster);

	void changeText(SfxBroadcaster & rBroadcaster, String const & rTheText);

	void progress(SfxBroadcaster & rBroadcaster, ULONG nTheProgress);

	void clear(SfxBroadcaster & rBroadcaster);

	Tag getTag() const { return m_eTag; }

	bool doPopOnError() const { return m_bPopOnError; }

	CntIMAPStatusInformation * getNext() { return m_pNext; }
};

//============================================================================
class CntIMAPTask: public chaos::ThreadTask
{
public:
	enum ErrorResponse
	{
		ERROR_RESPONSE_CANCELED = chaos::ThreadTask::RESPONSE_CANCELED,
		ERROR_RESPONSE_ABORT = chaos::ThreadTask::RESPONSE_ABORT,
		ERROR_RESPONSE_RETRY = chaos::ThreadTask::RESPONSE_RETRY,
		ERROR_RESPONSE_IGNORE = chaos::ThreadTask::RESPONSE_IGNORE,
		ERROR_RESPONSE_NONE
	};

private:
	CntIMAPAcnt & m_rAcnt;
	CntIMAPStatusInformation * m_pStatusInformations;
	bool m_bForwardTask;

	virtual void finished(bool bCanceled);

protected:
	inline CntIMAPTask(CntNodeJob & rJob, CntNode & rExecNode,
					   CntIMAPAcnt & rTheAcnt, bool bTheForwardTask = false);

	CntIMAPAcnt & getAcnt() { return m_rAcnt; }

	void pushStatusInformation(String const & rText,
							   CntIMAPStatusInformation::Tag eTag
							       = CntIMAPStatusInformation::TAG_NONE,
							   bool bPopOnError = false);

	void pushStatusInformation(String const & rText, ULONG nProgressMin,
							   ULONG nProgressMax,
							   CntIMAPStatusInformation::Tag eTag
							       = CntIMAPStatusInformation::TAG_NONE,
							   bool bPopOnError = false);

	void setStatusInformation(String const & rText,
							  CntIMAPStatusInformation::Tag eTag);

	void changeStatusInformation(String const & rText);

	void progressStatusInformation(ULONG nProgress);

	void popStatusInformation(CntIMAPStatusInformation::Tag eTag
							      = CntIMAPStatusInformation::TAG_NONE);

	void popStatusInformationOnError();

	void clearStatusInformation();

	virtual void beingCanceled() {}

	virtual void end() {}

public:
	bool isForwardTask() const { return m_bForwardTask; }

	static ErrorResponse handleErrorNoTask(ErrCode nError);
};

inline CntIMAPTask::CntIMAPTask(CntNodeJob & rJob, CntNode & rExecNode,
								CntIMAPAcnt & rTheAcnt, bool bTheForwardTask):
	ThreadTask(rJob, rExecNode),
	m_rAcnt(rTheAcnt),
	m_bForwardTask(bTheForwardTask),
	m_pStatusInformations(0)
{}

//============================================================================
class CntIMAPOfflineTask: public CntIMAPTask
{
	typedef CntIMAPTask super;

	bool m_bInitial;

	virtual SfxPoolItem const * execute();

protected:
	CntIMAPOfflineTask(CntNodeJob & rJob, CntNode & rExecNode,
					   CntIMAPAcnt & rAcnt):
		CntIMAPTask(rJob, rExecNode, rAcnt), m_bInitial(true) {}

	virtual bool executeTimeSlice(bool bFirst) = 0;
};

//============================================================================
class CntIMAPOnlineTask: public CntIMAPTask
{
	typedef CntIMAPTask super;

	enum { STATE_INITIALIZE, STATE_ONLINE, STATE_OPENING,
		   STATE_SEND_CAPABILITY, STATE_RECV_CAPABILITY, STATE_AUTHENTICATE,
		   STATE_SEND_LOGIN, STATE_RECV_LOGIN, STATE_OFFLINE,
		   FURTHER_STATES };

protected:
	/** States visible to derived classes.

		STATE_RESTART_ONLINE will (re-)start the online activities, (re-)
		opening a connection and authorizing as necessary.

		STATE_START_OFFLINE should be overwritten by a derived class with a
		state that starts that class's offline activities.  (This state is
		also used when 'ignoring' a severe online error that does not allow
		carrying on with the online activities, and when trying to SELECT a
		mailbox that has the \NoSelect flag specified.)

		STATE_START_ONLINE should be overwritten by a derived class with a
		state that starts that class's online activities (after an authorized
		connection has been established).

		Further states of a derived class must start after STATE_START_ONLINE.
		When two states STATE_SEND_cmd and STATE_RECV_cmd together implement
		sending a client command and processing the server results, the code
		to implement the error 'retry' feature (methods like defaultCallback()
		and handleCommandFailure()) rely on the equation

			STATE_RECV_cmd == STATE_SEND_cmd + 1.
	 */
	enum { STATE_RESTART_ONLINE = STATE_ONLINE,
		   STATE_START_OFFLINE = STATE_OFFLINE,
		   STATE_START_ONLINE = FURTHER_STATES };

public:
	/** Values indicating to clientCallback() how to continue after a call to
		executeState().

		Values that may be returned by executeState() are:
		(1) EXEC_UNHANDLED  executeState() was called from the callback (i.e.,
		     with a non-null pResponse) and the response has not been handled
			 by executeState() (i.e., defaultCallback() will be called).
		(2) EXEC_CONTINUE  executeState() will be called again (and an
		     eventual callback response has been handled and will not be
			 passed to executeState() again).
		(3) EXEC_DONE  clientCallback() will exit (and an eventual callback
		     response has been handled).
		(4) EXEC_RESCHEDULE  clientCallback() will exit and the task is
		     rescheduled (and an eventual callback response has been handled).
		(5) EXEC_BASE  clientCallback() will call CntNode::ExecuteJob().

		The special value EXEC_NOTHING is returned by handleAlertResponse() in
		case the response is either no alert response, or the alert shall be
		ignored.
	 */
	enum Execution
	{
		EXEC_BIT_HANDLED = 0x01,
		EXEC_BIT_DONE = 0x02,
		EXEC_BIT_RESCHEDULE = 0x04,
		EXEC_BIT_BASE = 0x08,
		EXEC_UNHANDLED = 0,
		EXEC_CONTINUE = EXEC_BIT_HANDLED,
		EXEC_DONE = EXEC_BIT_HANDLED | EXEC_BIT_DONE,
		EXEC_RESCHEDULE = EXEC_DONE | EXEC_BIT_RESCHEDULE,
		EXEC_BASE = EXEC_DONE | EXEC_BIT_BASE,
		EXEC_NOTHING = 0x10
	};

private:
#if !defined USE_JOB_DISPATCHER
	sal_uInt32 m_nInitialReschedule;
#endif // USE_JOB_DISPATCHER
	bool m_bToClose;
	bool m_bClientAcquired;

protected:
	int m_nState;

private:
	virtual SfxPoolItem const * execute() { return executeCallback(0); }

	DECL_LINK(clientCallback, INetIMAPResponse const *);

	SfxPoolItem const * executeCallback(INetIMAPResponse const * pResponse);

	Execution defaultCallback(INetIMAPResponse const & rResponse);

	Link getClientCallback()
	{ return LINK(this, CntIMAPOnlineTask, clientCallback); }

	void * getClientResponseData() { return this; }

protected:
	CntIMAPOnlineTask(CntNodeJob & rJob, CntIMAPAcnt & rAcnt,
					  bool bTheToClose = false);

	virtual void beingCanceled();

	virtual void end();

	void done();

	ErrCode clientCommandCapability();

	ErrCode clientCommandNoOp();

	ErrCode clientCommandLogOut();

	ErrCode clientCommandLogIn(String const & rUserID,
							   String const & rPassword);

	ErrCode clientCommandSelect(ByteString const & rMailboxName);

	ErrCode clientCommandExamine(ByteString const & rMailboxName);

	ErrCode clientCommandCreate(ByteString const & rMailboxName);

	ErrCode clientCommandDelete(ByteString const & rMailboxName);

	ErrCode clientCommandRename(ByteString const & rOldMailboxName,
								ByteString const & rNewMailboxName);

	ErrCode clientCommandSubscribe(ByteString const & rMailboxName);

	ErrCode clientCommandUnSubscribe(ByteString const & rMailboxName);

	ErrCode clientCommandList(ByteString const & rReference,
							  ByteString const & rPattern);

	ErrCode clientCommandLSub(ByteString const & rReference,
							  ByteString const & rPattern);

	ErrCode clientCommandStatus(ByteString const & rMailboxName,
								INetIMAPStatusAttributes eAttributes);

	ErrCode clientCommandAppend(ByteString const & rMailboxName,
								ByteString const & rRFC822Header,
								ByteString const & rMediaType,
								SvStream * pBody);

	ErrCode clientCommandAppend(ByteString const & rMailboxName,
								SvStream * pMessage);

	ErrCode clientCommandCheck();

	ErrCode clientCommandClose();

	ErrCode clientCommandExpunge();

	ErrCode clientCommandSearch(bool bUIDCommand, rtl_TextEncoding eCharset,
								INetIMAPSearchKeyList const & rKeys);

	ErrCode clientCommandFetch(bool bUIDCommand,
							   INetIMAPMessageNumberSet const &
							       rMessageNumberSet,
							   INetIMAPClient::FetchAttributes eAttributes,
							   INetIMAPArgumentBodySectionList const *
							       pBodySections,
							   INetIMAPHeaderFieldListList const *
							       pRFC822HeaderLines,
							   Link const & rStreamCallback);

	ErrCode clientCommandStore(bool bUIDCommand,
							   INetIMAPMessageNumberSet const &
							       rMessageNumberSet,
							   INetIMAPClient::StoreAttribute eAttribute,
							   INetIMAPFlags eFlags,
							   INetIMAPFlagKeywordList const * pFlagKeywords);

	ErrCode clientCommandCopy(bool bUIDCommand,
							  INetIMAPMessageNumberSet const &
							      rMessageNumberSet,
							  ByteString const & rMailboxName);

	ErrCode clientCommandNamespace();

	ErrorResponse handleError(ErrCode nError, bool bCancel = true);

	ErrorResponse handleLogInError(String const * pMessage = 0);

	Execution handleCommandFailure(ErrCode nError);

	Execution handleAlertResponse(INetIMAPCodeResponse const & rResponse);

#if !defined USE_JOB_DISPATCHER
	bool initialReschedule() { return ++m_nInitialReschedule == 1; }
#endif // USE_JOB_DISPATCHER

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

	static bool isRootMbox(INetIMAPListResponseMailbox const & rMbox,
						   ByteString & rMboxCanonicLiteralFullName);

	static bool isDirectSubMbox(ByteString const &
								    rMboxCanonicLiteralFullName,
								INetIMAPListResponseMailbox const & rSubMbox,
								ByteString & rSubMboxCanonicLiteralFullName);

	static bool isSubMbox(ByteString const & rFldrCanonicLiteralFullName,
						  INetIMAPListResponseMailbox const & rSubMbox,
						  ByteString & rSubMboxCanonicLiteralFullName);
};

//============================================================================
class CntIMAPSeparatorTask: public CntIMAPOnlineTask
{
	typedef CntIMAPOnlineTask super;

	enum { STATE_SEND_LIST = CntIMAPOnlineTask::STATE_START_ONLINE,
		   STATE_RECV_LIST, STATE_MBOX_NAME, FURTHER_STATES };

protected:
	enum { STATE_START_ONLINE = FURTHER_STATES };

private:
	ByteString m_aRootLiteralName;
	ByteString m_aMboxLiteralFullName;
	CntIMAPMbox * m_pMbox;
	INetIMAPListResponseMailbox::Flags m_eRootMboxFlags;
	sal_Char m_cHierarchySeparator;
	bool m_bForceDetermination;
	bool m_bHierarchySeparatorDetermined;

protected:
	CntIMAPSeparatorTask(CntNodeJob & rJob, CntIMAPMbox & rTheMbox);

	void exchangeMbox(CntIMAPMbox & rTheMbox) { m_pMbox = &rTheMbox; }

	virtual Execution executeState(INetIMAPResponse const * pResponse);

	CntIMAPMbox & getMbox() { return *m_pMbox; }

	void forceDetermination() { m_bForceDetermination = true; }

	sal_Char getHierarchySeparator() const { return m_cHierarchySeparator; }

	ByteString const & getMboxLiteralFullName() const
	{ return m_aMboxLiteralFullName; }
};

//============================================================================
class CntIMAPSelectTask: public CntIMAPSeparatorTask
{
	typedef CntIMAPSeparatorTask super;

	enum { STATE_SEND_SELECT = CntIMAPSeparatorTask::STATE_START_ONLINE,
		   STATE_RECV_SELECT, STATE_UIDVALIDITY_COLLECT,
		   STATE_UIDVALIDITY_CHANGE, FURTHER_STATES };

	enum SelectMode { SELECT_NO, SELECT_YES, SELECT_FORCE };

protected:
	enum { STATE_START_ONLINE = FURTHER_STATES };

private:
	CntNodeRef m_xMboxDirNode;
	CntIMAPMesgList m_aMesgs;
	CntStorageIterator * m_pMboxDirIter;
	ULONG m_nProgress;
	sal_uInt32 m_nUIDValidity;
	sal_uInt32 m_nMesgCount;
	sal_uInt32 m_nRecentMesgCount;
	SelectMode m_eMode;
	bool m_bHasMesgCount;
	bool m_bHasRecentMesgCount;
	bool m_bBadRecentMesgCount;

protected:
	inline CntIMAPSelectTask(CntNodeJob & rJob, CntIMAPMbox & rMbox,
							 bool bForceSelect = false);

	virtual void beingCanceled();

	void skipSelect() { m_eMode = SELECT_NO; }

	sal_uInt32 getUIDValidity() const { return m_nUIDValidity; }

	sal_uInt32 getMesgCount() const { return m_nMesgCount; }

	sal_uInt32 getRecentMesgCount() const { return m_nRecentMesgCount; }

	bool hasBadRecentMesgCount() const { return m_bBadRecentMesgCount; }

	virtual Execution executeState(INetIMAPResponse const * pResponse);
};

inline CntIMAPSelectTask::CntIMAPSelectTask(CntNodeJob & rJob,
											CntIMAPMbox & rMbox,
											bool bForceSelect):
	CntIMAPSeparatorTask(rJob, rMbox),
	m_eMode(bForceSelect ? SELECT_FORCE : SELECT_YES),
	m_pMboxDirIter(0)
{}

//============================================================================
class CntIMAPForwardTask: public CntIMAPTask
{
	typedef CntIMAPTask super;

	CntIMAPSubJobList m_aSubJobs;
	bool m_bCancel;

	virtual SfxPoolItem const * execute();

	virtual void notification(SfxBroadcaster & rBroadcaster,
							  SfxHint const & rHint);

	void startSubJob();

protected:
	CntIMAPForwardTask(CntNodeJob & rJob, CntNode & rExecNode,
					   CntIMAPAcnt & rAcnt):
		CntIMAPTask(rJob, rExecNode, rAcnt, true), m_bCancel(false) {}

	void cancelOnExecute() { m_bCancel = true; }

	void appendSubJob(CntNode & rSubject, SfxPoolItem const & rRequest,
					  bool bForwardResults);

	virtual void finish() {}
};

}

#endif // CHAOS_IMAPTASK_HXX

