/*************************************************************************
 *
 *  $RCSfile: imapmesg.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INET_IMAPCLNT_HXX
#include <inet/imapclnt.hxx>
#endif
#ifndef _INETCOREMSG_HXX
#include <inet/inetmsg.hxx>
#endif
#ifndef _DATETIMEITEM_HXX
#include <svtools/dateitem.hxx>
#endif
#ifndef _SVTOOLS_CENUMITM_HXX
#include <svtools/cenumitm.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef TOOLS_INETMIME_HXX
#include <tools/inetmime.hxx>
#endif

#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif
#ifndef _CNTMBITM_HXX
#include <cntmbitm.hxx>
#endif
#ifndef _CNTMMITM_HXX
#include <cntmmitm.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CHAOS_IMAP_HXX
#include <imap.hxx>
#endif
#ifndef _CHAOS_MBXFORMT_HXX
#include <mbxformt.hxx>
#endif
#ifndef _CHAOS_STORITEM_HXX
#include <storitem.hxx>
#endif

#ifndef CHAOS_IMAPACNT_HXX
#include <imapacnt.hxx>
#endif
#ifndef CHAOS_IMAPMBOX_HXX
#include <imapmbox.hxx>
#endif
#ifndef CHAOS_IMAPMESG_HXX
#include <imapmesg.hxx>
#endif
#ifndef CHAOS_IMAPSTOR_HXX
#include <imapstor.hxx>
#endif
#ifndef CHAOS_IMAPURL_HXX
#include <imapurl.hxx>
#endif

namespace unnamed_chaos_imapmesg {} using namespace unnamed_chaos_imapmesg;
	// unnamed namespaces don't work well ye

using namespace chaos;

SV_IMPL_REF(CntStoreItemSet)

//============================================================================
namespace unnamed_chaos_imapmesg {

USHORT const aCntIMAPMesgNodeRanges[]
	= { WID_MAIL_REPLY, WID_HIDE_SUBJECT,
		WID_MARK_THREAD_UNREAD, WID_REFERENCES,
		WID_OPEN, WID_PASTE,
		WID_HAS_DATA, WID_IS_MARKED,
		WID_INSERT, WID_INSERT,
		WID_MESSAGE_STOREMODE, WID_MESSAGE_STOREMODE,
		WID_UNDELETE, WID_REOPEN,
		WID_PROPERTYLIST, WID_PROPERTYLIST,
		WID_DOCUMENT_SIZE, WID_DOCUMENT_SIZE,
		WID_KEYWORDS, WID_KEYWORDS,
		WID_EXPORT, WID_EXPORT,
		WID_ACTION_LIST, WID_ACTION_LIST, 0 };
	// WID_POST_REPLY should not be in these ranges, but the buggy SFX2 code
	// relies on WID_POST_REPLY being disabled rather than not being in the
	// ranges.

//============================================================================
USHORT const aCntIMAPMesgDirSetRanges[]
	= { WID_PRIORITY, WID_PRIORITY,
		WID_REPLY_TO, WID_TITLE,
		WID_REFERENCES, WID_REFERENCES,
		WID_DATE_CREATED, WID_DATE_MODIFIED,
		WID_MESSAGE_STOREMODE, WID_MESSAGE_STOREMODE,
		WID_DOCUMENT_SIZE, WID_DOCUMENT_SIZE,
		WID_KEYWORDS, WID_KEYWORDS,
		WID_ACTION_LIST, WID_ACTION_LIST, 0 };

}

//============================================================================
//
//  CntIMAPMesgNode
//
//============================================================================

// static
bool CntIMAPMesgNode::skipNumber(String const & rText, xub_StrLen & rOffset,
								 sal_uInt32 & rValue)
{
	sal_uInt32 nTheValue = 0;
	bool bDigits = false;
	for (; rOffset < rText.Len(); ++rOffset)
	{
		int nDigitValue = INetMIME::getWeight(rText.GetChar(rOffset));
		if (nDigitValue >= 0)
		{
			nTheValue = 10 * nTheValue + nDigitValue;
			bDigits = true;
		}
		else
			break;
	}
	if (bDigits)
		rValue = nTheValue;
	return bDigits;
}

//============================================================================
CntIMAPMesgNode::CntIMAPMesgNode():
	CntMessageNode(aCntIMAPMesgNodeRanges),
	m_bInitialized(false),
	m_bDeleted(false),
	m_bInheritedKeepBodyFlag(false)
{
	DisableItem(WID_POST_REPLY); // see comment to aCntIMAPMesgNodeRanges
}

//============================================================================
TYPEINIT1_AUTOFACTORY(CntIMAPMesgNode, CntMessageNode)

//============================================================================
CntIMAPMbox & CntIMAPMesgNode::getParentMbox()
{
	return static_cast< CntIMAPMboxNode * >(GetParent())->getMbox();
}

//============================================================================
bool CntIMAPMesgNode::initialize(CntNodeJob & rJob, bool bCreate,
								 INetIMAPFetchResponse const * pFetchData,
								 SfxItemSet const * pImportData)
{
	DBG_ASSERT((!(pFetchData || pImportData) || bCreate)
			   && !(pFetchData && pImportData),
			   "CntIMAPMesgNode::initialize(): Bad args");

	if (m_bInitialized && !bCreate)
		return false;
	bool bWasInitialized;
	{
		vos::OGuard aGuard(getMutex());
		bWasInitialized = m_bInitialized;
		if (bWasInitialized && !bCreate)
			return false;
		m_bInitialized = true;
	}

	String aMboxURL;
	sal_uInt32 nUIDValidity;
	sal_uInt32 nMesgUID;
	CntIMAPURL::decomposeMesgURL(OWN_URL(this), aMboxURL, nUIDValidity,
								 nMesgUID);

	CntNodeRef xMboxDirNode(getParentMbox().getDirNode(rJob));
	String aMesgDirID(createMesgDirID(nUIDValidity, nMesgUID));

	sal_uInt32 nMesgDirAttribs = 0;
	bool bMesgDirSetPresent
		= xMboxDirNode.Is()
		  && static_cast< CntStorageNode * >(&xMboxDirNode)->
		             attrib(aMesgDirID, 0, 0, nMesgDirAttribs)
		         != ERRCODE_IO_NOTEXISTS;

	getParentMbox().initialize(rJob, !bMesgDirSetPresent && bCreate, 0, false,
							   true);

	m_bDeleted = (nMesgDirAttribs & CNTDIRENTRY_ATTRIB_MARKEDFORDELETE) != 0;

	sal_uInt32 nClearMask = 0;
	sal_uInt32 nSetMask = 0;
	CntIMAPFldr::CountChange eLMesgCountChange = CntIMAPFldr::COUNT_STAY;
	CntIMAPFldr::CountChange eSMesgCountChange = CntIMAPFldr::COUNT_STAY;
	CntIMAPFldr::CountChange eLSMesgCountChange = CntIMAPFldr::COUNT_STAY;
	CntIMAPFldr::CountChange eLSDMesgCountChange = CntIMAPFldr::COUNT_STAY;
	CntIMAPFldr::CountChange eReadMesgCountChange = CntIMAPFldr::COUNT_STAY;
	CntIMAPFldr::CountChange eMarkedMesgCountChange = CntIMAPFldr::COUNT_STAY;

	if (bCreate)
		if (!bMesgDirSetPresent)
		{
			nSetMask |= CNTDIRENTRY_ATTRIB_CREATE;
			if (pImportData)
				eLMesgCountChange = CntIMAPFldr::COUNT_INC;
			else
			{
				nSetMask |= CNTDIRENTRY_ATTRIB_IMAP_MESG_SERVER;
				eSMesgCountChange = CntIMAPFldr::COUNT_DEC;
				eLSMesgCountChange = CntIMAPFldr::COUNT_INC;
			}
		}
		else if (!pImportData
				 && !(nMesgDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_MESG_SERVER))
		{
			nSetMask |= CNTDIRENTRY_ATTRIB_IMAP_MESG_SERVER;
			eSMesgCountChange = CntIMAPFldr::COUNT_DEC;
			if (isDeleted())
				eLSDMesgCountChange = CntIMAPFldr::COUNT_INC;
			else
			{
				eLMesgCountChange = CntIMAPFldr::COUNT_DEC;
				eLSMesgCountChange = CntIMAPFldr::COUNT_INC;
			}
		}

	if (isDeleted())
	{
		pFetchData = 0;
		pImportData = 0;
	}

	bool bWasRead = false;
	bool bWasMarked = false;
	if (!isDeleted())
		if (bMesgDirSetPresent)
		{
			bWasRead = (nMesgDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_MESG_READ)
				           != 0;
			bWasMarked = (nMesgDirAttribs
						          & CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED)
				             != 0;
		}
		else if (bWasInitialized)
		{
			SfxPoolItem const * pItem;
			if (GetItemState(WID_IS_READ, false, &pItem) == SFX_ITEM_SET)
				bWasRead = ITEM_VALUE(CntBoolItem, *pItem) != false;
			if (GetItemState(WID_IS_MARKED, false, &pItem) == SFX_ITEM_SET)
				bWasMarked = ITEM_VALUE(CntBoolItem, *pItem) != false;
		}

	bool bSetRead = false;
	bool bSetMarked = false;
	if (pFetchData)
	{
		if (pFetchData->getPresentParts() & INetIMAPFetchResponse::PART_FLAGS)
		{
			Put(CntBoolItem(WID_IS_READ,
							(pFetchData->getFlags()
							         & INetIMAPFetchResponse::FLAG_SEEN)
							    != 0));
			bSetRead = true;
			if (pFetchData->getFlags() & INetIMAPFetchResponse::FLAG_SEEN)
			{
				nSetMask |= CNTDIRENTRY_ATTRIB_IMAP_MESG_READ;
				if (!bWasRead)
					eReadMesgCountChange = CntIMAPFldr::COUNT_INC;
			}
			else
			{
				nClearMask |= CNTDIRENTRY_ATTRIB_IMAP_MESG_READ;
				if (bWasRead)
					eReadMesgCountChange = CntIMAPFldr::COUNT_DEC;
			}
			Put(CntBoolItem(WID_IS_MARKED,
							(pFetchData->getFlags()
							         & INetIMAPFetchResponse::FLAG_FLAGGED)
							    != 0));
			bSetMarked = true;
			if (pFetchData->getFlags() & INetIMAPFetchResponse::FLAG_FLAGGED)
			{
				nSetMask |= CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED;
				if (!bWasMarked)
					eMarkedMesgCountChange = CntIMAPFldr::COUNT_INC;
			}
			else
			{
				nClearMask |= CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED;
				if (bWasMarked)
					eMarkedMesgCountChange = CntIMAPFldr::COUNT_DEC;
			}
		}
	}
	else if (pImportData)
	{
		SfxPoolItem const * pItem;
		if (pImportData->GetItemState(WID_IS_READ, false, &pItem)
			    == SFX_ITEM_SET)
		{
			Put(*pItem);
			bSetRead = true;
			if (ITEM_VALUE(CntBoolItem, *pItem))
			{
				nSetMask |= CNTDIRENTRY_ATTRIB_IMAP_MESG_READ;
				if (!bWasRead)
					eReadMesgCountChange = CntIMAPFldr::COUNT_INC;
			}
			else
			{
				nClearMask |= CNTDIRENTRY_ATTRIB_IMAP_MESG_READ;
				if (bWasRead)
					eReadMesgCountChange = CntIMAPFldr::COUNT_DEC;
			}
		}
		if (pImportData->GetItemState(WID_IS_MARKED, false, &pItem)
			    == SFX_ITEM_SET)
		{
			Put(*pItem);
			bSetMarked = true;
			if (ITEM_VALUE(CntBoolItem, *pItem))
			{
				nSetMask |= CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED;
				if (!bWasMarked)
					eMarkedMesgCountChange = CntIMAPFldr::COUNT_INC;
			}
			else
			{
				nClearMask |= CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED;
				if (bWasMarked)
					eMarkedMesgCountChange = CntIMAPFldr::COUNT_DEC;
			}
		}
	}

	if (!bWasInitialized && !isDeleted() && bMesgDirSetPresent)
	{
		if (!bSetRead)
			Put(CntBoolItem(WID_IS_READ,
							(nMesgDirAttribs
							         & CNTDIRENTRY_ATTRIB_IMAP_MESG_READ)
							    != 0));
		if (!bSetMarked)
			Put(CntBoolItem(WID_IS_MARKED,
							(nMesgDirAttribs
							         & CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED)
							    != 0));
	}

	if (xMboxDirNode.Is()
		&& nMesgDirAttribs != (nMesgDirAttribs & ~nClearMask | nSetMask))
			static_cast< CntStorageNode * >(&xMboxDirNode)->attrib(aMesgDirID,
																   nClearMask,
																   nSetMask);

	getParentMbox().changeMesgCounts(rJob, eLMesgCountChange,
									 eSMesgCountChange, eLSMesgCountChange,
									 eLSDMesgCountChange,
									 eReadMesgCountChange,
									 eMarkedMesgCountChange);

	// Set properties from storage and/or fetch/import data:
	bool bData = pFetchData
		             && pFetchData->getPresentParts()
		                    & (INetIMAPFetchResponse::PART_ENVELOPE
						           | INetIMAPFetchResponse::PART_INTERNALDATE
						           | INetIMAPFetchResponse::PART_RFC822_SIZE)
	             || pImportData;
	if (!bWasInitialized || bData)
	{
		CntStoreItemSetRef xMesgDirSet;
		if (xMboxDirNode.Is())
			xMesgDirSet = static_cast< CntStorageNode * >(&xMboxDirNode)->
			                  openItemSet(aCntIMAPMesgDirSetRanges,
										  aMesgDirID,
										  bData ?
										      STREAM_STD_READWRITE :
										      STREAM_READ
										          | STREAM_SHARE_DENYNONE);

		SfxPoolItem const * pItem;

		// WID_DATE_CREATED:
		if (pFetchData
			&& pFetchData->getPresentParts()
			       & INetIMAPFetchResponse::PART_ENVELOPE
			&& pFetchData->getPresentEnvelopeParts()
			       & INetIMAPFetchResponse::ENVELOPE_DATE)
		{
			DateTime aDate = pFetchData->getEnvelopeDate();
			aDate.ConvertToLocalTime();
			Put(SfxDateTimeItem(WID_DATE_CREATED, aDate));
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(SfxDateTimeItem(WID_DATE_CREATED, aDate));
		}
		else if (pImportData
				 && pImportData->GetItemState(WID_DATE_CREATED, false, &pItem)
				        == SFX_ITEM_SET)
		{
			Put(*pItem);
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(*pItem);
		}
		else if (!bWasInitialized && xMesgDirSet.Is()
				 && xMesgDirSet->GetItemState(WID_DATE_CREATED, false,
											  &pItem)
				        == SFX_ITEM_SET)
			Put(*pItem);

		// WID_TITLE:
		if (pFetchData
			&& pFetchData->getPresentParts()
			       & INetIMAPFetchResponse::PART_ENVELOPE
			&& pFetchData->getPresentEnvelopeParts()
			       & INetIMAPFetchResponse::ENVELOPE_SUBJECT)
		{
			String aSubject(INetMIME::decodeHeaderFieldBody(
				                INetMIME::HEADER_FIELD_TEXT,
								pFetchData->getEnvelopeSubject()));
			Put(CntStringItem(WID_TITLE, aSubject));
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(CntStringItem(WID_TITLE, aSubject));
		}
		else if (pImportData
				 && pImportData->GetItemState(WID_TITLE, false, &pItem)
				        == SFX_ITEM_SET)
		{
			Put(*pItem);
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(*pItem);
		}
		else if (!bWasInitialized && xMesgDirSet.Is()
				 && xMesgDirSet->GetItemState(WID_TITLE, false, &pItem)
				        == SFX_ITEM_SET)
			Put(*pItem);

		// WID_FROM:
		if (pFetchData
			&& pFetchData->getPresentParts()
			       & INetIMAPFetchResponse::PART_ENVELOPE
			&& pFetchData->getPresentEnvelopeParts()
		           & INetIMAPFetchResponse::ENVELOPE_FROM)
		{
			String aFrom(INetMIME::decodeHeaderFieldBody(
				             INetMIME::HEADER_FIELD_ADDRESS,
							 pFetchData->getEnvelopeFrom()));
			Put(CntNameItem(WID_FROM, aFrom));
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(CntNameItem(WID_FROM, aFrom));
		}
		else if (pFetchData
				 && pFetchData->getPresentParts()
				        & INetIMAPFetchResponse::PART_ENVELOPE
				 && pFetchData->getPresentEnvelopeParts()
			            & INetIMAPFetchResponse::ENVELOPE_SENDER)
		{
			String aSender(INetMIME::decodeHeaderFieldBody(
				               INetMIME::HEADER_FIELD_ADDRESS,
							   pFetchData->getEnvelopeSender()));
			Put(CntNameItem(WID_FROM, aSender));
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(CntNameItem(WID_FROM, aSender));
		}
		else if (pImportData
				 && pImportData->GetItemState(WID_FROM, false, &pItem)
				        == SFX_ITEM_SET)
		{
			Put(*pItem);
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(*pItem);
		}
		else if (!bWasInitialized && xMesgDirSet.Is()
				 && xMesgDirSet->GetItemState(WID_FROM, false, &pItem)
				        == SFX_ITEM_SET)
			Put(*pItem);

		// WID_REPLY_TO:
		if (pFetchData
			&& pFetchData->getPresentParts()
			       & INetIMAPFetchResponse::PART_ENVELOPE
			&& pFetchData->getPresentEnvelopeParts()
		           & INetIMAPFetchResponse::ENVELOPE_REPLY_TO)
		{
			String aReplyTo(INetMIME::decodeHeaderFieldBody(
				                INetMIME::HEADER_FIELD_ADDRESS,
								pFetchData->getEnvelopeReplyTo()));
			Put(CntStringItem(WID_REPLY_TO, aReplyTo));
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(CntStringItem(WID_REPLY_TO, aReplyTo));
		}
		else if (pImportData
				 && pImportData->GetItemState(WID_REPLY_TO, false, &pItem)
				        == SFX_ITEM_SET)
		{
			Put(*pItem);
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(*pItem);
		}
		else if (!bWasInitialized && xMesgDirSet.Is()
				 && xMesgDirSet->GetItemState(WID_REPLY_TO, false, &pItem)
				        == SFX_ITEM_SET)
			Put(*pItem);

		// WID_TO:
		if (pFetchData
			&& pFetchData->getPresentParts()
			       & INetIMAPFetchResponse::PART_ENVELOPE
			&& pFetchData->getPresentEnvelopeParts()
		           & INetIMAPFetchResponse::ENVELOPE_TO)
		{
			String aTo(INetMIME::decodeHeaderFieldBody(
				           INetMIME::HEADER_FIELD_ADDRESS,
						   pFetchData->getEnvelopeTo()));
			Put(CntStringItem(WID_TO, aTo));
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(CntStringItem(WID_TO, aTo));
		}
		else if (pImportData
				 && pImportData->GetItemState(WID_TO, false, &pItem)
				        == SFX_ITEM_SET)
		{
			Put(*pItem);
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(*pItem);
		}
		else if (!bWasInitialized && xMesgDirSet.Is()
				 && xMesgDirSet->GetItemState(WID_TO, false, &pItem)
				        == SFX_ITEM_SET)
			Put(*pItem);

		// WID_CC:
		if (pFetchData
			&& pFetchData->getPresentParts()
			       & INetIMAPFetchResponse::PART_ENVELOPE
			&& pFetchData->getPresentEnvelopeParts()
		           & INetIMAPFetchResponse::ENVELOPE_CC)
		{
			String aCC(INetMIME::decodeHeaderFieldBody(
				           INetMIME::HEADER_FIELD_ADDRESS,
						   pFetchData->getEnvelopeCC()));
			Put(CntStringItem(WID_CC, aCC));
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(CntStringItem(WID_CC, aCC));
		}
		else if (pImportData
				 && pImportData->GetItemState(WID_CC, false, &pItem)
				        == SFX_ITEM_SET)
		{
			Put(*pItem);
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(*pItem);
		}
		else if (!bWasInitialized && xMesgDirSet.Is()
				 && xMesgDirSet->GetItemState(WID_CC, false, &pItem)
				        == SFX_ITEM_SET)
			Put(*pItem);

		// WID_BCC:
		if (pFetchData
			&& pFetchData->getPresentParts()
			       & INetIMAPFetchResponse::PART_ENVELOPE
			&& pFetchData->getPresentEnvelopeParts()
		           & INetIMAPFetchResponse::ENVELOPE_BCC)
		{
			String aBCC(INetMIME::decodeHeaderFieldBody(
				            INetMIME::HEADER_FIELD_ADDRESS,
							pFetchData->getEnvelopeBCC()));
			Put(CntStringItem(WID_BCC, aBCC));
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(CntStringItem(WID_BCC, aBCC));
		}
		else if (pImportData
				 && pImportData->GetItemState(WID_BCC, false, &pItem)
				        == SFX_ITEM_SET)
		{
			Put(*pItem);
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(*pItem);
		}
		else if (!bWasInitialized && xMesgDirSet.Is()
				 && xMesgDirSet->GetItemState(WID_BCC, false, &pItem)
				        == SFX_ITEM_SET)
			Put(*pItem);

		// WID_IN_REPLY_TO:
		if (pFetchData
			&& pFetchData->getPresentParts()
			       & INetIMAPFetchResponse::PART_ENVELOPE
			&& pFetchData->getPresentEnvelopeParts()
		           & INetIMAPFetchResponse::ENVELOPE_IN_REPLY_TO)
		{
			String aInReplyTo(INetMIME::decodeHeaderFieldBody(
				                  INetMIME::HEADER_FIELD_ADDRESS,
								  pFetchData->getEnvelopeInReplyTo()));
			Put(CntStringItem(WID_IN_REPLY_TO, aInReplyTo));
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(CntStringItem(WID_IN_REPLY_TO, aInReplyTo));
		}
		else if (pImportData
				 && pImportData->GetItemState(WID_IN_REPLY_TO, false, &pItem)
				        == SFX_ITEM_SET)
		{
			Put(*pItem);
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(*pItem);
		}
		else if (!bWasInitialized && xMesgDirSet.Is()
				 && xMesgDirSet->GetItemState(WID_IN_REPLY_TO, false, &pItem)
				        == SFX_ITEM_SET)
			Put(*pItem);

		// WID_MESSAGE_ID:
		if (pFetchData
			&& pFetchData->getPresentParts()
			       & INetIMAPFetchResponse::PART_ENVELOPE
			&& pFetchData->getPresentEnvelopeParts()
		           & INetIMAPFetchResponse::ENVELOPE_MESSAGE_ID)
		{
			String aMessageID(INetMIME::decodeHeaderFieldBody(
				                  INetMIME::HEADER_FIELD_MESSAGE_ID,
								  pFetchData->getEnvelopeMessageID()));
			Put(CntStringItem(WID_MESSAGE_ID, aMessageID));
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(CntStringItem(WID_MESSAGE_ID, aMessageID));
		}
		else if (pImportData
				 && pImportData->GetItemState(WID_MESSAGE_ID, false, &pItem)
				        == SFX_ITEM_SET)
		{
			Put(*pItem);
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(*pItem);
		}
		else if (!bWasInitialized && xMesgDirSet.Is()
				 && xMesgDirSet->GetItemState(WID_MESSAGE_ID, false, &pItem)
				        == SFX_ITEM_SET)
			Put(*pItem);

		// WID_DATE_MODIFIED:
		if (pFetchData
			&& pFetchData->getPresentParts()
			       & INetIMAPFetchResponse::PART_ENVELOPE
			&& pFetchData->getPresentParts()
		           & INetIMAPFetchResponse::PART_INTERNALDATE)
		{
			DateTime aDate(pFetchData->getInternalDate());
			aDate.ConvertToLocalTime();
			Put(SfxDateTimeItem(WID_DATE_MODIFIED, aDate));
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(SfxDateTimeItem(WID_DATE_MODIFIED, aDate));
		}
		else if (pImportData
				 && pImportData->GetItemState(WID_DATE_MODIFIED, false,
											  &pItem)
				        == SFX_ITEM_SET)
		{
			Put(*pItem);
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(*pItem);
		}
		else if (!bWasInitialized && xMesgDirSet.Is()
				 && xMesgDirSet->GetItemState(WID_DATE_MODIFIED, false,
											  &pItem)
				        == SFX_ITEM_SET)
			Put(*pItem);

		// WID_DOCUMENT_SIZE:
		if (pFetchData
			&& pFetchData->getPresentParts()
			       & INetIMAPFetchResponse::PART_RFC822_SIZE)
		{
			Put(CntUInt32Item(WID_DOCUMENT_SIZE,
							  pFetchData->getRFC822Size()));
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(CntUInt32Item(WID_DOCUMENT_SIZE,
											   pFetchData->getRFC822Size()));
		}
		else if (pImportData
				 && pImportData->GetItemState(WID_DOCUMENT_SIZE, false,
											  &pItem)
				        == SFX_ITEM_SET)
		{
			Put(*pItem);
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(*pItem);
		}
		else if (!bWasInitialized && xMesgDirSet.Is()
				 && xMesgDirSet->GetItemState(WID_DOCUMENT_SIZE, false,
											  &pItem)
				        == SFX_ITEM_SET)
			Put(*pItem);

		// WID_PRIORITY:
		if (pImportData
			&& pImportData->GetItemState(WID_PRIORITY, false, &pItem)
			       == SFX_ITEM_SET)
		{
			Put(*pItem);
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(*pItem);
		}
		else if (!bWasInitialized && xMesgDirSet.Is()
				 && xMesgDirSet->GetItemState(WID_PRIORITY, false, &pItem)
				        == SFX_ITEM_SET)
			Put(*pItem);

		// WID_PRIORITY:
		if (pImportData
			&& pImportData->GetItemState(WID_REFERENCES, false, &pItem)
			       == SFX_ITEM_SET)
		{
			Put(*pItem);
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(*pItem);
		}
		else if (!bWasInitialized && xMesgDirSet.Is()
				 && xMesgDirSet->GetItemState(WID_REFERENCES, false, &pItem)
				        == SFX_ITEM_SET)
			Put(*pItem);

		// WID_KEYWORDS:
		if (!bWasInitialized && xMesgDirSet.Is()
			&& xMesgDirSet->GetItemState(WID_KEYWORDS, false, &pItem)
				    == SFX_ITEM_SET)
			Put(*pItem);

		// WID_ACTION_LIST:
		if (!bWasInitialized && xMesgDirSet.Is()
			&& xMesgDirSet->GetItemState(WID_ACTION_LIST, false, &pItem)
				    == SFX_ITEM_SET)
			Put(*pItem);

		// WID_MESSAGE_STOREMODE:
		if (!bWasInitialized)
			if (xMesgDirSet.Is()
				&& xMesgDirSet->GetItemState(WID_MESSAGE_STOREMODE, false,
											 &pItem)
				       == SFX_ITEM_SET)
			{
				Put(*pItem);
				m_bInheritedKeepBodyFlag = false;
			}
			else
			{
				Put(GetParent()->Get(WID_MESSAGE_STOREMODE));
				m_bInheritedKeepBodyFlag = true;
			}
	}

	// Enable/disable WID_MESSAGEBODY to reflect off line availability of the
	// message body:
	if (!bWasInitialized
		&& GetItemState(WID_MESSAGEBODY, false) != SFX_ITEM_SET
		&& THIS_ITEM_VALUE(CntMsgStoreModeItem, WID_MESSAGE_STOREMODE)
		       == CNT_MESSAGE_STOREMODE_LOCAL)
	{
		CntStorageNode * pCacheNode = rJob.GetCacheNode();
		if (pCacheNode
			&& pCacheNode->attrib(getBodyStreamID(), 0, 0)
			       == ERRCODE_IO_NOTEXISTS)
			DisableItem(WID_MESSAGEBODY);
	}

	return !bMesgDirSetPresent && bCreate;
}

//============================================================================
void CntIMAPMesgNode::storeProperty(CntNodeJob & rJob,
									SfxPoolItem const & rItem)
{
	switch (rItem.Which())
	{
		case WID_MESSAGE_STOREMODE:
		case WID_ACTION_LIST:
		{
			Put(rItem);

			CntNodeRef xMboxDirNode(getParentMbox().getDirNode(rJob));
			if (xMboxDirNode.Is())
			{
				String aMboxURL;
				sal_uInt32 nUIDValidity;
				sal_uInt32 nMesgUID;
				CntIMAPURL::decomposeMesgURL(OWN_URL(this), aMboxURL,
											 nUIDValidity, nMesgUID);
				CntStoreItemSetRef xMesgDirSet
					= static_cast< CntStorageNode * >(&xMboxDirNode)->
					      openItemSet(aCntIMAPMesgDirSetRanges,
									  createMesgDirID(nUIDValidity, nMesgUID),
									  STREAM_STD_WRITE | STREAM_NOCREATE);
				if (xMesgDirSet.Is())
					xMesgDirSet->Put(rItem);
			}

			if (rItem.Which() == WID_MESSAGE_STOREMODE)
				m_bInheritedKeepBodyFlag = false;
			break;
		}

		case WID_IS_READ:
		case WID_IS_MARKED:
		{
			SfxPoolItem const * pOldItem;
			bool bWasFlagged = GetItemState(rItem.Which(), false, &pOldItem)
				                   == SFX_ITEM_SET
				               && ITEM_VALUE(CntBoolItem, *pOldItem);
			bool bIsFlagged = ITEM_VALUE(CntBoolItem, rItem) != false;

			Put(rItem);
			if (bWasFlagged != bIsFlagged)
			{
				CntNodeRef xMboxDirNode = getParentMbox().getDirNode(rJob);
				if (xMboxDirNode.Is())
				{
					sal_uInt32 nClearMask = 0;
					sal_uInt32 nSetMask = 0;
					if (bIsFlagged)
						nSetMask = rItem.Which() == WID_IS_READ ?
							           CNTDIRENTRY_ATTRIB_IMAP_MESG_READ :
						               CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED;
					else
						nClearMask = rItem.Which() == WID_IS_READ ?
							             CNTDIRENTRY_ATTRIB_IMAP_MESG_READ :
						                 CNTDIRENTRY_ATTRIB_IMAP_MESG_MARKED;

					String aMboxURL;
					sal_uInt32 nUIDValidity;
					sal_uInt32 nMesgUID;
					CntIMAPURL::decomposeMesgURL(OWN_URL(this), aMboxURL,
												 nUIDValidity, nMesgUID);
					static_cast< CntStorageNode * >(&xMboxDirNode)->
						attrib(createMesgDirID(nUIDValidity, nMesgUID),
							   nClearMask, nSetMask);
				}

				if (!isDeleted())
					getParentMbox().
						changeMesgCounts(rJob, CntIMAPFldr::COUNT_STAY,
										 CntIMAPFldr::COUNT_STAY,
										 CntIMAPFldr::COUNT_STAY,
										 CntIMAPFldr::COUNT_STAY,
										 rItem.Which() != WID_IS_READ ?
										     CntIMAPFldr::COUNT_STAY :
										 bIsFlagged ?
										     CntIMAPFldr::COUNT_INC :
										     CntIMAPFldr::COUNT_DEC,
										 rItem.Which() != WID_IS_MARKED ?
										     CntIMAPFldr::COUNT_STAY :
										 bIsFlagged ?
										     CntIMAPFldr::COUNT_INC :
										     CntIMAPFldr::COUNT_DEC);
			}
			break;
		}

		default:
			DBG_ERROR("CntIMAPMesgNode::storeProperty(): Invalid item");
			break;
	}
}

//============================================================================
String CntIMAPMesgNode::getDataStreamID() const
{
	String aDataStreamID(OWN_URL(this));
	aDataStreamID.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
		                          CNT_IMAP_MESG_DATA_STREAM_ID_SUFFIX));
	return aDataStreamID;
}

//============================================================================
String CntIMAPMesgNode::getBodyStreamID() const
{
	String aBodyStreamID(OWN_URL(this));
	aBodyStreamID.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
		                          CNT_IMAP_MESG_BODY_STREAM_ID_SUFFIX));
	return aBodyStreamID;
}

//============================================================================
// static
String CntIMAPMesgNode::createMesgDirID(sal_uInt32 nUIDValidity,
										sal_uInt32 nMesgUID)
{
	DBG_ASSERT(nMesgUID != 0,
			   "CntIMAPMesgNode::createMesgDirID(): Invalid UID");

	String aMesgDirID(String::CreateFromInt64(nMesgUID));
	if (nUIDValidity != 0)
	{
		aMesgDirID += CNT_IMAP_MESG_SET_ID_UIDVALIDITY_SEPARATOR;
		aMesgDirID += String::CreateFromInt64(nUIDValidity);
	}
	return aMesgDirID;
}

//============================================================================
// static
String CntIMAPMesgNode::createDataStreamID(String const & rMboxURL,
										   sal_uInt32 nUIDValidity,
										   sal_uInt32 nMesgUID)
{
	String aDataStreamID(CntIMAPURL::createMesgURL(rMboxURL, nUIDValidity,
												   nMesgUID));
	aDataStreamID.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
		                          CNT_IMAP_MESG_DATA_STREAM_ID_SUFFIX));
	return aDataStreamID;
}

//============================================================================
// static
String CntIMAPMesgNode::createBodyStreamID(String const & rMboxURL,
										   sal_uInt32 nUIDValidity,
										   sal_uInt32 nMesgUID)
{
	String aBodyStreamID(CntIMAPURL::createMesgURL(rMboxURL, nUIDValidity,
												   nMesgUID));
	aBodyStreamID.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
		                          CNT_IMAP_MESG_BODY_STREAM_ID_SUFFIX));
	return aBodyStreamID;
}

//============================================================================
// static
String CntIMAPMesgNode::createBodyStreamID(String const & rMesgURL)
{
	String aBodyStreamID(rMesgURL);
	aBodyStreamID.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
		                          CNT_IMAP_MESG_BODY_STREAM_ID_SUFFIX));
	return aBodyStreamID;
}

//============================================================================
// static
bool CntIMAPMesgNode::isMesgDirID(String const & rMesgDirID,
								  sal_uInt32 & rUIDValidity,
								  sal_uInt32 & rMesgUID)
{
	xub_StrLen nOffset = 0;
	sal_uInt32 nTheMesgUID;
	if (!skipNumber(rMesgDirID, nOffset, nTheMesgUID) || nTheMesgUID == 0)
		return false;

	if (nOffset == rMesgDirID.Len())
	{
		rUIDValidity = 0;
		rMesgUID = nTheMesgUID;
		return true;
	}

	sal_uInt32 nTheUIDValidity;
	if (rMesgDirID.GetChar(nOffset++)
		    != CNT_IMAP_MESG_SET_ID_UIDVALIDITY_SEPARATOR
		|| !skipNumber(rMesgDirID, nOffset, nTheUIDValidity)
		|| nTheUIDValidity == 0 || nOffset != rMesgDirID.Len())
		return false;

	rUIDValidity = nTheUIDValidity;
	rMesgUID = nTheMesgUID;
	return true;
}

//============================================================================
void CntIMAPMesgNode::setBodyProperties(CntNodeJob & rJob)
{
	SfxPoolItem const * pMesgBody;
	if (GetItemState(WID_MESSAGEBODY, false, &pMesgBody) != SFX_ITEM_SET)
		return;

	INetCoreNewsMessage const * pMessage
		= static_cast< CntMessageBodyItem const * >(pMesgBody)->Get();
	if (!pMessage)
		return;

	CntNodeRef xMboxDirNode = getParentMbox().getDirNode(rJob);
	CntStoreItemSetRef xMesgDirSet;
	if (xMboxDirNode.Is())
	{
		String aMboxURL;
		sal_uInt32 nUIDValidity;
		sal_uInt32 nMesgUID;
		CntIMAPURL::decomposeMesgURL(OWN_URL(this), aMboxURL, nUIDValidity,
									 nMesgUID);
		xMesgDirSet = static_cast< CntStorageNode * >(&xMboxDirNode)->
			              openItemSet(aCntIMAPMesgDirSetRanges,
									  createMesgDirID(nUIDValidity, nMesgUID),
									  STREAM_STD_WRITE | STREAM_NOCREATE);
	}

	if (pMessage->GetXPriority().Len() != 0)
	{
		sal_uInt32 nValue;
		if (CntMBXFormat::parseNumericFieldBody(pMessage->GetXPriority(),
												false, false, nValue)
			&& nValue >= 1 && nValue <= 5)
		{
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(CntPriorityItem(WID_PRIORITY,
												 CntPriority(nValue)));
			Put(CntPriorityItem(WID_PRIORITY, CntPriority(nValue)));
		}
		else
		{
			if (xMesgDirSet.Is())
				xMesgDirSet->ClearItem(WID_PRIORITY);
			ClearItem(WID_PRIORITY);
		}
	}

	if (GetItemState(WID_REPLY_TO, false) != SFX_ITEM_SET
		&& pMessage->GetReplyTo().Len() != 0)
	{
		if (xMesgDirSet.Is())
			xMesgDirSet->Put(CntStringItem(WID_REPLY_TO,
										   pMessage->GetReplyTo()));
		Put(CntStringItem(WID_REPLY_TO, pMessage->GetReplyTo()));
	}

	if (GetItemState(WID_IN_REPLY_TO, false) != SFX_ITEM_SET
		&& pMessage->GetInReplyTo().Len() != 0)
	{
		if (xMesgDirSet.Is())
			xMesgDirSet->Put(CntStringItem(WID_IN_REPLY_TO,
										   pMessage->GetInReplyTo()));
		Put(CntStringItem(WID_IN_REPLY_TO, pMessage->GetInReplyTo()));
	}

	if (GetItemState(WID_MESSAGE_ID, false) != SFX_ITEM_SET
		&& pMessage->GetMessageID().Len() != 0)
	{
		if (xMesgDirSet.Is())
			xMesgDirSet->Put(CntStringItem(WID_MESSAGE_ID,
										   pMessage->GetMessageID()));
		Put(CntStringItem(WID_MESSAGE_ID, pMessage->GetMessageID()));
	}

	if (GetItemState(WID_BCC, false) != SFX_ITEM_SET
		&& pMessage->GetBCC().Len() != 0)
	{
		if (xMesgDirSet.Is())
			xMesgDirSet->Put(CntStringItem(WID_BCC, pMessage->GetBCC()));
		Put(CntStringItem(WID_BCC, pMessage->GetBCC()));
	}

	if (GetItemState(WID_CC, false) != SFX_ITEM_SET
		&& pMessage->GetCC().Len() != 0)
	{
		if (xMesgDirSet.Is())
			xMesgDirSet->Put(CntStringItem(WID_CC, pMessage->GetCC()));
		Put(CntStringItem(WID_CC, pMessage->GetCC()));
	}

	if (GetItemState(WID_TO, false) != SFX_ITEM_SET
		&& pMessage->GetTo().Len() != 0)
	{
		if (xMesgDirSet.Is())
			xMesgDirSet->Put(CntStringItem(WID_TO, pMessage->GetTo()));
		Put(CntStringItem(WID_TO, pMessage->GetTo()));
	}

	if (GetItemState(WID_FROM, false) != SFX_ITEM_SET)
		if (pMessage->GetFrom().Len() != 0)
		{
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(CntNameItem(WID_FROM, pMessage->GetFrom()));
			Put(CntNameItem(WID_FROM, pMessage->GetFrom()));
		}
		else if (pMessage->GetSender().Len() != 0)
		{
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(CntNameItem(WID_FROM,
											 pMessage->GetSender()));
			Put(CntNameItem(WID_FROM, pMessage->GetSender()));
		}

	if (pMessage->GetSubject().Len() != 0)
	{
		if (xMesgDirSet.Is())
			xMesgDirSet->Put(CntStringItem(WID_TITLE,
										   pMessage->GetSubject()));
		Put(CntStringItem(WID_TITLE, pMessage->GetSubject()));
	}

	if (pMessage->GetReferences().Len() != 0)
	{
		if (xMesgDirSet.Is())
			xMesgDirSet->Put(CntStringItem(WID_REFERENCES,
										   pMessage->GetReferences()));
		Put(CntStringItem(WID_REFERENCES, pMessage->GetReferences()));
	}

	if (pMessage->GetDate().Len() != 0)
	{
		DateTime aDateTime(0, 0);
		if (CntMBXFormat::parseDateTimeFieldBody(pMessage->GetDate(),
												 aDateTime)
			&& aDateTime.IsValid())
		{
			aDateTime.ConvertToLocalTime();
			if (xMesgDirSet.Is())
				xMesgDirSet->Put(SfxDateTimeItem(WID_DATE_CREATED,
												 aDateTime));
			Put(SfxDateTimeItem(WID_DATE_CREATED, aDateTime));
		}
		else
		{
			if (xMesgDirSet.Is())
				xMesgDirSet->ClearItem(WID_DATE_CREATED);
			ClearItem(WID_DATE_CREATED);
		}
	}

	if (pMessage->GetKeywords().Len() != 0)
	{
		if (xMesgDirSet.Is())
			xMesgDirSet->Put(CntStringItem(WID_KEYWORDS,
										   pMessage->GetKeywords()));
		Put(CntStringItem(WID_KEYWORDS, pMessage->GetKeywords()));
	}
}

//============================================================================
bool CntIMAPMesgNode::getBody(CntNodeJob & rJob)
{
	if (isDeleted() || GetItemState(WID_MESSAGEBODY, false) == SFX_ITEM_SET)
		return true;

	CntStorageNode * pCacheNode = rJob.GetCacheNode();
	if (!pCacheNode)
		return true;

	String aBodyStreamID(getBodyStreamID());
	SvStream * pMesgBodyCacheStream = pCacheNode->openStream(aBodyStreamID,
															 STREAM_STD_READ);
	if (!pMesgBodyCacheStream)
		return false;

	delete pMesgBodyCacheStream;

	CntMessageBodyItem aMesgBody(WID_MESSAGEBODY, aBodyStreamID);
	aMesgBody.Get(pCacheNode, getParentMbox().getAcnt().getINetMailer());

	// Force the following Put() to broadcast an SfxItemChangedHint:
	if (GetItemState(WID_MESSAGEBODY, false) == SFX_ITEM_DISABLED)
		ClearItem(WID_MESSAGEBODY);

	Put(aMesgBody);
	setBodyProperties(rJob);

	return true;
}

//============================================================================
bool CntIMAPMesgNode::mustDownloadBody(CntNodeJob & rJob)
{
	if (isDeleted()
		|| THIS_ITEM_VALUE(CntMsgStoreModeItem, WID_MESSAGE_STOREMODE)
		       == CNT_MESSAGE_STOREMODE_REMOTE)
		return false;

	CntStorageNode * pCacheNode = rJob.GetCacheNode();
	if (!pCacheNode)
		return true;

	return pCacheNode->attrib(getBodyStreamID(), 0, 0)
		       == ERRCODE_IO_NOTEXISTS;
}

//============================================================================
void CntIMAPMesgNode::setKeepBodyFlag(CntNodeJob & rJob, bool bStore)
{
	// If switching from not keeping to keeping the body, and if this node has
	// a body that is not cached, store it into the cache (and if it doesn't
	// even have a cached body, disable WID_MESSAGEBODY to reflect that); if
	// switching from keeping to not keeping the body, undo an eventual
	// disabling of WID_MESSAGEBODY:
	if (ITEM_VALUE(CntMsgStoreModeItem, *rJob.GetRequest())
		    == CNT_MESSAGE_STOREMODE_LOCAL)
	{
		if (THIS_ITEM_VALUE(CntMsgStoreModeItem, WID_MESSAGE_STOREMODE)
			    == CNT_MESSAGE_STOREMODE_REMOTE)
		{
			SfxPoolItem const * pMesgBody;
			if (GetItemState(WID_MESSAGEBODY, false, &pMesgBody)
				    == SFX_ITEM_SET)
			{
				INetCoreNewsMessage * pMessage
					= static_cast< CntMessageBodyItem const * >(pMesgBody)->
					      Get();
				if (pMessage)
				{
					CntStorageNode * pCacheNode = rJob.GetCacheNode();
					if (pCacheNode)
					{
						String aBodyStreamID(getBodyStreamID());
						if (pCacheNode->attrib(aBodyStreamID, 0, 0)
							    == ERRCODE_IO_NOTEXISTS)
						{
							SvStream * pMesgBodyCacheStream
								= pCacheNode->openStream(aBodyStreamID,
														 STREAM_STD_WRITE);
							if (pMesgBodyCacheStream)
							{
								*pMesgBodyCacheStream << CNT_MESSAGEBODY_NEWS;
								CntMessageBodyItem::StoreMessage(
									*pMesgBodyCacheStream, *pMessage);
								delete pMesgBodyCacheStream;

								pCacheNode->attrib(aBodyStreamID, 0,
												   CNTDIRENTRY_ATTRIB_HIDDEN);
							}
						}
					}
				}
			}
			else
			{
				CntStorageNode * pCacheNode = rJob.GetCacheNode();
				if (pCacheNode
					&& pCacheNode->attrib(getBodyStreamID(), 0, 0)
					       == ERRCODE_IO_NOTEXISTS)
					DisableItem(WID_MESSAGEBODY);
			}
		}
	}
	else if (THIS_ITEM_VALUE(CntMsgStoreModeItem, WID_MESSAGE_STOREMODE)
			     == CNT_MESSAGE_STOREMODE_LOCAL
			 && GetItemState(WID_MESSAGEBODY, false) == SFX_ITEM_DISABLED)
		ClearItem(WID_MESSAGEBODY);

	if (bStore)
		storeProperty(rJob, *rJob.GetRequest());
	else
		Put(*rJob.GetRequest());
}

