/*************************************************************************
 *
 *  $RCSfile: imapactt.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/12 16:40:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <limits>

#ifndef _INET_IMAPCLNT_HXX
#include <inet/imapclnt.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef TOOLS_INETMIME_HXX
#include <tools/inetmime.hxx>
#endif

#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTXREF_HXX
#include <cntxref.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CHAOS_EXPORT_HXX
#include <export.hxx>
#endif
#ifndef CHAOS_FLSTITEM_HXX
#include <flstitem.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _CHAOS_IMAP_HXX
#include <imap.hxx>
#endif
#ifndef _CHAOS_IMPORT_HXX
#include <import.hxx>
#endif
#ifndef _PROCHAOS_HRC
#include <prochaos.hrc>
#endif
#ifndef _CHAOS_STRMITEM_HXX
#include <strmitem.hxx>
#endif

#ifndef CHAOS_IMAPACNT_HXX
#include <imapacnt.hxx>
#endif
#ifndef CHAOS_IMAPACTT_HXX
#include <imapactt.hxx>
#endif
#ifndef CHAOS_IMAPMBOX_HXX
#include <imapmbox.hxx>
#endif
#ifndef CHAOS_IMAPMESG_HXX
#include <imapmesg.hxx>
#endif
#ifndef CHAOS_IMAPMSGT_HXX
#include <imapmsgt.hxx>
#endif
#ifndef CHAOS_IMAPSTOR_HXX
#include <imapstor.hxx>
#endif
#ifndef CHAOS_IMAPURL_HXX
#include <imapurl.hxx>
#endif

using namespace chaos;

//============================================================================
namespace chaos {

class CntIMAPAcntMesgCachingPolicy: public CntMessageCachingPolicy
{
	String m_aAcntURL;
	CntStorageNode * m_pCacheNode;

public:
	CntIMAPAcntMesgCachingPolicy(const String & rTheAcntURL,
								 CntStorageNode * pTheCacheNode):
		m_aAcntURL(rTheAcntURL), m_pCacheNode(pTheCacheNode) {}

	bool getMesgURL(const SfxItemSet & rImportSet, String & rMesgURL);

	virtual BOOL doCache(const CntMBXVersion * pVersion, SfxItemSet & rItems,
						 String & rName);

	virtual CntStorageNode * getCacheNode() { return m_pCacheNode; }
};

}

//============================================================================
//
//  CntIMAPAcntMesgCachingPolicy
//
//============================================================================

bool CntIMAPAcntMesgCachingPolicy::getMesgURL(const SfxItemSet & rImportSet,
											  String & rMesgURL)
{
	const SfxPoolItem * pItem;
	if (rImportSet.GetItemState(WID_NEWS_XREFLIST, false, &pItem)
		 != SFX_ITEM_SET)
		return false;

	const CntItemListItem * pXrefList = PTR_CAST(CntItemListItem, pItem);
	if (!pXrefList || pXrefList->Count() != 1)
		return false;

	const SfxPoolItem & rEntry = (*pXrefList)[0];
	if (rEntry.Which() != WID_NEWS_XREF)
		return false;

	const CntCrossReferenceItem * pXref
		= PTR_CAST(CntCrossReferenceItem, &rEntry);
	if (!pXref)
		return false;

	return CntIMAPURL::createMesgURL(m_aAcntURL, pXref->GetGroup(),
									 pXref->GetIndex(), rMesgURL);
}

//============================================================================
// virtual
BOOL CntIMAPAcntMesgCachingPolicy::doCache(const CntMBXVersion * pVersion,
										   SfxItemSet & rItems,
										   String & rName)
{
	if (pVersion && !pVersion->getVersion())
		if (CntMBXVersion0 const * pVersion0
			    = PTR_CAST(CntMBXVersion0, pVersion))
			if (pVersion0->getType() != CntMBXVersion0::TYPE_MESSAGE)
				return false;

	String aMesgURL;
	if (!getMesgURL(rItems, aMesgURL))
		return false;

	rName = CntIMAPMesgNode::createBodyStreamID(aMesgURL);
	return true;
}

//============================================================================
//
//  CntIMAPAcntOpenTask
//
//============================================================================

bool CntIMAPAcntOpenTask::listMbox(CntNode & rMboxNode)
{
	if (static_cast< CntIMAPMboxNode * >(&rMboxNode)->getMbox().isDeleted())
		return false;

	switch (m_eListMboxsMode)
	{
		case CNT_VIEW_ALL_FOLDERS:
			return true;

		case CNT_VIEW_SUBSCRIBED_FOLDERS:
			return ITEMSET_VALUE(&rMboxNode, CntBoolItem,
								 WID_FLAG_SUBSCRIBED)
				       != false;

		default: // CNT_VIEW_ACTIVE_FOLDERS
			return
			 ITEMSET_VALUE(&rMboxNode, CntBoolItem, WID_FLAG_SUBSCRIBED)
			 && !ITEMSET_VALUE(&rMboxNode, CntBoolItem, WID_IS_READ);
	}
}

//============================================================================
// virtual
void CntIMAPAcntOpenTask::beingCanceled()
{
	delete m_pAcntDirIter;
	super::beingCanceled();
}

//============================================================================
// virtual
bool CntIMAPAcntOpenTask::initialize()
{
	if (getJob().GetRequest()->Which() == WID_OPEN)
		switch (ITEM_VALUE(CntOpenModeItem, *getJob().GetRequest()))
		{
			case CNT_OPEN_ALL:
			case CNT_OPEN_FOLDERS:
				break;

			default:
				done();
				return false;
		}

	m_eListMboxsMode;
	switch (getJob().GetRequest()->Which())
	{
		case WID_OPEN:
		case WID_SEARCH:
			m_eListMboxsMode
				= CntFolderViewMode(ITEMSET_VALUE(getJob().GetClient(),
												  CntFolderViewModeItem,
												  WID_FOLDERVIEW_MODE));
			break;

		default:
			m_eListMboxsMode = CNT_VIEW_ALL_FOLDERS;
			break;
	}

	m_aAcntURL = OWN_URL(&getAcnt().getNode());
	m_xAcntDirNode = getAcnt().getDirNode(getJob());

	sal_uInt32 nAcntDirAttribs = 0;
	if (m_xAcntDirNode.Is())
		static_cast< CntStorageNode * >(&m_xAcntDirNode)->
			attrib(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(
				                               CNT_IMAP_ACNT_SET_ID)),
				   0, 0, nAcntDirAttribs);

	m_bCompleteSubscribedMboxs
		= (nAcntDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_ACNT_SSCRBD_MBOXS) != 0;
	m_bCompleteMboxs
		= m_eListMboxsMode != CNT_VIEW_ALL_FOLDERS
		  || nAcntDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_ACNT_MBOXS;
	m_bAutoSubscribeChecked
		= (nAcntDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_ACNT_AUTO_CHECKED) != 0;

	m_bUpdate = getJob().GetRequest()->Which() == WID_UPDATE
	            || getJob().GetRequest()->Which() == WID_SYNCHRONIZE
	            || ITEMSET_VALUE(getJob().GetClient(), CntBoolItem,
								 WID_FLAG_UPDATE_ON_OPEN);

	if (m_bInboxOnly)
	{
		m_bAutoSubscribeChecked = true;
		m_bAutoSubscribe = false;
	}
	else
		m_bAutoSubscribe = !m_bAutoSubscribeChecked
			               || getJob().GetRequest()->Which()
			                      == WID_SYNCHRONIZE;

	if (m_xAcntDirNode.Is())
		m_pAcntDirIter = new CntStorageIterator(CNTDIRENTRY_ATTRIB_IMAP_MBOX);

	m_bOfflineDone = false;
	m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;

	m_nMboxCount = 0;
	m_nSscrbdMboxCount = 0;
	m_nNewMboxCount = 0;
	m_nRemovedMboxCount = 0;
	m_bModifiedSubscribed = false;

	return false;
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPAcntOpenTask::executeState(const INetIMAPResponse * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_NAMESPACE:
#if 0 // no NAMESPACE
			if (m_bInboxOnly
				|| !(getClient().hasDeterminedCapabilities()
					 && getClient().getCapabilities()
					     & INetIMAPClient::CAPABILITY_NAMESPACE))
#endif // no NAMESPACE
			{
				m_nState = STATE_SEND_LSUB;
				return EXEC_CONTINUE;
			}

			++m_nState;
			return handleCommandFailure(clientCommandNamespace());


		case STATE_RECV_NAMESPACE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						    == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
						 = handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						m_nState = STATE_SEND_LSUB;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_NAMESPACE:
				{
					INetIMAPNamespaceResponse const & rNamespaceResponse
						= *static_cast< INetIMAPNamespaceResponse const * >(
							   pResponse);

					for (int nKind
							 = INetIMAPNamespaceResponse::NAMESPACE_PERSONAL;
						 nKind <= INetIMAPNamespaceResponse::NAMESPACE_SHARED;
						 ++nKind)
					{
						INetIMAPNamespaceList const * pList
							= rNamespaceResponse.
						          getNamespaces(
									 INetIMAPNamespaceResponse::NamespaceKind(
										  nKind));
						if (pList)
							for (ULONG i = 0; i < pList->getCount(); ++i)
							{
								INetIMAPNamespace const & rNamespace
									= pList->get(i);
								ByteString aPrefix(rNamespace.getPrefix());
								sal_Char cSep
									= rNamespace.getHierarchySeparator();

								bool bSimple = false;
								if (aPrefix.Len() != 0)
									if (cSep != '\0')
									{
										xub_StrLen nPos
											= aPrefix.Search(cSep);
										if (nPos == STRING_NOTFOUND)
											bSimple = true;
										else if (nPos == aPrefix.Len() - 1
												 && nPos != 0)
										{
											aPrefix.Erase(nPos);
											bSimple = true;
										}
									}
									else
										bSimple = true;
								if (bSimple
									&& INetMIME::equalIgnoreCase(
										   aPrefix,
										   INET_IMAP_CANONIC_INBOX_NAME))
									bSimple = false;

								if (bSimple)
								{
									String aMboxURL(CntIMAPURL::createMboxURL(
										                m_aAcntURL, aPrefix,
														cSep));
									CntNodeRef xMboxNode(getAcnt().getNode().
														     Query(aMboxURL));
									if (xMboxNode.Is())
									{
										// The mbox initialize needs an
										// INetIMAPListResponseMailbox struct
										// to store the hierarchy separator,
										// so fake reasonable \Noinferiors and
										// \Noselect flags:
										INetIMAPListResponseMailbox aMboxFake;
										if (cSep != '\0')
											aMboxFake.
												addFlags(
								  INetIMAPListResponseMailbox::FLAG_NOSELECT);
										aMboxFake.setHierarchySeparator(cSep);

										if (static_cast< CntIMAPMboxNode * >(
											        &xMboxNode)->
											    getMbox().
											        initialize(
														getJob(), true,
														&aMboxFake, false,
													m_bCompleteSubscribedMboxs
														&& m_bCompleteMboxs))
											++m_nNewMboxCount;
										++m_nMboxCount;

										if (listMbox(*xMboxNode))
										{
											if (m_bUpdate)
											{
												//@@@
											}

											getJob().Result(xMboxNode);
											switch (getJob().GetRequest()->
													    Which())
											{
												case WID_SEARCH:
													getJob().
														ResultSearchMatch(
															xMboxNode);
													break;

												case WID_SYNCHRONIZE:
													m_aSyncMboxList.
														remove(aMboxURL);
													break;
											}
										}
									}
								}
							}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_SEND_LSUB:
		{
			if (m_bCompleteSubscribedMboxs && !m_bUpdate && !m_bAutoSubscribe)
			{
				m_nState = STATE_SEND_LIST;
				return EXEC_CONTINUE;
			}

			pushStatusInformation(CntResId(RID_READING_SUBFOLDERS),
								  CntIMAPStatusInformation::TAG_NONE, true);

			if (m_bAutoSubscribe)
				m_aAutoSscrbMboxList.
					add(getJob(), getAcnt().getNode(), ByteString(),
						ByteString(RTL_CONSTASCII_STRINGPARAM(
							           INET_IMAP_CANONIC_INBOX_NAME)),
						'\0', false);

			ByteString aPattern;
			if (m_bInboxOnly)
				aPattern.Assign(RTL_CONSTASCII_STRINGPARAM(
					                INET_IMAP_CANONIC_INBOX_NAME));
			else if (m_bAutoSubscribe)
				aPattern = INET_IMAP_LIST_WILDCARD_SEPARATOR;
			else
				aPattern = INET_IMAP_LIST_WILDCARD_NON_SEPARATOR;

			++m_nState;
			return handleCommandFailure(clientCommandLSub(ByteString(),
														  aPattern));
		}

		case STATE_RECV_LSUB:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (!m_bCompleteSubscribedMboxs && !m_bInboxOnly)
						{
							if (m_xAcntDirNode.Is())
								static_cast< CntStorageNode * >(
									    &m_xAcntDirNode)->
									attrib(
										String::CreateFromAscii(
											RTL_CONSTASCII_STRINGPARAM(
												CNT_IMAP_ACNT_SET_ID)),
										0,
								   CNTDIRENTRY_ATTRIB_IMAP_ACNT_SSCRBD_MBOXS);
							if (getAcnt().getNode().
								        GetItemState(
											WID_IMAP_SSCRBD_MBOX_COUNT,
											false)
								    != SFX_ITEM_SET)
								getAcnt().
								 storeProperty
								  (CntUInt32Item(WID_IMAP_SSCRBD_MBOX_COUNT,
												 0),
								   getJob());
						}

						popStatusInformation();

						m_nState = STATE_UNSUBSCRIBE;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					const INetIMAPListResponse & rListResponse
						= *static_cast< const INetIMAPListResponse * >(
							   pResponse);

					for (ULONG i = 0; i < rListResponse.getMailboxCount();
						 ++i)
					{
						const INetIMAPListResponseMailbox & rMbox
							= rListResponse.getMailbox(i);
						ByteString aMboxLiteralFullName;
						if (isRootMbox(rMbox, aMboxLiteralFullName))
						{
							if (!m_bInboxOnly
								|| aMboxLiteralFullName
								       == INET_IMAP_CANONIC_INBOX_NAME)
							{
								String aMboxURL
									= CntIMAPURL::createMboxURL(
										  m_aAcntURL, aMboxLiteralFullName,
										  rMbox.getHierarchySeparator());
								CntNodeRef xMboxNode
									= getAcnt().getNode().Query(aMboxURL);
								if (xMboxNode.Is())
								{
									bool bSubscribedChanged;
									if (static_cast< CntIMAPMboxNode * >(
										        &xMboxNode)->
									        getMbox().
										        initialize(
													getJob(), true, &rMbox,
													true,
													m_bCompleteSubscribedMboxs
													&& m_bCompleteMboxs,
													&bSubscribedChanged))
										++m_nNewMboxCount;
									++m_nSscrbdMboxCount;
									if (bSubscribedChanged)
										m_bModifiedSubscribed = true;

									if (listMbox(*xMboxNode))
									{
										if (m_bUpdate)
										{
											m_aSelectMboxList.
												add(aMboxURL,
													aMboxLiteralFullName
											   != INET_IMAP_CANONIC_INBOX_NAME
													&& !static_cast
													    < CntIMAPMboxNode * >(
																 &xMboxNode)->
													        getMbox().
													            getSelect());
											m_aSscrbdMboxList.
												remove(aMboxURL);
										}

										getJob().Result(xMboxNode);
										switch (getJob().GetRequest()->
												    Which())
										{
											case WID_SEARCH:
												getJob().ResultSearchMatch(
													         xMboxNode);
												break;

											case WID_SYNCHRONIZE:
												m_aSyncMboxList.
													remove(aMboxURL);
												break;
										}
									}
								}

								if (m_bAutoSubscribe)
									m_aAutoSscrbMboxList.
										add(getJob(), getAcnt().getNode(),
											ByteString(),
											aMboxLiteralFullName,
											rMbox.getHierarchySeparator(),
											true);
							}
						}
						else if (m_bAutoSubscribe
								 && isSubMbox(ByteString(), rMbox,
											  aMboxLiteralFullName))
								m_aAutoSscrbMboxList.
									add(getJob(), getAcnt().getNode(),
										ByteString(), aMboxLiteralFullName,
										rMbox.getHierarchySeparator(), true);
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_UNSUBSCRIBE:
			if (m_bUpdate)
			{
				startTimeSlice();

				while (m_aSscrbdMboxList.iter(m_aMboxURL))
				{
					CntNodeRef xMboxNode
						= getAcnt().getNode().Query(m_aMboxURL);
					if (xMboxNode.Is())
					{
						static_cast< CntIMAPMboxNode * >(&xMboxNode)->
							getMbox().initialize(getJob());
						static_cast< CntIMAPMboxNode * >(&xMboxNode)->
							getMbox().
							    storeProperty(getJob(),
											  CntBoolItem(WID_FLAG_SUBSCRIBED,
														  false));
						m_bModifiedSubscribed = true;
						if (!listMbox(*xMboxNode))
							getJob().Result(xMboxNode, CNT_ACTION_REMOVED);

						if (checkTimeSliceExhausted())
							return EXEC_RESCHEDULE;
					}
				}
			}

			m_nState = STATE_SEND_LIST;
			return EXEC_CONTINUE;

		case STATE_SEND_LIST:
		{
			if (m_bCompleteMboxs && !m_bUpdate)
			{
				m_nState = STATE_SEND_SELECT;
				return EXEC_CONTINUE;
			}

			pushStatusInformation(CntResId(RID_READING_SUBFOLDERS),
								  CntIMAPStatusInformation::TAG_NONE, true);

			ByteString aPattern;
			if (m_bInboxOnly)
				aPattern.Assign(RTL_CONSTASCII_STRINGPARAM(
					                INET_IMAP_CANONIC_INBOX_NAME));
			else
				aPattern = INET_IMAP_LIST_WILDCARD_NON_SEPARATOR;

			++m_nState;
			return handleCommandFailure(clientCommandList(ByteString(),
														  aPattern));
		}

		case STATE_RECV_LIST:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (!m_bCompleteMboxs && !m_bInboxOnly)
						{
							if (m_xAcntDirNode.Is())
								static_cast< CntStorageNode * >(
									    &m_xAcntDirNode)->
									attrib(
										String::CreateFromAscii(
											RTL_CONSTASCII_STRINGPARAM(
												CNT_IMAP_ACNT_SET_ID)),
										0,
										CNTDIRENTRY_ATTRIB_IMAP_ACNT_MBOXS);
							if (getAcnt().getNode().
								        GetItemState(WID_IMAP_MBOX_COUNT,
													 false)
								    != SFX_ITEM_SET)
								getAcnt().
									storeProperty(CntUInt32Item(
										              WID_IMAP_MBOX_COUNT, 0),
												  getJob());
						}

						popStatusInformation();

						m_nState = STATE_SEND_SELECT;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					const INetIMAPListResponse & rListResponse
						= *static_cast< const INetIMAPListResponse * >(
							   pResponse);

					for (ULONG i = 0; i < rListResponse.getMailboxCount();
						 ++i)
					{
						const INetIMAPListResponseMailbox & rMbox
							= rListResponse.getMailbox(i);
						ByteString aMboxLiteralFullName;
						if (isRootMbox(rMbox, aMboxLiteralFullName)
							&& (!m_bInboxOnly
								|| aMboxLiteralFullName
								       == INET_IMAP_CANONIC_INBOX_NAME))
						{
							String aMboxURL
								= CntIMAPURL::createMboxURL(
									  m_aAcntURL, aMboxLiteralFullName,
									  rMbox.getHierarchySeparator());
							CntNodeRef xMboxNode
								= getAcnt().getNode().Query(aMboxURL);
							if (xMboxNode.Is())
							{
								if (static_cast< CntIMAPMboxNode * >(
									        &xMboxNode)->
									    getMbox().
									        initialize(
												getJob(), true, &rMbox, false,
												m_bCompleteSubscribedMboxs
												&& m_bCompleteMboxs))
									++m_nNewMboxCount;
								++m_nMboxCount;

								if (listMbox(*xMboxNode))
								{
									if (m_bUpdate)
										if (aMboxLiteralFullName
											   == INET_IMAP_CANONIC_INBOX_NAME
											|| static_cast
											           < CntIMAPMboxNode * >(
														   &xMboxNode)->
											       getMbox().getSelect())
											m_aSelectMboxList.add(aMboxURL);
										else
											m_aSelectMboxList.
												remove(aMboxURL);

									getJob().Result(xMboxNode);
									switch (getJob().GetRequest()->Which())
									{
										case WID_SEARCH:
											getJob().
												ResultSearchMatch(xMboxNode);
											break;

										case WID_SYNCHRONIZE:
											m_aSyncMboxList.remove(aMboxURL);
											break;
									}
								}
							}
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_SEND_SELECT:
		{
			if (m_nProgress == CntIMAPStatusInformation::NO_PROGRESS)
			{
				pushStatusInformation(CntResId(RID_UPDATING_SUBFOLDERS), 0,
									  m_aSelectMboxList.getCount());
				m_nProgress = 0;
			}

			if (!m_aSelectMboxList.iter(m_aMboxURL))
			{
				popStatusInformation();
				m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;

				m_nState = STATE_SYNC;
				return EXEC_CONTINUE;
			}

			m_bMboxHasMesgCount = false;

			ByteString aMboxLiteralFullName;
			CntIMAPURL::getMboxLiteralFullName(m_aMboxURL, 0,
											   aMboxLiteralFullName);

			++m_nState;
			return handleCommandFailure(clientCommandSelect(
				                            aMboxLiteralFullName));
		}

		case STATE_RECV_SELECT:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal())
						switch (rStateResponse.getState())
						{
							case INetIMAPStateResponse::STATE_OK:
							case INetIMAPStateResponse::STATE_NO:
							{
								// At least the 'Solstice (tm) Internet Mail
								// Server (tm) IMAP4 service @ 2.0' in some
								// cases sends tagged NO responses when
								// requested to SELECT a mailbox it advertised
								// as *not* being marked \NoSelect.

								Execution eExecution
								 = handleAlertResponse(rStateResponse);
								if (eExecution != EXEC_NOTHING)
									return eExecution;

								if (rStateResponse.getState()
									 == INetIMAPStateResponse::STATE_OK
									&& m_bMboxHasMesgCount)
								{
									CntNodeRef xMboxNode(getAcnt().getNode().
														  Query(m_aMboxURL));
									if (xMboxNode.Is())
									{
										static_cast< CntIMAPMboxNode * >(
											    &xMboxNode)->
											getMbox().initialize(getJob());

										static_cast< CntIMAPMboxNode * >(
											    &xMboxNode)->
											getMbox().setServerMesgCount(
												          getJob(),
														  m_nMboxMesgCount);
									}
								}

								progressStatusInformation(++m_nProgress);

								--m_nState;
								return EXEC_RESCHEDULE;
							}
						}
					break;
				}

				case INetIMAPResponse::TYPE_EXISTS:
					m_bMboxHasMesgCount = true;
					m_nMboxMesgCount
						= static_cast< const INetIMAPExistsResponse * >(
							      pResponse)->
					          getMessageCount();
					return EXEC_DONE;
			}
			break;

		case STATE_SYNC:
			if (getJob().GetRequest()->Which() == WID_SYNCHRONIZE)
			{
				if (m_nProgress == CntIMAPStatusInformation::NO_PROGRESS)
				{
					m_nRemovedMboxCount = m_aSyncMboxList.getCount();

					pushStatusInformation(CntResId(RID_SYNCHRONIZING_FOLDER),
										  0, m_nRemovedMboxCount);
					m_nProgress = 0;
				}

				startTimeSlice();

				while (m_aSyncMboxList.iter(m_aMboxURL))
				{
					CntNodeRef
						xMboxNode(getAcnt().getNode().Query(m_aMboxURL));
					if (xMboxNode.Is())
					{
						static_cast< CntIMAPMboxNode * >(&xMboxNode)->
							getMbox().initialize(getJob());

						if (!static_cast< CntIMAPMboxNode * >(&xMboxNode)->
							     getMbox().isDeleted())
						{
							getAcnt().changeMboxCounts
							           (getJob(),
										CntIMAPFldr::COUNT_DEC,
										ITEMSET_VALUE(xMboxNode, CntBoolItem,
													  WID_FLAG_SUBSCRIBED) ?
										 CntIMAPFldr::COUNT_DEC :
										 CntIMAPFldr::COUNT_STAY);
							static_cast< CntIMAPMboxNode * >(&xMboxNode)->
								getMbox().setDeleted(true);
						}

						if (m_xAcntDirNode.Is())
							static_cast< CntStorageNode * >(&m_xAcntDirNode)->
								remove(m_aMboxURL);

						getJob().Result(xMboxNode, CNT_ACTION_DELETED);
					}

					++m_nProgress;

					if (checkTimeSliceExhausted())
					{
						progressStatusInformation(m_nProgress);
						return EXEC_RESCHEDULE;
					}
				}

				popStatusInformation();

				getAcnt().storeProperty(CntUInt32Item(WID_IMAP_MBOX_COUNT,
													  m_nMboxCount),
										getJob());
				getAcnt().
				 storeProperty(CntUInt32Item(WID_IMAP_SSCRBD_MBOX_COUNT,
											 m_nSscrbdMboxCount),
							   getJob());
			}

			m_nState = m_bAutoSubscribe ? STATE_SEND_CHECK_LIST : STATE_DONE;
			return EXEC_CONTINUE;

		case STATE_SEND_CHECK_LIST:
		{
			sal_Char cHierarchySeparator;
			if (!m_aAutoSscrbMboxList.iter(true, ByteString(),
										   m_aMboxLiteralFullName,
										   cHierarchySeparator))
			{
				m_nState = STATE_ASK_AUTO_SUBSCRIBE;
				return EXEC_CONTINUE;
			}
			m_bFound = false;

			++m_nState;
			return handleCommandFailure(clientCommandList(
				                            ByteString(),
											m_aMboxLiteralFullName));
		}

		case STATE_RECV_CHECK_LIST:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						if (!m_bFound)
							m_aAutoSscrbMboxList.removeSubscribed();

						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						--m_nState;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					const INetIMAPListResponse & rListResponse
						= *static_cast< const INetIMAPListResponse * >(
							   pResponse);

					for (ULONG i = 0;
						 !m_bFound && i < rListResponse.getMailboxCount();
						 ++i)
					{
						ByteString aRecvdMboxLiteralFullName;
						if (isSubMbox(ByteString(),
									  rListResponse.getMailbox(i),
									  aRecvdMboxLiteralFullName)
							&& aRecvdMboxLiteralFullName
							       == m_aMboxLiteralFullName)
							m_bFound = true;
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_ASK_AUTO_SUBSCRIBE:
			m_bAutoSubscribe = m_bAutoSubscribe
				               && m_aAutoSscrbMboxList.hasEntries();

			if (m_bAutoSubscribe)
				switch (handleError(
					        *new StringErrorInfo(
								     ERRCODE_CHAOS_IMAP_AUTO_SUBSCRIBE,
									 ITEMSET_VALUE(&getAcnt().getNode(),
												   CntStringItem,
												   WID_SERVERNAME)),
							false))
				{
					case ERROR_RESPONSE_ABORT:
						cancel();
					case ERROR_RESPONSE_CANCELED:
						return EXEC_DONE;

					default:
						m_bAutoSubscribe = false;
					case ERROR_RESPONSE_RETRY:
							//@@@ i.e., yes, see ThreadTask::handleError()
						break;
				}

			m_nState = m_bAutoSubscribe ? STATE_SEND_SUBSCRIBE : STATE_DONE;
			return EXEC_CONTINUE;

		case STATE_SEND_SUBSCRIBE:
		{
			sal_Char cHierarchySeparator;
			if (!m_aAutoSscrbMboxList.iter(false, ByteString(),
										   m_aMboxLiteralFullName,
										   cHierarchySeparator))
			{
				m_nState = STATE_DONE;
				return EXEC_CONTINUE;
			}

			m_aMboxURL = CntIMAPURL::createMboxURL(m_aAcntURL,
												   m_aMboxLiteralFullName,
												   cHierarchySeparator);

			++m_nState;
			return handleCommandFailure(clientCommandSubscribe(
				                            m_aMboxLiteralFullName));
		}

		case STATE_RECV_SUBSCRIBE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal())
						switch (rStateResponse.getState())
						{
							case INetIMAPStateResponse::STATE_OK:
							{
								CntNodeRef xMboxNode
									= getAcnt().getNode().Query(m_aMboxURL);
								if (xMboxNode.Is())
								{
									static_cast< CntIMAPMboxNode * >(
										    &xMboxNode)->
										getMbox().initialize(getJob());
									static_cast< CntIMAPMboxNode * >(
										    &xMboxNode)->
										getMbox().storeProperty(
											          getJob(),
													  CntBoolItem(
														  WID_FLAG_SUBSCRIBED,
														  true));
									if (xMboxNode->GetParent()
										    == &getAcnt().getNode())
									{
										m_bModifiedSubscribed = true;
										if (listMbox(*xMboxNode))
											getJob().
												Result(xMboxNode,
													   CNT_ACTION_INSERTED);
									}
								}
							}
							case INetIMAPStateResponse::STATE_NO:
								Execution eExecution
									= handleAlertResponse(rStateResponse);
								if (eExecution != EXEC_NOTHING)
									return eExecution;

								--m_nState;
								return EXEC_CONTINUE;
						}
					break;
				}
			}
			break;

		case STATE_DONE:
			if (!m_bAutoSubscribeChecked && m_xAcntDirNode.Is())
				static_cast< CntStorageNode * >(&m_xAcntDirNode)->
					attrib(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(
						                               CNT_IMAP_ACNT_SET_ID)),
						   0, CNTDIRENTRY_ATTRIB_IMAP_ACNT_AUTO_CHECKED);

			if (getJob().GetClient())
			{
				if (getJob().GetRequest()->Which() == WID_UPDATE
					|| getJob().GetRequest()->Which() == WID_SYNCHRONIZE)
				{
					if (m_bModifiedSubscribed)
						getJob().GetClient()->
							Broadcast(CntFolderStateHint(
								          std::numeric_limits< ULONG >::max(),
										  CNTFOLDER_SUBSCR));
					getJob().GetClient()->
						Broadcast(CntFolderStateHint(m_nNewMboxCount,
													 CNTFOLDER_NEW));
				}
				if (getJob().GetRequest()->Which() == WID_SYNCHRONIZE)
					getJob().GetClient()->
						Broadcast(CntFolderStateHint(m_nRemovedMboxCount,
													 CNTFOLDER_REMOVED));
			}

			done();
			return EXEC_DONE;

		case STATE_START_OFFLINE:
			if (m_bOfflineDone)
			{
				cancel();
				return EXEC_DONE;
			}

			if (m_nProgress == CntIMAPStatusInformation::NO_PROGRESS)
			{
				pushStatusInformation(CntResId(RID_OPENING_FOLDER), 0,
									  m_bInboxOnly ?
									   1 :
									   ITEMSET_VALUE
									    (&getAcnt().getNode(), CntUInt32Item,
										 m_eListMboxsMode
										   == CNT_VIEW_ALL_FOLDERS ?
										  WID_IMAP_MBOX_COUNT :
										  WID_IMAP_SSCRBD_MBOX_COUNT));
				m_nProgress = 0;
			}

			startTimeSlice();

			while (m_pAcntDirIter)
			{
				String aAcntDirEntryID;
				sal_uInt32 nAcntDirEntryAttribs;
				if (m_bInboxOnly)
				{
					delete m_pAcntDirIter;
					m_pAcntDirIter = 0;
					aAcntDirEntryID = CntIMAPURL::createSubMboxURL
					                   (m_aAcntURL,
										INET_IMAP_CANONIC_INBOX_NAME);
					if (static_cast< CntStorageNode * >(&m_xAcntDirNode)->
						        attrib(aAcntDirEntryID, 0, 0,
									   nAcntDirEntryAttribs)
						    == ERRCODE_IO_NOTEXISTS)
						break;
				}
				else
				{
					String
						aID(static_cast< CntStorageNode * >(&m_xAcntDirNode)->
							    iter(*m_pAcntDirIter));
					if (m_pAcntDirIter->eof())
					{
						delete m_pAcntDirIter;
						m_pAcntDirIter = 0;
						break;
					}
					aAcntDirEntryID = aID;
					nAcntDirEntryAttribs = (**m_pAcntDirIter).m_nAttrib;
				}

				if ((m_eListMboxsMode == CNT_VIEW_ALL_FOLDERS
					 || nAcntDirEntryAttribs
					     & CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD)
					&& CntIMAPURL::isRootMboxURL(m_aAcntURL, aAcntDirEntryID))
				{
					CntNodeRef xMboxNode(getAcnt().getNode().
										  Query(aAcntDirEntryID));
					if (xMboxNode.Is())
					{
						static_cast< CntIMAPMboxNode * >(&xMboxNode)->
							getMbox().initialize(getJob());

						if (listMbox(*xMboxNode))
						{
							if (m_bUpdate
								&& ITEMSET_VALUE(xMboxNode, CntBoolItem,
												 WID_FLAG_SUBSCRIBED))
								m_aSscrbdMboxList.add(aAcntDirEntryID);

							switch (getJob().GetRequest()->Which())
							{
								case WID_OPEN:
								case WID_SEARCH:
									if (m_bUpdate
										&& (aAcntDirEntryID.
											    EqualsAscii(
												 INET_IMAP_CANONIC_INBOX_NAME)
											|| static_cast<
											           CntIMAPMboxNode * >(
														   &xMboxNode)->
											       getMbox().getSelect()))
										m_aSelectMboxList.
											add(aAcntDirEntryID);

									getJob().Result(xMboxNode);
									if (getJob().GetRequest()->Which()
										    == WID_SEARCH)
										getJob().ResultSearchMatch(xMboxNode);
									break;

								case WID_SYNCHRONIZE:
									m_aSyncMboxList.add(aAcntDirEntryID);
									break;
							}
						}
					}

					++m_nProgress;
				}

				if (checkTimeSliceExhausted())
				{
					progressStatusInformation(m_nProgress);
					return EXEC_RESCHEDULE;
				}
			}

			popStatusInformation();
			m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;

			m_bOfflineDone = true;

			if (m_bUpdate || !m_bCompleteSubscribedMboxs || !m_bCompleteMboxs
				|| m_bAutoSubscribe)
			{
				m_nState = STATE_GO_ONLINE;
				return EXEC_CONTINUE;
			}
			else
			{
				done();
				return EXEC_DONE;
			}

		case STATE_GO_ONLINE:
			if (CntIMAPOnlineTask::initialize())
			{
				m_nState = STATE_RESTART_ONLINE;
				return EXEC_CONTINUE;
			}

			if ((getJob().GetRequest()->Which() == WID_OPEN
				 || getJob().GetRequest()->Which() == WID_SEARCH)
				/*&& m_bCompleteSubscribedMboxs && m_bCompleteMboxs*/)
			{
				done();
				return EXEC_DONE;
			}

			switch (handleError(ERRCODE_CHAOS_OFFLINE))
			{
				case ERROR_RESPONSE_ABORT:
					cancel();
				case ERROR_RESPONSE_CANCELED:
					return EXEC_DONE;

				case ERROR_RESPONSE_RETRY:
					return EXEC_CONTINUE;

				default:
					done();
					return EXEC_DONE;
			}

		default:
			return CntIMAPOnlineTask::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
//
//  CntIMAPAcntGetMboxsTask
//
//============================================================================

void CntIMAPAcntGetMboxsTask::finish()
{
	getAcnt().getNode().Put(CntFolderListItem(WID_NEWS_GROUPLIST,
											  m_pMboxList));
	m_pMboxList = 0;
	done();
}

//============================================================================
// virtual
void CntIMAPAcntGetMboxsTask::beingCanceled()
{
	delete m_pAcntDirIter;
	if (m_pMboxList)
	{
		while (m_pMboxList->Count())
			delete m_pMboxList->Remove(m_pMboxList->Count() - 1);
		delete m_pMboxList;
	}
	super::beingCanceled();
}

//============================================================================
// virtual
bool CntIMAPAcntGetMboxsTask::initialize()
{
	m_aAcntURL = OWN_URL(&getAcnt().getNode());
	m_xAcntDirNode = getAcnt().getDirNode(getJob());

	m_bSubscribedMboxsOnly
		= static_cast< const CntFolderListItem * >(getJob().GetRequest())->
		          getCommand()
		      == CntFolderListItem::GET_SUBSCRIBED;

	sal_uInt32 nAcntDirAttribs = 0;
	if (m_xAcntDirNode.Is())
		static_cast< CntStorageNode * >(&m_xAcntDirNode)->
			attrib(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(
				                               CNT_IMAP_ACNT_SET_ID)),
				   0, 0, nAcntDirAttribs);

	m_bCompleteSubscribedMboxs
		= (nAcntDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_ACNT_SSCRBD_MBOXS) != 0;
	m_bCompleteMboxs
		= (nAcntDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_ACNT_MBOXS) != 0;

	if (m_xAcntDirNode.Is())
		m_pAcntDirIter = new CntStorageIterator(CNTDIRENTRY_ATTRIB_IMAP_MBOX);
	m_pMboxList = new CntFolderList;

	m_bOfflineDone = false;
	m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;

	return false;
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPAcntGetMboxsTask::executeState(const INetIMAPResponse * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_LSUB:
			if (m_bCompleteSubscribedMboxs)
			{
				m_nState = STATE_SEND_LIST;
				return EXEC_CONTINUE;
			}

			pushStatusInformation(CntResId(RID_READING_SUBFOLDERS),
								  CntIMAPStatusInformation::TAG_NONE, true);

			++m_nState;
			return
				handleCommandFailure(
					clientCommandLSub(ByteString(),
									  INET_IMAP_LIST_WILDCARD_NON_SEPARATOR));

		case STATE_RECV_LSUB:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (m_xAcntDirNode.Is())
							static_cast< CntStorageNode * >(&m_xAcntDirNode)->
								attrib(
									String::CreateFromAscii(
										RTL_CONSTASCII_STRINGPARAM(
											CNT_IMAP_ACNT_SET_ID)),
									0,
								   CNTDIRENTRY_ATTRIB_IMAP_ACNT_SSCRBD_MBOXS);
						if (getAcnt().getNode().
							        GetItemState(WID_IMAP_SSCRBD_MBOX_COUNT,
												 false)
							    != SFX_ITEM_SET)
							getAcnt().
								storeProperty(CntUInt32Item(
									              WID_IMAP_SSCRBD_MBOX_COUNT,
												  0),
											  getJob());

						popStatusInformation();

						m_nState = STATE_SEND_LIST;
						return EXEC_CONTINUE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					INetIMAPListResponse const & rListResponse
						= *static_cast< INetIMAPListResponse const * >(
							   pResponse);

					for (ULONG i = 0; i < rListResponse.getMailboxCount();
						 ++i)
					{
						INetIMAPListResponseMailbox const & rMbox
							= rListResponse.getMailbox(i);
						ByteString aMboxLiteralFullName;
						if (isRootMbox(rMbox, aMboxLiteralFullName))
						{
							String
								aMboxURL(CntIMAPURL::createMboxURL(
									         m_aAcntURL, aMboxLiteralFullName,
											 rMbox.getHierarchySeparator()));
							CntNodeRef xMboxNode(getAcnt().getNode().
												     Query(aMboxURL));
							if (xMboxNode.Is())
							{
								static_cast< CntIMAPMboxNode * >(&xMboxNode)->
									getMbox().initialize(getJob(), true,
														 &rMbox, true, false);

								ByteString
									aMboxLiteralLastName(
										CntIMAPURL::getMboxLiteralLastName(
											aMboxURL));
								String
									aMboxTitle(CntIMAPUTF7::translateFromUTF7(
										           aMboxLiteralLastName,
												   false));
								String aMboxID(aMboxLiteralLastName,
											   RTL_TEXTENCODING_ISO_8859_1);
								ULONG nIndex;
								if (m_pMboxList->find(aMboxTitle, aMboxID,
													  nIndex))
									m_pMboxList->GetObject(nIndex)->
										Subscribe();
								else
									m_pMboxList->
										Insert(new CntFolderEntry(aMboxTitle,
																  aMboxID,
																  sal_True));
							}
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_SEND_LIST:
			if (m_bSubscribedMboxsOnly || m_bCompleteMboxs)
			{
				finish();
				return EXEC_DONE;
			}

			pushStatusInformation(CntResId(RID_READING_SUBFOLDERS),
								  CntIMAPStatusInformation::TAG_NONE, true);

			++m_nState;
			return
				handleCommandFailure(
					clientCommandList(ByteString(),
									  INET_IMAP_LIST_WILDCARD_NON_SEPARATOR));

		case STATE_RECV_LIST:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						if (m_xAcntDirNode.Is())
							static_cast< CntStorageNode * >(&m_xAcntDirNode)->
								attrib(String::CreateFromAscii(
									       RTL_CONSTASCII_STRINGPARAM(
											   CNT_IMAP_ACNT_SET_ID)),
									   0,
									   CNTDIRENTRY_ATTRIB_IMAP_ACNT_MBOXS);
						if (getAcnt().getNode().
							        GetItemState(WID_IMAP_MBOX_COUNT, false)
							    != SFX_ITEM_SET)
							getAcnt().storeProperty(CntUInt32Item(
								                        WID_IMAP_MBOX_COUNT,
														0),
													getJob());

						popStatusInformation();

						finish();
						return EXEC_DONE;
					}
					break;
				}

				case INetIMAPResponse::TYPE_LIST:
				{
					INetIMAPListResponse const & rListResponse
						= *static_cast< INetIMAPListResponse const * >(
							   pResponse);

					for (ULONG i = 0; i < rListResponse.getMailboxCount();
						 ++i)
					{
						INetIMAPListResponseMailbox const & rMbox
							= rListResponse.getMailbox(i);
						ByteString aMboxLiteralFullName;
						if (isRootMbox(rMbox, aMboxLiteralFullName))
						{
							String
								aMboxURL(CntIMAPURL::createMboxURL(
									         m_aAcntURL, aMboxLiteralFullName,
											 rMbox.getHierarchySeparator()));
							CntNodeRef xMboxNode(getAcnt().getNode().
												     Query(aMboxURL));
							if (xMboxNode.Is())
							{
								static_cast< CntIMAPMboxNode * >(&xMboxNode)->
									getMbox().initialize(getJob(), true,
														 &rMbox, false,
														 false);

								ByteString
									aMboxLiteralLastName(
										CntIMAPURL::getMboxLiteralLastName(
											aMboxURL));
								m_pMboxList->
									Insert(
										new CntFolderEntry(
											   CntIMAPUTF7::translateFromUTF7(
													aMboxLiteralLastName,
													false),
												String(
													aMboxLiteralLastName,
											   RTL_TEXTENCODING_ISO_8859_1)));
							}
						}
					}

					return EXEC_DONE;
				}
			}
			break;

		case STATE_START_OFFLINE:
			if (m_bOfflineDone)
			{
				cancel();
				return EXEC_DONE;
			}

			if (m_nProgress == CntIMAPStatusInformation::NO_PROGRESS)
			{
				pushStatusInformation(CntResId(RID_OPENING_FOLDER), 0,
									  ITEMSET_VALUE(&getAcnt().getNode(),
													CntUInt32Item,
													WID_IMAP_MBOX_COUNT));
				m_nProgress = 0;
			}

			startTimeSlice();

			while (m_pAcntDirIter)
			{
				String aID(static_cast< CntStorageNode * >(&m_xAcntDirNode)->
						       iter(*m_pAcntDirIter));
				if (m_pAcntDirIter->eof())
				{
					delete m_pAcntDirIter;
					m_pAcntDirIter = 0;
					break;
				}

				if (CntIMAPURL::isRootMboxURL(m_aAcntURL, aID))
				{
					bool bSubscribed
						= ((**m_pAcntDirIter).m_nAttrib
						           & CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD)
					          != 0;
					if (bSubscribed || !m_bSubscribedMboxsOnly)
					{
						ByteString
							aMboxLiteralLastName(
								CntIMAPURL::getMboxLiteralLastName(aID));
						CntFolderEntry * pEntry
							= new CntFolderEntry(
								      CntIMAPUTF7::translateFromUTF7(
										  aMboxLiteralLastName, false),
									  String(aMboxLiteralLastName,
											 RTL_TEXTENCODING_ISO_8859_1));
						USHORT nFlags = bSubscribed ? CNTFOLDER_SUBSCR : 0;
						if ((**m_pAcntDirIter).m_nAttrib
							    & CNTDIRENTRY_ATTRIB_IMAP_MBOX_NEW)
							nFlags |= CNTFOLDER_NEW;
						if ((**m_pAcntDirIter).m_nAttrib
							    & CNTDIRENTRY_ATTRIB_IMAP_MBOX_REMOVED)
							nFlags |= CNTFOLDER_REMOVED;
						pEntry->SetFlags(nFlags);
						m_pMboxList->Insert(pEntry);
					}

					++m_nProgress;
				}

				if (checkTimeSliceExhausted())
				{
					progressStatusInformation(m_nProgress);
					return EXEC_RESCHEDULE;
				}
			}

			m_bOfflineDone = true;

			if (!m_bCompleteSubscribedMboxs || !m_bCompleteMboxs)
			{
				m_nState = STATE_GO_ONLINE;
				return EXEC_CONTINUE;
			}

			finish();
			return EXEC_DONE;

		case STATE_GO_ONLINE:
			if (CntIMAPOnlineTask::initialize())
			{
				m_nState = STATE_RESTART_ONLINE;
				return EXEC_CONTINUE;
			}

			switch (handleError(ERRCODE_CHAOS_OFFLINE))
			{
				case ERROR_RESPONSE_ABORT:
					cancel();
				case ERROR_RESPONSE_CANCELED:
					return EXEC_DONE;

				case ERROR_RESPONSE_RETRY:
					return EXEC_CONTINUE;

				default:
					finish();
					return EXEC_DONE;
			}

		default:
			return CntIMAPOnlineTask::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
//
//  CntIMAPAcntSetMboxsTask
//
//============================================================================

// virtual
void CntIMAPAcntSetMboxsTask::end()
{
	if (m_pMboxList)
	{
		while (m_pMboxList->Count())
			delete m_pMboxList->Remove(m_pMboxList->Count() - 1);
		delete m_pMboxList;
	}
	super::end();
}

//============================================================================
// virtual
bool CntIMAPAcntSetMboxsTask::initialize()
{
	m_pMboxList
		= static_cast< const CntFolderListItem * >(getJob().GetRequest())->
		      takeList();
	if (!(m_pMboxList && m_pMboxList->Count()))
	{
		done();
		return false;
	}

	m_aAcntURL = OWN_URL(&getAcnt().getNode());
	m_xAcntDirNode = getAcnt().getDirNode(getJob());

	m_bOnlineProlog = false;
	m_bGoOnline = true;
	m_nProgress = CntIMAPStatusInformation::NO_PROGRESS;

	return false;
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPAcntSetMboxsTask::executeState(const INetIMAPResponse * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_SUBSCRIBE:
		{
			m_bOnlineProlog = false;

			ByteString aMboxLiteralFullName;
			if (!CntIMAPURL::getMboxLiteralFullName(m_aMboxURL, 0,
													aMboxLiteralFullName))
			{
				m_nState = STATE_START_OFFLINE;
				return EXEC_CONTINUE;
			}

			++m_nState;
			return handleCommandFailure(m_bSubscribe ?
										    clientCommandSubscribe(
												aMboxLiteralFullName) :
										    clientCommandUnSubscribe(
												aMboxLiteralFullName));
		}

		case STATE_RECV_SUBSCRIBE:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					INetIMAPStateResponse const & rStateResponse
						= *static_cast< INetIMAPStateResponse const * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						static_cast< CntIMAPMboxNode * >(&m_xMboxNode)->
							getMbox().
							    storeProperty(getJob(),
											  CntBoolItem(WID_FLAG_SUBSCRIBED,
														  m_bSubscribe));

						progressStatusInformation(++m_nProgress);

						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						m_nState = STATE_START_OFFLINE;
						return EXEC_RESCHEDULE;
					}
					break;
				}
			}
			break;

		case STATE_START_OFFLINE:
			if (m_bOnlineProlog)
			{
				m_bOnlineProlog = false;
				m_bGoOnline = false;
			}

			if (m_nProgress == CntIMAPStatusInformation::NO_PROGRESS)
			{
				pushStatusInformation(CntResId(RID_UPDATING_SUBFOLDERS), 0,
									  m_pMboxList->Count());
				m_nProgress = 0;
			}

			while (m_pMboxList->Count())
			{
				CntFolderEntry * pEntry
					= m_pMboxList->Remove(m_pMboxList->Count() - 1);
				m_aMboxURL = CntIMAPURL::createMboxURL(
					             m_aAcntURL,
								 ByteString(pEntry->getID(),
											RTL_TEXTENCODING_ISO_8859_1),
								 0);
				m_bSubscribe = pEntry->IsSubscribed() != false;
				USHORT nFlags = pEntry->GetFlags();
				delete pEntry;

				m_xMboxNode = getAcnt().getNode().Query(m_aMboxURL);
				if (m_xMboxNode.Is())
				{
					static_cast< CntIMAPMboxNode * >(&m_xMboxNode)->
						getMbox().initialize(getJob());

					if (m_xAcntDirNode.Is())
					{
						sal_uInt32 nClearMask = 0;
						sal_uInt32 nSetMask = 0;
						if (nFlags & CNTFOLDER_NEW)
							nSetMask |= CNTDIRENTRY_ATTRIB_IMAP_MBOX_NEW;
						else
							nClearMask |= CNTDIRENTRY_ATTRIB_IMAP_MBOX_NEW;
//						if (nFlags & CNTFOLDER_REMOVED)
//							nSetMask |= CNTDIRENTRY_ATTRIB_IMAP_MBOX_REMOVED;
//						else
//							nClearMask
//							 |= CNTDIRENTRY_ATTRIB_IMAP_MBOX_REMOVED;
						static_cast< CntStorageNode * >(&m_xAcntDirNode)->
							attrib(m_aMboxURL, nClearMask, nSetMask);
					}

					if (m_bGoOnline
						&& m_bSubscribe
						       != (ITEMSET_VALUE(m_xMboxNode, CntBoolItem,
												 WID_FLAG_SUBSCRIBED)
								       != false))
					{
						m_bOnlineProlog = true;
						m_nState = STATE_RESTART_ONLINE;
						return EXEC_CONTINUE;
					}
				}

				++m_nProgress;

				if (checkTimeSliceExhausted())
				{
					progressStatusInformation(m_nProgress);
					return EXEC_RESCHEDULE;
				}
			}

			done();
			return EXEC_DONE;

		default:
			return CntIMAPOnlineTask::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
//
//  CntIMAPAcntImportTask
//
//============================================================================

// virtual
void CntIMAPAcntImportTask::end()
{
	delete m_pPolicy;
	delete m_pImport;
	if (m_pStream)
		static_cast< CntInStreamItem const * >(getJob().GetRequest())->
			releaseStream();
	super::end();
}

//============================================================================
// virtual
bool CntIMAPAcntImportTask::executeTimeSlice(bool bFirst)
{
	if (bFirst
		&& !static_cast< CntInStreamItem const * >(getJob().GetRequest())->
		        hasStream())
	{
		cancel();
		return false;
	}

	if (!m_pStream)
	{
		m_pStream
			= static_cast< CntInStreamItem const * >(getJob().GetRequest())->
			      tryToAcquireStream();
		if (!m_pStream)
			return true;

		m_pImport = new CntImport(*m_pStream);

		if (m_pStream->IsA() == ID_FILESTREAM)
			m_aFileName
				= static_cast< SvFileStream * >(m_pStream)->GetFileName();
		m_bMessageFound = false;

		String aStatusText;
		if (m_aFileName.Len() > 0)
		{
			aStatusText = CntResId(RID_STATUS_IMPORT_FROM);
			aStatusText.SearchAndReplaceAscii("%1", m_aFileName);
		}
		else
			aStatusText = CntResId(RID_STATUS_IMPORT);
		pushStatusInformation(aStatusText, 0, m_pImport->getProgressMax());

		m_pPolicy
		 = new CntIMAPAcntMesgCachingPolicy(OWN_URL(&getAcnt().getNode()),
											getJob().GetCacheNode());
	}

	for (;;)
	{
		BOOL bFound;
		CntMBXVersion * pVersion = 0;
		static USHORT const aImportRanges[]
			= { WID_CHAOS_START, WID_INTERIM_URL,
				WID_OWN_URL, WID_CHAOS_END, 0 };
		SfxItemSet aImportSet(*getAcnt().getNode().GetPool(), aImportRanges);
		ULONG nProgress;
		ErrCode nError = m_pImport->getMessage(*m_pPolicy, bFound, pVersion,
											   aImportSet, nProgress);
		if (nError != ERRCODE_NONE)
		{
			delete pVersion;

			getJob().SetError(nError);
			cancel();
			return false;
		}
		if (!bFound)
		{
			delete pVersion;
			break;
		}
		m_bMessageFound = true;

		CntMBXVersion0::MessageType eType = CntMBXVersion0::TYPE_MESSAGE;
		if (pVersion && !pVersion->getVersion())
			if (const CntMBXVersion0 * pVersion0
				    = PTR_CAST(CntMBXVersion0, pVersion))
				eType = pVersion0->getType();

		if (eType == CntMBXVersion0::TYPE_MESSAGE)
		{
			String aMesgURL;
			if (m_pPolicy->getMesgURL(aImportSet, aMesgURL))
			{
				CntNodeRef xMesgNode(getAcnt().getNode().Query(aMesgURL));
				if (xMesgNode.Is())
					static_cast< CntIMAPMesgNode * >(&xMesgNode)->
						initialize(getJob(), true, 0, &aImportSet);
			}
		}

		delete pVersion;

		if (checkTimeSliceExhausted())
		{
			progressStatusInformation(nProgress);
			return true;
		}
	}

	if (!m_bMessageFound
		&& getJob().SetError(m_aFileName.Len() == 0 ?
							     ERRCODE_CHAOS_NOTHING_IMPORTED :
							     *new StringErrorInfo(
									      ERRCODE_CHAOS_NOTHING_IMPORTED_FROM,
										  m_aFileName)))
		return 0;

	done();
	return false;
}

//============================================================================
CntIMAPAcntImportTask::CntIMAPAcntImportTask(CntNodeJob & rJob,
											 CntIMAPAcnt & rAcnt):
	CntIMAPOfflineTask(rJob, rAcnt.getNode(), rAcnt),
	m_pStream(0),
	m_pImport(0),
	m_pPolicy(0)
{}

//============================================================================
//
//  CntIMAPAcntExportTask
//
//============================================================================

void CntIMAPAcntExportTask::append(const String & rTheFldrURL)
{
	Entry * pEntry = new Entry;
	pEntry->m_aFldrURL = rTheFldrURL;
	pEntry->m_pNext = 0;
	if (m_pFldrListTail)
		m_pFldrListTail = m_pFldrListTail->m_pNext = pEntry;
	else
		m_pFldrListTail = m_pFldrListHead = pEntry;
}

//============================================================================
IMPL_LINK(CntIMAPAcntExportTask, errorHandler, CntErrorData *, pData)
{
	switch (pData->_nError)
	{
		case ERRCODE_CHAOS_OFFLINE:
		{
			if (m_bIgnoreOffline)
				return ERRCODE_BUTTON_NO;
			USHORT nResult
				= CntRootNodeMgr::Get()->HandleError(ERRCODE_CHAOS_OFFLINE,
													 &getJob(),
													 pData->_pErrorStr,
													 pData->_pData);
			if (nResult == ERRCODE_BUTTON_NO)
				m_bIgnoreOffline = true;
			return nResult;
		}

		case ERRCODE_CHAOS_LOGIN_FAILURE_RECEIVE:
			return CntRootNodeMgr::Get()->
				       HandleError(ERRCODE_CHAOS_LOGINFAIL_NOEXCH, &getJob(),
								   pData->_pErrorStr,
								   static_cast< CntLoginErrorData * >(
									       pData->_pData)->
								       getTarget());
	}
	return ERRCODE_CHAOS_NOT_HANDLED;
}

//============================================================================
// virtual
void CntIMAPAcntExportTask::notification(SfxBroadcaster & rBroadcaster,
										 const SfxHint & rHint)
{
	if (&rBroadcaster == &m_xOpenJob)
	{
		if (CntStatusHint * pStatusHint = PTR_CAST(CntStatusHint, &rHint))
			if (pStatusHint->GetStatus() == CNT_STATUS_DONE
				|| pStatusHint->GetStatus() == CNT_STATUS_ERROR
				   && pStatusHint->GetError() == ERRCODE_ABORT)
			{
				EndListening(*m_xOpenJob);
				m_xOpenJob = 0;
				reschedule();
			}
	}
	else
		super::notification(rBroadcaster, rHint);
}

//============================================================================
// virtual
void CntIMAPAcntExportTask::beingCanceled()
{
	if (m_xOpenJob.Is())
		EndListening(*m_xOpenJob);
	delete m_pFldrDirIter;
	super::beingCanceled();
}

//============================================================================
// virtual
void CntIMAPAcntExportTask::end()
{
	delete m_pExport;
	if (m_pStream)
		static_cast< CntExpStreamItem const * >(getJob().GetRequest())->
			releaseStream();
	super::end();
}

//============================================================================
// virtual
bool CntIMAPAcntExportTask::executeTimeSlice(bool bFirst)
{
	CntExpStreamItem const & rRequest
		= *static_cast< CntExpStreamItem const * >(getJob().GetRequest());

	if (bFirst && !rRequest.hasStream())
	{
		cancel();
		return false;
	}

	if (!m_pStream)
	{
		m_pStream = rRequest.tryToAcquireStream();
		if (!m_pStream)
			return true;

		m_pExport = new CntExport(*m_pStream);

		String aFileName;
		if (m_pStream->IsA() == ID_FILESTREAM)
			aFileName
				= static_cast< SvFileStream * >(m_pStream)->GetFileName();
		String aStatusText;
		if (aFileName.Len())
		{
			aStatusText = CntResId(RID_STATUS_EXPORT_TO);
			aStatusText.SearchAndReplaceAscii("%1", aFileName);
		}
		else
			aStatusText = CntResId(RID_STATUS_EXPORT);
		pushStatusInformation(aStatusText);

		append(getAcnt().getBaseFldrURL());
	}

	for (;;)
	{
		if (!m_pFldrDirIter)
		{
			if (!m_pFldrListHead)
				break;
			Entry * pEntry = m_pFldrListHead;
			m_aFldrURL = pEntry->m_aFldrURL;
			m_pFldrListHead = pEntry->m_pNext;
			if (m_pFldrListTail == pEntry)
				m_pFldrListTail = 0;
			delete pEntry;

			m_bAcnt = CntIMAPURL::isAcntURL(m_aFldrURL);
			if (m_bAcnt)
			{
				m_xFldrDirNode = getJob().GetDirectoryNode();
				m_pFldrDirIter
				 = new CntStorageIterator(CNTDIRENTRY_ATTRIB_IMAP_MBOX);
			}
			else
			{
				m_xFldrDirNode = CntIMAPMbox::getDirNode(m_aFldrURL);
				m_pFldrDirIter = new CntStorageIterator();
			}

			if (!m_xFldrDirNode)
			{
				delete m_pFldrDirIter;
				m_pFldrDirIter = 0;
			}
		}

		if (m_pFldrDirIter)
		{
			if (!m_xMesgNode.Is())
				m_aFldrDirID
					= static_cast< CntStorageNode * >(&m_xFldrDirNode)->
					      iter(*m_pFldrDirIter);
			if (m_pFldrDirIter->eof())
			{
				delete m_pFldrDirIter;
				m_pFldrDirIter = 0;
			}
			else if ((**m_pFldrDirIter).m_nAttrib
					  & CNTDIRENTRY_ATTRIB_IMAP_MBOX)
			{
				if (m_bAcnt ?
					    CntIMAPURL::isRootMboxURL(m_aFldrURL, m_aFldrDirID) :
					    CntIMAPURL::isDirectSubMboxURL(m_aFldrURL,
													   m_aFldrDirID))
					append(m_aFldrDirID);
			}
			else if (!m_bAcnt)
			{
				if (!m_xMesgNode.Is())
				{
					sal_uInt32 nUIDValidity;
					sal_uInt32 nMesgUID;
					if (CntIMAPMesgNode::isMesgDirID(m_aFldrDirID,
													 nUIDValidity, nMesgUID))
					{
						m_xMesgNode = getAcnt().getNode().
							              Query(CntIMAPURL::createMesgURL(
											        m_aFldrURL, nUIDValidity,
													nMesgUID));
						if (m_xMesgNode.Is())
						{
							static_cast< CntIMAPMesgNode * >(&m_xMesgNode)->
								initialize(getJob());
							if (rRequest.doForceBodies()
								&& !static_cast< CntIMAPMesgNode * >(
									        &m_xMesgNode)->
								        getBody(getJob()))
							{
								m_xOpenJob
									= new CntNodeJob(&getJob(), m_xMesgNode,
													 m_xMesgNode,
													 CntOpenModeItem(
														 WID_OPEN,
														 CNT_OPEN_MESSAGE));
								new CntIMAPMesgOpenTask(
									    *m_xOpenJob,
										*static_cast< CntIMAPMesgNode * >(
											 &m_xMesgNode));
								m_xOpenJob->SetErrorHandler(
									            LINK(this,
													 CntIMAPAcntExportTask,
													 errorHandler));
								StartListening(*m_xOpenJob);
								getAcnt().getNode().ExecuteJob(m_xOpenJob);
								return false;
							}
						}
					}
				}

				if (m_xMesgNode.Is())
				{
					ErrCode nError
						= getAcnt().
						      exportMesg(getJob(), *m_pExport,
										 *static_cast< CntIMAPMesgNode * >(
											  &m_xMesgNode));
					m_xMesgNode = 0;
					if (nError != ERRCODE_NONE)
					{
						getJob().SetError(nError);
						cancel();
						return false;
					}
				}
			}
		}

		if (checkTimeSliceExhausted())
			return true;
	}

	done();
	return false;
}

//============================================================================
CntIMAPAcntExportTask::CntIMAPAcntExportTask(CntNodeJob & rJob,
											 CntIMAPAcnt & rAcnt):
	CntIMAPOfflineTask(rJob, rAcnt.getNode(), rAcnt),
	m_pStream(0),
	m_pExport(0),
	m_pFldrListHead(0),
	m_pFldrListTail(0),
	m_pFldrDirIter(0),
	m_bIgnoreOffline(false)
{}

//============================================================================
//
//  CntIMAPAcntCloseTask
//
//============================================================================

// virtual
bool CntIMAPAcntCloseTask::initialize()
{
	return true;
}

//============================================================================
// virtual
CntIMAPOnlineTask::Execution
CntIMAPAcntCloseTask::executeState(const INetIMAPResponse * pResponse)
{
	switch (m_nState)
	{
		case STATE_SEND_LOGOUT:
			pushStatusInformation(CntResId(RID_LOGGING_OUT),
								  CntIMAPStatusInformation::TAG_NONE, true);

			++m_nState;
			return handleCommandFailure(clientCommandLogOut());

		case STATE_RECV_LOGOUT:
			switch (pResponse->getType())
			{
				case INetIMAPResponse::TYPE_STATE:
				{
					const INetIMAPStateResponse & rStateResponse
						= *static_cast< const INetIMAPStateResponse * >(
							   pResponse);

					if (rStateResponse.isFinal()
						&& rStateResponse.getState()
						       == INetIMAPStateResponse::STATE_OK)
					{
						Execution eExecution
							= handleAlertResponse(rStateResponse);
						if (eExecution != EXEC_NOTHING)
							return eExecution;

						popStatusInformation();

						done();
						return EXEC_DONE;
					}
					break;
				}
			}
			break;

		default:
			return CntIMAPOnlineTask::executeState(pResponse);
	}

	return EXEC_UNHANDLED;
}

//============================================================================
//
//  CntIMAPBaseOpenTask
//
//============================================================================

CntIMAPBaseOpenTask::CntIMAPBaseOpenTask(CntNodeJob & rJob,
										 CntIMAPAcnt & rAcnt):
	CntIMAPForwardTask(rJob, rAcnt.getNode(), rAcnt)
{
	CntNodeRef xBaseMboxNode(rAcnt.instantiateBaseMboxNode(getJob()));
	if (xBaseMboxNode.Is())
	{
		if (rAcnt.doAddBaseInbox())
			appendSubJob(rAcnt.getNode(), *getJob().GetRequest(), true);
		appendSubJob(*xBaseMboxNode, *getJob().GetRequest(), true);
	}
	else
		cancelOnExecute();
}

//============================================================================
//
//  CntIMAPBaseGetMboxsTask
//
//============================================================================

// virtual
void CntIMAPBaseGetMboxsTask::finish()
{
	getAcnt().getNode().Put(m_xBaseMboxNode->Get(WID_NEWS_GROUPLIST));
}

//============================================================================
CntIMAPBaseGetMboxsTask::CntIMAPBaseGetMboxsTask(CntNodeJob & rJob,
												 CntIMAPAcnt & rAcnt):
	CntIMAPForwardTask(rJob, rAcnt.getNode(), rAcnt)
{
	m_xBaseMboxNode = rAcnt.instantiateBaseMboxNode(getJob());
	if (m_xBaseMboxNode.Is())
		appendSubJob(*m_xBaseMboxNode, *getJob().GetRequest(), true);
	else
		cancelOnExecute();
}

//============================================================================
//
//  CntIMAPBaseForwardTask
//
//============================================================================

CntIMAPBaseForwardTask::CntIMAPBaseForwardTask(CntNodeJob & rJob,
											   CntIMAPAcnt & rAcnt):
	CntIMAPForwardTask(rJob, rAcnt.getNode(), rAcnt)
{
	CntNodeRef xBaseMboxNode(rAcnt.instantiateBaseMboxNode(getJob()));
	if (xBaseMboxNode.Is())
		appendSubJob(*xBaseMboxNode, *getJob().GetRequest(), true);
	else
		cancelOnExecute();
}

