/*************************************************************************
 *
 *  $RCSfile: cntjob.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/27 13:23:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _LINK_HXX //autogen
#include <tools/link.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _SFXITEMITER_HXX //autogen
#include <svtools/itemiter.hxx>
#endif
#ifndef _SFXCANCEL_HXX //autogen
#include <svtools/cancel.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX //autogen
#include <svtools/ctypeitm.hxx>
#endif

#define _CNTJOB_CXX
#include <cntjob.hxx>

#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CNTCCITM_HXX
#include <cntccitm.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTVNODE_HXX
#include <cntvnode.hxx>
#endif
#ifndef _CNTSDITM_HXX
#include <cntsditm.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif
#ifndef _CNTRIDS_HRC
#include <cntrids.hrc>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif

#ifndef USE_JOB_DISPATCHER

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx> /* CntThreadSwitcher -> Application::*UserEvent(...) */
#endif

#endif /* USE_JOB_DISPATCHER */

using namespace chaos;

/*========================================================================
 *
 * CntJobCancelable Interface.
 *
 *======================================================================*/

class CntJobCancelable : public SfxCancellable
{
private:
	CntNodeJob*	_pOwner;

public:
	CntJobCancelable( CntNodeJob *pOwner,
	                  const String& rTitle,
					  SfxCancelManager* pMgr );
	virtual	~CntJobCancelable();

	CntNodeJob*	GetOwner() const { return _pOwner; }

	// SfxCancellable interface
	virtual void Cancel();
};

//========================================================================

IMPL_PTRHINT( CntScheduleJobHint, CntNodeJob );

/*========================================================================
 *
 * CntNodeJob Implementation.
 *
 *======================================================================*/

TYPEINIT0( CntNodeJob );

//------------------------------------------------------------------------
CntNodeJob::CntNodeJob
(
	CntNodeJob* 	   pParent,	 // if generated from another job
	CntInterface*	   pClient,	 // defines the environment (e.g. view-data)
	CntNode*		   pSubject, // node on which the job operates
	const SfxPoolItem& rRequest, // description of the operation
	BOOL			   bMakePersist, // can the request data be stored?
	BOOL			   bLog,	 // store in logfile if offline
	ChaosTaskBase*     pTheTaskBase
)
: _xParent       ( pParent ),
  _xClient       ( pClient ),
  _xSubject      ( pSubject ),
  _xUserDataNode ( NULL ),
  _xViewDataNode ( NULL ),
  _xDirectoryNode( NULL ),
  _xCacheNode    ( NULL ),
  _pRequest      ( rRequest.Clone() ),
  _pCancelable   ( NULL ),
  _pChildJobs    ( NULL ),
  _pRequestData  ( NULL ),
  _pErrorHandler ( NULL ),
  _pTaskBase     ( pTheTaskBase ),
  _bStarted		 ( FALSE ),
  _bRescheduled  ( FALSE ),
  _bDone         ( FALSE ),
  _bCanceled     ( FALSE ),
  _bMakePersist  ( bMakePersist ),
  _bLogged       ( bLog )
#if !defined USE_JOB_DISPATCHER
, _bAlwaysReschedule( FALSE)
#endif // USE_JOB_DISPATCHER
{
#if 0
//#ifdef DBG_UTIL
	// In the "Non-Product" version, there all jobs will be visible at the
	// "Stop-Button" of Office UI -> Fine util to determine hanging jobs.
	BOOL bPublic = TRUE;
#else
	BOOL bPublic = IsPublic_Impl();
#endif

	// Create a Cancelable, if this is a public job...
	if ( bPublic )
		_pCancelable = new CntJobCancelable( this, CreateTitle_Impl(),
											 CNT_RNM()->GetCancelManager() );

	_xClient->StartListening( *this );

	// In case the view data node dies during job processing it cannot
	// be recreated on-demand (like the other nodes). So we have to hold it
	// until we die.
	if ( _xClient->ISA( CntAnchor ) )
		GetViewDataNode( FALSE );

	if ( _xParent )
		_xParent->InsertChildJob_Impl( this );

	// RNM takes care of us.
	CNT_RNM()->EnqueueJob( this );
}

//------------------------------------------------------------------------
CntNodeJob::~CntNodeJob()
{
	DBG_ASSERT( !GetParent(), "CntNodeJob dtor: parent job is set!" );
	DBG_ASSERT( !ChildJobCount(), "CntNodeJob dtor: There are child jobs!" );

	if ( _xViewDataNode.Is() )
	{
		// Release View Data Node's storage and try to close it.
		CntViewStorageNode* pStgNode = (CntViewStorageNode*)&_xViewDataNode;
		pStgNode->releaseStorage();
	}

	// Note: _pRequest was allocated in ctor by rRequest.Clone()
	delete _pRequest;

	delete _pCancelable;

	delete _pErrorHandler;

   	CNT_RNM()->DequeueJob( this );
}

//------------------------------------------------------------------------
void CntNodeJob::SetRequest( const SfxPoolItem& rRequest )
{
	// Note: _pRequest was allocated in ctor by rRequest.Clone()
	delete _pRequest;

	_pRequest = rRequest.Clone();
}

//------------------------------------------------------------------------
SfxCancellable* CntNodeJob::GetCancelable( BOOL bCreate /* = TRUE */ )
{
    if ( !_pCancelable && bCreate )
    {
    	// A Cancelable is requested, although 'this' is generally not
		// public. Otherwise _pCancellable would have been set in
		// constructor of 'this'.
		_pCancelable = new CntJobCancelable( this, CreateTitle_Impl(),
								  			 CNT_RNM()->GetOwnCancelManager() );
    }
	return _pCancelable;
}

//------------------------------------------------------------------------
const String CntNodeJob::GetTitle() const
{
	if ( _pCancelable )
		return _pCancelable->GetTitle();

	return CreateTitle_Impl();
}

//------------------------------------------------------------------------
void ExchangeChildren_Impl( CntNode* pOld, CntNode* pNew, CntNodeJob* pJob )
{
	const String& rOldURL = OWN_URL( pOld );
	const String& rNewURL = OWN_URL( pNew );

	ULONG nCount  = pOld->SubNodeCount();
	ULONG nCount1 = CNT_RNM()->SubNodeCount();
	ULONG n;

	CntNodeList aNodeList( (USHORT)nCount + (USHORT)nCount1 );

	// Process real children.
	for ( n = 0; n < nCount; ++n )
	{
		CntNode* pOldChild = pOld->GetSubNode( n );

		// Hold the child, it may be destroyed in "Exchange"!!!
		pOldChild->AddRef();
		aNodeList.Insert( pOldChild, LIST_APPEND );
	}

	// Process rootnodes matching changed URL.
	for ( n = 0; n < nCount1; ++n )
	{
		CntNode* pOldChild = CNT_RNM()->GetSubNode( n );

		const String& rOldChildURL = OWN_URL( pOldChild );
		xub_StrLen nPos = rOldChildURL.Match( rOldURL );

		if ( nPos == rOldURL.Len() )
		{
			// Hold the child, it may be destroyed in "Exchange"!!!
			pOldChild->AddRef();
			aNodeList.Insert( pOldChild, LIST_APPEND );
		}
	}

	// Exchange and release old children...
	nCount = aNodeList.Count();
	for ( n = 0; n < nCount; ++n )
	{
		CntNode* pOldChild = aNodeList.GetObject( n );

		const String& rOldChildURL = OWN_URL( pOldChild );

		String aChildURLPart(
					rOldChildURL.Copy( rOldChildURL.Match( rOldURL ) ) );

		String aNewChildURL( rNewURL );
		aNewChildURL += aChildURLPart;

		BOOL bRoot = pOldChild->IsRootNode();

		CntNode* pQuery = bRoot ? CNT_RNM() : pNew;
		CntNodeRef xNewChild( pQuery->Query( aNewChildURL ) );
		if ( xNewChild.Is() )
		{
			if ( bRoot )
				CNT_RNM()->RemoveView( pOldChild );

			SfxItemIter aIter( *pOldChild );
			for ( const SfxPoolItem *pItem = aIter.FirstItem();
	  	  		  pItem != NULL;
	      		  pItem = aIter.NextItem() )
			{
				//////////////////////////////////////////////////////////
				// Transfer old items to new node...
				//////////////////////////////////////////////////////////
				USHORT nWhich = pItem->Which();

				if ( !bRoot )
				{
					// Do not take over the refered URL of the old node!!!
					if ( nWhich == WID_REFERED_URL )
						continue;

					// Do not take over the presentation URL of the old node!!!
					if ( nWhich == WID_REAL_URL )
						continue;
				}

 				// Do not touch items already set in pNew!
				if ( xNewChild->GetItemState( nWhich, FALSE ) == SFX_ITEM_SET )
					continue;

				xNewChild->CntNode::Put( *pItem, nWhich );
			}

			ExchangeChildren_Impl( pOldChild, xNewChild, pJob );
			pOldChild->Broadcast(
					CntNodeHint( xNewChild, CNT_ACTION_EXCHANGED, pJob ) );
		}

		pOldChild->ReleaseRef();
	}
}

//------------------------------------------------------------------------
void CntNodeJob::Result( CntNode *pResult, CntAction eAction )
{
	if ( !pResult )
	{
		DBG_ERROR( "CntNodeJob::Result(...) : pResult is NULL!" );
		return;
	}

	switch ( eAction )
	{
		case CNT_ACTION_INSERTED:
		case CNT_ACTION_INSERTED_IN_MULTIPLE:
			if ( pResult->IsRootNode() )
			{
				if ( pResult->ISA( CntViewStorageNode ) )
				{
					CntViewStorageNode* pView = (CntViewStorageNode*)pResult;
					if ( !pView->IsRestored() )
					{
						// Never announce boot-strapping view nodes...
						break;
					}
				}
			}

			// a new child node was inserted
			if ( !pResult->IsInserted() )
			{
				// Special handling for some WID's.
				// WID_INSERT,
				// WID_UNDELETE: subject is always equal to pResult -
				//               node must be inserted at parent node
				// WID_REFERED_URL: subject shall be exchanged by pResult
				// WID_UPDATE : Subject may be equal to result,
				//              get parent in this case (UT/DV, 22.09.98)

				USHORT nWhich = _pRequest->Which();
				if ( ( nWhich == WID_INSERT ) ||
					 ( nWhich == WID_UNDELETE ) ||
					 ( nWhich == WID_REFERED_URL ) ||
					 ( ( nWhich == WID_UPDATE ) && ( pResult == _xSubject ) ) )
				{
					CntNode* pParent = pResult->GetParent();

					if ( pParent )
						pParent->Inserted( pResult, this, TRUE );
					else
						DBG_ERROR( "Don't know where to insert new node!" );
				}
				else
					_xSubject->Inserted( pResult, this, TRUE );

				if ( nWhich == WID_INSERT )
				{
					CntNode* pCreator = pResult->GetCreatorNode();
					if ( pCreator )
					{
						pCreator->Inserted( pResult, this, TRUE );
						pResult->SetCreatorNode( NULL );
					}
				}
			}
			else
			{
				BOOL bBroadcast = TRUE;
				switch ( GetRequest()->Which() )
				{
					case WID_OPEN:
					{
						CntOpenMode eOpenMode = (CntOpenMode)
								ITEM_VALUE( CntOpenModeItem, *GetRequest() );
						BOOL bIsMessage = ITEMSET_VALUE( pResult,
														 CntBoolItem,
														 WID_FLAG_IS_DOCUMENT );
						switch( eOpenMode )
						{
							case CNT_OPEN_ALL:
							case CNT_OPEN_DOCUMENT:
								break;

							case CNT_OPEN_FOLDERS:
							{
								// there are nodes which are of both kinds,
								// message and folder, so bIsFolder is true,
								// when something is a folder or when it is
								// not a message;
								BOOL bIsFolder =
										ITEMSET_VALUE( pResult,
													   CntBoolItem,
										   			   WID_FLAG_IS_FOLDER );
								bIsFolder |=
										ITEMSET_VALUE( pResult,
													   CntBoolItem,
													   WID_SHOW_IN_EXPLORER );
								bIsFolder |= !bIsMessage;
								bBroadcast = bIsFolder;
								break;
							}
							case CNT_OPEN_DOCUMENTS:
								bBroadcast = bIsMessage;
								break;

							default:
								DBG_ERRORFILE("unknown OpenMode");
						}
						break;
					}

					case WID_UPDATE:
					case WID_SYNCHRONIZE:
						// Propagate result to all views.
						_xSubject->Inserted( pResult, this, TRUE );
						bBroadcast = FALSE;
						break;

					case WID_UNDELETE:
						// undeleted nodes are always inserted, but must me
						// promoted for all views
						_xSubject->GetParent()->Inserted( pResult, this, TRUE );
						bBroadcast = FALSE;
						break;

					default:
						break;
				}

				if ( bBroadcast )
				{
					CntAnchor * pAnchor;
					if (eAction == CNT_ACTION_INSERTED_IN_MULTIPLE
						&& (pAnchor = PTR_CAST(CntAnchor, GetClient())))
						pAnchor->GetNode()->
						 Broadcast(
						  CntNodeHint(pResult, CNT_ACTION_RESULT, this));
					else
						Broadcast(
						 CntNodeHint( pResult, CNT_ACTION_RESULT, this ) );
				}

			}
			break;

		case CNT_ACTION_EXCHANGED:
			if ( _xSubject->IsInserted() )
				pResult->GetParent()->Inserted( pResult, this, FALSE );

			pResult->SetCreatorNode( _xSubject->GetCreatorNode() );
			_xSubject->SetCreatorNode( NULL );

			// Make sure, we have a cache/directory node at hand.
            GetDirectoryNode( TRUE );

			if ( CntViewStorageNode::IsRootViewURL( OWN_URL( GetClient() ) ) )
			{
				// Exchange of view root node needs special handling.
				// Only the requesting view must be informed!
				Broadcast( CntNodeHint( pResult, eAction, this ) );
			}
			else
			{
				ExchangeChildren_Impl( _xSubject, pResult, this );

				// All views must be informed!
				_xSubject->Broadcast( CntNodeHint( pResult, eAction, this ) );
			}
			break;

		case CNT_ACTION_DELETED:
			// a node was physically destroyed - inform all views
			pResult->Broadcast( CntNodeHint( pResult, eAction, this ) );
			break;

		case CNT_ACTION_REMOVED:
			// a node is to be removed from a parent - inform only client
		case CNT_ACTION_FILENAME_CHANGED:
			// a view storage file was renamed ( own URL changed )

			Broadcast( CntNodeHint( pResult, eAction, this ) );
			break;

		case CNT_ACTION_REMOVED_FROM_MULTIPLE:
		{
			// Remove node from multiple anchors:
			CntAnchor * pAnchor = PTR_CAST(CntAnchor, GetClient());
			if (pAnchor)
				pAnchor->GetNode()->
				 Broadcast(CntNodeHint(pResult, CNT_ACTION_REMOVED, this));
			else
				Broadcast(CntNodeHint(pResult, CNT_ACTION_REMOVED, this));
			break;
		}

		case CNT_ACTION_MODIFIED:
			// properties of a node have changed
		default:
			DBG_ERRORFILE( "CntNodeJob::Result(...) : Unknown action!" );
	}
}

//------------------------------------------------------------------------
void CntNodeJob::ResultSearchMatch(CntNode * pNode,
								   CntSearchMatchMode eMatchMode,
								   BOOL bRecurses)
{
	DBG_ASSERT(_pRequest->Which() == WID_SEARCH,
			   "CntNodeJob::ResultSearchMatch(): not WID_SEARCH");

	const CntSearchData & rData = ITEM_VALUE(CntSearchDataItem, *_pRequest);

	String sURL = OWN_URL(pNode);
	if (!CntViewBase::IsViewURL(sURL))
		if (const CntAnchor * pAnchor = PTR_CAST(CntAnchor, &_xClient))
		{
			String sViewURL = CntAnchor::ToViewURL(pAnchor->
												       GetRootViewURL(true),
												   OWN_URL(pNode));
			if (sViewURL.Len() > 0)
				sURL = sViewURL;
		}

	if (eMatchMode == CNT_SEARCH_MATCH_UNKNOWN)
	{
		eMatchMode = (pNode == _xSubject ? rData.DoSearchBase() :
					                       rData.DoSearchFirstLevel())
			         && rData.Matches(*pNode,
									  CntRootNodeMgr::GetIniManager()->
                                          getIntlWrapper()) ?
			             CNT_SEARCH_MATCH_YES : CNT_SEARCH_MATCH_NO;
	}

	if (eMatchMode == CNT_SEARCH_MATCH_YES)
	{
		CntNodeJob * pJob = this;
		for (;;)
		{
			CntNodeJob * pParentJob = pJob->GetParent();
			if (pParentJob == 0
				|| pParentJob->GetRequest()->Which() != WID_SEARCH)
				break;
			pJob = pParentJob;
		}
		pJob->Broadcast(CntSearchMatchedURLHint(sURL));
	}

	if (pNode != &_xSubject && !bRecurses && rData.IsRecursive()
		&& ITEMSET_VALUE(pNode, CntBoolItem, WID_FLAG_IS_FOLDER))
	{
		CntAnchorRef xAnchor(new CntAnchor(0, sURL));
		CntSearchData * pNextData = rData.createNextLevel(!!bRecurses);
		if (!pNextData->DoObeyFolderViewRestrictions())
			xAnchor->
				CntInterface::Put(CntFolderViewModeItem(WID_FOLDERVIEW_MODE,
														CNT_VIEW_ALL_FOLDERS),
								  WID_FOLDERVIEW_MODE);
		if (!pNextData->DoObeyDocViewRestrictions())
		{
			xAnchor->
				CntInterface::Put(CntMsgViewModeItem(WID_MESSAGEVIEW_MODE,
													 CNT_VIEW_ALL_ARTICLES),
								  WID_MESSAGEVIEW_MODE);
			xAnchor->
				CntInterface::Put(CntBoolItem(WID_SHOW_MSGS_HAS_TIMELIMIT,
											  FALSE),
								  WID_SHOW_MSGS_HAS_TIMELIMIT);
		}
		pNode->InsertJob(new CntNodeJob(this, xAnchor, pNode,
										CntSearchDataItem(WID_SEARCH,
														  *pNextData)));
		delete pNextData;
	}

	if (rData.DoFollowIndirections())
	{
		String sTargetURL = ITEMSET_VALUE(pNode, CntStringItem,
										  WID_TARGET_URL);
		if (sTargetURL.Len() > 0)
		{
			if (!CntViewBase::IsViewURL(sTargetURL))
			{
				if (const CntAnchor * pAnchor = PTR_CAST(CntAnchor,
														 &_xClient))
				{
					String sViewURL
						= CntAnchor::ToViewURL(pAnchor->GetRootViewURL(true),
											   sTargetURL);
					if (sViewURL.Len() > 0)
						sTargetURL = sViewURL;
				}
			}
//			CntSearchWaitingJob_Impl(sTargetURL, new CntSearchData(rData));
		}
	}
}

//------------------------------------------------------------------------
void CntNodeJob::Started()
{
	if ( _bStarted )
	{
		// Already running.
		return;
	}

	_bStarted = TRUE;

	if ( !IsRescheduled() )
		Broadcast( CntStatusHint( _pCancelable,
							  	  GetRequest(),
							      CNT_STATUS_STARTED ) );
}

//------------------------------------------------------------------------
void CntNodeJob::Done( BOOL bScheduleNextChildJob )
{
	if ( !_bStarted && !_bDone && !_bCanceled )
		Started();

	_bStarted = FALSE;
	_bDone    = TRUE;

	if ( ChildJobCount() == 0 )
	{
		// Hold 'this'.
		CntNodeJobRef xThis( this );

		// Hold parent.
		CntNodeJobRef xParent( _xParent );

		if ( !IsCancelled() )
		{
			// Done - schedule next job...
			ClearRequest_Impl();
			Broadcast( CntStatusHint( _pCancelable,
									  GetRequest(),
		                          	  CNT_STATUS_DONE ) );
		}

		if ( _xParent.Is() )
			_xParent->RemoveChildJob_Impl( this );
	}
	else
	{
		if ( bScheduleNextChildJob )
		{
			// Not "really done" yet - just schedule next job...
			Broadcast( CntScheduleJobHint( this ) );
		}
	}
}

//------------------------------------------------------------------------
void CntNodeJob::Cancel()
{
	if ( !_bStarted && !_bDone && !_bCanceled )
		Started();

	_bStarted  = FALSE;
	_bCanceled = TRUE;

    if ( _pCancelable )
       _pCancelable->SfxCancellable::Cancel();

	// Already 'really' done?
	if ( IsDone() && !ChildJobCount() )
		return;

	CntNodeJobRef xThis( this );

	// cancel all child jobs
	for ( ULONG n = ChildJobCount(); n > 0; --n )
		GetChildJob( n - 1 )->Cancel();

	ClearRequest_Impl();
	Broadcast( CntStatusHint( _pCancelable,
							  GetRequest(),
	                          CNT_STATUS_ERROR, ERRCODE_ABORT ) );
	Done();
}

//------------------------------------------------------------------------
void CntNodeJob::Log()
{
	if ( IsLogged() )
	{
		DBG_ERROR( "CntNodeJob::Log() - job already logged!" );
		return;
	}

	_bLogged = TRUE;
	CNT_RNM()->AddLoggedJob( this );
}

//------------------------------------------------------------------------
BOOL CntNodeJob::IsSynchronous() const
{
	USHORT nWhich = _pRequest->Which();

	// Special handling for "component commands". This is a hack, IMHO.
	if ( nWhich == WID_COMPONENT_COMMAND )
	{
		CntCmpCommandItem* pCommandItem =
								PTR_CAST( CntCmpCommandItem, _pRequest );
		if ( pCommandItem )
		{
			if ( pCommandItem->GetCommand().
						compareToAscii(	"prepareMenu" ) == 0 )
			{
				return TRUE;
			}
			else if ( pCommandItem->GetCommand().
						compareToAscii(	"prepareMultiSelectionMenu" ) == 0 )
			{
				return TRUE;
			}
			else if ( pCommandItem->GetCommand().
						compareToAscii(	"prepareEditing" ) == 0 )
			{
				return TRUE;
			}
		}
	}

	return _xClient->IsItemFlag( nWhich, CNT_ITEM_SYNCHRON );
}

//------------------------------------------------------------------------
void CntNodeJob::SetErrorHandler( const Link& rLink )
{
	DELETEZ( _pErrorHandler );

	if ( rLink.IsSet() )
		_pErrorHandler = new Link( rLink );
}

//------------------------------------------------------------------------
const Link* CntNodeJob::QueryErrorHandler() const
{
	// Return own error handler.
	if ( _pErrorHandler )
		return _pErrorHandler;

	// Return client's error handler, if it has one.
	return CNT_RNM()->QueryErrorHandler( _xClient );
}

//------------------------------------------------------------------------
BOOL CntNodeJob::SetError( ErrCode       nError,
						   const String* pErrorStr /* = NULL */,
						   void*         pData     /* = NULL */ )
{
	CntNodeJobRef xThis( this );

	CNT_RNM()->HandleError( nError, this, pErrorStr, pData );
	return IsCanceled();
}

//----------------------------------------------------------------------------
CntStorageNode* CntNodeJob::GetUserDataNode( BOOL bCreate )
{
	if ( _xUserDataNode.Is() )
		return (CntStorageNode *)&_xUserDataNode;

	/////////////////////////////////////////////////////////////////
	// "On-demand" creation of user data node
	/////////////////////////////////////////////////////////////////

	CntNode* pRoot = _xSubject->GetMostReferedNode()->GetRootNode();

	// assemble URL of user data node...
	UniString aUserURL( UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM( STG_PROTOCOL_USER ) ) );

	aUserURL += OWN_URL( pRoot );

	if ( !bCreate )
	{
       	if ( !CntStorageNode::StorageFileExists( aUserURL ) )
       		return NULL;
    }

	// get / create the user data node...
	_xUserDataNode = CNT_RNM()->Query( aUserURL );

	if ( _xCacheNode.Is() )
	{
		CntRootStorageNode* pCache = (CntRootStorageNode*)&*_xCacheNode;
   		pCache->SetUserNode( _xUserDataNode );
	}

	DBG_ASSERT( _xUserDataNode.Is(),
				"GetUserDataNode: Unable to get user data node!" );

	return (CntStorageNode *)&_xUserDataNode;
}

//----------------------------------------------------------------------------
BOOL AnchorMatches_Impl( CntAnchor* pAnchor, CntAnchor* pParent )
{
	if ( !pAnchor->GetNode() )
		return TRUE;

	if ( !pParent->GetNode() )
		return TRUE;

	const String& rAnchorURL =
					OWN_URL( pAnchor->GetNode()->GetMostReferedNode() );
	const String& rParentURL =
					OWN_URL( pParent->GetNode()->GetMostReferedNode() );

	if ( rParentURL.Len() >	rAnchorURL.Len() )
		return ( rParentURL.Match( rAnchorURL ) != STRING_NOTFOUND );

	return ( rAnchorURL.Match( rParentURL ) != STRING_NOTFOUND );
}

//----------------------------------------------------------------------------
CntStorageNode* CntNodeJob::GetViewDataNode( BOOL bCreate )
{
	if ( _xViewDataNode.Is() )
		return (CntStorageNode *)&_xViewDataNode;

	if ( !_xClient->ISA( CntAnchor ) )
	{
		DBG_ERROR( "GetViewDataNode: job client must be a CntAnchor!" );
		return NULL;
	}

	CntAnchor* pClient = (CntAnchor *)&_xClient;
	CntNode*   pNode   = pClient->GetNode();

	if ( !pNode )
		return NULL;

	pNode = pNode->GetRootNode();
	if ( CntViewStorageNode::IsRootViewURL( OWN_URL( pNode ) ) )
	{
		// Acquire View Data Node's storage. This disables the possibility
		// to close the storage medium.
		CntViewStorageNode* pStgNode = (CntViewStorageNode*)pNode;
		pStgNode->acquireStorage();
		_xViewDataNode = pStgNode;
		return pStgNode;
	}

#if 0 /* EXPERIMENTAL */

	/////////////////////////////////////////////////////////////////
	// "On-demand" creation of default(!) view data node
	/////////////////////////////////////////////////////////////////

	CntStorageNode* pCache = GetCacheNode( FALSE );
	if ( pCache )
	{
		const String& rCacheURL = OWN_URL( pCache );

		String aURL( rCacheURL );
		CntStorageNode::Own2FileURL( aURL );

		String aExt( '.' );
		aExt += STG_NOTVIEW_FILE_EXTENSION;

		xub_StrLen nPos = aURL.Search( aExt );
		if ( nPos == ( aURL.Len() - aExt.Len() ) )
		{
			aURL.Cut( nPos + 1 );
			aURL += STG_FILE_EXTENSION;

			BOOL bExists = CntStorageNode::StorageFileExists( aURL );
			if ( !bCreate && !bExists )
				return NULL;

			// Storage file exists or ( bCreate == TRUE )

#ifdef DBG_UTIL
			if ( bCreate )
			{
				String aText;
				if ( bExists )
					aText = "No view data node found! Using default: ";
				else
					aText = "No view data node found! Creating default: ";

				aText += aURL;
				DBG_ERROR( aText );
			}
#endif

			if ( !bExists )
			{
               	if ( CntRootStorageNode::create( aURL ) != ERRCODE_NONE )
					return NULL;
			}

			_xViewDataNode = CNT_RNM()->Query( aURL );

			if ( !bExists && _xViewDataNode.Is() )
			{
				CntNode* pRoot =
							_xSubject->GetMostReferedNode()->GetRootNode();
				String aTitle(
					ITEMSET_VALUE( pRoot, CntStringItem, WID_REAL_URL ) );
				if ( !aTitle.Len() )
					aTitle = OWN_URL( pRoot );

				_xViewDataNode->Put( CntStringItem( WID_TITLE, aTitle ) );

				CntAnchorRef xAnchor( new CntAnchor( NULL, _xViewDataNode ) );
				xAnchor->Put( CntStringItem( WID_REFERED_URL, rCacheURL ) );
				xAnchor->Put( SfxVoidItem( WID_INSERT ) );
			}

			return (CntStorageNode *)&_xViewDataNode;
		}
	}

#endif /* EXPERIMENTAL */

	// Error.
	return NULL;
}

//----------------------------------------------------------------------------
CntStorageNode* CntNodeJob::GetCacheNode( BOOL bCreate )
{
	if ( _xCacheNode.Is() )
		return (CntStorageNode *)&_xCacheNode;

	/////////////////////////////////////////////////////////////////
	// "On-demand" creation of cache node
	/////////////////////////////////////////////////////////////////

	CntNode* pRoot = _xSubject->GetMostReferedNode()->GetRootNode();

	// assemble URL of cache node...
	UniString aCacheURL(
				UniString::CreateFromAscii(
						RTL_CONSTASCII_STRINGPARAM(	STG_PROTOCOL_CACHE ) ) );
	aCacheURL += OWN_URL( pRoot );

	if ( !bCreate )
	{
       	if ( !CntStorageNode::StorageFileExists( aCacheURL ) )
       		return NULL;
    }

	// get / create the cache node...
	_xCacheNode = CNT_RNM()->Query( aCacheURL );

	DBG_ASSERT( _xCacheNode.Is(),
				"GetCacheNode: Unable to get cache node!" );

	if ( _xCacheNode.Is() )
	{
		if ( _xCacheNode->GetReferedNode() != pRoot )
			_xCacheNode->SetReferedNode( pRoot );

		if ( _xClient->ISA( CntAnchor ) )
		{
			// insert cache node in node chain
			CntAnchor* pAnchor = (CntAnchor*)&_xClient;
			CntNode*   pNode   = pAnchor->GetNode();
			if ( pNode )
			{
				if ( pNode == pRoot )
					pAnchor->SetNode( _xCacheNode );
				else
				{
					CntNode* pPrev = pNode;
					pNode = pNode->GetReferedNode();
					while ( pNode )
					{
						if ( pNode == pRoot )
						{
							if ( OWN_URL( pPrev ) != OWN_URL( &_xCacheNode ) )
								pPrev->SetReferedNode( _xCacheNode );

							pNode = NULL; // done.
						}
						else
						{
							pPrev = pNode;
							pNode = pNode->GetReferedNode();
						}
					}
				}
			}
		}
		if ( _xUserDataNode.Is() )
		{
			CntRootStorageNode* pCache = (CntRootStorageNode*)&*_xCacheNode;
	   		pCache->SetUserNode( _xUserDataNode );
		}
	}

	return (CntStorageNode *)&_xCacheNode;
}

//----------------------------------------------------------------------------
CntStorageNode* CntNodeJob::GetDirectoryNode( BOOL bCreate )
{
	if ( _xDirectoryNode.Is() )
		return (CntStorageNode *)&_xDirectoryNode;

	if ( _xClient->ISA( CntAnchor ) )
	{
		CntNode* pNode = ( (CntAnchor *)&_xClient )->GetNode();
		CntNode* pLast = NULL;
		while ( pNode )
		{
			if ( pNode->ISA( CntStorageNode ) )
				pLast = pNode;
			else
			{
				if ( !pLast )
					break; // Try on-demand creation

				_xDirectoryNode = pLast;
				return (CntStorageNode*)pLast;
			}
			pNode = pNode->GetReferedNode();
		}
	}

	/////////////////////////////////////////////////////////////////
	// "On-demand" creation of directory node
	/////////////////////////////////////////////////////////////////

	CntNode* pRoot = _xSubject;

	if ( ITEMSET_VALUE( pRoot, CntBoolItem, WID_FLAG_IS_DOCUMENT ) &&
	     !ITEMSET_VALUE( pRoot, CntBoolItem, WID_FLAG_IS_FOLDER ) )
		pRoot = pRoot->GetParent();

	pRoot = pRoot->GetMostReferedNode();

	// assemble URL of directory node...
	UniString aCacheURL(
				UniString::CreateFromAscii(
						RTL_CONSTASCII_STRINGPARAM(	STG_PROTOCOL_CACHE ) ) );
	aCacheURL += OWN_URL( pRoot );

	if ( !bCreate )
	{
       	if ( !CntStorageNode::StorageFileExists( aCacheURL ) )
       		return NULL;
    }

	// get / create the directory node...
	_xDirectoryNode = CNT_RNM()->Query( aCacheURL );

	DBG_ASSERT( _xDirectoryNode.Is(),
				"GetDirectoryNode: Unable to get directory node!" );

	if ( _xDirectoryNode.Is() )
	{
		if ( _xDirectoryNode->GetReferedNode() != pRoot )
			_xDirectoryNode->SetReferedNode( pRoot );

		// insert directory node in node chain
		if ( _xClient->ISA( CntAnchor ) )
		{
			CntAnchor* pAnchor = (CntAnchor*)&_xClient;
			CntNode*   pNode   = pAnchor->GetNode();
			if ( pNode )
			{
				if ( pNode == pRoot )
					pAnchor->SetNode( _xDirectoryNode );
				else
				{
					CntNode* pPrev = pNode;
					pNode = pNode->GetReferedNode();
					while ( pNode )
					{
						if ( pNode == pRoot )
						{
							if ( OWN_URL( pPrev ) !=
								 OWN_URL( &_xDirectoryNode ) )
								pPrev->SetReferedNode( _xDirectoryNode );

							pNode = NULL; // done.
						}
						else
						{
							pPrev = pNode;
							pNode = pNode->GetReferedNode();
						}
					}
				}
			}
		}
	}

	return (CntStorageNode *)&_xDirectoryNode;
}

//------------------------------------------------------------------------
CntInterface* CntNodeJob::GetViewDataTarget(
								CntInterface* pTarget /* = NULL */ ) const
{
	CntInterface* pViewDataTarget = pTarget ? pTarget : &_xClient;

	if ( CntViewBase::IsViewURL( OWN_URL( pViewDataTarget ) ) )
	{
		CntAnchor* pAnchor = PTR_CAST( CntAnchor, pViewDataTarget );

        if ( pAnchor )
		{
			pViewDataTarget = pAnchor->GetNode();

			DBG_ASSERT( pViewDataTarget->ISA( CntViewStorageNode ) ||
						pViewDataTarget->ISA( CntViewNode ),
						"CntNodeJob::GetViewDataTarget() - Ooops!" );
		}
	}

	return pViewDataTarget;
}

//------------------------------------------------------------------------
void CntNodeJob::InsertChildJob_Impl( CntNodeJob* pChild )
{
	if ( !_pChildJobs )
		_pChildJobs = new CntNodeJobList;

	_pChildJobs->Insert( pChild, LIST_APPEND );
}

//------------------------------------------------------------------------
void CntNodeJob::RemoveChildJob_Impl( CntNodeJob* pChild )
{
	if ( _pChildJobs )
	{
		CntNodeJobRef xThis( this );

		_pChildJobs->Remove( pChild );

		if ( ChildJobCount() == 0 )
		{
			// Was Done() already called for me and deferred because
			// child job(s) were active at this time?
			if ( IsDone() )
				Done();

			delete _pChildJobs;
			_pChildJobs = NULL;
		}

		// this may free "this"
		pChild->_xParent = NULL;
	}
}

//------------------------------------------------------------------------
String CntNodeJob::CreateTitle_Impl() const
{
	// The decription shall look like:
	// 		Open, Newsgroup '_sd.test'
	//      New (Message), OuTray 'My OutTray'
	//		Marked (1), Message 'Hello World'

	// Get item presentation
	String aDescription( CntResId( RID_CNT_POOL_PRES_NAME_START +
	                               _pRequest->Which() - WID_CHAOS_START ) );

	aDescription.EraseTrailingChars( '.' );
	aDescription.EraseTrailingChars( ' ' );

	if ( aDescription.Len() )
	{
		if ( _pRequest->ISA( CntEnumItem ) )
		{
			const CntEnumItem* pEnumItem = (const CntEnumItem*)_pRequest;
			String aEnumPres(
					pEnumItem->GetValueTextByPos( pEnumItem->GetValue() ) );
			if ( aEnumPres.Len() )
			{
				aDescription.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " (" ) );
				aDescription += aEnumPres;
				aDescription += ')';
			}
		}
		else if ( _pRequest->ISA( CntBoolItem ) )
		{
			aDescription.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " (" ) );
			aDescription +=
					(USHORT)( ( (const CntBoolItem*)_pRequest )->GetValue() );
			aDescription += ')';
		}
		else if ( _pRequest->ISA( CntUnencodedStringItem ) )
		{
			// Do not check for CntStringItem here, because we want to
			// catch CntNameItem's, too.
			aDescription.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " (" ) );
			aDescription +=
					( ( (const CntUnencodedStringItem*)_pRequest )->GetValue() );
			aDescription += ')';
		}
		else if ( ( _pRequest->Which() == WID_CREATE_NEW ) &&
		          _pRequest->ISA( CntItemListItem ) )
		{
			const CntItemListItem* pCreateItem =
										(const CntItemListItem*)_pRequest;
			const CntStringItem* pNameItem =
					(const CntStringItem*)pCreateItem->Get( WID_FACTORY_NAME );
			if ( pNameItem )
			{
				aDescription.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " (" ) );
				aDescription += pNameItem->GetValue();
				aDescription += ')';
			}
		}
	}

	if ( !aDescription.Len() )
	{
		// Got no presentation for the action to do.
		aDescription = CntResId( RID_NAMELESS_ACTION );

#ifdef DBG_UTIL
		if ( IsPublic_Impl() )
		{
			ByteString aBuf(
				RTL_CONSTASCII_STRINGPARAM(
					"CntNodeJob::CreateTitle - Nameless action: " ) );
			aBuf += ByteString::CreateFromInt32( _pRequest->Which() );
			DBG_ERROR( aBuf.GetBuffer() );
		}
#endif
	}

	aDescription += ':';

	String aType;
	const CntContentTypeItem& rItem =
				(const CntContentTypeItem&)_xClient->Get( WID_CONTENT_TYPE );
	rItem.GetPresentation( SFX_ITEM_PRESENTATION_NAMELESS,
						   SFX_MAPUNIT_APPFONT,
						   SFX_MAPUNIT_APPFONT,
						   aType,
						   &CntRootNodeMgr::GetIniManager()->
                             getIntlWrapper());
	if ( aType.Len() )
	{
		// Many content type representations ending with "..."
		aType.EraseTrailingChars( '.' );
		aType.EraseTrailingChars( ' ' );

		// Got type
		aDescription += ' ';
		aDescription += aType;
	}

	String aTitle( ITEMSET_VALUE( &_xClient, CntStringItem, WID_TITLE ) );
	if ( aTitle.Len() )
	{
		aDescription.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " '" ) );
		aDescription += aTitle;
		aDescription.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "'" ) );
	}

#ifdef DBG_UTIL
	if ( !IsPublic_Impl() )
	{
		// Enclose title into braces to indicate "privacy".
		aDescription.Insert(
			UniString::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM( "[ " ) ), 0 );
		aDescription.Insert(
			UniString::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM( " ]" ) ) );
	}
#endif

	return aDescription;
}

//------------------------------------------------------------------------
BOOL CntNodeJob::IsPublic_Impl() const
{
	if ( _xParent.Is() )
	{
		// Child jobs are never public.
		return FALSE;
	}

	USHORT nWhich = _pRequest->Which();

	if ( !_xClient->IsItemFlag( nWhich, CNT_ITEM_UI_CANCELABLE ) )
	{
		// Not flagged as UI cancelable.
		return FALSE;
	}

	if ( IsSynchronous() )
	{
		// Synchronous jobs are never public.
		return FALSE;
	}

	return TRUE;
}

//------------------------------------------------------------------------
void CntNodeJob::ClearRequest_Impl()
{
	// This method asures that, When the job broadcasts that it is done or
	// cancelled, it no longer holds any data supplied by the caller.  (For
	// example, we should release an XOutputSink in the WID_OPEN job's
	// OpenModeItem here, because the caller may want to delete or move the
	// file associated with the XOutputSink once he receives a 'done' from the
	// job.)
	if (CntOpenModeItem * pOpenModeItem
		    = PTR_CAST(CntOpenModeItem, _pRequest))
		pOpenModeItem->clearDataSink();
}

/*========================================================================
 *
 * CntJobRescheduler Implementation.
 *
 *======================================================================*/

#ifdef USE_JOB_DISPATCHER

CntJobRescheduler::CntJobRescheduler( CntNode *pNode, CntNodeJob *pJob )
: CntJobDispatchUnit( pNode, pJob )
{
	CntJobDispatcher* pDispatcher =	pNode->getJobDispatcher();
	if ( pDispatcher )
	{
		pDispatcher->dispatch( this );
	}
	else
	{
		DBG_ERROR( "CntJobRescheduler: No job dispatcher!" );
	}
}

#else

CntJobRescheduler::CntJobRescheduler( CntNode *pNode, CntNodeJob *pJob )
:	_xNode( pNode ),
	_xJob( pJob )
{
	CNT_RNM()->AddJobScheduler( this );

	SetTimeoutHdl( LINK( this, CntJobRescheduler, Reschedule ) );
	Start();
}

//----------------------------------------------------------------------------
CntJobRescheduler::~CntJobRescheduler()
{
	CNT_RNM()->RemoveJobScheduler( this );
}

//----------------------------------------------------------------------------
IMPL_LINK( CntJobRescheduler, Reschedule, void*, p )
{
	if ( _xJob->_bAlwaysReschedule
		 || !_xJob->IsCancelled() && !_xJob->IsDone() )
		_xNode->DoExecuteJob( _xJob );

	delete this;
	return 0;
}

#endif /* !USE_JOB_DISPATCHER */

/*========================================================================
 *
 * CntJobCancelable Implementation.
 *
 *======================================================================*/

CntJobCancelable::CntJobCancelable( CntNodeJob *pOwner,
                                    const String& rTitle,
                                    SfxCancelManager* pMgr )
: SfxCancellable( pMgr, rTitle ),
  _pOwner( pOwner )
{
	DBG_ASSERT( GetTitle().Len(),
	            "CntJobCancelable without title constructed!" );
}

//----------------------------------------------------------------------------
// virtual
CntJobCancelable::~CntJobCancelable()
{
}

//----------------------------------------------------------------------------
// virtual
void CntJobCancelable::Cancel()
{
	// Forward request to owner. Owner calls SfxCancellable::Cancel().
	_pOwner->Cancel();
}

/*========================================================================
 *
 * CntTask Implementation.
 *
 *======================================================================*/

CntTask::CntTask( CntNodeJob* pJob )
:  _xJob( pJob )
{
	AddRef();
	StartListening( *_xJob );
}

//----------------------------------------------------------------------------
// virtual
CntTask::~CntTask()
{
}

//----------------------------------------------------------------------------
//virtual
void CntTask::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	if( &rBC == &_xJob )
	{
		if ( _xJob->IsDone() || _xJob->IsCancelled() )
		{
			EndListening( *_xJob );
			ReleaseRef();
		}
	}
}

#ifndef USE_JOB_DISPATCHER

/*========================================================================
 *
 * CntThreadSwitcher Implementation.
 *
 *======================================================================*/

// virtual
CntThreadSwitcher::~CntThreadSwitcher()
{
	m_aMutex.acquire();

	if ( m_nUserId )
		Application::RemoveUserEvent( m_nUserId );

	m_aMutex.release();
}

//----------------------------------------------------------------------------
void CntThreadSwitcher::SwitchToMain()
{
	m_aMutex.acquire();

	if ( m_nUserId )
		Application::RemoveUserEvent( m_nUserId );

	m_nUserId =
		Application::PostUserEvent( LINK( this, CntThreadSwitcher, Switch ) );

	m_aMutex.release();
}

//----------------------------------------------------------------------------
IMPL_LINK( CntThreadSwitcher, Switch, void*, p )
{
	m_aMutex.acquire();
	m_nUserId = 0;
	m_aMutex.release();

	SwitchedToMain();

	return 0;
}

#endif /* USE_JOB_DISPATCHER */

