/*************************************************************************
 *
 *  $RCSfile: cntdisp.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#ifndef __STL_USE_NEWALLOC
#define __STL_USE_NEWALLOC 1
#endif

#ifndef _VOS_MACROS_HXX
#include <vos/macros.hxx>
#endif
#ifndef _VOS_THREAD_HXX
#include <vos/thread.hxx>
#endif
#ifndef _VOS_QUEUE_HXX_
#include <vos/queue.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_ //autogen
#include <vos/mutex.hxx>
#endif
#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#ifndef _TOOLS_TIME_HXX //autogen
#include <tools/time.hxx>
#endif

#include "cntdisp.hxx"

#ifndef _CNTNODE_HXX
#include "cntnode.hxx"
#endif
#ifndef _CNTJOB_HXX
#include "cntjob.hxx"
#endif

using namespace chaos;

class CntJobDispatcher_Impl;

//=========================================================================
//
// class CntJobExecutor_Impl
//
//=========================================================================

class CntJobExecutor_Impl : public NAMESPACE_VOS( OThread )
{
	CntJobDispatcher_Impl* m_pOwner;
#ifdef DBG_UTIL
	ULONG m_nRuns;
	ULONG m_nTime;
#endif

public:
	CntJobExecutor_Impl( CntJobDispatcher_Impl* pOwner );
	virtual ~CntJobExecutor_Impl();

	virtual void SAL_CALL run();
};

DECLARE_LIST( CntJobExecutorList_Impl, CntJobExecutor_Impl* );

//=========================================================================
//
// class CntJobDispatcher_Impl
//
//=========================================================================

class CntJobDispatcher_Impl :
					public NAMESPACE_VOS( OQueue<CntJobDispatchUnit*> )
{
	CntJobExecutorList_Impl*  m_pWorkers;

public:
	CntJobDispatcher_Impl( ULONG nWorkers );
	virtual ~CntJobDispatcher_Impl();

	void dispatch( CntJobDispatchUnit* pUnit ) { addTail( pUnit ); }
};

//=========================================================================
//
// CntJobExecutor_Impl implementation.
//
//=========================================================================

CntJobExecutor_Impl::CntJobExecutor_Impl( CntJobDispatcher_Impl* pOwner )
: m_pOwner( pOwner )
{
#ifdef DBG_UTIL
	m_nRuns = 0;
	m_nTime = 0;
#endif

	// Create worker thread...
	create();
}

//=========================================================================
//virtual
CntJobExecutor_Impl::~CntJobExecutor_Impl()
{
	// Cleanup thread.
	terminate();

	// Wake up sleeping thread.
	m_pOwner->dispatch( NULL );

	if ( getIdentifier() != getCurrentIdentifier() )
		join();
}

//=========================================================================
// virtual
void SAL_CALL CntJobExecutor_Impl::run()
{
	while ( schedule() )
	{
		// Block, until there is something new in the queue...
		CntJobDispatchUnit* pUnit = m_pOwner->getHead();

		if ( pUnit )
		{
#ifdef DBG_UTIL
			m_nRuns++;

			ULONG nStart = Time::GetSystemTicks();
#endif
			// Execute the job...
			pUnit->getExecutor()->DoExecuteJob( pUnit->getJob() );
			delete pUnit;

#ifdef DBG_UTIL
		   m_nTime += Time::GetSystemTicks() - nStart;
#endif
		}
	}
}

//=========================================================================
//
// CntJobDispatcher_Impl implementation.
//
//=========================================================================

CntJobDispatcher_Impl::CntJobDispatcher_Impl( ULONG nWorkers )
: m_pWorkers( new CntJobExecutorList_Impl() )
{
	// Create worker threads.
	for ( ULONG n = 0; n < nWorkers; ++n )
		m_pWorkers->Insert( new CntJobExecutor_Impl( this ), LIST_APPEND );
}

//=========================================================================
// virtual
CntJobDispatcher_Impl::~CntJobDispatcher_Impl()
{
	ULONG nCount = m_pWorkers->Count();
	ULONG n      = 0;

	// Terminate worker threads.
	for ( n = 0; n < nCount; ++n )
		m_pWorkers->GetObject( n )->terminate();

	// Awake sleeping threads. So they will leave their Run() method.
	for ( n = 0; n < nCount; ++n )
		dispatch( NULL );

	// Destroy worker threads.
	for ( n = 0; n < nCount; ++n )
	{
		CntJobExecutor_Impl* pWorker = m_pWorkers->GetObject( n );
		delete pWorker;
	}

	delete m_pWorkers;

	// Remove any (possibly) pending jobs from queue.
	while ( !isEmpty() )
	{
		CntJobDispatchUnit* pUnit = getHead();
		delete pUnit;
	}
}

//=========================================================================
//
// CntJobDispatchUnit implementation.
//
//=========================================================================

CntJobDispatchUnit::CntJobDispatchUnit( CntNode* pExecutor, CntNodeJob* pJob )
: m_pExecutor( pExecutor ),
  m_pJob( pJob )
{
	if ( m_pExecutor && m_pJob )
	{
		// Hold executor and job.
		m_pExecutor->AddRef();
		m_pJob->AddRef();
	}
}

//=========================================================================
CntJobDispatchUnit::~CntJobDispatchUnit()
{
	// Release executor and job.
	m_pExecutor->ReleaseRef();
	m_pJob->ReleaseRef();
}

//=========================================================================
//
// CntJobDispatcher implementation.
//
//=========================================================================

CntJobDispatcher::CntJobDispatcher( ULONG nWorkers /* = 1 */ )
: m_pImpl( new CntJobDispatcher_Impl( nWorkers ? nWorkers : 1 ) )
{
	DBG_ASSERT( nWorkers,
				"CntJobDispatcher::CntJobDispatcher - No Workers?!" );
}

//=========================================================================
CntJobDispatcher::~CntJobDispatcher()
{
	delete m_pImpl;
}

//=========================================================================
void CntJobDispatcher::dispatch( CntJobDispatchUnit* pUnit )
{
	m_pImpl->dispatch( pUnit );
}
