/*************************************************************************
 *
 *  $RCSfile: provider.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: kso $ $Date: 2001/04/27 08:04:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Kai Sommerfeld ( kso@sun.com )
 *
 *
 ************************************************************************/

/**************************************************************************
								TODO
 **************************************************************************

 *************************************************************************/

#include <hash_map>

#ifndef _COM_SUN_STAR_UCB_XPROPERTYSETREGISTRYFACTORY_HPP_
#include <com/sun/star/ucb/XPropertySetRegistryFactory.hpp>
#endif
#ifndef _UCBHELPER_CONTENTIDENTIFIER_HXX
#include <ucbhelper/contentidentifier.hxx>
#endif

#include "provider.hxx"

#ifndef _CONTENT_HXX
#include "content.hxx"
#endif

#ifndef _CNTRNMGR_HXX
#include "cntrnmgr.hxx"
#endif
#ifndef _CNTSYS_HXX
#include "cntsys.hxx"
#endif

using namespace chaos;
using namespace rtl;
using namespace cppu;
using namespace com::sun::star::beans;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::registry;
using namespace com::sun::star::ucb;

//=========================================================================
//
// ContentMap_Impl.
//
//=========================================================================

struct equalString_Impl
{
	bool operator()( const OUString& rKey11, const OUString& rKey22 ) const
  	{
  		return !!( rKey11 == rKey22 );
  	}
};

struct hashString_Impl
{
	size_t operator()( const OUString & rName ) const
	{
		return rName.hashCode();
	}
};

//=========================================================================
typedef std::hash_map
<
	OUString,
	ChaosContent*,
	hashString_Impl,
	equalString_Impl
>
ContentMap_Impl;

//=========================================================================
//
// class Contents_Impl.
//
//=========================================================================

// This is here to get a working forward declaration in provider.hxx!
class Contents_Impl : public ContentMap_Impl {};

//=========================================================================
//=========================================================================
//
// ChaosContentProvider Implementation.
//
//=========================================================================
//=========================================================================

ChaosContentProvider::ChaosContentProvider(
						const Reference< XMultiServiceFactory >& rXSMgr )
: m_xSMgr( rXSMgr ),
  m_pContents( new Contents_Impl )
{
	// Pass Service Manager to CHAOS.
	CntRootNodeMgr::setProcessServiceManager( rXSMgr );

	// Initialize CHAOS.
	CntSystem::Initialize();
}

//=========================================================================
// virtual
ChaosContentProvider::~ChaosContentProvider()
{
	// Deinitialize CHAOS.
	CntSystem::Deinitialize();

	delete m_pContents;
}

//=========================================================================
//
// XInterface methods.
//
//=========================================================================

XINTERFACE_IMPL_4( ChaosContentProvider,
				   XTypeProvider,
				   XServiceInfo,
				   XEventListener,
				   XContentProvider );

//=========================================================================
//
// XTypeProvider methods.
//
//=========================================================================

XTYPEPROVIDER_IMPL_4( ChaosContentProvider,
				   	  XTypeProvider,
				   	  XServiceInfo,
					  XEventListener,
				   	  XContentProvider );

//=========================================================================
//
// XServiceInfo methods.
//
//=========================================================================

#if 0

	// Problem: This code must be callable from Office-setup, where CHAOS
	//          is not fully functional, because of missing configuration
	//          data.

XSERVICEINFO_IMPL_0( ChaosContentProvider,
					 OUString::createFromAscii( "ChaosContentProvider" ) )
{
	sal_Bool bRet = CntSystem::Initialize();

	if ( !bRet )
	{
		DBG_ERROR( "ChaosContentProvider::getSupportedServiceNames_Static() "
				   "- CHAOS not initialized!" );
	}

	ULONG nCount = bRet ? CNT_RNM()->FactoryCount() : 0;

	OUString* pNames = new OUString[ nCount + 1 ];

	// Static service name.
	pNames[ 0 ] =
		OUString::createFromAscii( "com.sun.star.ucb.ChaosContentProvider" );

	ULONG nArrPos = 1;

	// Dynamic service names according to CHAOS services.
	for ( ULONG n = 0; n < nCount; ++n )
	{
		CntNodeFactory* pFac = CNT_RNM()->GetFactory( n );

		// Filter out internal factories.
		if ( !pFac->GetId() )
			continue;

		UniString aScheme( pFac->GetExternalScheme() );
		aScheme.SearchAndReplace( INET_VENDOR_SCHEME_PREFIX, "" );

		if ( !aScheme.Len() )
			continue;

		UniString aService( "com.sun.star.ucb." );
		aService += aScheme.Copy( 0, aScheme.Len() - 1 );

		UniString aWild( pFac->GetWildCard() );
		if ( aWild.GetChar( aWild.Len() - 1 ) != '*' )
		{
			// To avoid duplicates ( "file:///*" <-> "file:///*.sdb" )
			xub_StrLen nTokens = aWild.GetTokenCount( '*' );
			if ( nTokens )
			{
				UniString aTrailer( aWild.GetToken( nTokens - 1 , '*' ) );
				if ( aTrailer.Len() )
				{
					if ( aTrailer.GetChar( 0 ) != '.' )
						aTrailer.Insert( '.', 0 );

					aService += aTrailer;
				}
			}
		}

		pNames[ nArrPos ] = aService;
		nArrPos++;
	}

	Sequence< OUString > aSNS( pNames, nArrPos );
	delete [] pNames;

	CntSystem::Deinitialize();

	return aSNS;
}

#else

XSERVICEINFO_IMPL_1( ChaosContentProvider,
					 OUString::createFromAscii(
				 			"com.sun.star.comp.chaos.ChaosContentProvider" ),
					 OUString::createFromAscii(
					 		"com.sun.star.ucb.ChaosContentProvider" ) );

#endif

//=========================================================================
//
// Service factory implementation.
//
//=========================================================================

ONE_INSTANCE_SERVICE_FACTORY_IMPL( ChaosContentProvider );

//=========================================================================
//
// XEventListener methods.
//
//=========================================================================

// virtual
void SAL_CALL ChaosContentProvider::disposing( const EventObject& Source )
	throw( RuntimeException )
{
	if ( Source.Source == m_xBroker )
	{
		// Release UCB. UCB holds a reference on 'this' and 'this' holds
		// a reference on UCB ( cyclic reference )!
		m_xBroker.clear();
	}
}

//=========================================================================
//
// XContentProvider methods.
//
//=========================================================================

// virtual
Reference< XContent > SAL_CALL ChaosContentProvider::queryContent(
						const Reference< XContentIdentifier >& Identifier )
	throw( IllegalIdentifierException, RuntimeException )
{
	return queryContent_Impl( Identifier, NULL, NULL );
}

//=========================================================================
// virtual
sal_Int32 SAL_CALL ChaosContentProvider::compareContentIds(
								const Reference< XContentIdentifier >& Id1,
								const Reference< XContentIdentifier >& Id2 )
	throw( RuntimeException )
{
	return Id1->getContentIdentifier().compareTo( Id2->getContentIdentifier() );
}

//=========================================================================
//
// Non-Interface methods.
//
//=========================================================================

Reference< XContentProviderManager > ChaosContentProvider::getBroker()
{
	if ( !m_xBroker.is() )
	{
		//@@@ The broker service should be created using
		// createInstanceWithArguments(), specifing whether and how the
		// broker should be configured.  Not supplying these arguments implies
		// that the broker service must already be instantiated and configured
		// when this call is made:
		m_xBroker = Reference< XContentProviderManager >(
			m_xSMgr->createInstance(
				OUString::createFromAscii(
					"com.sun.star.ucb.UniversalContentBroker" ) ), UNO_QUERY );

		DBG_ASSERT( m_xBroker.is(),
					"ChaosContentProvider::getBroker - No UCB service!" )

		// Holding the broker creates a cyclic reference, because it holds
		// it providers!!! So register self at UCB to get informed if the
		// UCB wishes to be destroyed.
		// See ChaosContentProvider::disposing(...)

		Reference< XComponent > xComponent( m_xBroker, UNO_QUERY );
		if ( xComponent.is() )
			xComponent->addEventListener( this );
	}
	return m_xBroker;
}

//=========================================================================
Reference< XPropertySetRegistry > ChaosContentProvider::getPropertySetRegistry()
{
	if ( !m_xPropsReg.is() )
	{
		Reference< XPropertySetRegistryFactory > xRegFac(
				m_xSMgr->createInstance(
					OUString::createFromAscii( "com.sun.star.ucb.Store" ) ),
				UNO_QUERY );

		DBG_ASSERT( xRegFac.is(),
					"ChaosContentProvider::getPropertySetRegistry - "
					"No UCB-Store service!" )

		if ( xRegFac.is() )
		{
			// Open/create a registry.
			m_xPropsReg = xRegFac->createPropertySetRegistry( OUString() );

			DBG_ASSERT( m_xPropsReg.is(),
						"ChaosContentProvider::getPropertySetRegistry - "
						"Error opening registry!" )
		}
	}
	return m_xPropsReg;
}

//=========================================================================
Reference< XContent > ChaosContentProvider::queryContent(
							ChaosContent* pParent, CntAnchor* pAnchor )
	throw( IllegalIdentifierException, RuntimeException )
{
	Reference< XContentIdentifier > xId(
		new ucb::ContentIdentifier( m_xSMgr, pAnchor->GetViewURL( FALSE ) ) );
	return queryContent_Impl( xId, pParent, pAnchor );
}

//=========================================================================
void ChaosContentProvider::addContent( ChaosContent* pContent )
{
	vos::OGuard aGuard( m_aMutex );

	const OUString aURL( pContent->getAnchor()->GetViewURL( FALSE ) );
	(*m_pContents)[ aURL ] = pContent;
}

//=========================================================================
void ChaosContentProvider::removeContent( ChaosContent* pContent )
{
	vos::OGuard aGuard( m_aMutex );

	const OUString aURL( pContent->getAnchor()->GetViewURL( FALSE ) );
	removeContent( aURL );
}

//=========================================================================
void ChaosContentProvider::removeContent( const OUString& rURL )
{
	vos::OGuard aGuard( m_aMutex );

	Contents_Impl::iterator it = m_pContents->find( rURL );
	if ( it != m_pContents->end() )
		m_pContents->erase( it );
}

//=========================================================================
Reference< XContent > ChaosContentProvider::queryContent_Impl(
								const Reference< XContentIdentifier >& xId,
								ChaosContent* pParent,
								CntAnchor* pAnchor )
	throw( IllegalIdentifierException, RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	// Check, if a content with given id already exists...

	String aURL;
	if ( pAnchor )
		aURL = pAnchor->GetViewURL( FALSE );
	else
	{
		aURL = xId->getContentIdentifier();
		NormalizeURL( aURL );
	}

	Reference< XContent > xContent;

	Contents_Impl::const_iterator it = m_pContents->find( aURL );
	if ( it != m_pContents->end() )
	{
		// Already there. Return it.
		xContent = (*it).second;
	}
	else
	{
		// Create a new content. Note that the content will insert itself
		// into m_pContents by calling addContent(...) from it's ctor.

		xContent = new ChaosContent( m_xSMgr, this, xId, pParent, pAnchor );

		if ( !xContent->getIdentifier().is() )
			throw IllegalIdentifierException();
	}

	return xContent;
}

