/*************************************************************************
 *
 *  $RCSfile: ehdli.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: mhu $ $Date: 2001/09/12 11:10:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONABORT_HPP_
#include <com/sun/star/task/XInteractionAbort.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XINTERACTIONAPPROVE_HPP_
#include <com/sun/star/task/XInteractionApprove.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XINTERACTIONDISAPPROVE_HPP_
#include <com/sun/star/task/XInteractionDisapprove.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XINTERACTIONRETRY_HPP_
#include <com/sun/star/task/XInteractionRetry.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_AUTHENTICATIONREQUEST_HPP_
#include <com/sun/star/ucb/AuthenticationRequest.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_COOKIE_HPP_
#include <com/sun/star/ucb/Cookie.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_COOKIEPOLICY_HPP_
#include <com/sun/star/ucb/CookiePolicy.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_COOKIEREQUEST_HPP_
#include <com/sun/star/ucb/CookieRequest.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_HANDLECOOKIESREQUEST_HPP_
#include <com/sun/star/ucb/HandleCookiesRequest.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_IOERRORCODE_HPP_
#include <com/sun/star/ucb/IOErrorCode.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVEBADTRANSFERURLEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveBadTransferURLException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVECHAOSEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveCHAOSException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVEIOEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveIOException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVENETWORKCONNECTEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveNetworkConnectException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVENETWORKGENERALEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveNetworkGeneralException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVENETWORKOFFLINEEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveNetworkOffLineException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVENETWORKREADEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveNetworkReadException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVENETWORKRESOLVENAMEEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveNetworkResolveNameException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVENETWORKWRITEEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveNetworkWriteException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_REMEMBERAUTHENTICATION_HPP_
#include <com/sun/star/ucb/RememberAuthentication.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XINTERACTIONCOOKIEHANDLING_HPP_
#include <com/sun/star/ucb/XInteractionCookieHandling.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XINTERACTIONSUPPLYAUTHENTICATION_HPP_
#include <com/sun/star/ucb/XInteractionSupplyAuthentication.hpp>
#endif
#ifndef _LOGINERR_HXX
#include <svtools/loginerr.hxx>
#endif

#ifndef _CNTCOOK_HXX
#include <cntcook.hxx>
#endif

#ifndef CHAOS_EHDLC_HXX
#include <ehdlc.hxx>
#endif
#ifndef CHAOS_EHDLI_HXX
#include <ehdli.hxx>
#endif

using namespace com::sun::star::task;
using namespace com::sun::star::ucb;
using namespace com::sun::star::uno;
using rtl::OUString;

using namespace chaos;

//============================================================================
class InteractionApprove_Impl: public InteractionContinuation_Impl,
							   public XInteractionApprove
{
	sal_uInt16 m_nButton;

public:
	InteractionApprove_Impl(const vos::ORef<InteractionRequest_Impl> &
							 rRequest,
							sal_uInt16 nTheButton):
		InteractionContinuation_Impl(rRequest), m_nButton(nTheButton) {}

    virtual com::sun::star::uno::Any SAL_CALL queryInterface(const com::sun::star::uno::Type & rType)
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw() { OWeakObject::acquire(); }

    virtual void SAL_CALL release() throw() { OWeakObject::release(); }

	virtual sal_uInt16 getButton() const { return m_nButton; }

	virtual void SAL_CALL select()
		throw (com::sun::star::uno::RuntimeException)
	{ recordSelection(); }
};

//============================================================================
class InteractionDisapprove_Impl: public InteractionContinuation_Impl,
								  public XInteractionDisapprove
{
public:
	InteractionDisapprove_Impl(const vos::ORef<InteractionRequest_Impl> &
							    rRequest):
		InteractionContinuation_Impl(rRequest) {}

    virtual com::sun::star::uno::Any SAL_CALL queryInterface(const com::sun::star::uno::Type & rType)
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw() { OWeakObject::acquire(); }

    virtual void SAL_CALL release() throw() { OWeakObject::release(); }

	virtual sal_uInt16 getButton() const { return ERRCODE_BUTTON_NO; }

	virtual void SAL_CALL select()
		throw (com::sun::star::uno::RuntimeException)
	{ recordSelection(); }
};

//============================================================================
class InteractionAbort_Impl: public InteractionContinuation_Impl,
							 public XInteractionAbort
{
public:
	InteractionAbort_Impl(const vos::ORef<InteractionRequest_Impl> &
						   rRequest):
		InteractionContinuation_Impl(rRequest) {}

    virtual com::sun::star::uno::Any SAL_CALL queryInterface(const com::sun::star::uno::Type & rType)
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw() { OWeakObject::acquire(); }

    virtual void SAL_CALL release() throw() { OWeakObject::release(); }

	virtual sal_uInt16 getButton() const { return ERRCODE_BUTTON_CANCEL; }

	virtual void SAL_CALL select()
		throw (com::sun::star::uno::RuntimeException)
   	{ recordSelection(); }
};

//============================================================================
class InteractionRetry_Impl: public InteractionContinuation_Impl,
							 public XInteractionRetry
{
public:
	InteractionRetry_Impl(const vos::ORef<InteractionRequest_Impl> &
						   rRequest):
		InteractionContinuation_Impl(rRequest) {}

    virtual com::sun::star::uno::Any SAL_CALL queryInterface(const com::sun::star::uno::Type & rType)
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw() { OWeakObject::acquire(); }

    virtual void SAL_CALL release() throw() { OWeakObject::release(); }

	virtual sal_uInt16 getButton() const { return ERRCODE_BUTTON_RETRY; }

	virtual void SAL_CALL select()
		throw (com::sun::star::uno::RuntimeException)
   	{ recordSelection(); }
};

//============================================================================
class InteractionSupplyAuthentication_Impl:
	public InteractionContinuation_Impl,
	public XInteractionSupplyAuthentication
{
	OUString m_sUserName;
	OUString m_sPassword;
	OUString m_sAccount;
	unsigned m_bCanSetUserName: 1;
	unsigned m_bCanSetAccount: 1;
	unsigned m_bRememberPersistent: 1;
	unsigned m_bRemember: 1;

	inline LoginErrorInfo * getInfo();

public:
	InteractionSupplyAuthentication_Impl
	 (const vos::ORef<InteractionRequest_Impl> & rRequest,
	  sal_Bool bTheCanSetUserName, sal_Bool bTheCanSetAccount);

    virtual com::sun::star::uno::Any SAL_CALL queryInterface(const com::sun::star::uno::Type & rType)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL acquire() throw() { OWeakObject::acquire(); }

	virtual void SAL_CALL release() throw() { OWeakObject::release(); }

	virtual sal_uInt16 getButton() const { return ERRCODE_BUTTON_OK; }

	virtual void SAL_CALL select()
		throw (com::sun::star::uno::RuntimeException)
   	{ recordSelection(); }

	virtual sal_Bool SAL_CALL canSetRealm()
		throw (com::sun::star::uno::RuntimeException)
   	{ return sal_False; }

	virtual void SAL_CALL setRealm(const OUString &)
		throw (com::sun::star::uno::RuntimeException)
   	{}

	virtual sal_Bool SAL_CALL canSetUserName()
		throw (com::sun::star::uno::RuntimeException)
   	{ return m_bCanSetUserName; }

	virtual void SAL_CALL setUserName(const OUString & rTheUserName)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL canSetPassword()
		throw (com::sun::star::uno::RuntimeException)
   	{ return sal_True; }

	virtual void SAL_CALL setPassword(const OUString & rThePassword)
		throw (com::sun::star::uno::RuntimeException);

	virtual Sequence<RememberAuthentication>
	SAL_CALL getRememberPasswordModes(RememberAuthentication & rDefault)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL setRememberPassword(
		RememberAuthentication eTheRemember)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL canSetAccount()
		throw (com::sun::star::uno::RuntimeException)
   	{ return m_bCanSetAccount; }

	virtual void SAL_CALL setAccount(const OUString & rTheAccount)
		throw (com::sun::star::uno::RuntimeException);

	virtual Sequence<RememberAuthentication>
	SAL_CALL getRememberAccountModes(RememberAuthentication & rDefault)
		throw (com::sun::star::uno::RuntimeException)
	{ return getRememberPasswordModes(rDefault); }

	virtual void SAL_CALL setRememberAccount(
		RememberAuthentication eTheRemember)
		throw (com::sun::star::uno::RuntimeException)
	{ setRememberPassword(eTheRemember); }

	OUString getUserName() const { return m_sUserName; }

	OUString getPassword() const { return m_sPassword; }

	OUString getAccount() const { return m_sAccount; }

	sal_Bool getRemember() const { return m_bRemember; }
};

inline LoginErrorInfo * InteractionSupplyAuthentication_Impl::getInfo()
{
	void * pData = getErrorExtraData();
	return pData ? &SAL_STATIC_CAST(CntLoginErrorData *, pData)->getInfo() :
	               0;
}

//============================================================================
class InteractionCookieHandling_Impl: public InteractionContinuation_Impl,
									  public XInteractionCookieHandling
{
	inline CntHTTPCookieRequest * getRequest();

public:
	InteractionCookieHandling_Impl(const vos::ORef<InteractionRequest_Impl> &
								    rRequest):
		InteractionContinuation_Impl(rRequest) {}

    virtual com::sun::star::uno::Any SAL_CALL queryInterface(const com::sun::star::uno::Type & rType)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL acquire() throw() { OWeakObject::acquire(); }

	virtual void SAL_CALL release() throw() { OWeakObject::release(); }

	virtual sal_uInt16 getButton() const { return ERRCODE_BUTTON_OK; }

	virtual void SAL_CALL select()
		throw (com::sun::star::uno::RuntimeException)
	{ recordSelection(); }

	virtual void SAL_CALL setGeneralPolicy(CookiePolicy ePolicy)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL setSpecificPolicy(
		const Cookie & rConfirmCookie, sal_Bool bAccept)
		throw (com::sun::star::uno::RuntimeException);
};

inline CntHTTPCookieRequest * InteractionCookieHandling_Impl::getRequest()
{
	void * pData = getErrorExtraData();
	return pData ? SAL_STATIC_CAST(CntHTTPCookieRequest *, pData) : 0;
}

//============================================================================
//
//  class InteractionRequest_Impl
//
//============================================================================

void InteractionRequest_Impl::getResource()
{
	if (m_bResource)
		return;
	m_bResource = sal_True;

	m_eResourceClassification
	 = com::sun::star::task::InteractionClassification_ERROR;
	m_nResourceButtons = ERRCODE_BUTTON_OK;

	if (!m_pData)
		return;

	if (m_pData->_nError & ERRCODE_DYNAMIC_MASK)
	{
		const ErrorInfo * pInfo = ErrorInfo::GetErrorInfo(m_pData->_nError);
		if (pInfo)
			if (pInfo->ISA(StringErrorInfo))
			{
				m_aResourceArguments.realloc(1);
				m_aResourceArguments[0]
				 = UniString(SAL_STATIC_CAST(const StringErrorInfo *, pInfo)->
						    GetErrorString());
			}
			else if (pInfo->ISA(TwoStringErrorInfo))
			{
				m_aResourceArguments.realloc(2);
				m_aResourceArguments[0]
				 = UniString(SAL_STATIC_CAST(const TwoStringErrorInfo *,
										   pInfo)->
						    GetArg1());
				m_aResourceArguments[1]
				 = UniString(SAL_STATIC_CAST(const TwoStringErrorInfo *,
										   pInfo)->
						    GetArg2());
			}
	}

	sal_uInt32 nErrorID = m_pData->_nError & ~ERRCODE_DYNAMIC_MASK;
	sal_uInt32 nErrorCode = nErrorID & 0xFF;

	if ((nErrorID & 0x1FFFUL << ERRCODE_AREA_SHIFT) == ERRCODE_AREA_CHAOS)
		getErrorResource_Impl(nErrorID, m_eResourceClassification,
							  m_nResourceButtons);

	if (m_eResourceClassification
		 == com::sun::star::task::InteractionClassification_ERROR
		&& m_pData->_nError & ERRCODE_WARNING_MASK)
		m_eResourceClassification
		 = com::sun::star::task::InteractionClassification_WARNING;
}

//============================================================================
// virtual
Any SAL_CALL
InteractionRequest_Impl::queryInterface(
	const com::sun::star::uno::Type & rType)
	throw (com::sun::star::uno::RuntimeException)
{
	Any aRet = cppu::queryInterface(rType,
	   					static_cast< XInteractionRequest * >(this));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
// virtual
Any SAL_CALL InteractionRequest_Impl::getRequest()
	throw (com::sun::star::uno::RuntimeException)
{
	getResource();
	sal_uInt32 nErrorID = m_pData ? m_pData->_nError & ~ERRCODE_DYNAMIC_MASK :
	                                ERRCODE_NONE;
    sal_uInt32 nArea = nErrorID & (0x1FFFUL << ERRCODE_AREA_SHIFT);
    if ((nArea == ERRCODE_AREA_IO) || (nArea == ERRCODE_AREA_TOOLS))
	{
		sal_uInt32 nErrorCode = nErrorID & 0xFF;
		if (nErrorCode >= 1 && nErrorCode != 10 && nErrorCode <= 37)
		{
			static const IOErrorCode aCode[37]
			 = { com::sun::star::ucb::IOErrorCode_MISPLACED_CHARACTER,
				 // ERRCODE_IO_MISPLACEDCHAR
				 com::sun::star::ucb::IOErrorCode_NOT_EXISTING,
				 // ERRCODE_IO_NOTEXISTS
				 com::sun::star::ucb::IOErrorCode_ALREADY_EXISTING,
				 // ERRCODE_IO_ALREADYEXISTS
				 com::sun::star::ucb::IOErrorCode_NO_DIRECTORY,
				 // ERRCODE_IO_NOTADIRECTORY
				 com::sun::star::ucb::IOErrorCode_NO_FILE,
				 // ERRCODE_IO_NOTAFILE
				 com::sun::star::ucb::IOErrorCode_INVALID_DEVICE,
				 // ERRCODE_IO_INVALIDDEVICE
				 com::sun::star::ucb::IOErrorCode_ACCESS_DENIED,
				 // ERRCODE_IO_ACCESSDENIED
				 com::sun::star::ucb::IOErrorCode_LOCKING_VIOLATION,
				 // ERRCODE_IO_LOCKVIOLATION
				 com::sun::star::ucb::IOErrorCode_OUT_OF_DISK_SPACE,
				 // ERRCODE_IO_OUTOFSPACE
				 IOErrorCode(0x7FFF),
				 com::sun::star::ucb::IOErrorCode_IS_WILDCARD,
				 // ERRCODE_IO_ISWILDCARD
				 com::sun::star::ucb::IOErrorCode_NOT_SUPPORTED,
				 // ERRCODE_IO_NOTSUPPORTED
				 com::sun::star::ucb::IOErrorCode_GENERAL, // ERRCODE_IO_GENERAL
				 com::sun::star::ucb::IOErrorCode_OUT_OF_FILE_HANDLES,
				 // ERRCODE_IO_TOOMANYOPENFILES
				 com::sun::star::ucb::IOErrorCode_CANT_READ,
				 // ERRCODE_IO_CANTREAD
				 com::sun::star::ucb::IOErrorCode_CANT_WRITE,
				 // ERRCODE_IO_CANTWRITE
				 com::sun::star::ucb::IOErrorCode_OUT_OF_MEMORY,
				 // ERRCODE_IO_OUTOFMEMORY
				 com::sun::star::ucb::IOErrorCode_CANT_SEEK,
				 // ERRCODE_IO_CANTSEEK
				 com::sun::star::ucb::IOErrorCode_CANT_TELL,
				 // ERRCODE_IO_CANTTELL
				 com::sun::star::ucb::IOErrorCode_WRONG_VERSION,
				 // ERRCODE_IO_WRONGVERSION
				 com::sun::star::ucb::IOErrorCode_WRONG_FORMAT,
				 // ERRCODE_IO_WRONGFORMAT
				 com::sun::star::ucb::IOErrorCode_INVALID_CHARACTER,
				 // ERRCODE_IO_INVALIDCHAR
				 com::sun::star::ucb::IOErrorCode_UNKNOWN, // ERRCODE_IO_UNKNOWN
				 com::sun::star::ucb::IOErrorCode_INVALID_ACCESS,
				 // ERRCODE_IO_INVALIDACCESS
				 com::sun::star::ucb::IOErrorCode_CANT_CREATE,
				 // ERRCODE_IO_CANTCREATE
				 com::sun::star::ucb::IOErrorCode_INVALID_PARAMETER,
				 // ERRCODE_IO_INVALIDPARAMETER
				 com::sun::star::ucb::IOErrorCode_ABORT, // ERRCODE_IO_ABORT
				 com::sun::star::ucb::IOErrorCode_NOT_EXISTING_PATH,
				 // ERRCODE_IO_NOTEXISTSPATH
				 com::sun::star::ucb::IOErrorCode_PENDING, // ERRCODE_IO_PENDING
				 com::sun::star::ucb::IOErrorCode_RECURSIVE,
				 // ERRCODE_IO_RECURSIVE
				 com::sun::star::ucb::IOErrorCode_NAME_TOO_LONG,
				 // ERRCODE_IO_NAMETOOLONG
				 com::sun::star::ucb::IOErrorCode_INVALID_LENGTH,
				 // ERRCODE_IO_INVALIDLENGTH
				 com::sun::star::ucb::IOErrorCode_CURRENT_DIRECTORY,
				 // ERRCODE_IO_CURRENTDIR
				 com::sun::star::ucb::IOErrorCode_DIFFERENT_DEVICES,
				 // ERRCODE_IO_NOTSAMEDEVICE
				 com::sun::star::ucb::IOErrorCode_DEVICE_NOT_READY,
				 // ERRCODE_IO_DEVICENOTREADY
				 com::sun::star::ucb::IOErrorCode_BAD_CRC, // ERRCODE_IO_BADCRC
				 com::sun::star::ucb::IOErrorCode_WRITE_PROTECTED };
			      // ERRCODE_IO_WRITEPROTECTED
			InteractiveIOException aError;
			aError.Classification = m_eResourceClassification;
			aError.Code = aCode[nErrorCode - 1];
			return makeAny(aError);
		}
	}
	else
		switch (nErrorID)
		{
			case ERRCODE_INET_NAME_RESOLVE:
			{
				InteractiveNetworkResolveNameException aError;
				aError.Classification = m_eResourceClassification;
				if (m_aResourceArguments.getLength() >= 1)
					aError.Server = m_aResourceArguments[0];
				return makeAny(aError);
			}

			case ERRCODE_INET_CONNECT:
			{
				InteractiveNetworkConnectException aError;
				aError.Classification = m_eResourceClassification;
				if (m_aResourceArguments.getLength() >= 1)
					aError.Server = m_aResourceArguments[0];
				return makeAny(aError);
			}

			case ERRCODE_INET_READ:
			{
				InteractiveNetworkReadException aError;
				aError.Classification = m_eResourceClassification;
				if (m_aResourceArguments.getLength() >= 1)
					aError.Diagnostic = m_aResourceArguments[0];
				return makeAny(aError);
			}

			case ERRCODE_INET_WRITE:
			{
				InteractiveNetworkWriteException aError;
				aError.Classification = m_eResourceClassification;
				if (m_aResourceArguments.getLength() >= 1)
					aError.Diagnostic = m_aResourceArguments[0];
				return makeAny(aError);
			}

			case ERRCODE_INET_GENERAL:
			{
				InteractiveNetworkGeneralException aError;
				aError.Classification = m_eResourceClassification;
				return makeAny(aError);
			}

			case ERRCODE_INET_OFFLINE:
			{
				InteractiveNetworkOffLineException aError;
				aError.Classification = m_eResourceClassification;
				return makeAny(aError);
			}

			case ERRCODE_CHAOS_LOGIN_FAILURE_RECEIVE:
			case ERRCODE_CHAOS_LOGINFAIL_NOEXCH:
			case ERRCODE_CHAOS_LOGIN_FAILURE_ACCOUNT:
			case ERRCODE_CHAOS_LOGINFAIL_ACCOUNT_NOEXCH:
			{
				const LoginErrorInfo * pInfo
				 = m_pData ? &SAL_STATIC_CAST(CntLoginErrorData *,
											  m_pData->_pData)->
				               getInfo() :
				             0;
				AuthenticationRequest aError;
				aError.Classification = m_eResourceClassification;
				if (pInfo)
					aError.ServerName = pInfo->GetServer();
				if (pInfo)
					aError.Diagnostic = pInfo->GetErrorText();
				aError.HasRealm = pInfo && pInfo->GetAccount().Len() > 0
				                  && !(pInfo->GetFlags()
									    & LOGINERROR_FLAG_MODIFY_ACCOUNT);
				if (pInfo && aError.HasRealm)
					aError.Realm = pInfo->GetAccount();
				aError.HasUserName = sal_True;
				if (pInfo)
					aError.UserName = pInfo->GetUserName();
				aError.HasPassword = sal_True;
				if (pInfo)
					aError.Password = pInfo->GetPassword();
				aError.HasAccount
				 = nErrorID == ERRCODE_CHAOS_LOGIN_FAILURE_ACCOUNT
				   || nErrorID == ERRCODE_CHAOS_LOGINFAIL_ACCOUNT_NOEXCH;
				if (aError.HasAccount && pInfo)
					aError.Account = pInfo->GetAccount();
				return makeAny(aError);
			}

			case ERRCODE_CHAOS_HTTP_COOKIE_REQUEST:
			{
				const CntHTTPCookieRequest * pRequest = 0;
				if (m_pData) pRequest = SAL_STATIC_CAST(
					CntHTTPCookieRequest*, m_pData->_pData);

				HandleCookiesRequest aError;
				aError.Classification = m_eResourceClassification;
				if (pRequest)
				{
					aError.URL = pRequest->m_rURL;
					aError.Cookies.
					 realloc(sal_Int32(pRequest->m_rCookieList.Count()));
					for (sal_Int32 i = 0;
						 i < sal_Int32(pRequest->m_rCookieList.Count()); ++i)
					{
						const CntHTTPCookie * pCookie
						 = SAL_STATIC_CAST(CntHTTPCookie *,
										   pRequest->
										    m_rCookieList.GetObject(i));
						if (pCookie)
						{
							aError.Cookies[i].Name
							 = pCookie->m_aName;
							aError.Cookies[i].Value
							 = pCookie->m_aValue;
							aError.Cookies[i].Domain
							 = pCookie->m_aDomain;
							aError.Cookies[i].Path
							 = pCookie->m_aPath;
							aError.Cookies[i].Expires.HundredthSeconds
							 = pCookie->m_aExpires.Get100Sec();
							aError.Cookies[i].Expires.Seconds
							 = pCookie->m_aExpires.GetSec();
							aError.Cookies[i].Expires.Minutes
							 = pCookie->m_aExpires.GetMin();
							aError.Cookies[i].Expires.Hours
							 = pCookie->m_aExpires.GetHour();
							aError.Cookies[i].Expires.Day
							 = pCookie->m_aExpires.GetDay();
							aError.Cookies[i].Expires.Month
							 = pCookie->m_aExpires.GetMonth();
							aError.Cookies[i].Expires.Year
							 = pCookie->m_aExpires.GetYear();
							aError.Cookies[i].Secure
							 = (pCookie->m_nFlags
								 & CNTHTTP_COOKIE_FLAG_SECURE)
							    != 0;
							switch (pCookie->m_nPolicy)
							{
								case CNTHTTP_COOKIE_POLICY_INTERACTIVE:
									aError.Cookies[i].Policy
									 = CookiePolicy_CONFIRM;
									break;

								case CNTHTTP_COOKIE_POLICY_ACCEPTED:
									aError.Cookies[i].Policy
									 = CookiePolicy_ACCEPT;
									break;

								case CNTHTTP_COOKIE_POLICY_BANNED:
									aError.Cookies[i].Policy
									 = CookiePolicy_IGNORE;
									break;
							}
						}
					}
					aError.Request
					 = pRequest->m_eType == CNTHTTP_COOKIE_REQUEST_SEND ?
					    CookieRequest_SEND : CookieRequest_RECEIVE;
				}
				return makeAny(aError);
			}

			case ERRCODE_CHAOS_TRANSFER_URL_NOT_SUPPORTED:
				return makeAny(InteractiveBadTransferURLException());
		}
	InteractiveCHAOSException aError;
	aError.Classification = m_eResourceClassification;
	aError.ID = nErrorID;
	aError.Arguments = m_aResourceArguments;
	return makeAny(aError);
}

//============================================================================
// virtual
Sequence<Reference<XInteractionContinuation> >
SAL_CALL InteractionRequest_Impl::getContinuations()
	throw (com::sun::star::uno::RuntimeException)
{
	getResource();
	sal_Int32 nLength;
	sal_Bool bApprove;
	sal_Bool bDisapprove;
	sal_Bool bAbort;
	sal_Bool bRetry;
	sal_Bool bAuthentication;
	sal_Bool bAuthenticationUserName;
	sal_Bool bAuthenticationAccount;
	sal_Bool bCookies;
	switch (m_pData ? m_pData->_nError : ERRCODE_NONE)
	{
		case ERRCODE_CHAOS_LOGIN_FAILURE_RECEIVE:
			nLength = 3;
			bApprove = sal_False;
			bDisapprove = sal_False;
			bAbort = sal_True;
			bRetry = sal_True;
			bAuthentication = sal_True;
			bAuthenticationUserName = sal_True;
			bAuthenticationAccount = sal_False;
			bCookies = sal_False;
			break;

		case ERRCODE_CHAOS_LOGINFAIL_NOEXCH:
			nLength = 3;
			bApprove = sal_False;
			bDisapprove = sal_False;
			bAbort = sal_True;
			bRetry = sal_True;
			bAuthentication = sal_True;
			bAuthenticationUserName = sal_False;
			bAuthenticationAccount = sal_False;
			bCookies = sal_False;
			break;

		case ERRCODE_CHAOS_LOGIN_FAILURE_ACCOUNT:
			nLength = 3;
			bApprove = sal_False;
			bDisapprove = sal_False;
			bAbort = sal_True;
			bRetry = sal_True;
			bAuthentication = sal_True;
			bAuthenticationUserName = sal_True;
			bAuthenticationAccount = sal_True;
			bCookies = sal_False;
			break;

		case ERRCODE_CHAOS_LOGINFAIL_ACCOUNT_NOEXCH:
			nLength = 3;
			bApprove = sal_False;
			bDisapprove = sal_False;
			bAbort = sal_True;
			bRetry = sal_True;
			bAuthentication = sal_True;
			bAuthenticationUserName = sal_False;
			bAuthenticationAccount = sal_True;
			bCookies = sal_False;
			break;

		case ERRCODE_CHAOS_HTTP_COOKIE_REQUEST:
			nLength = 1;
			bApprove = sal_False;
			bDisapprove = sal_False;
			bAbort = sal_False;
			bRetry = sal_False;
			bAuthentication = sal_False;
			bCookies = sal_True;
			break;

		default:
			nLength = 0;
			if (m_nResourceButtons & (ERRCODE_BUTTON_OK | ERRCODE_BUTTON_YES))
			{
				++nLength;
				bApprove = sal_True;
			}
			else
				bApprove = sal_False;
			if (m_nResourceButtons & ERRCODE_BUTTON_NO)
			{
				++nLength;
				bDisapprove = sal_True;
			}
			else
				bDisapprove = sal_False;
			if (m_nResourceButtons & ERRCODE_BUTTON_CANCEL)
			{
				++nLength;
				bAbort = sal_True;
			}
			else
				bAbort = sal_False;
			if (m_nResourceButtons & ERRCODE_BUTTON_RETRY)
			{
				++nLength;
				bRetry = sal_True;
			}
			else
				bRetry = sal_False;
			bAuthentication = sal_False;
			bCookies = sal_False;
			break;
	}
	Sequence<Reference<XInteractionContinuation> > aContinuations(nLength);
	nLength = 0;
	if (bApprove)
		aContinuations[nLength++]
		 = new InteractionApprove_Impl(this,
									   m_nResourceButtons
									     & ERRCODE_BUTTON_OK ?
									    ERRCODE_BUTTON_OK :
									    ERRCODE_BUTTON_YES);
	if (bDisapprove)
		aContinuations[nLength++] = new InteractionDisapprove_Impl(this);
	if (bAbort)
		aContinuations[nLength++] = new InteractionAbort_Impl(this);
	if (bRetry)
		aContinuations[nLength++] = new InteractionRetry_Impl(this);
	if (bAuthentication)
		aContinuations[nLength++]
		 = new InteractionSupplyAuthentication_Impl(this,
													bAuthenticationUserName,
													bAuthenticationAccount);
	if (bCookies)
		aContinuations[nLength++] = new InteractionCookieHandling_Impl(this);
	return aContinuations;
}

//============================================================================
//
//  class InteractionApprove_Impl
//
//============================================================================

// virtual
Any SAL_CALL
InteractionApprove_Impl::queryInterface(
	const com::sun::star::uno::Type & rType)
	throw (com::sun::star::uno::RuntimeException)
{
	Any aRet = cppu::queryInterface(rType,
						static_cast< XInteractionContinuation * >(this),
	   					static_cast< XInteractionApprove * >(this));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
//
//  class InteractionDisapprove_Impl
//
//============================================================================

// virtual
Any SAL_CALL
InteractionDisapprove_Impl::queryInterface(
	const com::sun::star::uno::Type & rType)
	throw (com::sun::star::uno::RuntimeException)
{
	Any aRet = cppu::queryInterface(rType,
						static_cast< XInteractionContinuation * >(this),
	   					static_cast< XInteractionDisapprove * >(this));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
//
//  class InteractionAbort_Impl
//
//============================================================================

// virtual
Any SAL_CALL
InteractionAbort_Impl::queryInterface(const com::sun::star::uno::Type & rType)
	throw (com::sun::star::uno::RuntimeException)
{
	Any aRet = cppu::queryInterface(rType,
						static_cast< XInteractionContinuation * >(this),
	   					static_cast< XInteractionAbort * >(this));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
//
//  class InteractionRetry_Impl
//
//============================================================================

// virtual
Any SAL_CALL
InteractionRetry_Impl::queryInterface(const com::sun::star::uno::Type & rType)
	throw (com::sun::star::uno::RuntimeException)
{
	Any aRet = cppu::queryInterface(rType,
						static_cast< XInteractionContinuation * >(this),
	   					static_cast< XInteractionRetry * >(this));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
//
//  class InteractionSupplyAuthentication_Impl
//
//============================================================================

InteractionSupplyAuthentication_Impl::InteractionSupplyAuthentication_Impl
 (const vos::ORef<InteractionRequest_Impl> & rRequest,
  sal_Bool bTheCanSetUserName, sal_Bool bTheCanSetAccount):
	InteractionContinuation_Impl(rRequest),
	m_bCanSetUserName(bTheCanSetUserName),
	m_bCanSetAccount(bTheCanSetAccount)
{
	LoginErrorInfo * pInfo = getInfo();
	m_bRememberPersistent = pInfo && pInfo->GetIsPersistentPassword();
	m_bRemember = pInfo && pInfo->GetIsSavePassword();
}

//============================================================================
// virtual
Any SAL_CALL
InteractionSupplyAuthentication_Impl::queryInterface(
	const com::sun::star::uno::Type & rType)
	throw (com::sun::star::uno::RuntimeException)
{
	Any aRet = cppu::queryInterface(rType,
						static_cast< XInteractionContinuation * >(this),
	   					static_cast< XInteractionSupplyAuthentication * >(this));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
// virtual
void SAL_CALL
InteractionSupplyAuthentication_Impl::setUserName(
	const OUString & rTheUserName)
	throw (com::sun::star::uno::RuntimeException)
{
	if (m_bCanSetUserName)
	{
		LoginErrorInfo * pInfo = getInfo();
		if (pInfo)
			pInfo->SetUserName(rTheUserName);
	}
}

//============================================================================
// virtual
void SAL_CALL
InteractionSupplyAuthentication_Impl::setPassword(
	const OUString & rThePassword)
	throw (com::sun::star::uno::RuntimeException)
{
	LoginErrorInfo * pInfo = getInfo();
	if (pInfo)
		pInfo->SetPassword(rThePassword);
}

//============================================================================
// virtual
Sequence<RememberAuthentication> SAL_CALL
InteractionSupplyAuthentication_Impl::getRememberPasswordModes (
	RememberAuthentication & rDefault)
	throw (com::sun::star::uno::RuntimeException)
{
	Sequence<RememberAuthentication> aModes(2);
	aModes[0] = RememberAuthentication_NO;
	aModes[1] = m_bRememberPersistent ? RememberAuthentication_PERSISTENT :
	                                    RememberAuthentication_SESSION;
	rDefault = aModes[m_bRemember ? 1 : 0];
	return aModes;
}

//============================================================================
// virtual
void SAL_CALL InteractionSupplyAuthentication_Impl::setRememberPassword(
	RememberAuthentication eTheRemember)
	throw (com::sun::star::uno::RuntimeException)
{
	LoginErrorInfo * pInfo = getInfo();
	if (pInfo)
		switch (eTheRemember)
		{
			case RememberAuthentication_NO:
				pInfo->SetSavePassword(FALSE);
				break;

			case RememberAuthentication_SESSION:
				if (!m_bRememberPersistent)
					pInfo->SetSavePassword(TRUE);
				break;

			case RememberAuthentication_PERSISTENT:
				if (m_bRememberPersistent)
					pInfo->SetSavePassword(TRUE);
				break;
		}
}

//============================================================================
// virtual
void SAL_CALL
InteractionSupplyAuthentication_Impl::setAccount(const OUString & rTheAccount)
	throw (com::sun::star::uno::RuntimeException)
{
	if (m_bCanSetAccount)
	{
		LoginErrorInfo * pInfo = getInfo();
		if (pInfo)
			pInfo->SetAccount(rTheAccount);
	}
}

//============================================================================
//
//  class InteractionCookieHandling_Impl
//
//============================================================================

// virtual
Any SAL_CALL
InteractionCookieHandling_Impl::queryInterface(
	const com::sun::star::uno::Type & rType)
	throw (com::sun::star::uno::RuntimeException)
{
	Any aRet = cppu::queryInterface(rType,
						static_cast< XInteractionContinuation * >(this),
	   					static_cast< XInteractionCookieHandling * >(this));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
// virtual
void SAL_CALL InteractionCookieHandling_Impl::setGeneralPolicy(
	CookiePolicy ePolicy)
	throw (com::sun::star::uno::RuntimeException)
{
	CntHTTPCookieRequest * pRequest = getRequest();
	if (pRequest)
		switch (ePolicy)
		{
			case CookiePolicy_CONFIRM:
				pRequest->m_nRet = CNTHTTP_COOKIE_POLICY_INTERACTIVE;
				break;

			case CookiePolicy_ACCEPT:
				pRequest->m_nRet = CNTHTTP_COOKIE_POLICY_ACCEPTED;
				break;

			case CookiePolicy_IGNORE:
				pRequest->m_nRet = CNTHTTP_COOKIE_POLICY_BANNED;
				break;
		}
}

//============================================================================
// virtual
void SAL_CALL
InteractionCookieHandling_Impl::setSpecificPolicy(
	const Cookie & rConfirmCookie, sal_Bool bAccept)
	throw (com::sun::star::uno::RuntimeException)
{
	if (rConfirmCookie.Policy == CookiePolicy_CONFIRM)
	{
		CntHTTPCookieRequest * pRequest = getRequest();
		if (pRequest)
			for (ULONG i = 0; i < pRequest->m_rCookieList.Count(); ++i)
			{
				CntHTTPCookie * pListedCookie
				 = SAL_STATIC_CAST(CntHTTPCookie *,
								   pRequest->m_rCookieList.GetObject(i));
				if (pListedCookie
					&& pListedCookie->m_aName
					    == UniString(rConfirmCookie.Name)
					&& pListedCookie->m_aValue
					    == UniString(rConfirmCookie.Value)
					&& pListedCookie->m_aDomain
					    == UniString(rConfirmCookie.Domain)
					&& pListedCookie->m_aPath
					    == UniString(rConfirmCookie.Path)
					&& pListedCookie->m_aExpires.GetDay()
					    == rConfirmCookie.Expires.Day
					&& pListedCookie->m_aExpires.GetMonth()
					    == rConfirmCookie.Expires.Month
					&& pListedCookie->m_aExpires.GetYear()
					    == rConfirmCookie.Expires.Year
					&& pListedCookie->m_aExpires.GetHour()
					    == rConfirmCookie.Expires.Hours
					&& pListedCookie->m_aExpires.GetMin()
					    == rConfirmCookie.Expires.Minutes
					&& pListedCookie->m_aExpires.GetSec()
					    == rConfirmCookie.Expires.Seconds
					&& pListedCookie->m_aExpires.Get100Sec()
					    == rConfirmCookie.Expires.HundredthSeconds
					&& ((pListedCookie->m_nFlags & CNTHTTP_COOKIE_FLAG_SECURE)
						 != 0)
					    == rConfirmCookie.Secure)
				{
					sal_Bool bEqual;
					switch (pListedCookie->m_nPolicy)
					{
						case CNTHTTP_COOKIE_POLICY_INTERACTIVE:
							bEqual = rConfirmCookie.Policy
							          == CookiePolicy_CONFIRM;
							break;

						case CNTHTTP_COOKIE_POLICY_ACCEPTED:
							bEqual = rConfirmCookie.Policy
							          == CookiePolicy_ACCEPT;
							break;

						case CNTHTTP_COOKIE_POLICY_BANNED:
							bEqual = rConfirmCookie.Policy
							          == CookiePolicy_IGNORE;
							break;

						default:
							bEqual = FALSE;
					}
					if (bEqual)
					{
						pListedCookie->m_nPolicy
						 = bAccept ? CNTHTTP_COOKIE_POLICY_ACCEPTED :
						             CNTHTTP_COOKIE_POLICY_BANNED;
						break;
					}
				}
			}
	}
}

