/*************************************************************************
 *
 *  $RCSfile: content.cxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: mhu $ $Date: 2001/09/12 11:10:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Kai Sommerfeld ( kso@sun.com )
 *
 *
 ************************************************************************/

/**************************************************************************
								TODO
 **************************************************************************

 *************************************************************************/

#include <hash_map>

#ifndef _COM_SUN_STAR_UCB_COMMANDINFOCHANGE_HPP_
#include <com/sun/star/ucb/CommandInfoChange.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_CONTENTACTION_HPP_
#include <com/sun/star/ucb/ContentAction.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_CONTENTINFOATTRIBUTE_HPP_
#include <com/sun/star/ucb/ContentInfoAttribute.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYSETINFOCHANGE_HPP_
#include <com/sun/star/beans/PropertySetInfoChange.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYSTATE_HPP_
#include <com/sun/star/beans/PropertyState.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif
#ifndef _UCBHELPER_COMMANDENVIRONMENTPROXY_HXX
#include <ucbhelper/commandenvironmentproxy.hxx>
#endif
#ifndef _UCBHELPER_CONTENTIDENTIFIER_HXX
#include <ucbhelper/contentidentifier.hxx>
#endif
#ifndef _UCBHELPER_PROPERTYVALUESET_HXX
#include <ucbhelper/propertyvalueset.hxx>
#endif
#ifndef _UCBHELPER_CANCELCOMMANDEXECUTION_HXX_
#include <ucbhelper/cancelcommandexecution.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX
#include <svtools/ctypeitm.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _SFXNRANGES_HXX
#include <svtools/nranges.hxx>
#endif
#ifndef _RTL_USTRING_H_
#include <rtl/ustring.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#include "content.hxx"

#ifndef _CNTNODE_HXX /* CntURLTransformer */
#include "cntnode.hxx"
#endif
#ifndef _CNTPOOL_HXX
#include "cntpool.hxx"
#endif
#ifndef _ILSTITEM_HXX
#include "ilstitem.hxx"
#endif
#ifndef _TASKS_HXX
#include "tasks.hxx"
#endif
#ifndef _CONTINFO_HXX
#include "continfo.hxx"
#endif
#ifndef _PROVIDER_HXX
#include "provider.hxx"
#endif
#ifndef _DYNRSET_HXX
#include "dynrset.hxx"
#endif
#ifndef _CSTRITEM_HXX
#include "cstritem.hxx"
#endif
#ifndef CHAOS_TASKBASE_HXX
#include "taskbase.hxx"
#endif

using namespace com::sun::star::container;
using namespace com::sun::star::beans;
using namespace com::sun::star::lang;
using namespace com::sun::star::task;
using namespace com::sun::star::ucb;
using namespace com::sun::star::uno;
using namespace cppu;
using namespace rtl;
using namespace vos;
using namespace chaos;

//=========================================================================

//  The mutex to synchronize access to containers.
static osl::Mutex& getContainerMutex()
{
	static osl::Mutex* pMutex = NULL;
	if( !pMutex )
	{
		osl::Guard< osl::Mutex > aGuard( osl::Mutex::getGlobalMutex() );
		if( !pMutex )
		{
			static osl::Mutex aMutex;
			pMutex = &aMutex;
		}
	}

	return *pMutex;
}

//=========================================================================
//
// class PropertyEventSequence_Impl.
//
//=========================================================================

class PropertyEventSequence_Impl
{
	Sequence< PropertyChangeEvent > m_aSeq;
	sal_uInt32                      m_nPos;

public:
	PropertyEventSequence_Impl( sal_uInt32 nSize )
	: m_aSeq( nSize ), m_nPos( 0 ) {};

	void append( const PropertyChangeEvent& rEvt )
	{ m_aSeq.getArray()[ m_nPos ] = rEvt; ++m_nPos; }

	const Sequence< PropertyChangeEvent >& getEvents()
	{ m_aSeq.realloc( m_nPos ); return m_aSeq; }
};

//=========================================================================
//
// PropertiesEventListenerMap_Impl.
//
//=========================================================================

typedef void* XPropertiesChangeListenerPtr; // -> Compiler problems!

struct equalPtr_Impl
{
	bool operator()( const XPropertiesChangeListenerPtr& rp1,
					 const XPropertiesChangeListenerPtr& rp2 ) const
	{
		return ( rp1 == rp2 );
	}
};

struct hashPtr_Impl
{
	size_t operator()( const XPropertiesChangeListenerPtr& rp ) const
	{
		return (size_t)rp;
	}
};

typedef std::hash_map
<
	XPropertiesChangeListenerPtr,
	PropertyEventSequence_Impl*,
	hashPtr_Impl,
	equalPtr_Impl
>
PropertiesEventListenerMap_Impl;

//=========================================================================
//
// PropertyChangeListenerContainer_Impl.
//
//=========================================================================

struct equalStr_Impl
{
	bool operator()( const OUString& s1, const OUString& s2 ) const
  	{
		return !!( s1 == s2 );
	}
};

struct hashStr_Impl
{
	size_t operator()( const OUString& rName ) const
	{
		return rName.hashCode();
	}
};

typedef OMultiTypeInterfaceContainerHelperVar
<
	OUString,
	hashStr_Impl,
	equalStr_Impl
> PropertyChangeListenerContainer_Impl;

//=========================================================================
//
// class PropertyChangeListeners_Impl
//
//=========================================================================

namespace chaos {

class PropertyChangeListeners_Impl : public PropertyChangeListenerContainer_Impl
{
public:
	PropertyChangeListeners_Impl()
	: PropertyChangeListenerContainer_Impl( getContainerMutex() ) {}
};

}

//=========================================================================
//
// TaskMap_Impl.
//
//=========================================================================

struct TaskMapEntry
{
    vos::ORef< ContentTask > xTask;
    bool                     bInAbort;

    TaskMapEntry()
    : xTask( 0 ), bInAbort( false ) {}

    TaskMapEntry( const vos::ORef< ContentTask > & rxTask )
    : xTask( rxTask ), bInAbort( false ) {}
};

struct equalLong_Impl
{
	bool operator()( const sal_Int32& rn1, const sal_Int32& rn2 ) const
	{
		return ( rn1 == rn2 );
	}
};

struct hashLong_Impl
{
	size_t operator()( const sal_Int32& rn ) const
	{
		return (size_t)rn;
	}
};

typedef std::hash_map
<
	sal_Int32,
    TaskMapEntry,
	hashLong_Impl,
	equalLong_Impl
>
TaskMap_Impl;

//=========================================================================
//
// class Tasks_Impl.
//
//=========================================================================

namespace chaos {

// This is here to get a working forward declaration in content.hxx!
class Tasks_Impl : public TaskMap_Impl
{
};

}

//=========================================================================
//=========================================================================
//
// ChaosContent Implementation.
//
//=========================================================================
//=========================================================================

ChaosContent::ChaosContent(	const Reference< XMultiServiceFactory >& rxSMgr,
							ChaosContentProvider* pProvider,
							const Reference< XContentIdentifier >& Identifier,
							ChaosContent* pParent /* = NULL */,
							CntAnchor* pAnchor /* = NULL */ )
:   m_xSMgr( rxSMgr ),
	m_pParent( pParent ),
	m_pPropSetInfo( NULL ),
  	m_pCommandsInfo( NULL ),
  	m_pProvider( pProvider ),
	m_pDisposeEventListeners( NULL ),
  	m_pContentEventListeners( NULL ),
	m_pPropSetChangeListeners( NULL ),
	m_pCommandChangeListeners( NULL ),
  	m_pPropertyChangeListeners( NULL ),
	m_pTasks( NULL ),
	m_nCommandId( 0 ),
	m_bHasViewData( sal_False )
{
	m_pProvider->acquire();

	CntAnchorRef xAnchor;
	if ( pAnchor )
	{
		xAnchor = pAnchor;
	}
	else
	{
		// Try to create a CHAOS object for given URL.
		xAnchor = new CntAnchor( NULL, Identifier->getContentIdentifier() );
	}

	if ( !xAnchor->GetError() )
	{
		m_xIdentifier = Identifier;
		m_xAnchor 	  = xAnchor;

		const String aViewURL( m_xAnchor->GetViewURL( TRUE ) );
		m_bHasViewData = ( aViewURL.Len() > 0 );

		// The anchor must broadcast a hint for every inserted child.
		// Generally he would filter children by applying rules, checking
		// whether the same child was notified before, and so on. This
		// behaviour is okay for StarOffice Desktop, but we must get all
		// information unfiltered.
		m_xAnchor->SetNotifyAll( TRUE );

		StartListening( *m_xAnchor );

		m_pProvider->addContent( this );
	}
}

//=========================================================================
// virtual
ChaosContent::~ChaosContent()
{
	if ( m_xAnchor.Is() )
	{
		m_pProvider->removeContent( this );
		EndListening( *m_xAnchor );
	}

	if ( m_pPropSetInfo )
		m_pPropSetInfo->release();

	if ( m_pCommandsInfo )
		m_pCommandsInfo->release();

	delete m_pDisposeEventListeners;
	delete m_pContentEventListeners;
	delete m_pPropSetChangeListeners;
	delete m_pCommandChangeListeners;
	delete m_pPropertyChangeListeners;

	delete m_pTasks;

	m_pProvider->release();
}

//=========================================================================
//
// XInterface methods.
//
//=========================================================================

XINTERFACE_COMMON_IMPL( ChaosContent );

//============================================================================
// virtual
Any SAL_CALL
ChaosContent::queryInterface( const com::sun::star::uno::Type & rType )
	throw ( RuntimeException )
{
	Any aRet = cppu::queryInterface( rType,
				static_cast< XTypeProvider * >( this ),
				static_cast< XServiceInfo * >( this ),
				static_cast< XComponent * >( this ),
				static_cast< XContent * >( this ),
				static_cast< XContentCreator * >( this ),
				static_cast< XCommandProcessor * >( this ),
				static_cast< XPropertiesChangeNotifier * >( this ),
				static_cast< XCommandInfoChangeNotifier * >( this ),
				static_cast< XPropertyContainer * >( this ),
				static_cast< XPropertySetInfoChangeNotifier * >( this ),
				static_cast< XChild * >( this ) );

	return aRet.hasValue() ? aRet : OWeakObject::queryInterface( rType );
}

//=========================================================================
//
// XTypeProvider methods.
//
//=========================================================================

XTYPEPROVIDER_COMMON_IMPL( ChaosContent );

//=========================================================================
// virtual
Sequence< Type > SAL_CALL ChaosContent::getTypes()
	throw( RuntimeException )
{
	static OTypeCollection* pCollection = NULL;

	if ( !pCollection )
	{
		osl::Guard< osl::Mutex > aGuard( osl::Mutex::getGlobalMutex() );
	  	if ( !pCollection )
	  	{
            static OTypeCollection aCollection(
                CPPU_TYPE_REF( XTypeProvider ),
                CPPU_TYPE_REF( XServiceInfo ),
                CPPU_TYPE_REF( XComponent ),
                CPPU_TYPE_REF( XContent ),
                CPPU_TYPE_REF( XContentCreator ),
                CPPU_TYPE_REF( XCommandProcessor ),
                CPPU_TYPE_REF( XPropertiesChangeNotifier ),
                CPPU_TYPE_REF( XCommandInfoChangeNotifier ),
                CPPU_TYPE_REF( XPropertyContainer ),
                CPPU_TYPE_REF( XPropertySetInfoChangeNotifier ),
                CPPU_TYPE_REF( XChild ) );
            pCollection = &aCollection;
		}
	}

	return (*pCollection).getTypes();
}

//=========================================================================
//
// XServiceInfo methods.
//
//=========================================================================

XSERVICEINFO_NOFACTORY_IMPL_1( ChaosContent,
					 		   OUString::createFromAscii(
									"com.sun.star.comp.chaos.ChaosContent" ),
		 					   OUString::createFromAscii(
									CONTENT_SERVICE_NAME ) );

//=========================================================================
//
// XComponent methods.
//
//=========================================================================

// virtual
void SAL_CALL ChaosContent::dispose()
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_pDisposeEventListeners && m_pDisposeEventListeners->getLength() )
	{
		EventObject aEvt;
		aEvt.Source = static_cast< XComponent * >( this );
		m_pDisposeEventListeners->disposeAndClear( aEvt );
	}

	if ( m_pContentEventListeners && m_pContentEventListeners->getLength() )
	{
		EventObject aEvt;
		aEvt.Source = static_cast< XContent * >( this );
		m_pContentEventListeners->disposeAndClear( aEvt );
	}

	if ( m_pPropSetChangeListeners && m_pPropSetChangeListeners->getLength() )
	{
		EventObject aEvt;
		aEvt.Source = static_cast< XPropertySetInfoChangeNotifier * >( this );
		m_pPropSetChangeListeners->disposeAndClear( aEvt );
	}

	if ( m_pCommandChangeListeners && m_pCommandChangeListeners->getLength() )
	{
		EventObject aEvt;
		aEvt.Source = static_cast< XCommandInfoChangeNotifier * >( this );
		m_pCommandChangeListeners->disposeAndClear( aEvt );
	}

	if ( m_pPropertyChangeListeners )
	{
		EventObject aEvt;
		aEvt.Source = static_cast< XPropertiesChangeNotifier * >( this );
		m_pPropertyChangeListeners->disposeAndClear( aEvt );
	}
}

//=========================================================================
// virtual
void SAL_CALL ChaosContent::addEventListener(
							const Reference< XEventListener >& Listener )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_pDisposeEventListeners )
		m_pDisposeEventListeners =
					new OInterfaceContainerHelper( getContainerMutex() );

	m_pDisposeEventListeners->addInterface( Listener );
}

//=========================================================================
// virtual
void SAL_CALL ChaosContent::removeEventListener(
							const Reference< XEventListener >& Listener )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_pDisposeEventListeners )
		m_pDisposeEventListeners->removeInterface( Listener );
}

//=========================================================================
//
// XContent methods.
//
//=========================================================================

// virtual
Reference< XContentIdentifier > SAL_CALL ChaosContent::getIdentifier()
	throw( RuntimeException )
{
	return m_xIdentifier;
}

//=========================================================================
// virtual
OUString SAL_CALL ChaosContent::getContentType()
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_xAnchor.Is() )
		return OUString();

	UniString aType(
		ITEMSET_VALUE( m_xAnchor, CntContentTypeItem, WID_CONTENT_TYPE ) );

	// Transform internal ".chaos" type prefix to official vendor scheme.
	xub_StrLen nPos = aType.SearchAndReplace(
			UniString::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM( CHAOS_TYPE_PREFIX ) ),
			UniString::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM( APP_VENDOR_TYPE_PREFIX ) ) );

	if ( nPos == STRING_NOTFOUND )
	{
		// content type string contains any non ".chaos" type, which
		// is illegal for UCB content type. We can only try to obtain the
		// original ".chaos" type from the anchors CntDefaults object...

		const SfxItemSet* pDefs = &m_xAnchor;
		while ( pDefs->SfxItemSet::GetParent() )
			pDefs = pDefs->SfxItemSet::GetParent();

		aType = ITEMSET_VALUE( pDefs, CntContentTypeItem, WID_CONTENT_TYPE );

		// Transform internal ".chaos" type prefix to official vendor scheme.
		aType.SearchAndReplace(
				UniString::CreateFromAscii(
					RTL_CONSTASCII_STRINGPARAM( CHAOS_TYPE_PREFIX ) ),
				UniString::CreateFromAscii(
					RTL_CONSTASCII_STRINGPARAM( APP_VENDOR_TYPE_PREFIX ) ) );
	}

	return OUString( aType );
}

//=========================================================================
// virtual
void SAL_CALL ChaosContent::addContentEventListener(
						const Reference< XContentEventListener >& Listener )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_pContentEventListeners )
		m_pContentEventListeners =
					new OInterfaceContainerHelper( getContainerMutex() );

	m_pContentEventListeners->addInterface( Listener );
}

//=========================================================================
// virtual
void SAL_CALL ChaosContent::removeContentEventListener(
						const Reference< XContentEventListener >& Listener )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_pContentEventListeners )
		m_pContentEventListeners->removeInterface( Listener );
}

//=========================================================================
//
// XContentCreator methods.
//
//=========================================================================

// virtual
Sequence< ContentInfo > SAL_CALL ChaosContent::queryCreatableContentsInfo()
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_xAnchor.Is() )
	{
		DBG_ERROR( "ChaosContent::queryCreatableContentsInfo!" );
		return Sequence< ContentInfo >();
	}

	if ( m_xAnchor->GetItemState( WID_CREATE_NEW, TRUE ) <= SFX_ITEM_DISABLED )
		return Sequence< ContentInfo >();

	const CntItemListItem& rListItem =
				(const CntItemListItem&)m_xAnchor->Get( WID_CREATE_NEW );

	USHORT nCount = rListItem.Count();
	if ( !nCount )
		return Sequence< ContentInfo >();

	Sequence< ContentInfo > aSeq( nCount );

	for( USHORT n = 0; n < nCount; ++n )
	{
		ContentInfo& rInfo = aSeq.getArray()[ n ];

		const CntItemListItem& rCurr = (const CntItemListItem&)rListItem[ n ];

		const INetContentType eType = (const INetContentType)
				ITEM_VALUE( CntUInt16Item, *rCurr.Get( WID_FACTORY_NO ) );
		UniString aType( INetContentTypes::GetContentType ( eType ) );

		// Transform internal ".chaos" type prefix to official vendor scheme.
		aType.SearchAndReplace(
			UniString::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM( CHAOS_TYPE_PREFIX ) ),
			UniString::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM( APP_VENDOR_TYPE_PREFIX ) ) );

		rInfo.Type = aType;

		sal_Int16 nFlags
			= ITEM_VALUE( CntUInt16Item, *rCurr.Get( WID_CREATION_FLAGS ) );

		if ( nFlags & CNT_CREATION_FLAG_TITLE )
		{
			Sequence< Property > aProps( 1 );
			aProps.getArray()[ 0 ] = Property(
										OUString::createFromAscii( "Title" ),
										WID_TITLE,
										getCppuType(
											static_cast<
												const rtl::OUString * >( 0 ) ),
										PropertyAttribute::BOUND
										| PropertyAttribute::MAYBEVOID
										| PropertyAttribute::MAYBEDEFAULT );
			rInfo.Properties = aProps;
		}

		rInfo.Attributes = 0;

		if ( nFlags & CNT_CREATION_FLAG_INSERT_WITH_STREAM )
			rInfo.Attributes |= ContentInfoAttribute::INSERT_WITH_INPUTSTREAM;

		if ( nFlags & CNT_CREATION_FLAG_KIND_DOCUMENT )
			rInfo.Attributes |= ContentInfoAttribute::KIND_DOCUMENT;

		if ( nFlags & CNT_CREATION_FLAG_KIND_FOLDER )
			rInfo.Attributes |= ContentInfoAttribute::KIND_FOLDER;

		if ( nFlags & CNT_CREATION_FLAG_KIND_LINK )
			rInfo.Attributes |= ContentInfoAttribute::KIND_LINK;
	}

	return aSeq;
}

//=========================================================================
// virtual
Reference< XContent > SAL_CALL ChaosContent::createNewContent(
												const ContentInfo& Info )
throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_xAnchor.Is() )
	{
		DBG_ERROR( "ChaosContent::createNewContent - not initialized!" );
		return Reference< XContent >();
	}

	if ( !Info.Type.getLength() )
		return Reference< XContent >();

	// Get WID_CREATE_NEW item corresponding to Info.Type...

	const CntItemListItem* pItem = NULL;
	const CntItemListItem& rListItem =
				(const CntItemListItem&)m_xAnchor->Get( WID_CREATE_NEW );

	// Transform official vendor scheme prefix to internal ".chaos" type.
	UniString aType( Info.Type );
	aType.SearchAndReplace(
			UniString::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM( APP_VENDOR_TYPE_PREFIX ) ),
			UniString::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM( CHAOS_TYPE_PREFIX ) ) );

	INetContentType eType = INetContentTypes::GetContentType( aType );

	USHORT nCount = rListItem.Count();
	for( USHORT n = 0; n < nCount; ++n )
	{
		const CntItemListItem& rCurr = (const CntItemListItem&)rListItem[ n ];

		INetContentType eCurrType = (INetContentType)
				ITEM_VALUE( CntUInt16Item, *rCurr.Get( WID_FACTORY_NO ) );

		if ( eCurrType == eType )
		{
			// Gotcha!
			pItem = &rCurr;
			break;
		}

		pItem = NULL;
	}

	if ( !pItem )
		return Reference< XContent >();

	CntAnchorItem* pResult = (CntAnchorItem*)m_xAnchor->Put( *pItem );
	if ( !pResult )
		return Reference< XContent >();

	CntAnchorRef xAnchor( pResult->GetValue() );

	delete pResult;

	if ( !xAnchor.Is() || xAnchor->GetError() )
		return Reference< XContent >();

	return m_pProvider->queryContent( NULL, xAnchor );
}

//=========================================================================
//
// XCommandProcessor methods.
//
//=========================================================================

// virtual
sal_Int32 SAL_CALL ChaosContent::createCommandIdentifier()
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	// Just increase counter on every call to generate an identifier.
	return ++m_nCommandId;
}

//=========================================================================
// virtual
Any SAL_CALL ChaosContent::execute( const Command& aCommand,
			 						sal_Int32 CommandId,
			 						const Reference<
										XCommandEnvironment >& Environment )
	throw( Exception, CommandAbortedException, RuntimeException )
{
	// Note: Method must be reentrent. Do not use a guard to protect the
	//       whole method body!!!

	if ( !m_xAnchor.Is() )
	{
		DBG_ERROR( "ChaosContent::execute - not initialized!" );
		return Any();
	}

	if ( CommandId == 0 )
	{
		// No id given, create one for internal purposes.
		CommandId = createCommandIdentifier();
	}
	else
	{
		vos::OGuard aGuard( m_aMutex );

		// Check command identifier.
		if ( m_pTasks )
		{
			const Tasks_Impl::const_iterator it = m_pTasks->find( CommandId );
			if ( it != m_pTasks->end() )
			{
				DBG_ERROR( "ChaosContent::execute - duplicate command id!" );
				return Any();
			}
		}
	}

	Any aRet;
	vos::ORef< ContentTask > xTask;
    ChaosPropertyTask* pGetPropValuesTask = 0;
    ChaosPropertyTask* pSetPropValuesTask = 0;

	if ( aCommand.Name.compareToAscii( "getPropertyValues" ) == 0 )
	{
		//////////////////////////////////////////////////////////////////
		// getPropertyValues
		//////////////////////////////////////////////////////////////////

		Sequence< Property > Properties;
		if ( !( aCommand.Argument >>= Properties ) )
		{
            ucbhelper::cancelCommandExecution(
                makeAny( IllegalArgumentException(
                                    rtl::OUString::createFromAscii(
                                        "Wrong argument type!" ),
                                    static_cast< cppu::OWeakObject * >( this ),
                                    -1 ) ),
                Environment );
            // Unreachable
        }

		// Note: GET + empty sequence means "get all property values".

		// Create Property-Get-Task.

		pGetPropValuesTask = new ChaosPropertyTask(
								m_xSMgr,
								this,
                                new ucb::CommandEnvironmentProxy( Environment ),
								Properties );
		xTask = pGetPropValuesTask;
	}
	else if ( aCommand.Name.compareToAscii( "setPropertyValues" ) == 0 )
	{
		//////////////////////////////////////////////////////////////////
		// setPropertyValues
		//////////////////////////////////////////////////////////////////

		Sequence< PropertyValue > Properties;
		if ( !( aCommand.Argument >>= Properties ) )
		{
            ucbhelper::cancelCommandExecution(
                makeAny( IllegalArgumentException(
                                    rtl::OUString::createFromAscii(
                                        "Wrong argument type!" ),
                                    static_cast< cppu::OWeakObject * >( this ),
                                    -1 ) ),
                Environment );
            // Unreachable
		}

		if ( !Properties.getLength() )
		{
            ucbhelper::cancelCommandExecution(
                makeAny( IllegalArgumentException(
                                    rtl::OUString::createFromAscii(
                                        "No properties!" ),
                                    static_cast< cppu::OWeakObject * >( this ),
                                    -1 ) ),
                Environment );
            // Unreachable
		}

		// Create Property-Set-Task

        pSetPropValuesTask = new ChaosPropertyTask(
                                m_xSMgr,
								this,
                                new ucb::CommandEnvironmentProxy( Environment ),
								PropertyTaskType_SET,
								Properties );
        xTask = pSetPropValuesTask;
	}
	else if ( aCommand.Name.compareToAscii( "getPropertySetInfo" ) == 0 )
	{
		//////////////////////////////////////////////////////////////////
		// getPropertySetInfo
		//////////////////////////////////////////////////////////////////

		aRet <<= getPropertySetInfo();
	}
	else if ( aCommand.Name.compareToAscii( "getCommandInfo" ) == 0 )
	{
		//////////////////////////////////////////////////////////////////
		// getCommandInfo
		//////////////////////////////////////////////////////////////////

		aRet <<= getCommandInfo();
	}
	else if ( ( ( aCommand.Handle == WID_OPEN ) ||
	            ( aCommand.Name.compareToAscii( "open" ) == 0 ) ) &&
			  ITEMSET_VALUE( m_xAnchor, CntBoolItem, WID_FLAG_IS_FOLDER ) )
	{
		//////////////////////////////////////////////////////////////////
		// open command for a folder content
		//////////////////////////////////////////////////////////////////

		Reference< XDynamicResultSet > xSet
				= new DynamicResultSet(
							m_xSMgr,
							this,
							aCommand,
                            new ucb::CommandEnvironmentProxy( Environment ) );
		aRet <<= xSet;
	}
	else if ( ( aCommand.Handle == WID_SEARCH ) ||
			  ( aCommand.Name.compareToAscii( "search" ) == 0 ) )
	{
		//////////////////////////////////////////////////////////////////
		// search command
		//////////////////////////////////////////////////////////////////

		Reference< XDynamicResultSet > xSet
				= new DynamicResultSet(
							m_xSMgr,
							this,
							aCommand,
                            new ucb::CommandEnvironmentProxy( Environment ) );
		aRet <<= xSet;
	}
	else
	{
		//////////////////////////////////////////////////////////////////
		// any other command
		//////////////////////////////////////////////////////////////////

		// Check the command...
		if ( !aCommand.Name.getLength() && ( aCommand.Handle == -1 ) )
		{
            ucbhelper::cancelCommandExecution(
                makeAny( UnsupportedCommandException(
                                rtl::OUString(),
                                static_cast< cppu::OWeakObject * >( this ) ) ),
                Environment );
            // Unreachable
		}

		// create Command-Task

		xTask = new ChaosCommandTask(
							m_xSMgr,
							this,
							aCommand,
                            new ucb::CommandEnvironmentProxy( Environment ) );
	}

	if ( xTask.isValid() )
	{
		// Insert task into task list
		{
			vos::OGuard aGuard( m_aMutex );

			if ( !m_pTasks )
				m_pTasks = new Tasks_Impl;

            (*m_pTasks)[ CommandId ] = TaskMapEntry( xTask );
		}

		try
		{
			// Execute task synchronously!!!
			xTask->execute();
		}
		catch ( Exception& )
		{
			// Remove task from task list
			{
				vos::OGuard aGuard( m_aMutex );

				Tasks_Impl::iterator it = m_pTasks->find( CommandId );

				DBG_ASSERT( it != m_pTasks->end(),
							"ChaosContent::execute - task not found!" );

				m_pTasks->erase( it );
			}

			throw;
		}

		DBG_ASSERT( ( xTask->getStatus() == ContentTaskStatus_ABORTED ) ||
					( xTask->getStatus() == ContentTaskStatus_DONE ),
					"ChaosContent::execute - task not finished!" );

        // Was ChaosContent::abort called for this task?
        bool bInAbort = false;

		// Remove task from task list
		{
			vos::OGuard aGuard( m_aMutex );

			Tasks_Impl::iterator it = m_pTasks->find( CommandId );

            if ( it != m_pTasks->end() )
                bInAbort = (*it).second.bInAbort;

			m_pTasks->erase( it );
		}

        if ( xTask->getStatus() == ContentTaskStatus_ABORTED )
        {
            if ( bInAbort )
            {
                throw CommandAbortedException(
                    rtl::OUString::createFromAscii(
                        "Task was aborted via XCommandProcessor::abort!" ),
                    static_cast< cppu::OWeakObject * >( this ) );
            }
            else
            {
				Any aAny (makeAny(
					PropertyValue(
						OUString(RTL_CONSTASCII_USTRINGPARAM("Uri")),
						-1,
						makeAny(m_xIdentifier->getContentIdentifier()),
						PropertyState_DIRECT_VALUE)));

                ucbhelper::cancelCommandExecution(
                    IOErrorCode_ABORT,
                    Sequence< Any >(&aAny, 1),
                    Environment,
                    rtl::OUString::createFromAscii(
                        "Task was aborted - no details available!" ),
                    this );
                // Unreachable
            }
        }

		// Get task result and put it into aRet.

		if ( pGetPropValuesTask )
		{
		    const Sequence< PropertyValueInfo > aProps
				= pGetPropValuesTask->getProperties();
			sal_Int32 nCount = aProps.getLength();

			if ( nCount )
			{
				Sequence< PropertyValue > aValues( nCount );

				const PropertyValueInfo* pProps = aProps.getConstArray();
				PropertyValue* pValues = aValues.getArray();

				for ( sal_Int32 n = 0; n < nCount; ++n )
					pValues[ n ] = pProps[ n ];

				aRet <<= Reference< com::sun::star::sdbc::XRow >(
							new ::ucb::PropertyValueSet( m_xSMgr, aValues ) );
			}
			else
				aRet <<= Reference< com::sun::star::sdbc::XRow >(
								new ::ucb::PropertyValueSet( m_xSMgr ) );
		}
        else if ( pSetPropValuesTask )
		{
		    const Sequence< PropertyValueInfo > aProps
                = pSetPropValuesTask->getProperties();
			sal_Int32 nCount = aProps.getLength();

            Sequence< Any > aExceptions( nCount );
			if ( nCount )
			{
				const PropertyValueInfo* pProps = aProps.getConstArray();
                Any* pExceptions = aExceptions.getArray();

				for ( sal_Int32 n = 0; n < nCount; ++n )
                {
                    switch ( pProps[ n ].ValueState )
                    {
                        case PropertyValueState_PROCESSED:
                            // Okay. No error.
                            break;

                        case PropertyValueState_UNPROCESSED:
                            pExceptions[ n ] <<= Exception(
                                rtl::OUString::createFromAscii(
                                    "Error setting property value!" ),
                                static_cast< cppu::OWeakObject * >( this ) );
                            break;

                        case PropertyValueState_INVALID_NAME:
                            pExceptions[ n ] <<= UnknownPropertyException(
                                rtl::OUString(),
                                static_cast< cppu::OWeakObject * >( this ) );
                            break;

                        case PropertyValueState_INVALID_TYPE:
                            pExceptions[ n ] <<= IllegalTypeException(
                                rtl::OUString::createFromAscii(
                                        "Property value has wrong type!" ),
                                static_cast< cppu::OWeakObject * >( this ) );
                            break;

                        default:
                            DBG_ERROR( "ChaosContent::execute - "
                                       "Unknown property value state!" );
                            pExceptions[ n ] <<= Exception(
                                rtl::OUString::createFromAscii(
                                    "Unknown property value state!" ),
                                static_cast< cppu::OWeakObject * >( this ) );
                            break;
                    }
                }
			}

            aRet <<= aExceptions;
		}

	}

	return aRet;
}

//=========================================================================
// virtual
void SAL_CALL ChaosContent::abort( sal_Int32 CommandId )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_pTasks )
	{
		// Find task with given id.
        const Tasks_Impl::iterator it = m_pTasks->find( CommandId );
		if ( it != m_pTasks->end() )
		{
			// Abort task. It will be removed from task list in
			// ChaosContent::execute(...).
            (*it).second.bInAbort = true;
            (*it).second.xTask->abort();
		}
	}
}

//=========================================================================
//
// XPropertiesChangeNotifier methods.
//
//=========================================================================

// virtual
void SAL_CALL ChaosContent::addPropertiesChangeListener(
					const Sequence< OUString >& PropertyNames,
					const Reference< XPropertiesChangeListener >& Listener )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_pPropertyChangeListeners )
		m_pPropertyChangeListeners = new PropertyChangeListeners_Impl();

	sal_Int32 nCount = PropertyNames.getLength();
	if ( !nCount )
	{
		// Note: An empty sequence means a listener for "all" properties.
		m_pPropertyChangeListeners->addInterface( OUString(), Listener );
	}
	else
	{
		const OUString* pSeq = PropertyNames.getConstArray();

		for ( sal_Int32 n = 0; n < nCount; ++n )
		{
			const OUString& rName = pSeq[ n ];
			if ( rName.getLength() )
				m_pPropertyChangeListeners->addInterface( rName, Listener );
		}
	}
}

//=========================================================================
// virtual
void SAL_CALL ChaosContent::removePropertiesChangeListener(
					const Sequence< OUString >& PropertyNames,
					const Reference< XPropertiesChangeListener >& Listener )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_pPropertyChangeListeners )
		return;

	sal_Int32 nCount = PropertyNames.getLength();
	if ( !nCount )
	{
		// Note: An empty sequence means a listener for "all" properties.
		m_pPropertyChangeListeners->removeInterface( OUString(), Listener );
	}
	else
	{
		const OUString* pSeq = PropertyNames.getConstArray();

		for ( sal_Int32 n = 0; n < nCount; ++n )
		{
			const OUString& rName = pSeq[ n ];
			if ( rName.getLength() )
				m_pPropertyChangeListeners->removeInterface( rName, Listener );
		}
	}
}

//=========================================================================
//
// XCommandInfoChangeNotifier methods.
//
//=========================================================================

// virtual
void SAL_CALL ChaosContent::addCommandInfoChangeListener(
					const Reference< XCommandInfoChangeListener >& Listener )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_pCommandChangeListeners )
		m_pCommandChangeListeners =
					new OInterfaceContainerHelper( getContainerMutex() );

	m_pCommandChangeListeners->addInterface( Listener );
}

//=========================================================================
// virtual
void SAL_CALL ChaosContent::removeCommandInfoChangeListener(
					const Reference< XCommandInfoChangeListener >& Listener )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_pCommandChangeListeners )
		m_pCommandChangeListeners->removeInterface( Listener );
}

//=========================================================================
//
// XPropertyContainer methods.
//
//=========================================================================

// virtual
void SAL_CALL ChaosContent::addProperty(
		const OUString& Name, sal_Int16 Attributes, const Any& DefaultValue )
	throw( PropertyExistException,
		   IllegalTypeException,
		   IllegalArgumentException,
		   RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	//////////////////////////////////////////////////////////////////////
	// Make sure a property with the requested name does not already
	// exist in dynamic and static(!) properties.
	//////////////////////////////////////////////////////////////////////

	if ( getPropertySetInfo()->hasPropertyByName( Name ) )
	{
		// Property does already exist.
		throw PropertyExistException();
	}

	//////////////////////////////////////////////////////////////////////
	// Add a new dynamic property.
	//////////////////////////////////////////////////////////////////////

	// Open/create persistent property set.
    Reference< XPersistentPropertySet > xSet(
									getDynamicPropertySet( sal_True ) );

	DBG_ASSERT( xSet.is(), "ChaosContent::addProperty - No property set!" );

	if ( xSet.is() )
	{
		Reference< XPropertyContainer > xContainer( xSet, UNO_QUERY );

		DBG_ASSERT( xContainer.is(),
					"ChaosContent::addProperty - No property container!" );

		if ( xContainer.is() )
		{
			// Property is always removeable.
			Attributes |= PropertyAttribute::REMOVEABLE;

			try
			{
				xContainer->addProperty( Name, Attributes, DefaultValue );
			}
			catch ( PropertyExistException& e )
			{
				DBG_ERROR( "ChaosContent::addProperty - Exists!" );
				throw e;
			}
			catch ( IllegalTypeException& e )
			{
				DBG_ERROR( "ChaosContent::addProperty - Wrong Type!" );
				throw e;
			}
			catch ( IllegalArgumentException& e )
			{
				DBG_ERROR( "ChaosContent::addProperty - Illegal Arg!" );
				throw e;
			}

			// Success!

			if ( m_pPropSetInfo )
			{
				// Info cached in propertyset info is invalid now!
				m_pPropSetInfo->resetUcbPropertyInfo();
			}

			// Notify propertyset info change listeners.
			if ( m_pPropSetChangeListeners &&
				 m_pPropSetChangeListeners->getLength() )
			{
				PropertySetInfoChangeEvent evt(
							static_cast< OWeakObject * >( this ),
							Name,
							-1, /* No handle available */
							PropertySetInfoChange::PROPERTY_INSERTED );
				notifyPropertySetInfoChange( evt );
			}
		}
	}
}

//=========================================================================
// virtual
void SAL_CALL ChaosContent::removeProperty( const OUString& Name )
	throw( UnknownPropertyException,
		   NotRemoveableException,
		   RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	try
	{
		Property aProp = getPropertySetInfo()->getPropertyByName( Name );

		if ( !( aProp.Attributes & PropertyAttribute::REMOVEABLE ) )
		{
			// Not removeable!
			throw NotRemoveableException();
		}
	}
	catch ( UnknownPropertyException& e )
	{
		DBG_ERROR( "ChaosContent::removeProperty - Unknown!" );
		throw e;
	}

	//////////////////////////////////////////////////////////////////////
	// Try to remove property from dynamic property set.
	//////////////////////////////////////////////////////////////////////

	// Open persistent property set, if exists.
    Reference< XPersistentPropertySet > xSet(
									getDynamicPropertySet( sal_False ) );
	if ( xSet.is() )
	{
		Reference< XPropertyContainer > xContainer( xSet, UNO_QUERY );

		DBG_ASSERT( xContainer.is(),
					"ChaosContent::removeProperty - No property container!" );

		if ( xContainer.is() )
		{
			try
			{
				xContainer->removeProperty( Name );
			}
			catch ( UnknownPropertyException& e )
			{
				DBG_ERROR( "ChaosContent::removeProperty - Unknown!" );
				throw e;
			}
			catch ( NotRemoveableException& e )
			{
				DBG_ERROR( "ChaosContent::removeProperty - Unremoveable!" );
				throw e;
			}

			xContainer = 0;

			// Success!

			if ( xSet->getPropertySetInfo()->getProperties().getLength() == 0 )
			{
				// Remove empty propertyset from registry.
    			Reference< XPropertySetRegistry > xReg = xSet->getRegistry();
				if ( xReg.is() )
				{
					OUString aKey( xSet->getKey() );
					xSet = 0;
					xReg->removePropertySet( aKey );
				}
			}

			if ( m_pPropSetInfo )
			{
				// Info cached in propertyset info is invalid now!
				m_pPropSetInfo->resetUcbPropertyInfo();
			}

			// Notify propertyset info change listeners.
			if ( m_pPropSetChangeListeners &&
				 m_pPropSetChangeListeners->getLength() )
			{
				PropertySetInfoChangeEvent evt(
							static_cast< OWeakObject * >( this ),
							Name,
							-1, /* No handle available */
							PropertySetInfoChange::PROPERTY_REMOVED );
				notifyPropertySetInfoChange( evt );
			}
		}
	}
}

//=========================================================================
//
// XPropertySetInfoChangeNotifier methods.
//
//=========================================================================

// virtual
void SAL_CALL ChaosContent::addPropertySetInfoChangeListener(
				const Reference< XPropertySetInfoChangeListener >& Listener )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_pPropSetChangeListeners )
		m_pPropSetChangeListeners =
					new OInterfaceContainerHelper( getContainerMutex() );

	m_pPropSetChangeListeners->addInterface( Listener );
}

//=========================================================================
// virtual
void SAL_CALL ChaosContent::removePropertySetInfoChangeListener(
				const Reference< XPropertySetInfoChangeListener >& Listener )
	throw( RuntimeException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_pPropSetChangeListeners )
		m_pPropSetChangeListeners->removeInterface( Listener );
}

//=========================================================================
//
// XChild methods.
//
//=========================================================================

// virtual
Reference< XInterface > SAL_CALL ChaosContent::getParent()
	throw( RuntimeException )
{
	if ( !m_xAnchor.Is() )
	{
		DBG_ERROR( "ChaosContent::getParent - not initialized!" );
		return Reference< XInterface >();
	}

	const UniString aParentURL( m_xAnchor->GetParentViewURL( FALSE ) );
	if ( !aParentURL.Len() )
		return Reference< XInterface >();

	CntAnchorRef xParentAnchor( new CntAnchor( 0, aParentURL ) );
	if ( xParentAnchor->GetError() )
		return Reference< XInterface >();

	return m_pProvider->queryContent( this, xParentAnchor );
}

//=========================================================================
// virtual
void SAL_CALL ChaosContent::setParent( const Reference< XInterface >& Parent )
	throw( NoSupportException, RuntimeException )
{
	throw NoSupportException();
}

//=========================================================================
//
// SfxListener methods.
//
//=========================================================================

// virtual
void ChaosContent::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	//////////////////////////////////////////////////////////////////////
	// SfxItemChangedHint handling.
	//////////////////////////////////////////////////////////////////////

	if ( rHint.ISA( SfxItemChangedHint ) )
	{
		const SfxItemChangedHint* pItemHint = (const SfxItemChangedHint*)&rHint;
		USHORT nWhich = pItemHint->GetOldItem().Which();
		if ( nWhich == WID_OWN_URL )
		{
			const String& rOldValue =
					ITEM_VALUE( CntStringItem, pItemHint->GetOldItem() );
			if ( rOldValue.Len() )
			{
				// Anchor changed it's identity...
				exchange();
			}
		}

		if ( !m_pPropertyChangeListeners )
			return;

		const CntItemMapEntry* pEntry = CNT_ITEMMAP()->Which2Prop( nWhich );
		if ( pEntry && pEntry->IsProperty() )
		{
			//////////////////////////////////////////////////////////////
			// From PropertyChangeEvent.idl:
			//
			// A "PropertyChange" event gets delivered whenever a "bound"
			// or "constrained" property is changed.
			//////////////////////////////////////////////////////////////

			if ( ( pEntry->nAttributes & PropertyAttribute::BOUND ) ||
				 ( pEntry->nAttributes & PropertyAttribute::CONSTRAINED ) )
			{
				OUString  aName( OUString::createFromAscii( pEntry->pName ) );
				sal_Int16 nHandle = nWhich;

				// Special handling for content type <-> media type.
				if ( nWhich == WID_CONTENT_TYPE )
				{
					UniString aNewType( ITEM_VALUE( CntContentTypeItem,
													pItemHint->GetNewItem() ) );
					UniString aPrefix(
							UniString::CreateFromAscii( CHAOS_TYPE_PREFIX ) );
					if ( aNewType.CompareTo( aPrefix, aPrefix.Len() ) !=
																COMPARE_EQUAL )
					{
						// Propagate "MediaType" change.
						aName   = OUString::createFromAscii( "MediaType" );
						nHandle = -1;
					}
				}

				// Fill Event Object.
				PropertyChangeEvent aEvt;

				if ( !pItemHint->GetOldItem().QueryValue( aEvt.OldValue ) )
				{
					DBG_ERROR( "ChaosContent::Notify - Not QueryValue!" );
					return;
				}

				if ( !pItemHint->GetNewItem().QueryValue( aEvt.NewValue ) )
				{
					DBG_ERROR( "ChaosContent::Notify - Not QueryValue!" );
					return;
				}

				aEvt.Source   		= static_cast< OWeakObject * >( this );
				aEvt.PropertyName   = aName;
				aEvt.PropertyHandle = nHandle;

				// Soll lt. MM true sein, wenn nach diesem Event noch
				// weitere folgen. Aber woher soll ich das wissen? FALSE
				// geht aber immer - kann hoechstens Performance-Einbussen
				// bringen.
				aEvt.Further = sal_False;

				ChaosContent::translatePropertyValue( aEvt.PropertyName,
													  aEvt.OldValue,
													  TRANSLATE_TO_EXTERNAL );
				ChaosContent::translatePropertyValue( aEvt.PropertyName,
													  aEvt.NewValue,
													  TRANSLATE_TO_EXTERNAL );
				// Propagate change to listeners.
				notifyPropertyChange( aEvt );
			}
		}
	}

	//////////////////////////////////////////////////////////////////////
	// CntAnchorHint handling.
	//////////////////////////////////////////////////////////////////////

    else if ( rHint.ISA( CntAnchorHint ) )
    {
		Reference< XContent > xRelatedContent( this );
		Reference< XContentIdentifier > xRelatedId( m_xIdentifier );

        const CntAnchorHint* pAnchorHint = (const CntAnchorHint*)&rHint;
		const CntAction eAction = pAnchorHint->GetAction();
		switch ( eAction )
		{
			case CNT_ACTION_INSERTED:
			{
				if ( !m_pContentEventListeners ||
				     !m_pContentEventListeners->getLength() )
					return;

				// Check, whether the notifying CHAOS-job is a WID_OPEN or
				// WID_SEARCH.  Ignore event in that case, because results of
				// those jobs will be propagated by the related UCB-Command-
				// Task.
				// ATTENTION!  This is wrong if WID_FLAG_UPDATE_ON_OPEN is
				// true.  In that case, both WID_OPEN and WID_SEARCH can
				// notify 'old' as well as 'new' contents via CNT_ACTION_
				// INSERTED, but only the 'new' contents should be notified
				// further via ContentAction::INSERTED.

				CntNodeJob* pJob = pAnchorHint->GetJob();
				DBG_ASSERT( pJob, "ChaosContent::Notify - No job!" );
				if ( pJob && ( pJob->GetRequest()->Which() == WID_OPEN ||
							   pJob->GetRequest()->Which() == WID_SEARCH ) )
					return;

				// Note: This content will be notified to listeners.
				xRelatedContent = m_pProvider->queryContent(
											this, pAnchorHint->GetAnchor() );
				break;
			}

			case CNT_ACTION_REMOVED:
			{
				acquire();

				if ( m_pParent )
					m_pParent->acquire();

				CntAnchor* pAnchor = pAnchorHint->GetAnchor();
				if ( pAnchor->GetViewURL() == m_xAnchor->GetViewURL() )
				{
					// Note: REMOVED events from CHAOS are broadcasted by
					// the element to remove. But we want the parent to be
					// the notifier!

					// Inform content event listeners of parent.
					if ( m_pParent )
						m_pParent->notifyContentEvent(
									eAction, this, m_pParent->m_xIdentifier );
				}
				else
				{
					// Notify content event listeners.
					if ( m_pParent )
						notifyContentEvent(
									eAction, this, m_pParent->m_xIdentifier );
				}

				// Notify all listeners and release references on them.
				dispose();

				if ( m_pParent )
					m_pParent->release();

				release();
				return;
			}

			case CNT_ACTION_DELETED:
			{
				acquire();

				// Inform content event listeners.
				notifyContentEvent( eAction, this, m_xIdentifier );

				// Additionally, let parent notify a REMOVED event.
				if ( m_pParent )
				{
					m_pParent->acquire();
					m_pParent->notifyContentEvent( ContentAction::REMOVED,
												   this,
												   m_pParent->m_xIdentifier );
				}

				// Notify all listeners and release references on them.
				dispose();

				if ( m_pParent )
					m_pParent->release();

				release();
				return;
			}

			case CNT_ACTION_EXCHANGED:
				// Anchor changed it's identity...
				exchange();
				break;

			default:
				break;
		}

		// Notify content event listeners.
		notifyContentEvent( eAction, xRelatedContent, xRelatedId );
		return;
	}

	//////////////////////////////////////////////////////////////////////
	// CntItemStateChangedHint handling.
	//////////////////////////////////////////////////////////////////////

	else if ( rHint.ISA( CntItemStateChangedHint ) )
	{
		const CntItemStateChangedHint* pHint =
								(const CntItemStateChangedHint*)&rHint;
		CntItemStateAction eAction = pHint->GetAction();
		switch ( eAction )
		{
			case CNT_ITEM_CLEARED:  // item now available
			case CNT_ITEM_DISABLED: // item no longer available
			{
				// Listeners present?
				sal_Bool bHasPropSetChangeListeners =
								( m_pPropSetChangeListeners &&
					  			m_pPropSetChangeListeners->getLength() );
				sal_Bool bHasCommandChangeListeners =
								( m_pCommandChangeListeners &&
					  			m_pCommandChangeListeners->getLength() );
				if ( bHasPropSetChangeListeners || bHasCommandChangeListeners )
				{
					const CntItemMapEntry* pEntry =
							CNT_ITEMMAP()->Which2Prop( pHint->GetWhich() );
					if ( pEntry && isHandleValid( pEntry->nWhich ) )
					{
						if ( pEntry->IsProperty() )
						{
							// Property.

							PropertySetInfoChangeEvent aEvt(
								static_cast< OWeakObject * >( this ),
								OUString::createFromAscii( pEntry->pName ),
								pEntry->nWhich,
								eAction == CNT_ITEM_CLEARED
									? PropertySetInfoChange::PROPERTY_INSERTED
									: PropertySetInfoChange::PROPERTY_REMOVED );

							notifyPropertySetInfoChange( aEvt );
						}
						else
						{
							// Command.

							CommandInfoChangeEvent aEvt(
								static_cast< OWeakObject * >( this ),
								OUString::createFromAscii( pEntry->pName ),
								pEntry->nWhich,
								eAction == CNT_ITEM_CLEARED
									? CommandInfoChange::COMMAND_INSERTED
									: CommandInfoChange::COMMAND_REMOVED );

							notifyCommandInfoChange( aEvt );
						}
					}
				}
				break;
			}

			default:
				break;
		}
	}
}

//=========================================================================
//
// New methods.
//
//=========================================================================

sal_Bool ChaosContent::isHandleValid( sal_uInt16 nHandle ) const
{
	if ( m_xAnchor.Is() )
	{
		SfxItemState eState = m_xAnchor->GetItemState( nHandle );
		if ( eState > SFX_ITEM_DISABLED )
		{
			SfxUShortRanges aRanges( m_xAnchor->REAL_RANGES() );
			if ( aRanges.Contains( nHandle ) )
			{
#if 1
				// Filter View Properties.

				// Check for special id's.
				switch ( nHandle )
				{
					case WID_TITLE:
						// Is always available, though it is a view prop.
						return sal_True;

					default:
						break;
				}

				if ( m_xAnchor->IsItemFlag(	nHandle, CNT_ITEM_AUTO_VIEWPROP ) )
				{
					if ( m_bHasViewData )
						return sal_True;
				}
				else
					return sal_True;
#else
				return sal_True;
#endif
			}
		}
	}
	return sal_False;
}

//=========================================================================
void ChaosContent::notifyPropertyChange( const PropertyChangeEvent& evt ) const
{
	if ( !m_pPropertyChangeListeners )
		return;

	Sequence< PropertyChangeEvent > aSeq( 1 );
	aSeq.getArray()[ 0 ] = evt;
	notifyPropertiesChange( aSeq );
}

//=========================================================================
void ChaosContent::notifyPropertiesChange(
						const Sequence< PropertyChangeEvent >& evt ) const
{
	if ( !m_pPropertyChangeListeners )
		return;

	sal_Int32 nCount = evt.getLength();
	if ( nCount )
	{
		// First, notify listeners interested in changes of every property.
		OInterfaceContainerHelper* pAllPropsContainer =
					m_pPropertyChangeListeners->getContainer( OUString() );
		if ( pAllPropsContainer )
		{
			OInterfaceIteratorHelper aIter( *pAllPropsContainer );
			while ( aIter.hasMoreElements() )
			{
				// Propagate event.
				Reference< XPropertiesChangeListener > xListener(
												aIter.next(), UNO_QUERY );
				if ( xListener.is() )
					xListener->propertiesChange( evt );
			}
		}

		PropertiesEventListenerMap_Impl aListeners;

		const PropertyChangeEvent* pEvents = evt.getConstArray();

		for ( sal_Int32 n = 0; n < nCount; ++n )
		{
			const PropertyChangeEvent& rEvent = pEvents[ n ];
			const OUString& rName = rEvent.PropertyName;

			OInterfaceContainerHelper* pPropsContainer =
							m_pPropertyChangeListeners->getContainer( rName );
			if ( pPropsContainer )
			{
				OInterfaceIteratorHelper aIter( *pPropsContainer );
				while ( aIter.hasMoreElements() )
				{
					PropertyEventSequence_Impl* pEvents = NULL;

					XPropertiesChangeListener* pListener =
						static_cast< XPropertiesChangeListener * >(
															aIter.next() );
					PropertiesEventListenerMap_Impl::iterator it =
							aListeners.find( pListener );
					if ( it == aListeners.end() )
					{
						// Not in map - create and insert new entry.
						pEvents = new PropertyEventSequence_Impl( nCount );
						aListeners[ pListener ] = pEvents;
					}
					else
						pEvents = (*it).second;

					if ( pEvents )
						pEvents->append( rEvent );
				}
			}
		}

		// Notify listeners.
		PropertiesEventListenerMap_Impl::iterator it = aListeners.begin();
		while ( !aListeners.empty() )
		{
			XPropertiesChangeListener* pListener =
					static_cast< XPropertiesChangeListener * >( (*it).first );
			PropertyEventSequence_Impl* pSeq = (*it).second;

			// Remove current element.
			aListeners.erase( it );

			// Propagate event.
			pListener->propertiesChange( pSeq->getEvents() );

			delete pSeq;

			it = aListeners.begin();
		}
	}
}

//=========================================================================
void ChaosContent::notifyContentEvent(
			const Reference< com::sun::star::uno::XInterface >& rSource,
			const long nAction,
			const Reference< XContent >& rContent,
			const Reference< XContentIdentifier >& rId )
{
	if ( !m_pContentEventListeners )
		return;

	// Fill Content Event Object.
	ContentEvent aEvent( rSource, nAction, rContent, rId );

	// Notify event listeners.
	OInterfaceIteratorHelper aIter( *m_pContentEventListeners );
	while ( aIter.hasMoreElements() )
	{
		// Propagate event.
		Reference< XContentEventListener > xListener( aIter.next(), UNO_QUERY );
		if ( xListener.is() )
			xListener->contentEvent( aEvent );
	}
}

//=========================================================================
void ChaosContent::notifyPropertySetInfoChange(
								const PropertySetInfoChangeEvent& evt ) const
{
	if ( !m_pPropSetChangeListeners )
		return;

	// Notify event listeners.
	OInterfaceIteratorHelper aIter( *m_pPropSetChangeListeners );
	while ( aIter.hasMoreElements() )
	{
		// Propagate event.
		Reference< XPropertySetInfoChangeListener >
							xListener( aIter.next(), UNO_QUERY );
		if ( xListener.is() )
			xListener->propertySetInfoChange( evt );
	}
}

//=========================================================================
void ChaosContent::notifyCommandInfoChange(
								const CommandInfoChangeEvent& evt ) const
{
	if ( !m_pCommandChangeListeners )
		return;

	// Notify event listeners.
	OInterfaceIteratorHelper aIter( *m_pCommandChangeListeners );
	while ( aIter.hasMoreElements() )
	{
		// Propagate event.
		Reference< XCommandInfoChangeListener >
							xListener( aIter.next(), UNO_QUERY );
		if ( xListener.is() )
			xListener->commandInfoChange( evt );
	}
}

//=========================================================================
// static
sal_Int32 ChaosContent::queryChaosPropertyHandle( const OUString& rName )
{
	if ( rName.compareToAscii( "MediaType" ) == 0 )
	{
		return WID_CONTENT_TYPE;
	}
	else if ( rName.compareToAscii( "CHAOS-PresentationURL" ) == 0 )
	{
		return WID_REAL_URL;
	}
	else if ( rName.compareToAscii( "CHAOS-TargetURL" ) == 0 )
	{
		return WID_TARGET_URL;
	}
	else
	{
		// Try to get handle using property name.
		const CntItemMapEntry* pEntry = CNT_ITEMMAP()->Prop2Which( rName );
		if ( pEntry )
			return pEntry->nWhich;
	}

	return -1;
}

//=========================================================================
// static
sal_Bool ChaosContent::translatePropertyValue( const OUString& rName,
										  	   Any& rValue,
											   TranslationDirection eDirection )
{
	if ( ( rName.compareToAscii( "PresentationURL" ) == 0 ) ||
	     ( rName.compareToAscii( "TargetURL" ) == 0 ) )
	{
		// Translate URL contained in property value...

		OUString aOldValue;
		if ( !( rValue >>= aOldValue ) )
			return sal_False;

		String aURL( aOldValue );

		switch ( eDirection )
		{
			case TRANSLATE_TO_EXTERNAL:
				CntURLTransformer::ToExternalURL( aURL );
				break;

			case TRANSLATE_TO_INTERNAL:
				CntURLTransformer::ToInternalURL( aURL );
				break;

			default:
				DBG_ERROR(
					"ChaosContent::translatePropertyValue - unknown mode! " );
				return sal_False;
		}

		rValue <<= OUString( aURL );
	}
	else if ( rName.compareToAscii( "ContentType" ) == 0 )
	{
		// Translate ".chaos" content types...

		OUString aOrigType;
		if ( !( rValue >>= aOrigType ) )
			return sal_False;

		UniString aType( aOrigType );

		switch ( eDirection )
		{
			case TRANSLATE_TO_EXTERNAL:
			{
				// Transform internal ".chaos" type prefix to official
				// vendor scheme.
				xub_StrLen nPos = aType.SearchAndReplace(
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM(
								CHAOS_TYPE_PREFIX ) ),
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM(
								APP_VENDOR_TYPE_PREFIX ) ) );

				if ( nPos == STRING_NOTFOUND )
				{
					// chaos content type never contains a media type.
					aType.Erase();
				}

				break;
			}

			case TRANSLATE_TO_INTERNAL:
				// Transform official vendor scheme prefix to internal
				// ".chaos" type.
				aType.SearchAndReplace(
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM(
								APP_VENDOR_TYPE_PREFIX ) ),
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM(
								CHAOS_TYPE_PREFIX ) ) );
				break;

			default:
				DBG_ERROR(
					"ChaosContent::translatePropertyValue - unknown mode! " );
				return sal_False;
		}

		rValue <<= OUString( aType );
	}
	else if ( rName.compareToAscii( "MediaType" ) == 0 )
	{
		// Translate ".chaos" content types...

		OUString aOrigType;
		if ( !( rValue >>= aOrigType ) )
			return sal_False;

		UniString aType( aOrigType );

		switch ( eDirection )
		{
			case TRANSLATE_TO_EXTERNAL:
			{
				// Transform internal ".chaos" type prefix to official
				// vendor scheme.
				xub_StrLen nPos = aType.SearchAndReplace(
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM(
								CHAOS_TYPE_PREFIX ) ),
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM(
								APP_VENDOR_TYPE_PREFIX ) ) );
				if ( nPos != STRING_NOTFOUND )
				{
					// media type never contains a chaos content type.
					aType.Erase();
				}
				break;
			}

			case TRANSLATE_TO_INTERNAL:
				// Transform official vendor scheme prefix to internal
				// ".chaos" type.
				aType.SearchAndReplace(
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM(
								APP_VENDOR_TYPE_PREFIX ) ),
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM(
								CHAOS_TYPE_PREFIX ) ) );
				break;

			default:
				DBG_ERROR(
					"ChaosContent::translatePropertyValue - unknown mode! " );
				return sal_False;
		}

		rValue <<= OUString( aType );
	}

	return sal_True;
}

//=========================================================================
void ChaosContent::exchange()
{
	vos::OGuard aGuard( m_pProvider->getMutex() );

	// Reinsert content at content provider and adapt own identifier to
	// changed URL of the anchor.

	// Note: m_xIdentifier does contain old id, but m_xAnchor already
	//       has the new one.

	String aNormalizedURL = m_xIdentifier->getContentIdentifier();
	NormalizeURL( aNormalizedURL );
	OUString aURL = OUString( aNormalizedURL );
	m_pProvider->removeContent( aURL );

	m_xIdentifier =	new ucb::ContentIdentifier(
								m_xSMgr, m_xAnchor->GetViewURL( FALSE ) );
	m_pProvider->addContent( this );
}

//=========================================================================
Reference< XPersistentPropertySet >
ChaosContent::getDynamicPropertySet( sal_Bool bCreate )
{
	// Get propertyset registry from provider.
	Reference< XPropertySetRegistry > xReg(
								m_pProvider->getPropertySetRegistry() );

	DBG_ASSERT( xReg.is(),
				"ChaosContent::getDynamicPropertySet - No regsitry!" );

	if ( xReg.is() )
	{
		// Open/create persistent property set.
	    Reference< XPersistentPropertySet > xSet(
							xReg->openPropertySet(
								m_xAnchor->GetViewURL( FALSE ), bCreate ) );
		return xSet;
	}

	return Reference< XPersistentPropertySet >();
}

//=========================================================================
Reference< XPropertySetInfo > ChaosContent::getPropertySetInfo()
{
	if ( !m_xAnchor.Is() )
	{
		DBG_ERROR( "ChaosContent::getPropertySetInfo - not initialized!" );
		return Reference< XPropertySetInfo >();
	}

	if ( !m_pPropSetInfo )
	{
		m_pPropSetInfo =
			new ChaosPropertySetInfo( m_xSMgr, m_pProvider, m_xAnchor );
		m_pPropSetInfo->acquire();
	}

	return Reference< XPropertySetInfo >( m_pPropSetInfo );
}

//=========================================================================
Reference< XCommandInfo > ChaosContent::getCommandInfo()
{
	if ( !m_xAnchor.Is() )
	{
		DBG_ERROR( "ChaosContent::getCommandsInfo - not initialized!" );
		return Reference< XCommandInfo >();
	}

	if ( !m_pCommandsInfo )
	{
		m_pCommandsInfo = new ChaosCommandInfo( m_xSMgr, m_xAnchor );
		m_pCommandsInfo->acquire();
	}

	return Reference< XCommandInfo >( m_pCommandsInfo );
}

