/*************************************************************************
 *
 *  $RCSfile: test.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: kr $ $Date: 2000/12/14 12:33:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include<stdio.h>

#ifdef UNX
#include <unistd.h>
#endif

#include <jni.h>

#include <uno/environment.h>
#include <uno/dispatcher.h>
#include <uno/mapping.hxx>

#include <com/sun/star/uno/Reference.hxx>

#include <cppuhelper/servicefactory.hxx>

#include <com/sun/star/java/XJavaMapper.hpp>
#include <com/sun/star/java/XJavaThreadRegister_11.hpp>
#include <com/sun/star/java/XJavaVM.hpp>

using namespace ::com::sun::star::java;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;

using namespace ::cppu;

using namespace ::rtl;


extern "C" jint my_vfprintf(FILE *fp, const char *format, va_list args)
{
	return vfprintf(stderr, format, args);
}

char * props[] = {"java.compiler=NONE", NULL};

int SAL_CALL main(int argc, char * argv[]) {
	if(argc != 2) {
		printf("usage: %s <my rdb file>\n", argv[0]);
		printf("needed native services: >com.sun.star.java.JavaVirtualMachine\n");
	}
	else
		try {
			// create a service mananger
			fprintf(stderr, "creating service manager on file: %s\n", argv[1]);
			OUString rdbFile = OUString::createFromAscii(argv[1]);
			Reference<XMultiServiceFactory> smgr = createRegistryServiceFactory(rdbFile);


			// get a java vm service
			printf("instantiating java vm service....");
			Reference<XInterface> javaVM = smgr->createInstance(OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.java.JavaVirtualMachine")));
			if(!javaVM.is()) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get instance of jvm service")), Reference<XInterface>());

			Reference<XJavaVM>    javaVM_xJavaVM(javaVM, UNO_QUERY);
			if(!javaVM_xJavaVM.is()) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get XJavaVM interface from vm service")), Reference<XInterface>());

			printf("ok\n");
			
			// get a java vm
			Sequence<sal_Int8> processID(16);
			rtl_getGlobalProcessId(reinterpret_cast<sal_uInt8 *>(processID.getArray()));

			JavaVM * pJavaVM = NULL;
			if(javaVM_xJavaVM->getJavaVM(processID).hasValue())
				pJavaVM = *(JavaVM **)(javaVM_xJavaVM->getJavaVM(processID).getValue());
			if(!pJavaVM) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get vm from vm service")), Reference<XInterface>());



			// attach this thread to the java vm
			Reference<XJavaThreadRegister_11> xJavaThreadRegister_11 = Reference<XJavaThreadRegister_11>(javaVM, UNO_QUERY);
			if(xJavaThreadRegister_11.is())
				xJavaThreadRegister_11->registerThread();

			JNIEnv * pJNIEnv = NULL;
			pJavaVM->AttachCurrentThread((void **)&pJNIEnv, (void *)NULL);



			// get a java_curr and a curr_java mapping
			printf("getting java_curr and curr_java mapping...\n");
			OUString sJava(RTL_CONSTASCII_USTRINGPARAM("java"));

			sal_Int32 size = 0;
			uno_Environment ** ppJava_environments = NULL;

			uno_getRegisteredEnvironments(&ppJava_environments, &size, (uno_memAlloc)malloc, sJava.pData);
			if(!size) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't find any java environment")), Reference<XInterface>());

			// why is there no convinient contructor?
			uno_Environment * pCurr_environment = NULL;
			OUString sCppu_current_lb_name(RTL_CONSTASCII_USTRINGPARAM(CPPU_CURRENT_LANGUAGE_BINDING_NAME));
			uno_getEnvironment(&pCurr_environment, sCppu_current_lb_name.pData, NULL);
			if(!pCurr_environment) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't find environment for this language")), Reference<XInterface>());
			
			Mapping java_curr(ppJava_environments[0], pCurr_environment);
			if(!java_curr.is()) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get java_curr mapping")), Reference<XInterface>());

			Mapping curr_java(pCurr_environment, ppJava_environments[0]);
			if(!java_curr.is()) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get curr_java mapping")), Reference<XInterface>());

			// release all java environments
			for(sal_Int32 i = 0; i < size; ++ i)
				ppJava_environments[i]->release(ppJava_environments[i]);
			size = 0;
			free(ppJava_environments);
		
			// release uno environment
			pCurr_environment->release(pCurr_environment);
			pCurr_environment = NULL;
			
		
			// test the curr_java mapping
			{
				printf("creating native object...\n");
				Reference<XInterface> xInterface = smgr->createInstance(OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.java.JavaVirtualMachine")));
				if(!xInterface.is()) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get native object")), Reference<XInterface>());
		

				printf("mapping object from native to java...\n");
				typelib_InterfaceTypeDescription * pXConnector_Type = 0;
				getCppuType((Reference<XInterface> *) 0).getDescription((typelib_TypeDescription **) & pXConnector_Type);
				jobject joConnector_cpp = (jobject)curr_java.mapInterface(xInterface.get(), getCppuType((Reference<XInterface> *) 0));
		
				printf("object is mapped, now call >hashCode< on it...\n");
		
		
				jclass jcObject = pJNIEnv->FindClass("java/lang/Object");
				jmethodID jmObject_hashCode = pJNIEnv->GetMethodID(jcObject, "hashCode", "()I");
				jint jiHash = pJNIEnv->CallIntMethod(joConnector_cpp, jmObject_hashCode);
		
				printf("hash value of jni object is: hash:%i p:%p\n", jiHash, joConnector_cpp);
			}

		
			// test the java_curr mapping
			{
				printf("creating java object...\n");
				typelib_InterfaceTypeDescription * pType = 0;
				getCppuType((Reference<XJavaMapper> *) 0).getDescription((typelib_TypeDescription **) & pType);

				jclass jcConnector = pJNIEnv->FindClass("com/sun/star/comp/connections/Connector");
				jobject joConnector = pJNIEnv->AllocObject(jcConnector);
		
				printf("mapping object from java to native...\n");
				XInterface * xConnector = (XInterface *)java_curr.mapInterface(joConnector, pType);
		
				printf("object is mapped, now call on it...\n", xConnector);
				xConnector->queryInterface(getCppuType((Reference<XJavaMapper> *)0));
				printf("... ok\n", xConnector);
			}

			// detach from java vm
			if(xJavaThreadRegister_11.is()) {
				xJavaThreadRegister_11->revokeThread();
			
				if(!xJavaThreadRegister_11->isThreadAttached())
					pJavaVM->DetachCurrentThread();
			}
			else
				pJavaVM->DetachCurrentThread();
		
			pJNIEnv = NULL;

		}
		catch(Exception & exception) {
			OString message = OUStringToOString(exception.Message, RTL_TEXTENCODING_ASCII_US);
			fprintf(stderr, "test - an exception occurred: %s\n", message.getStr());
		}

	return 0;
}
