/*************************************************************************
 *
 *  $RCSfile: java_uno_mapping.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: dbo $ $Date: 2001/10/26 07:22:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <bridges/java/jvmcontext.hxx>


#include <string.h>

#include <osl/diagnose.h>
#include <osl/interlck.h>

#include <rtl/ustring>
#include <rtl/process.h>

#include <uno/mapping.hxx>
#include <uno/lbnames.h>

#ifdef LINUX
#undef minor
#undef major
#endif

#include <com/sun/star/uno/Reference.hxx>

#include <com/sun/star/connection/XConnection.hpp>

#include <com/sun/star/java/XJavaMapper.hpp>
#include <com/sun/star/java/XJavaVM.hpp>
#include <com/sun/star/java/XJavaThreadRegister_11.hpp>

#include <bridges/remote/context.h>
#include <bridges/remote/remote.h>

#include "nativeThreadPool.hxx"
#include "connectionWrapper.hxx"
#include "java_uno_mapping.hxx"

using namespace ::com::sun::star::java;
using namespace ::com::sun::star::uno;
using namespace ::rtl;

namespace java {
	// This is an implementation of a java to uno bridge (and vice versa).
	// This bridge uses a java- and a uno-remote bridge to do the mapping.
	// These bridges communicate over a java pipe connection.

	const static RuntimeException javaException(OUString(RTL_CONSTASCII_USTRINGPARAM("unexpected java exception")), Reference<XInterface>());
			


	void test_java_exception(JNIEnv * pJNIEnv) throw(RuntimeException) {
		if(pJNIEnv && pJNIEnv->ExceptionOccurred()) {

			jthrowable jtException = pJNIEnv->ExceptionOccurred();
			pJNIEnv->ExceptionClear();
			jclass jcThrowable = pJNIEnv->FindClass("java/lang/Throwable"); if(pJNIEnv->ExceptionOccurred()) throw javaException;
			jmethodID jmThrowable_getMessage = pJNIEnv->GetMethodID(jcThrowable, "toString", "()Ljava/lang/String;"); if(pJNIEnv->ExceptionOccurred()) throw javaException;
			jstring jsMessage = (jstring)pJNIEnv->CallObjectMethod(jtException, jmThrowable_getMessage); if(pJNIEnv->ExceptionOccurred()) throw javaException;
					
			const char * pcMessage = pJNIEnv->GetStringUTFChars(jsMessage, NULL);
			OUString message = OUString::createFromAscii(pcMessage);
			pJNIEnv->ReleaseStringUTFChars(jsMessage, pcMessage);

			throw RuntimeException(message, Reference<XInterface>());
		}
	}
	
	// We create a remote bridge on java side and wrap the connection to be a remote_Connection.
	// The endpoint of the connection on this side is our way to communicate with java.
	static remote_Connection * init_java_side(JavaVMContext * pVMContext, const char * pServiceName) throw (RuntimeException) { // do java stuff
		// attach the current thread, if needed
		sal_Bool attached = sal_False;

		if(!pVMContext->isThreadAttached()) {
			attached = sal_True;
			pVMContext->registerThread();
		}

		JNIEnv * pJNIEnv;
		pVMContext->_pJavaVM->AttachCurrentThread((void **)&pJNIEnv, (void *)NULL);


		java_uno_mapping_initNativeThreadPool(pJNIEnv, pVMContext);

		remote_Connection * pRemote_Connection = NULL;

		try {
			// we need to register the need services
			static const char * neededServices[] = {
				"com.sun.star.comp.bridgefactory.BridgeFactory",
				"com.sun.star.comp.connections.PipedConnection",
				"com.sun.star.comp.connections.ConstantInstanceProvider",
				"com.sun.star.comp.bridge.JavaMapper"
			};

			jclass jcString = pJNIEnv->FindClass("java/lang/String");                                                        if(pJNIEnv->ExceptionOccurred()) throw javaException;
			jobjectArray jaNeededServices = pJNIEnv->NewObjectArray(sizeof(neededServices) / sizeof(char *), jcString, NULL);if(pJNIEnv->ExceptionOccurred()) throw javaException;
			for(int i = 0; i < sizeof(neededServices) / sizeof(char *); ++ i) {
				pJNIEnv->SetObjectArrayElement(jaNeededServices, i, pJNIEnv->NewStringUTF(neededServices[i]));               if(pJNIEnv->ExceptionOccurred()) throw javaException;
			}


			jclass jcJavaMapper = pJNIEnv->FindClass("com/sun/star/comp/bridge/JavaMapper");                 if(pJNIEnv->ExceptionOccurred()) throw javaException;
			jmethodID jmJavaMapper_createSimpleServiceManager = pJNIEnv->GetStaticMethodID(
				jcJavaMapper, 
				"createSimpleServiceManager", 
				"([Ljava/lang/String;)Lcom/sun/star/lang/XMultiServiceFactory;");					     if(pJNIEnv->ExceptionOccurred()) throw javaException;
			

			jobject joServiceManager = pJNIEnv->CallStaticObjectMethod(jcJavaMapper, 
																	   jmJavaMapper_createSimpleServiceManager,
																	   jaNeededServices);



			jclass jcXMultiServiceFactory = pJNIEnv->FindClass("com/sun/star/lang/XMultiServiceFactory");                 if(pJNIEnv->ExceptionOccurred()) throw javaException;
			jmethodID jmXMultiServiceFactory_createInstanceWithArguments = pJNIEnv->GetMethodID(jcXMultiServiceFactory, 
																						  "createInstanceWithArguments", 
																						  "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;"); if(pJNIEnv->ExceptionOccurred()) throw javaException;
			// create an instance of our special inprocess connection
			jmethodID jmXMultiServiceFactory_createInstance = pJNIEnv->GetMethodID(jcXMultiServiceFactory, 
																			 "createInstance", 
																			 "(Ljava/lang/String;)Ljava/lang/Object;");      if(pJNIEnv->ExceptionOccurred()) throw javaException;

			jstring jsConnectionName = pJNIEnv->NewStringUTF("com.sun.star.connection.PipedConnection");					 if(pJNIEnv->ExceptionOccurred()) throw javaException;
			jobject joConnection_nativeSide = pJNIEnv->CallObjectMethod(joServiceManager, 
																		jmXMultiServiceFactory_createInstance, 
																		jsConnectionName);                                   if(pJNIEnv->ExceptionOccurred()) throw javaException;

			jclass jcObject = pJNIEnv->FindClass("java/lang/Object");														 if(pJNIEnv->ExceptionOccurred()) throw javaException;
			jobjectArray jaArgs = pJNIEnv->NewObjectArray(1, jcObject, joConnection_nativeSide);							   
			jobject joConnection_javaSide = pJNIEnv->CallObjectMethod(joServiceManager, 
																	  jmXMultiServiceFactory_createInstanceWithArguments, 
																	  jsConnectionName, jaArgs);							 if(pJNIEnv->ExceptionOccurred()) throw javaException;

			// create an constant service provider with java servicemanager
			jstring jsInstanceProvider = pJNIEnv->NewStringUTF("com.sun.star.comp.connection.InstanceProvider");			 if(pJNIEnv->ExceptionOccurred()) throw javaException;
			jobject joInstanceProvider = pJNIEnv->CallObjectMethod(joServiceManager, 
																   jmXMultiServiceFactory_createInstance, 
																   jsInstanceProvider);										 if(pJNIEnv->ExceptionOccurred()) throw javaException;
		  
			jclass jcInstanceProvider = pJNIEnv->FindClass("com/sun/star/comp/connections/ConstantInstanceProvider");        if(pJNIEnv->ExceptionOccurred()) throw javaException;
			jmethodID jmInstanceProvider_setInstance = pJNIEnv->GetMethodID(jcInstanceProvider, "setInstance", "(Ljava/lang/String;)V");
			if(pJNIEnv->ExceptionOccurred()) throw javaException;

			jstring jsServiceName = pJNIEnv->NewStringUTF(pServiceName);			                                         if(pJNIEnv->ExceptionOccurred()) throw javaException;
			pJNIEnv->CallVoidMethod(joInstanceProvider, jmInstanceProvider_setInstance, jsServiceName);                      if(pJNIEnv->ExceptionOccurred()) throw javaException;


  			jclass jcXBridgeFactory = pJNIEnv->FindClass("com/sun/star/bridge/XBridgeFactory");                              if(pJNIEnv->ExceptionOccurred()) throw javaException;
			jmethodID jmXBridgeFactory_createBridge = pJNIEnv->GetMethodID(jcXBridgeFactory, 
																		   "createBridge", 
																		   "(Ljava/lang/String;Ljava/lang/String;Lcom/sun/star/connection/XConnection;Lcom/sun/star/bridge/XInstanceProvider;)Lcom/sun/star/bridge/XBridge;");
			if(pJNIEnv->ExceptionOccurred()) throw javaException;

  			jstring jsBridgeComponent = pJNIEnv->NewStringUTF("com.sun.star.bridge.BridgeFactory");                          if(pJNIEnv->ExceptionOccurred()) throw javaException;
			jobject joBridgeFactory = pJNIEnv->CallObjectMethod(joServiceManager, 
																jmXMultiServiceFactory_createInstance, jsBridgeComponent);	 if(pJNIEnv->ExceptionOccurred()) throw javaException;


			jclass jcUnoRumtime = pJNIEnv->FindClass("com/sun/star/uno/UnoRuntime");                                         if(pJNIEnv->ExceptionOccurred()) throw javaException;
			jmethodID jmUnoRuntime_queryInterface = pJNIEnv->GetStaticMethodID(
				jcUnoRumtime, 
				"queryInterface", 
				"(Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/Object;");                                                  if(pJNIEnv->ExceptionOccurred()) throw javaException;

			jobject joBridgeFactory_XBridgeFactory = pJNIEnv->CallStaticObjectMethod(jcUnoRumtime, 
																					 jmUnoRuntime_queryInterface, 
																					 jcXBridgeFactory, 
																					 joBridgeFactory);                       if(pJNIEnv->ExceptionOccurred()) throw javaException;


			jstring jsBridgeName = pJNIEnv->NewStringUTF("the native bridge");	                                             if(pJNIEnv->ExceptionOccurred()) throw javaException;
			jstring jsProtocol = pJNIEnv->NewStringUTF("urp,Negotiate=0,ForceSynchronous=1");	                             if(pJNIEnv->ExceptionOccurred()) throw javaException;

			jobject joBridge = pJNIEnv->CallObjectMethod(joBridgeFactory_XBridgeFactory,
														 jmXBridgeFactory_createBridge,
														 jsBridgeName,
														 jsProtocol,
														 joConnection_javaSide,
														 joInstanceProvider);			                                     if(pJNIEnv->ExceptionOccurred()) throw javaException;

			pRemote_Connection = reinterpret_cast<remote_Connection *>(new ConnectionWrapper(pVMContext, joConnection_nativeSide));
		}
		catch(...) {
			try {
				test_java_exception(pJNIEnv);
			}
			catch(...) {
				if(attached) {
					pVMContext->revokeThread();
					pVMContext->_pJavaVM->DetachCurrentThread();
				}

				throw;
			}

			if(attached) {
				pVMContext->revokeThread();
				pVMContext->_pJavaVM->DetachCurrentThread();
			}

			throw;
		}

		if(attached) {
			pVMContext->revokeThread();
			pVMContext->_pJavaVM->DetachCurrentThread();
		}
		

		return pRemote_Connection;
	}

	class Remote_disposingListener {
		remote_DisposingListener _remote_DisposingListener;
		oslInterlockedCount  _refCount;

		uno_Environment * _pJava_environment;

		static void SAL_CALL _acquire(remote_DisposingListener * pRemote_DisposingListener) throw();
		static void SAL_CALL _release(remote_DisposingListener * pRemote_DisposingListener) throw();

		static void SAL_CALL _disposing(remote_DisposingListener * pRemote_DisposingListener, rtl_uString * pBridgeName) throw();

	public:
		Remote_disposingListener(uno_Environment * pJava_environment) throw();
	};

	void SAL_CALL Remote_disposingListener::_acquire(remote_DisposingListener * premote_DisposingListener) throw() {
		OSL_TRACE("Remote_disposingListener::_acquire");
		Remote_disposingListener * pRemote_DisposingListener = reinterpret_cast<Remote_disposingListener *>(premote_DisposingListener);

		osl_incrementInterlockedCount(&pRemote_DisposingListener->_refCount);
	}

	void SAL_CALL Remote_disposingListener::_release(remote_DisposingListener * premote_DisposingListener) throw() {
		OSL_TRACE("Remote_disposingListener::_release");
		Remote_disposingListener * pRemote_DisposingListener = reinterpret_cast<Remote_disposingListener *>(premote_DisposingListener);

		if(!osl_decrementInterlockedCount(&pRemote_DisposingListener->_refCount))
			delete pRemote_DisposingListener;
	}

	void SAL_CALL Remote_disposingListener::_disposing(remote_DisposingListener * premote_DisposingListener, rtl_uString * pBridgeName) throw() {
		OSL_TRACE("Remote_disposingListener::_disposing");
		Remote_disposingListener * pRemote_DisposingListener = reinterpret_cast<Remote_disposingListener *>(premote_DisposingListener);

		pRemote_DisposingListener->_pJava_environment->release(pRemote_DisposingListener->_pJava_environment);
		pRemote_DisposingListener->_pJava_environment = NULL;
	}

	Remote_disposingListener::Remote_disposingListener(uno_Environment * pJava_environment) throw() 
		: _pJava_environment(pJava_environment),
		  _refCount(1)
	{
		OSL_TRACE("Remote_disposingListener::Remote_disposingListener");

		_remote_DisposingListener.acquire = _acquire;
		_remote_DisposingListener.release = _release;
		_remote_DisposingListener.disposing = _disposing;

		_pJava_environment->acquire(_pJava_environment);
	}

	static uno_Interface * map_java_to_uno(uno_Environment * pJava_environment, 
										   uno_Environment * pUNO_environment, 
										   typelib_InterfaceTypeDescription * pType_XInterface) 
		throw(RuntimeException)
	{
		const char * pServiceName = "com.sun.star.comp.JavaMapper";

		// create the id string for the bridge
		char buffer[256];
		sprintf(buffer, "java-uno-bridge - mapping: %p", pJava_environment);
		OUString idStr(OUString::createFromAscii(buffer));

		// create the remote context
        OUString protocolName(RTL_CONSTASCII_USTRINGPARAM("urp"));
        OUString protocolName_withAttributes(RTL_CONSTASCII_USTRINGPARAM("urp,Negotiate=0,ForceSynchronous=1"));
		OUString dcpStr(RTL_CONSTASCII_USTRINGPARAM("the description string"));

		OUString remoteO(OUString::createFromAscii(pServiceName));

		remote_Context * pRemote_Context = NULL;
		uno_Environment * pRemote_Environment = NULL;
		remote_Interface *pRemoteI = NULL;
		uno_Interface * xInterface = NULL;

		try {
			// see if there is already a context 
			pRemote_Context = remote_getContext(idStr.pData);
			if(!pRemote_Context) {// otherwise create a new one
				OSL_TRACE("java_uno_mapping.cxx: creating a new bridge");
				// init the java side
				remote_Connection * pRemote_Connection = init_java_side((JavaVMContext *)pJava_environment->pContext, pServiceName);
			
				pRemote_Context = remote_createContext(pRemote_Connection, idStr.pData, dcpStr.pData, protocolName_withAttributes.pData, NULL);
				if(!pRemote_Context) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't create remote_context")), Reference<XInterface>());

				pRemote_Context->addDisposingListener(pRemote_Context, reinterpret_cast<remote_DisposingListener *>(new Remote_disposingListener(pJava_environment)));
			}
			else
				OSL_TRACE("java_uno_mapping.cxx: found a bridge");

			// get the remote environment with the above constructed context
			uno_getEnvironment(&pRemote_Environment, protocolName.pData, pRemote_Context);											   
			if(!pRemote_Environment) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get remote_environment")), Reference<XInterface>());


			// map the java object to remote
			uno_Any exc = {NULL, NULL};
			uno_Any * pExc = &exc;
			pRemote_Context->getRemoteInstance(pRemote_Environment,
											   &pRemoteI,
											   remoteO.pData,
											   pType_XInterface->aBase.pWeakRef,
											   &pExc);
			if(pExc) // hey hey, an exception has occurred
				throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get JavaMapper cause of an exception")), Reference<XInterface>());

			if(!pRemoteI) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get JavaMapper")), Reference<XInterface>());
			
			pRemote_Context->aBase.release(reinterpret_cast<uno_Context *>(pRemote_Context));
			pRemote_Context = NULL;


			// get mapping to map from remote to uno
			Mapping remote_uno(pRemote_Environment, pUNO_environment, OUString());
			if(!remote_uno.is()) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get remote_uno mapping")), Reference<XInterface>());

			pRemote_Environment->release(pRemote_Environment);
			pRemote_Environment = NULL;

			xInterface = (uno_Interface *)remote_uno.mapInterface(pRemoteI, pType_XInterface);
			if(!xInterface) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't map JavaMapper from remote to uno")), Reference<XInterface>());

			pRemoteI->release(pRemoteI);
			pRemoteI = NULL;
		}
		catch(RuntimeException &) { // enshure that everything gets released
			if(xInterface)
				xInterface->release(xInterface);

			if(pRemoteI)
				pRemoteI->release(pRemoteI);

			if(pRemote_Environment)
				pRemote_Environment->release(pRemote_Environment);

			if(pRemote_Context)
				pRemote_Context->aBase.release(reinterpret_cast<uno_Context *>(pRemote_Context));

			throw;
		}

		return xInterface;
	}

	static uno_Interface * getJavaMapper(uno_Environment * pJava_environment, 
										 uno_Environment * pUNO_environment, 
										 typelib_TypeDescription * pType_XJavaMapper) throw(RuntimeException) 
	{
		uno_Interface * pMapper;

		typelib_InterfaceTypeDescription * pType_XInterface = NULL;
		typelib_InterfaceMemberTypeDescription *pType_XInterface_queryInterface = 0;		
		uno_Interface * xInterface = NULL;
		
		try {
			// get the method typedescription for queryInterface
			getCppuType((Reference <XInterface> *) 0).getDescription((typelib_TypeDescription **) & pType_XInterface);
			if(!pType_XInterface) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get XInterface type_description")), Reference<XInterface>());
			
			if(!pType_XInterface->aBase.bComplete)
				typelib_typedescription_complete((typelib_TypeDescription **)&pType_XInterface);
				
				
			// map the initial object from java to here
			xInterface = map_java_to_uno(pJava_environment, pUNO_environment, pType_XInterface);
				
				
			typelib_typedescriptionreference_getDescription((typelib_TypeDescription **)&pType_XInterface_queryInterface,
															pType_XInterface->ppAllMembers[0]);
			if(!pType_XInterface_queryInterface) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get queryInterface description")), Reference<XInterface>());
				
			typelib_typedescription_release((typelib_TypeDescription *)pType_XInterface);
			pType_XInterface = NULL;
				
				
				
				
				
			// call queryInterface for XJavaMapper 
			void * args[] = {&pType_XJavaMapper};
				
			uno_Any any = {NULL, NULL};
				
			uno_Any exc = {NULL, NULL};
			uno_Any * pExc = &exc;
				
			xInterface->pDispatcher(xInterface, 
									(typelib_TypeDescription *)pType_XInterface_queryInterface, 
									&any, 
									(void **)&args, 
									&pExc);
			if(pExc) // hey hey, an exception has occurred
				throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("an exception occured during queryInterface on JavaMapper")), Reference<XInterface>());
				
			// release queryInterface
			typelib_typedescription_release((typelib_TypeDescription *)pType_XInterface_queryInterface);
			pType_XInterface_queryInterface = NULL;
				
			// release the xInterface
			xInterface->release(xInterface);
			xInterface = NULL;
				
			pMapper = *(uno_Interface **)any.pData;
			if(!pMapper)
				throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("got an empty interface for JavaMapper")), Reference<XInterface>());
		}
		catch(RuntimeException &) {
			if(xInterface)
				xInterface->release(xInterface);
				
			if(pType_XInterface_queryInterface)
				typelib_typedescription_release((typelib_TypeDescription *)pType_XInterface_queryInterface);

			if(pType_XInterface)
				typelib_typedescription_release((typelib_TypeDescription *)pType_XInterface);
				
			if(pType_XJavaMapper)
				typelib_typedescription_release((typelib_TypeDescription *)pType_XJavaMapper);

			throw;
		}

		return pMapper;
	}

	java_Mapping::java_Mapping(uno_Environment * pFrom, uno_Environment * pTo) throw(RuntimeException) 
		: _pFrom(pFrom),
		  _pTo(pTo),
		  _pMapper(NULL),
		  _pXJavaMapper_mapIntToObject(NULL),
		  _pXJavaMapper_mapObjectToInt(NULL)
	{
		OSL_TRACE("java_Mapping::java_Mapping");

		// acquire the environments
		_pFrom->acquire(_pFrom);
		_pTo->acquire(_pTo);

		_uno_mapping.acquire = NULL;
		_uno_mapping.release = NULL;
		_uno_mapping.mapInterface = NULL;

		_refCount = 0;

		// initialize the mapping methods

  		// acquire and release
		_uno_mapping.acquire = java_Mapping_acquire;
		_uno_mapping.release = java_Mapping_release;

		uno_Environment * pJava_environment = NULL;
		uno_Environment * pUNO_environment = NULL;

		// get the direction of the mapping and set the map method
		OUString fromName(pFrom->pTypeName);
		if(fromName.equalsIgnoreAsciiCase(OUString(RTL_CONSTASCII_USTRINGPARAM(UNO_LB_JAVA)))) { // mapping from java to uno?
			_uno_mapping.mapInterface = java_Mapping_mapInterface_from;
			
			pJava_environment = _pFrom;
			pUNO_environment = _pTo;
		}
		else {
			_uno_mapping.mapInterface = java_Mapping_mapInterface_to;

			pJava_environment = _pTo;
			pUNO_environment = _pFrom;
		}

		typelib_InterfaceTypeDescription * pType_XJavaMapper = NULL;

		try {
			// init the typedescriptions for the java mapper
			// get the type for XJavaMapper
			getCppuType((Reference<XJavaMapper> *)0).getDescription(reinterpret_cast<typelib_TypeDescription **>(&pType_XJavaMapper));
			if(!pType_XJavaMapper) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get XJavaMapper type")), Reference<XInterface>());
				
			if(!pType_XJavaMapper->aBase.bComplete)
				typelib_typedescription_complete((typelib_TypeDescription **)&pType_XJavaMapper);
				
			// get method type description for "mapIntToObject"
			typelib_typedescriptionreference_getDescription(reinterpret_cast<typelib_TypeDescription **>(&_pXJavaMapper_mapIntToObject),
															pType_XJavaMapper->ppMembers[0]);
			if(!_pXJavaMapper_mapIntToObject) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get method mapIntToObject")), Reference<XInterface>());



			// get method type description for "mapObjectToInt"
			typelib_typedescriptionreference_getDescription(reinterpret_cast<typelib_TypeDescription **>(&_pXJavaMapper_mapObjectToInt),
															pType_XJavaMapper->ppMembers[1]);
			if(!_pXJavaMapper_mapObjectToInt) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("couldn't get method mapObjectToInt")), Reference<XInterface>());


			// get the mapper object
			_pMapper = getJavaMapper(pJava_environment, pUNO_environment, reinterpret_cast<typelib_TypeDescription *>(pType_XJavaMapper));

			// release XJavaMapper
			typelib_typedescription_release((typelib_TypeDescription *)pType_XJavaMapper);
			pType_XJavaMapper = NULL;
		}
		catch(RuntimeException &) {
			if(pType_XJavaMapper)
				typelib_typedescription_release((typelib_TypeDescription *)pType_XJavaMapper);

			if(_pMapper)
				_pMapper->release(_pMapper);

			if(_pFrom)
				_pFrom->release(_pFrom);

			if(_pTo)
				_pTo->release(_pTo);

			if(_pXJavaMapper_mapIntToObject)
				typelib_typedescription_release(reinterpret_cast<typelib_TypeDescription *>(_pXJavaMapper_mapIntToObject));

			if(_pXJavaMapper_mapObjectToInt)
				typelib_typedescription_release(reinterpret_cast<typelib_TypeDescription *>(_pXJavaMapper_mapObjectToInt));

			throw;
		}
	}

	java_Mapping::~java_Mapping() {
		OSL_TRACE("java_Mapping::~java_Mapping");

		_pMapper->release(_pMapper);
		_pFrom->release(_pFrom);
		_pTo->release(_pTo);
		typelib_typedescription_release(reinterpret_cast<typelib_TypeDescription *>(_pXJavaMapper_mapIntToObject));
		typelib_typedescription_release(reinterpret_cast<typelib_TypeDescription *>(_pXJavaMapper_mapObjectToInt));
	}

	void SAL_CALL java_Mapping_acquire(uno_Mapping * pUno_mapping) {
		java_Mapping * pJava_mapping = reinterpret_cast<java_Mapping *>(pUno_mapping);

		osl_incrementInterlockedCount(&(pJava_mapping->_refCount));
		if(1 == pJava_mapping->_refCount) {
			uno_registerMapping(&pUno_mapping,
								java_Mapping_free,
								pJava_mapping->_pFrom,
								pJava_mapping->_pTo ,
								NULL);
		}
	}

	void SAL_CALL java_Mapping_release(uno_Mapping * pUno_mapping) {
		java_Mapping * pJava_mapping = reinterpret_cast<java_Mapping *>(pUno_mapping);

		if (!osl_decrementInterlockedCount(&(pJava_mapping->_refCount)))
			uno_revokeMapping(pUno_mapping);
	}

	void SAL_CALL java_Mapping_free(uno_Mapping * pUno_mapping)	{
		java_Mapping * pJava_mapping = reinterpret_cast<java_Mapping *>(pUno_mapping);

  		delete pJava_mapping;
	}

	/**
	 * maps an interface from java jni (jobject) to binary uno
	 */
	void SAL_CALL java_Mapping_mapInterface_from(uno_Mapping * pMapping,
												 void ** ppOut, 
												 void * pInterface,
												 typelib_InterfaceTypeDescription * pInterfaceTypeDescr)
	{
		OSL_TRACE("java_Mapping_mapInterface_from");
		java_Mapping * pJava_mapping = (java_Mapping *)pMapping;
			

		jobject joObject = (jobject)pInterface;
		OUString className(pInterfaceTypeDescr->aBase.pTypeName);

		void * args[] = {&joObject, &className};

		uno_Any any = {NULL, NULL};

		uno_Any exc;
		uno_Any * pExc = &exc;
			
		pJava_mapping->_pMapper->pDispatcher(pJava_mapping->_pMapper, 
											 pJava_mapping->_pXJavaMapper_mapIntToObject, 
											 &any, 
											 (void **)&args, 
											 &pExc);

		*ppOut = *(uno_Interface **)any.pData;
	}


	/**
	 * maps an interface from binary uno to java jni (jobject)
	 */
	void SAL_CALL java_Mapping_mapInterface_to(uno_Mapping * pMapping,
											   void ** ppOut, void * pInterface,
											   typelib_InterfaceTypeDescription * pInterfaceTypeDescr)
	{
		OSL_TRACE("java_Mapping_mapInterface_to");
		java_Mapping * pJava_mapping = (java_Mapping *)pMapping;

  		void * args[] = {&pInterface};

		sal_Int32 out;

		uno_Any exc;
		uno_Any * pExc = &exc;

		pJava_mapping->_pMapper->pDispatcher(pJava_mapping->_pMapper, 
											 pJava_mapping->_pXJavaMapper_mapObjectToInt, 
											 &out, 
											 (void **)&args, 
											 &pExc);

		*ppOut = (jobject)out;
	}
}
