/*************************************************************************
 *
 *  $RCSfile: namesp_i.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_UIDL_NAMESP_I_HXX
#define ARY_UIDL_NAMESP_I_HXX


// USED SERVICES
	// BASE CLASSES
#include <ary_i/uidl/cenamesp.hxx>
	// COMPONENTS
	// PARAMETERS



namespace ary
{
namespace uidl
{


class Gate_Impl;


class CeNamespace_Impl : public CeNamespace
{
  public:
	enum E_Predeclared
	{
		pd_no = 0,
		pd_yes,
		pd_already_defined
	};

	typedef std::pair< Cei, E_Predeclared >		Id_n_Declaration;

						CeNamespace_Impl(
							Cei					i_nId,
							const char *		i_sName,
							CeNamespace_Impl *	i_pParent,
							Gate_Impl &			io_rGate );
	virtual				~CeNamespace_Impl();

	// INQUIRY  ( CeNamespace )
	virtual const udmstri &
						Name() const;
	virtual void	  	GetFullName(
							csv::StreamStr &	o_rStream,
							const char *		i_sDelimiter ) const;
	virtual Cei			Id() const;
	virtual uintt		Depth() const;
	virtual CeNamespace *
						Parent() const;
	virtual CeNamespace *
						SubNamespace(
							const char *		i_sName ) const;
	// OPERATION
//	virtual void		DisplayContents(
//							csi::uidl::Display &
//												o_rDisplay );
	uintt				FindName(
							const char *        i_sName ) const;
	Id_n_Declaration	FindPredeclaration(
							const char *        i_sName ) const;

	void				AddSubNamespace(
							CeNamespace_Impl &	i_rSubNsp );
	void				AddName(
							Cei					i_nId,
							const udmstri &		i_sName,
							E_NamedObjsKind		i_eKindOfObj );

	// INQUIRY  
	virtual void		GetSubNamespaces(
							std::vector< CeNamespace * > &
												o_rResult ) const;
	virtual const NameMap &
						LocalNames() const;

	//	CeNamespace_Impl *	ParentImpl() const;
	CeNamespace_Impl *	SubNamespaceImpl(
							const char *		i_sName ) const;

  private:
	typedef std::vector< CeNamespace_Impl * > 	SortedNamespaces;

	void				CheckDirectory(
							csi::uidl::Display &
												o_rDisplay );
	void				DisplayIndex(
							csi::uidl::Display &
												o_rDisplay );
	void				DisplayLocalNames(
							csi::uidl::Display &
												o_rDisplay );
	// DATA
	Cei					nId;
	udmstri				sName;
	CeNamespace_Impl *	pParent;
	uintt				nDepth;
	Gate_Impl *			pGate;

	SortedNamespaces	aSubNamespaces;
	NameMap				aLocalNames;
};


}   // namespace uidl
}   // namespace ary

#endif



