/*************************************************************************
 *
 *  $RCSfile: ipi_ce.cxx,v $
 *
 *  $Revision: 1.1.12.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/01/27 17:00:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include "ipi_ce.hxx"


// NOT FULLY DEFINED SERVICES
#include <cosv/template/tpltools.hxx>
#include <ary/idl/i_attribute.hxx>
#include <ary/idl/i_constant.hxx>
#include <ary/idl/i_constgroup.hxx>
#include <ary/idl/i_enum.hxx>
#include <ary/idl/i_enumvalue.hxx>
#include <ary/idl/i_exception.hxx>
#include <ary/idl/i_function.hxx>
#include <ary/idl/i_interface.hxx>
#include <ary/idl/i_module.hxx>
#include <ary/idl/i_property.hxx>
#include <ary/idl/i_service.hxx>
#include <ary/idl/i_singleton.hxx>
#include <ary/idl/i_struct.hxx>
#include <ary/idl/i_structelem.hxx>
#include <ary/idl/i_typedef.hxx>
#include <store/st_access.hxx>
#include "is_ce.hxx"



namespace ary
{
namespace idl
{

inline const Ce_Storage &
CePilot_Inst::my_Storage() const
    { return *pStorage; }

inline Ce_Storage &
CePilot_Inst::my_Storage()
    { return *pStorage; }

inline Module &
CePilot_Inst::lhf_Access_Module( Ce_id i_nId )
    { return store::find_access(my_Storage(),i_nId, T2T<Module>()); }

inline void
CePilot_Inst::lhf_Put2Storage_and_AssignId( CodeEntity & pass_io_rCe )
    { // This also assigns an ID to pass_io_rCe:
      my_Storage().Container().Add(pass_io_rCe); }

inline void
CePilot_Inst::lhf_Store_NewEntity( DYN CodeEntity &  pass_io_rCe,
                                   Module &          i_rOwner )
{
    lhf_Put2Storage_and_AssignId(pass_io_rCe);
    i_rOwner.Add_Name(pass_io_rCe.LocalName(), pass_io_rCe.CeId());
}




CePilot_Inst::CePilot_Inst( Ce_Storage & io_rStorage )
    :   pStorage(&io_rStorage),
        pGlobalNamespace(0)
{
    my_Storage().Container().Set_Reserved(
                    Ce_id(predefined::ce_GlobalNamespace),
                    *new Module );
    pGlobalNamespace = &lhf_Access_Module(Ce_id(predefined::ce_GlobalNamespace));
}

CePilot_Inst::~CePilot_Inst()
{
}

Module &
CePilot_Inst::do_CheckIn_Module( Ce_id               i_nParentId,
                                 const String &      i_sName )
{
    Module & rOwner  = lhf_Access_Module(i_nParentId);
    Ce_id    nId     = rOwner.Search_Name(i_sName);
    if (nId.IsValid())
    {
        return lhf_Access_Module(nId);
    }

    Module & ret = *new Module( i_sName,
                                rOwner );
    lhf_Store_NewEntity(ret, rOwner);
    return ret;
}

Service &
CePilot_Inst::do_Store_Service( Ce_id               i_nOwner,
                                const String &      i_sName )
{
    Module & rOwner  = lhf_Access_Module(i_nOwner);
    Service & ret = *new Service( i_sName,
                                  i_nOwner );
    lhf_Store_NewEntity(ret, rOwner);
    return ret;
}


Interface &
CePilot_Inst::do_Store_Interface( Ce_id               i_nOwner,
                                  const String &      i_sName,
                                  Type_id             i_nBase )
{
    Module & rOwner  = lhf_Access_Module(i_nOwner);
    Interface & ret = *new Interface( i_sName,
                                      i_nOwner,
                                      i_nBase );
    lhf_Store_NewEntity(ret, rOwner);
    return ret;
}

Struct &
CePilot_Inst::do_Store_Struct( Ce_id               i_nOwner,
                               const String &      i_sName,
                               Type_id             i_nBase )
{
    Module & rOwner  = lhf_Access_Module(i_nOwner);
    Struct & ret = *new Struct( i_sName,
                                i_nOwner,
                                i_nBase );
    lhf_Store_NewEntity(ret, rOwner);
    return ret;
}

Exception &
CePilot_Inst::do_Store_Exception( Ce_id               i_nOwner,
                                  const String &      i_sName,
                                  Type_id             i_nBase )
{
    Module & rOwner  = lhf_Access_Module(i_nOwner);
    Exception & ret = *new Exception( i_sName,
                                      i_nOwner,
                                      i_nBase );
    lhf_Store_NewEntity(ret, rOwner);
    return ret;
}

Enum &
CePilot_Inst::do_Store_Enum( Ce_id               i_nOwner,
                             const String &      i_sName )
{
    Module & rOwner  = lhf_Access_Module(i_nOwner);
    Enum & ret = *new Enum( i_sName,
                            i_nOwner );
    lhf_Store_NewEntity(ret, rOwner);
    return ret;
}

Typedef &
CePilot_Inst::do_Store_Typedef( Ce_id               i_nOwner,
                                const String &      i_sName,
                                Type_id             i_nDefiningType )
{
    Module & rOwner  = lhf_Access_Module(i_nOwner);
    Typedef & ret = *new Typedef( i_sName,
                                  i_nOwner,
                                  i_nDefiningType );
    lhf_Store_NewEntity(ret, rOwner);
    return ret;
}


ConstantsGroup &
CePilot_Inst::do_Store_ConstantsGroup( Ce_id               i_nOwner,
                                       const String &      i_sName )
{
    Module & rOwner  = lhf_Access_Module(i_nOwner);
    ConstantsGroup & ret = *new ConstantsGroup( i_sName,
                                                i_nOwner );
    lhf_Store_NewEntity(ret, rOwner);
    return ret;
}

Singleton & 
CePilot_Inst::do_Store_Singleton( Ce_id               i_nOwner,
                                  const String &      i_sName )
{
    Module &    rOwner  = lhf_Access_Module(i_nOwner);
    Singleton & ret = *new Singleton( i_sName,
                                      i_nOwner );
    lhf_Store_NewEntity(ret, rOwner);
    return ret;
}

Constant &
CePilot_Inst::do_Store_Constant( Ce_id               i_nOwner,
                                 const String &      i_sName,
                                 Type_id             i_nType,
                                 const String &      i_sValue )
{
    ConstantsGroup & rOwner  = store::find_access(my_Storage(), i_nOwner, T2T<ConstantsGroup>());
    Constant & ret = *new Constant( i_sName,
                                    i_nOwner,
                                    rOwner.NameRoom(),
                                    i_nType,
                                    i_sValue );
    lhf_Put2Storage_and_AssignId(ret);
    rOwner.Add_Constant(ret.CeId());
    return ret;
}

Property &
CePilot_Inst::do_Store_Property( Ce_id                  i_nOwner,
                                 const String &         i_sName,
                                 Type_id                i_nType,
                                 Property::Stereotypes  i_stereotypes )
{
    Service &  rOwner  = store::find_access(my_Storage(), i_nOwner, T2T<Service>());
    Property & ret = *new Property( i_sName,
                                    i_nOwner,
                                    rOwner.NameRoom(),
                                    i_nType,
                                    i_stereotypes );
    lhf_Put2Storage_and_AssignId(ret);
    rOwner.Add_Property(ret.CeId());
    return ret;
}

Function &
CePilot_Inst::do_Store_Function( Ce_id               i_nOwner,
                                 const String &      i_sName,
                                 Type_id             i_nReturnType,
                                 bool                i_bOneWay,
                                 bool                i_bConst )
{
    Interface &  rOwner  = store::find_access(my_Storage(), i_nOwner, T2T<Interface>());
    Function & ret = *new Function( i_sName,
                                    i_nOwner,
                                    rOwner.NameRoom(),
                                    i_nReturnType,
                                    i_bConst,
									i_bOneWay);
    lhf_Put2Storage_and_AssignId(ret);
    rOwner.Add_Function(ret.CeId());
    return ret;
}

StructElement &
CePilot_Inst::do_Store_StructMember( Ce_id               i_nOwner,
                                     const String &      i_sName,
                                     Type_id             i_nType )
{
    Struct &  rOwner  = store::find_access(my_Storage(), i_nOwner, T2T<Struct>());
    StructElement & ret = *new StructElement( i_sName,
                                              i_nOwner,
                                              rOwner.NameRoom(),
                                              i_nType );
    lhf_Put2Storage_and_AssignId(ret);
    rOwner.Add_Member(ret.CeId());
    return ret;
}

StructElement &
CePilot_Inst::do_Store_ExceptionMember( Ce_id               i_nOwner,
                                        const String &      i_sName,
                                        Type_id             i_nType )
{
    Exception &  rOwner  = store::find_access(my_Storage(), i_nOwner, T2T<Exception>());
    StructElement & ret = *new StructElement( i_sName,
                                              i_nOwner,
                                              rOwner.NameRoom(),
                                              i_nType );
    lhf_Put2Storage_and_AssignId(ret);
    rOwner.Add_Member(ret.CeId());
    return ret;
}

EnumValue &
CePilot_Inst::do_Store_EnumValue( Ce_id               i_nOwner,
                                  const String &      i_sName,
                                  const String &      i_sValue )
{
    Enum &  rOwner  = store::find_access(my_Storage(), i_nOwner, T2T<Enum>());
    EnumValue & ret = *new EnumValue( i_sName,
                                      i_nOwner,
                                      rOwner.NameRoom(),
                                      i_sValue );
    lhf_Put2Storage_and_AssignId(ret);
    rOwner.Add_Value(ret.CeId());
    return ret;
}

Attribute &
CePilot_Inst::do_Store_Attribute( Ce_id               i_nOwner,
                                  const String &      i_sName,
                                  Type_id             i_nType,
                                  bool                i_bReadOnly )
{
    Interface &  rOwner  = store::find_access(my_Storage(), i_nOwner, T2T<Interface>());
    Attribute & ret = *new Attribute ( i_sName,
                                       i_nOwner,
                                       rOwner.NameRoom(),
                                       i_nType,
                                       i_bReadOnly );
    lhf_Put2Storage_and_AssignId(ret);
    rOwner.Add_Attribute(ret.CeId());
    return ret;
}

const Module &
CePilot_Inst::inq_GlobalNamespace() const
{
    csv_assert(pGlobalNamespace);
    return *pGlobalNamespace;
}

const CodeEntity &
CePilot_Inst::inq_Find_Ce( Ce_id i_nId ) const
{
    return my_Storage()[i_nId].Entity();

}

const Module &
CePilot_Inst::inq_Find_Module( Ce_id i_nId ) const
{
    return store::find( my_Storage(), i_nId, T2T<Module>() );
}

const Module *
CePilot_Inst::inq_Search_Module( Ce_id i_nId ) const
{
    return store::search( my_Storage(), i_nId, T2T<Module>() );
}

const Function &
CePilot_Inst::inq_Find_Function( Ce_id i_nId ) const
{
    return store::find( my_Storage(), i_nId, T2T<Function>() );
}

const Property &
CePilot_Inst::inq_Find_Property( Ce_id i_nId ) const
{
    return store::find( my_Storage(), i_nId, T2T<Property>() );
}

const EnumValue &
CePilot_Inst::inq_Find_EnumValue( Ce_id i_nId ) const
{
    return store::find( my_Storage(), i_nId, T2T<EnumValue>() );
}

const Constant &
CePilot_Inst::inq_Find_Constant( Ce_id i_nId ) const
{
    return store::find( my_Storage(), i_nId, T2T<Constant>() );
}

const StructElement &
CePilot_Inst::inq_Find_StructElement( Ce_id i_nId ) const
{
    return store::find( my_Storage(), i_nId, T2T<StructElement>() );
}

void        
CePilot_Inst::inq_Get_Text( StringVector &      o_module,
                            String &            o_ce,
                            String &            o_member,
                            const CodeEntity &  i_ce ) const
{
    const CodeEntity * pCe = &i_ce;
    csv::erase_container(o_module);
    o_ce.clear();
    o_member.clear();

    switch ( pCe->SightLevel() )
    {   
        // Here are intentionally no breaks!
        case sl_Member:                                 
                        if (pCe->ClassId() == Function::class_id)
                            o_member = StreamLock(200)() 
                                            << pCe->LocalName() 
                                            << "()"
                                            << c_str;
                        else
                            o_member = pCe->LocalName();
                        pCe = my_Storage()[pCe->Owner()].EntityPtr();
                        csv_assert(pCe != 0);
        case sl_File:       
                        o_ce = pCe->LocalName();                            
                        pCe = my_Storage()[pCe->NameRoom()].EntityPtr();
                        csv_assert(pCe != 0);
        case sl_Module:
                        get_ModuleText(o_module,*pCe);
    }
}

Module &
CePilot_Inst::access_GlobalNamespace()
{
    csv_assert(pGlobalNamespace);
    return *pGlobalNamespace;
}

CodeEntity &
CePilot_Inst::access_Find_Ce( Ce_id i_nId )
{
    return my_Storage()[i_nId].Entity();
}

void                
CePilot_Inst::get_ModuleText( StringVector &      o_module,
                              const CodeEntity &  i_ce ) const
{
    if (i_ce.NameRoom().IsValid())
    {                  
        const CodeEntity & rParent = my_Storage()[i_ce.NameRoom()].Entity();
        get_ModuleText(o_module, rParent);  
        o_module.push_back(i_ce.LocalName());
    }
}
                                   


}   // namespace idl
}   // namespace ary

