/*************************************************************************
 *
 *  $RCSfile: common_gate.hxx,v $
 *
 *  $Revision: 1.1.12.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/01/27 16:59:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_COMMON_GATE_HXX
#define ARY_COMMON_GATE_HXX

//	VERSION:		    Autodoc 2.2


// USED SERVICES
    // BASE CLASSES
    // COMPONENTS
    // PARAMETERS
#include <ary/actions.hxx>

namespace ary
{

class PhysicalLocationPilot;
class LogicalLocationPilot;
class InformationPilot;


class CommonGate
{
  public:
    // LIFECYCLE
    virtual             CommonGate::~CommonGate() {}

    // OPERATIONS

    // INQUIRY
    const PhysicalLocationPilot &
                        PhysicalLocations() const;

    const LogicalLocationPilot &
                        LogicalLocations() const;
    const InformationPilot &
                        Informations() const;
    // ACCESS
    PhysicalLocationPilot &
                        PhysicalLocations();

    LogicalLocationPilot &
                        LogicalLocations();
    InformationPilot &  Informations();

  private:
    // Locals
    CommonGate &        MutableMe() const;

    virtual PhysicalLocationPilot &
                        access_PhysicalLocations() = 0;
    virtual LogicalLocationPilot &
                        access_LogicalLocations() = 0;
    virtual InformationPilot &
                        access_Informations() = 0;
};




// IMPLEMENTATION

inline CommonGate &
CommonGate::MutableMe() const
    { return const_cast< CommonGate& >(*this); }

inline const PhysicalLocationPilot &
CommonGate::PhysicalLocations() const
    { return MutableMe().access_PhysicalLocations(); }

inline const LogicalLocationPilot &
CommonGate::LogicalLocations() const
    { return MutableMe().access_LogicalLocations(); }

inline const InformationPilot &
CommonGate::Informations() const
    { return MutableMe().access_Informations(); }

inline PhysicalLocationPilot &
CommonGate::PhysicalLocations()
    { return access_PhysicalLocations(); }

inline LogicalLocationPilot &
CommonGate::LogicalLocations()
    { return access_LogicalLocations(); }

inline InformationPilot &
CommonGate::Informations()
    { return access_Informations(); }





}   // namespace ary



#endif

