/*************************************************************************
 *
 *  $RCSfile: Query.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.qe;

import java.io.PrintStream;
import com.sun.xmlsearch.util.Location;

public class Query {
  private double  _currentStandard;
  private final int _nColumns;
  private double[] _missingPenalty;
  private double[] _upperboundTemplate;
  private double[] _penalties;
  
  private final SearchEnvironment _env;
  private int                 _hitCounter;
  private boolean                 _vote;
  
  private HitStore  _store;
  
  public Query(SearchEnvironment env, int nColumns, double[] missingPenalties) {
    _env = env;
    _nColumns = nColumns;
    _missingPenalty = new double[nColumns];
    _upperboundTemplate = new double[nColumns];
    _penalties = missingPenalties;
    _hitCounter = 0;
    _vote = false;
    _currentStandard = (nColumns - 1) * 10.0 + 9.9999;
    _store = new HitStore(_currentStandard);
    for (int i = 0; i < _nColumns; i++)
      _missingPenalty[i] = missingPenalties != null
	? missingPenalties[i]
	: 10.0;
    makePenaltiesTable();
  }

  public double lookupPenalty(int pattern) {
    return _penalties[pattern];
  }
  
  public double getOutOufOrderPenalty() {
    return 0.25;
  }
  
  public double getGapPenalty() {
    return 0.005;
  }
  
  public int getNColumns() {
    return _nColumns;
  }
  
  public boolean goodEnough(double penalty) {
    return penalty <= _currentStandard;
  }
  
  public int[] getConceptArrayOfNewHit(double penalty, Location loc) {
    QueryHit hit = new QueryHit(loc, penalty, _nColumns);
    _store.addQueryHit(hit);
    _hitCounter++;
    return hit.getArray();
  }

  public void resetForNextDocument() {
    _currentStandard = _store.getCurrentStandard();
    // "everything's missing"
    for (int i = 0; i < _nColumns; i++)
      _upperboundTemplate[i] = _missingPenalty[i];
    _vote = false;
  }

  public boolean vote() {
    double sum = 0.0;
    for (int i = 0; i < _nColumns; i++)
      sum += _upperboundTemplate[i];
    return _vote = (sum <= _currentStandard);
  }

  public void updateEstimate(int role, double penalty) {
    if (penalty < _upperboundTemplate[role])
      _upperboundTemplate[role] = penalty;
  }
  
  public void printHits(PrintStream out, int n) {
    if (n > 0) {
      int N = n;
      QueryHit qh = _store.firstBestQueryHit();
      n = N;
      for ( ; qh != null; qh = --n > 0 ? _store.nextBestQueryHit() : null)
	try {
	  out.println(_env.hitToString(qh));
	}
      catch (Exception e) {
	e.printStackTrace();
	System.err.println(e + "hit not translated");
      }
    }
  }

  private void makePenaltiesTable() {
    int nPatterns = 1 << _nColumns;
    _penalties = new double[nPatterns];
    for (int i = 0; i < nPatterns; i++)
      _penalties[i] = computePenalty(i);
  }

  private double computePenalty(int n) {
    double penalty = 0.0;
    for (int i = 0; i < _nColumns; i++)
      if ((n & 1 << i) == 0)
	penalty += _missingPenalty[i];
    return penalty;
  }
}
