*** orig/dmake/function.c	Sat Sep  9 18:36:53 2000
--- modified/dmake/function.c	Sat Sep  9 18:36:53 2000
***************
*** 1,44 ****
! /* RCS  $Id: function.c,v 1.1.1.1 1997/07/15 16:02:25 dvadura Exp $
  --
  -- SYNOPSIS
  --      GNU style functions for dmake.
! -- 
  -- DESCRIPTION
  -- 	All GNU stule functions understood by dmake are implemented in this
  --	file.  Currently the only such function is $(mktmp ...) which is
  --	not part of GNU-make is an extension provided by dmake.
  --
  -- AUTHOR
  --      Dennis Vadura, dvadura@dmake.wticorp.com
  --
  -- WWW
  --      http://dmake.wticorp.com/
  --
  -- COPYRIGHT
  --      Copyright (c) 1996,1997 by WTI Corp.  All rights reserved.
! -- 
  --      This program is NOT free software; you can redistribute it and/or
  --      modify it under the terms of the Software License Agreement Provided
  --      in the file <distribution-root>/readme/license.txt.
  --
  -- LOG
  --      Use cvs log to obtain detailed change logs.
  */
  
  #include "extern.h"
  
  static char *_exec_mktmp  ANSI((char *, char *, char *));
  static char *_exec_subst  ANSI((char *, char *, char *));
  static char *_exec_iseq   ANSI((char *, char *, char *, int));
  static char *_exec_sort   ANSI((char *));
  static char *_exec_echo   ANSI((char *));
  static char *_exec_uniq   ANSI((char *));
  static char *_exec_shell  ANSI((char *, char *));
  static char *_exec_call   ANSI((char *, char *));
  static char *_exec_assign ANSI((char *));
  static char *_exec_foreach ANSI((char *, char *, char *));
  static char *_exec_andor  ANSI((char *, int));
  static char *_exec_not    ANSI((char *));
  static int   _mystrcmp    ANSI((CONST PVOID, CONST PVOID));
  
  
--- 1,44 ----
! /* RCS  $Id: function.c,v 1.3 1997/11/21 11:35:42 sdo Exp $
  --
  -- SYNOPSIS
  --      GNU style functions for dmake.
! --
  -- DESCRIPTION
  -- 	All GNU stule functions understood by dmake are implemented in this
  --	file.  Currently the only such function is $(mktmp ...) which is
  --	not part of GNU-make is an extension provided by dmake.
  --
  -- AUTHOR
  --      Dennis Vadura, dvadura@dmake.wticorp.com
  --
  -- WWW
  --      http://dmake.wticorp.com/
  --
  -- COPYRIGHT
  --      Copyright (c) 1996,1997 by WTI Corp.  All rights reserved.
! --
  --      This program is NOT free software; you can redistribute it and/or
  --      modify it under the terms of the Software License Agreement Provided
  --      in the file <distribution-root>/readme/license.txt.
  --
  -- LOG
  --      Use cvs log to obtain detailed change logs.
  */
  
  #include "extern.h"
  
  static char *_exec_mktmp  ANSI((char *, char *, char *));
  static char *_exec_subst  ANSI((char *, char *, char *));
  static char *_exec_iseq   ANSI((char *, char *, char *, int));
  static char *_exec_sort   ANSI((char *));
  static char *_exec_echo   ANSI((char *));
  static char *_exec_uniq   ANSI((char *));
  static char *_exec_shell  ANSI((char *, char *));
  static char *_exec_call   ANSI((char *, char *));
  static char *_exec_assign ANSI((char *));
  static char *_exec_foreach ANSI((char *, char *, char *));
  static char *_exec_andor  ANSI((char *, int));
  static char *_exec_not    ANSI((char *));
  static int   _mystrcmp    ANSI((CONST PVOID, CONST PVOID));
  
  
***************
*** 175,225 ****
     }
  
     return(DmStrDup(LastMacName));
  }
  
  
  static char *
  _exec_echo(data)
  char *data;
  {
     return(DmStrDup(DmStrSpn(data," \t")));
  }
  
  
  static char *
  _exec_call( var, list )
  char *var;
  char *list;
  {
     char *res = NIL(char);
     char *s;
     TKSTR tk;
     int   i=0;
  
     list = Expand(list);
!    
     SET_TOKEN(&tk,list);
     while( *(s=Get_token(&tk, "", FALSE)) != '\0' ) {
        char  buf[40];
  
        sprintf(buf, "%d", i++);
        Def_macro(buf,s,M_MULTI|M_NOEXPORT|M_FORCE|M_PUSH);
     }
     CLEAR_TOKEN(&tk);
  
     var = DmStrJoin(DmStrJoin("$(",var,-1,FALSE),")",-1,TRUE);
     res = Expand(var);
  
     i=0;
     SET_TOKEN(&tk,list);
     while( *(s=Get_token(&tk, "", FALSE)) != '\0' ) {
        HASHPTR hp;
        char    buf[40];
  
        sprintf(buf, "%d", i++);
        hp = GET_MACRO(buf);
        Pop_macro(hp);
        FREE(hp->ht_name);
        if(hp->ht_value) FREE(hp->ht_value);
        FREE(hp);
     }
--- 175,225 ----
     }
  
     return(DmStrDup(LastMacName));
  }
  
  
  static char *
  _exec_echo(data)
  char *data;
  {
     return(DmStrDup(DmStrSpn(data," \t")));
  }
  
  
  static char *
  _exec_call( var, list )
  char *var;
  char *list;
  {
     char *res = NIL(char);
     char *s;
     TKSTR tk;
     int   i=0;
  
     list = Expand(list);
! 
     SET_TOKEN(&tk,list);
     while( *(s=Get_token(&tk, "", FALSE)) != '\0' ) {
        char  buf[40];
  
        sprintf(buf, "%d", i++);
        Def_macro(buf,s,M_MULTI|M_NOEXPORT|M_FORCE|M_PUSH);
     }
     CLEAR_TOKEN(&tk);
  
     var = DmStrJoin(DmStrJoin("$(",var,-1,FALSE),")",-1,TRUE);
     res = Expand(var);
  
     i=0;
     SET_TOKEN(&tk,list);
     while( *(s=Get_token(&tk, "", FALSE)) != '\0' ) {
        HASHPTR hp;
        char    buf[40];
  
        sprintf(buf, "%d", i++);
        hp = GET_MACRO(buf);
        Pop_macro(hp);
        FREE(hp->ht_name);
        if(hp->ht_value) FREE(hp->ht_value);
        FREE(hp);
     }
***************
*** 291,341 ****
        Get_temp( &newtmp, "", FALSE ); FREE(newtmp);
        tmpname = Expand(file);
  
        if( *tmpname ) {
  	 if( (tmpfile = fopen(tmpname, "w")) == NIL(FILE) )
  	    Open_temp_error( tmpname, name );
  
  	 Def_macro("TMPFILE", tmpname, M_EXPANDED|M_MULTI);
  	 Link_temp( Current_target, tmpfile, tmpname );
        }
        else
  	 FREE(tmpname);
     }
  
     if( !tmpfile )
        tmpfile = Start_temp( "", Current_target, &tmpname );
  
     if( !text || !*text ) text = tmpname;
     data = Expand(DmStrSpn(data, " \t\n"));
  
     for(p=strchr(data,'\n'); p; p=strchr(p,'\n')) {
        char *q = DmStrSpn(++p," \t");
        strcpy(p,q);
     }
  
!    Append_line( data, FALSE, tmpfile, name, FALSE, TRUE );
     Close_temp( Current_target, tmpfile );
     FREE(data);
  
     return( Expand(text) );
  }
  
  
  static char *
  _exec_iseq( lhs, rhs, data, eq )
  char *lhs;
  char *rhs;
  char *data;
  int  eq;
  {
     char *l = Expand(lhs);
     char *r = Expand(rhs);
     char *i = DmStrSpn(data, " \t\n");
     char *e = strchr(i, ' ');
     char *res = NIL(char);
     int  val = strcmp(l,r);
  
     if( (!val && eq) || (val && !eq) ) {
        if( e != NIL(char) ) *e = '\0';
        res = Expand(i);
     }
--- 291,343 ----
        Get_temp( &newtmp, "", FALSE ); FREE(newtmp);
        tmpname = Expand(file);
  
        if( *tmpname ) {
  	 if( (tmpfile = fopen(tmpname, "w")) == NIL(FILE) )
  	    Open_temp_error( tmpname, name );
  
  	 Def_macro("TMPFILE", tmpname, M_EXPANDED|M_MULTI);
  	 Link_temp( Current_target, tmpfile, tmpname );
        }
        else
  	 FREE(tmpname);
     }
  
     if( !tmpfile )
        tmpfile = Start_temp( "", Current_target, &tmpname );
  
     if( !text || !*text ) text = tmpname;
     data = Expand(DmStrSpn(data, " \t\n"));
  
     for(p=strchr(data,'\n'); p; p=strchr(p,'\n')) {
        char *q = DmStrSpn(++p," \t");
        strcpy(p,q);
     }
  
! /* do not map escape sequences while writing a tmpfile */
! /*  Append_line( data, FALSE, tmpfile, name, FALSE, TRUE ); */
!    Append_line( data, FALSE, tmpfile, name, FALSE, FALSE );
     Close_temp( Current_target, tmpfile );
     FREE(data);
  
     return( Expand(text) );
  }
  
  
  static char *
  _exec_iseq( lhs, rhs, data, eq )
  char *lhs;
  char *rhs;
  char *data;
  int  eq;
  {
     char *l = Expand(lhs);
     char *r = Expand(rhs);
     char *i = DmStrSpn(data, " \t\n");
     char *e = strchr(i, ' ');
     char *res = NIL(char);
     int  val = strcmp(l,r);
  
     if( (!val && eq) || (val && !eq) ) {
        if( e != NIL(char) ) *e = '\0';
        res = Expand(i);
     }
***************
*** 573,623 ****
     return(!arg);
  }
  
  
  static int
  nop (arg)
  int arg;
  {
     return(arg);
  }
  
  
  static char *
  _exec_andor( args, doand )
  char *args;
  int  doand;
  {
     char *next;
     char *p;
     char *white = " \t\n";
     int  res=doand;
  
     args = DmStrSpn(args,white);
     do {
        p=ScanToken(args, &next, TRUE);
!       
        if (doand ? !*p : *p) {
           res = !doand;
           FREE(p);
           break;
        }
  
        FREE(p);
     }
     while (*(args=DmStrSpn(next,white)));
!  
     return(res ? DmStrDup("t") : DmStrDup(""));
  }
  
  
  static char *
  _exec_not( args )
  char *args;
  {
     char *white = " \t\n";
     char *p=Expand(args);
     int  res = (*DmStrSpn(p,white) == '\0');
  
     FREE(p);
     return(res ? DmStrDup("t") : DmStrDup(""));
  }
--- 575,625 ----
     return(!arg);
  }
  
  
  static int
  nop (arg)
  int arg;
  {
     return(arg);
  }
  
  
  static char *
  _exec_andor( args, doand )
  char *args;
  int  doand;
  {
     char *next;
     char *p;
     char *white = " \t\n";
     int  res=doand;
  
     args = DmStrSpn(args,white);
     do {
        p=ScanToken(args, &next, TRUE);
! 
        if (doand ? !*p : *p) {
           res = !doand;
           FREE(p);
           break;
        }
  
        FREE(p);
     }
     while (*(args=DmStrSpn(next,white)));
! 
     return(res ? DmStrDup("t") : DmStrDup(""));
  }
  
  
  static char *
  _exec_not( args )
  char *args;
  {
     char *white = " \t\n";
     char *p=Expand(args);
     int  res = (*DmStrSpn(p,white) == '\0');
  
     FREE(p);
     return(res ? DmStrDup("t") : DmStrDup(""));
  }
