
#include "app_string.hh"
#include "error.h"
#include "error_messages.hh"

void unknown_key(int & num, PspellErrorExtraInfo * &,
		 PspellAppendableString & mesg, 
		 const char * key) 
{
  num = PERROR_UNKNOWN_KEY;
  mesg += "The key \"";
  mesg += key;
  mesg += "\" is not known";
}

void cant_change_value(int & num, PspellErrorExtraInfo * &,
		       PspellAppendableString & mesg, 
		       const char * key) 
{
  num = PERROR_CANT_CHANGE_VALUE;
  mesg += "Sorry, the value of option \"";
  mesg += key;
  mesg += "\" can not be changes.";
}

void bad_key(int & num, PspellErrorExtraInfo * &,
	     PspellAppendableString & mesg, 
	     const char * key,
	     const char * accepted_value)
{
  num = PERROR_BAD_VALUE;
  mesg += "The key \"";
  mesg += key;
  mesg += "\" is not ";
  mesg += accepted_value;
  mesg += " and is thus invalid.";
}

void bad_value(int & num, PspellErrorExtraInfo * &,
	       PspellAppendableString & mesg, 
	       const char * key, const char * value, 
	       const char * accepted_value)
{
  num = PERROR_BAD_VALUE;
  mesg += "The value \"";
  mesg += value;
  mesg += "\" is not ";
  mesg += accepted_value;
  mesg += " and is thus invalid for the key \"";
  mesg += key;
  mesg += "\".";
}

void list_set(int & num, PspellErrorExtraInfo * & extra,
	      PspellAppendableString & mesg, 
	      const char * key)
{
  num = PERROR_LIST_SET;
  mesg += "The value type of the key \"";
  mesg += key;
  mesg += "\" is a list and can not be set directory.";
}


void duplicate(int & num, PspellErrorExtraInfo * & extra,
	       PspellAppendableString & mesg, 
	       const char * what,
	       const char * value)
{
  num = PERROR_DUPLICATE;
  mesg += "The ";
  mesg += what;
  mesg += " \"";
  mesg += value;
  mesg += "\" is already defined.";
}


void cant_read_file(int & num, PspellErrorExtraInfo * & extra,
		    PspellAppendableString & mesg, const char * file)
{
  num = PERROR_CANT_READ_FILE;
  mesg += "Sorry, I can't read the file \"";
  mesg += file;
  mesg += "\".";
}

void cant_write_file(int & num, PspellErrorExtraInfo * & extra,
		     PspellAppendableString & mesg, const char * file)
{
  num = PERROR_CANT_WRITE_FILE;
  mesg += "Sorry, I can't write to the file \"";
  mesg += file;
  mesg += "\".";
}


void bad_file_format(int & num, 
		     PspellErrorExtraInfo * & extra,
		     PspellAppendableString & mesg, 
		     const char * file,
		     const char * info)
{
  num = PERROR_BAD_FILE_FORMAT;
  if (info[0] == '\0') {
    mesg += "The file \"";
    mesg += file;
    mesg += "\" is not in the proper format.";
  } else {
    mesg += file;
    mesg += ": ";
    mesg += info;
  }
}


void unknown_language(int & num, PspellErrorExtraInfo * & extra,
		      PspellAppendableString & mesg,
		      const char * language) 
{
  num = PERROR_UNKNOWN_LANGUAGE;
  mesg += "The language code \"";
  mesg += language;
  mesg += "\" is not known.";
}

void unknown_region(int & num, PspellErrorExtraInfo * & extra,
		    PspellAppendableString & mesg,
		    const char * region)
{
  num = PERROR_UNKNOWN_REGION;
  mesg += "The region code \"";
  mesg += region;
  mesg += "\" is not known.";
}

void unknown_encoding(int & num, PspellErrorExtraInfo * & extra,
		      PspellAppendableString & mesg,
		      const char * encoding)
{
  num = PERROR_UNKNOWN_ENCODING;
  mesg += "The encoding \"";
  mesg += encoding;
  mesg += "\" is not known.";
}

void operation_not_supported(int & num, PspellErrorExtraInfo * & extra,
			     PspellAppendableString & mesg, 
			     const char * operation)
{
  num = PERROR_OPERATION_NOT_SUPPORTED;
  mesg += "The operation \"";
  mesg += operation;
  mesg += "\" is currently unsupported.";
}

void process_died(int & num, PspellErrorExtraInfo * & extra,
		  PspellAppendableString & mesg, 
		  const char * program)
{
  num = PERROR_PROCESS_DIED;
  mesg += "I'm sorry, for some reason the \"";
  mesg += program;
  mesg += "\" process died.";
}

void cant_load_module(int & num, PspellErrorExtraInfo * & extra,
		      PspellAppendableString & mesg, 
		      const char * module)
{
  num = PERROR_OTHER;
  mesg += "Unable to load the \"";
  mesg += module;
  mesg += "\" module.";
}
