*** orig/win32_65/inc/pgpOptionList.h	Wed Aug 30 12:08:30 2000
--- modified/win32_65/inc/pgpOptionList.h	Wed Aug 30 12:08:30 2000
***************
*** 1,51 ****
  /*____________________________________________________________________________
  	pgpOptionList.h
  	
  	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
  	All rights reserved.
  	
  	This file contains the types and prototypes for functions which manipulate
  	PGPOptionList data structures.
  
! 	$Id: pgpOptionList.h,v 1.35 1999/05/07 23:47:46 hal Exp $
  ____________________________________________________________________________*/
  
  #ifndef Included_pgpOptionList_h	/* [ */
  #define Included_pgpOptionList_h
  
  #include <stdarg.h>
  
  #include "pgpPubTypes.h"
  
  #if PGP_MACINTOSH
  #include <Files.h>
  #endif
  
  /* Standard event callback declaration */
  struct PGPEvent;
! typedef PGPError (*PGPEventHandlerProcPtr)(PGPContextRef context,
  						struct PGPEvent *event, PGPUserValue userValue);
  
  /* Export formats for exporting functions */
  enum PGPExportFormat_
  {
  	kPGPExportFormat_Basic				= 1,
  	kPGPExportFormat_Complete			= 255,
  	
  	kPGPExportFormat_X509Cert			= 10000,
  
  	kPGPExportFormat_X509CertReq		= 11000,
  	kPGPExportFormat_NetToolsCAV1_CertReq,
  	kPGPExportFormat_VerisignV1_CertReq,
  	kPGPExportFormat_EntrustV1_CertReq,
  
  	/* Deprecated aliases for three above */
  /*	kPGPExportFormat_NetToolsCAV1 = 11001,
  	kPGPExportFormat_VerisignV1,
  	kPGPExportFormat_EntrustV1,
  */	
  	kPGPExportFormat_X509GetCertInitial	= 11010,
  	kPGPExportFormat_NetToolsCAV1_GetCertInitial,
  	kPGPExportFormat_VerisignV1_GetCertInitial,
  	kPGPExportFormat_EntrustV1_GetCertInitial,
  	
--- 1,51 ----
  /*____________________________________________________________________________
  	pgpOptionList.h
  	
  	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
  	All rights reserved.
  	
  	This file contains the types and prototypes for functions which manipulate
  	PGPOptionList data structures.
  
! 	$Id: pgpOptionList.h,v 1.1 2000/07/28 15:58:02 mhu Exp $
  ____________________________________________________________________________*/
  
  #ifndef Included_pgpOptionList_h	/* [ */
  #define Included_pgpOptionList_h
  
  #include <stdarg.h>
  
  #include "pgpPubTypes.h"
  
  #if PGP_MACINTOSH
  #include <Files.h>
  #endif
  
  /* Standard event callback declaration */
  struct PGPEvent;
! typedef PGPError (PGPAPI *PGPEventHandlerProcPtr)(PGPContextRef context,
  						struct PGPEvent *event, PGPUserValue userValue);
  
  /* Export formats for exporting functions */
  enum PGPExportFormat_
  {
  	kPGPExportFormat_Basic				= 1,
  	kPGPExportFormat_Complete			= 255,
  	
  	kPGPExportFormat_X509Cert			= 10000,
  
  	kPGPExportFormat_X509CertReq		= 11000,
  	kPGPExportFormat_NetToolsCAV1_CertReq,
  	kPGPExportFormat_VerisignV1_CertReq,
  	kPGPExportFormat_EntrustV1_CertReq,
  
  	/* Deprecated aliases for three above */
  /*	kPGPExportFormat_NetToolsCAV1 = 11001,
  	kPGPExportFormat_VerisignV1,
  	kPGPExportFormat_EntrustV1,
  */	
  	kPGPExportFormat_X509GetCertInitial	= 11010,
  	kPGPExportFormat_NetToolsCAV1_GetCertInitial,
  	kPGPExportFormat_VerisignV1_GetCertInitial,
  	kPGPExportFormat_EntrustV1_GetCertInitial,
  	
***************
*** 180,452 ****
  	kPGPAVAttributeFirstNumber = 2000,
  
  	PGP_ENUM_FORCE( PGPAVAttribute_ )
  } ;
  PGPENUM_TYPEDEF( PGPAVAttribute_, PGPAVAttribute );
  
  typedef struct PGPAttributeValue {
  	PGPAVAttribute    attribute;
  	PGPSize             size;
  	union {
  		PGPBoolean  booleanvalue;
  		PGPUInt32   longvalue;
  		void       *pointervalue;
  	}                   value;          
  	PGPUInt32           unused;
  } PGPAttributeValue ;
  
  
  
  PGP_BEGIN_C_DECLARATIONS
  
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import on
  #endif
  
! PGPError	PGPNewOptionList(PGPContextRef context,
  					PGPOptionListRef *outList);
! PGPError 	PGPAppendOptionList(PGPOptionListRef optionList,
  					PGPOptionListRef firstOption, ...);
! PGPError 	PGPBuildOptionList( PGPContextRef context,
  					PGPOptionListRef *outList,
  					PGPOptionListRef firstOption, ...);
! PGPError	PGPCopyOptionList(PGPOptionListRef optionList,
  					PGPOptionListRef *outList );
! PGPError 	PGPFreeOptionList(PGPOptionListRef optionList);
  
  /*
  **	The following functions are used to create PGPOptionListRef's for
  **	specifying the various options to several SDK functions. The
  **	functions can be used as inline parameters in a temporary manner or
  **	used with PGPBuildOptionList() to create persistent lists.
  */
  
  /*
  ** Special PGPOptionListRef to mark last option passed to those functions
  ** which take variable lists of PGPOptionListRef's:
  */
  
! PGPOptionListRef 		PGPOLastOption( PGPContextRef context );
  
  /*
  ** Special PGPOptionListRef which is always ignored:
  */
  
! PGPOptionListRef 		PGPONullOption( PGPContextRef context);
  
  /* Data input (required): */
  
! PGPOptionListRef 		PGPOInputFile( PGPContextRef context,
  							PGPFileSpecRef fileRef);
! PGPOptionListRef 		PGPOInputBuffer( PGPContextRef context,
  							void const *buffer, PGPSize bufferSize);
  #if PGP_MACINTOSH
! PGPOptionListRef 		PGPOInputFileFSSpec( PGPContextRef context,
  							const FSSpec *fileSpec);
  #endif
  	
  /* Data output (optional, generates event if missing): */
  
! PGPOptionListRef 		PGPOOutputFile( PGPContextRef context,
  							PGPFileSpecRef fileRef);
! PGPOptionListRef 		PGPOOutputBuffer( PGPContextRef context,
  							void *buffer, PGPSize bufferSize,
  							PGPSize *outputDataLength);
  #if PGP_MACINTOSH
! PGPOptionListRef 		PGPOOutputFileFSSpec( PGPContextRef context,
  							const FSSpec *fileSpec);
  #endif
  
  /* '*buffer' must be disposed of via PGPFreeData() */
  /* maximum memory usage will be no more than maximumBufferSize */
! PGPOptionListRef 		PGPOAllocatedOutputBuffer(PGPContextRef context,
  							void **buffer,
  							PGPSize maximumBufferSize,
  							PGPSize *actualBufferSize);
! PGPOptionListRef 		PGPOAppendOutput( PGPContextRef context,
  							PGPBoolean appendOutput );
! PGPOptionListRef 		PGPODiscardOutput( PGPContextRef context,
  							PGPBoolean discardOutput );
  
  /* Encrypting and signing */
  
! PGPOptionListRef 		PGPOEncryptToKey( PGPContextRef context,
  							PGPKeyRef keyRef);
! PGPOptionListRef 		PGPOEncryptToKeySet( PGPContextRef context,
  							PGPKeySetRef keySetRef);
! PGPOptionListRef 		PGPOEncryptToUserID( PGPContextRef context,
  							PGPUserIDRef userIDRef);
! PGPOptionListRef 		PGPOSignWithKey( PGPContextRef context,
  							PGPKeyRef keyRef,
  							PGPOptionListRef firstOption, ...);
! PGPOptionListRef 		PGPOConventionalEncrypt( PGPContextRef context,
  							PGPOptionListRef firstOption,
  								...);
  
! PGPOptionListRef 		PGPOPassphraseBuffer( PGPContextRef context,
  							const void *passphrase, PGPSize passphraseLength);
! PGPOptionListRef 		PGPOPassphrase( PGPContextRef context,
  							const char *passphrase);
! PGPOptionListRef 		PGPOPasskeyBuffer( PGPContextRef context,
  							const void *passkey, PGPSize passkeyLength);
! PGPOptionListRef 		PGPOSessionKey( PGPContextRef context,
  							const void *sessionKey, PGPSize sessionKeyLength);
! PGPOptionListRef 		PGPOAskUserForEntropy( PGPContextRef context,
  							PGPBoolean askUserForEntropy );
! PGPOptionListRef 		PGPORawPGPInput( PGPContextRef context,
  							PGPBoolean rawPGPInput );
! PGPOptionListRef 		PGPOCompression( PGPContextRef context,
  							PGPBoolean compression );
  
! PGPOptionListRef		PGPOLocalEncoding( PGPContextRef context,
  							PGPLocalEncodingFlags localEncode);
! PGPOptionListRef		PGPOOutputLineEndType(PGPContextRef context,
  							PGPLineEndType lineEnd);
! PGPOptionListRef		PGPOPGPMIMEEncoding(PGPContextRef context,
  							PGPBoolean mimeEncoding, PGPSize *mimeBodyOffset,
  							char mimeSeparator[ kPGPMimeSeparatorSize ]);
! PGPOptionListRef		PGPOOmitMIMEVersion( PGPContextRef context,
  							PGPBoolean omitVersion);
! PGPOptionListRef		PGPOX509Encoding( PGPContextRef context,
  							PGPBoolean x509Encoding);
  							
! PGPOptionListRef 		PGPODetachedSig( PGPContextRef context,
  							PGPOptionListRef firstOption,
  								...);
  
! PGPOptionListRef 		PGPOCipherAlgorithm( PGPContextRef context,
  							PGPCipherAlgorithm algorithm);
! PGPOptionListRef 		PGPOHashAlgorithm( PGPContextRef context,
  							PGPHashAlgorithm algorithm);
  
! PGPOptionListRef 		PGPOFailBelowValidity( PGPContextRef context,
  							PGPValidity minValidity);
! PGPOptionListRef 		PGPOWarnBelowValidity( PGPContextRef context,
  							PGPValidity minValidity);
  
  
! PGPOptionListRef 		PGPOEventHandler( PGPContextRef context,
  							PGPEventHandlerProcPtr eventHandler,
  								PGPUserValue eventHandlerData);
! PGPOptionListRef 		PGPOSendNullEvents( PGPContextRef context,
  							PGPTimeInterval approxInterval);
  	
! PGPOptionListRef 		PGPOArmorOutput( PGPContextRef context,
  							PGPBoolean armorOutput );
! PGPOptionListRef 		PGPODataIsASCII( PGPContextRef context,
  							PGPBoolean dataIsASCII );
! PGPOptionListRef 		PGPOClearSign( PGPContextRef context,
  							PGPBoolean clearSign );
! PGPOptionListRef 		PGPOForYourEyesOnly( PGPContextRef context,
  							PGPBoolean forYourEyesOnly );
! PGPOptionListRef 		PGPOKeySetRef( PGPContextRef context,
  							PGPKeySetRef keysetRef);
  
! PGPOptionListRef 		PGPOExportKeySet( PGPContextRef context,
  							PGPKeySetRef keysetRef);
! PGPOptionListRef 		PGPOExportKey( PGPContextRef context,
  							PGPKeyRef keyRef);
! PGPOptionListRef 		PGPOExportUserID( PGPContextRef context,
  							PGPUserIDRef useridRef);
! PGPOptionListRef 		PGPOExportSig( PGPContextRef context,
  							PGPSigRef sigRef);
  
! PGPOptionListRef 		PGPOImportKeysTo( PGPContextRef context,
  							PGPKeySetRef keysetRef);
! PGPOptionListRef 		PGPOSendEventIfKeyFound( PGPContextRef context,
  							PGPBoolean sendEventIfKeyFound );
! PGPOptionListRef 		PGPOPassThroughIfUnrecognized( PGPContextRef context,
  							PGPBoolean passThroughIfUnrecognized );
! PGPOptionListRef 		PGPOPassThroughClearSigned( PGPContextRef context,
  							PGPBoolean passThroughClearSigned );
! PGPOptionListRef 		PGPOPassThroughKeys( PGPContextRef context,
  							PGPBoolean passThroughKeys );
! PGPOptionListRef 		PGPORecursivelyDecode( PGPContextRef context,
  							PGPBoolean recurse );
  
! PGPOptionListRef		PGPOKeyGenParams( PGPContextRef context,
  							PGPPublicKeyAlgorithm pubKeyAlg,
  							PGPUInt32 bits);
  								
! PGPOptionListRef		PGPOKeyGenName( PGPContextRef context,
  							const void *name, PGPSize nameLength);
  							
! PGPOptionListRef		PGPOCreationDate( PGPContextRef context,
  							PGPTime creationDate);
! PGPOptionListRef		PGPOExpiration( PGPContextRef context,
  							PGPUInt32 expirationDays);
  							
! PGPOptionListRef		PGPOAdditionalRecipientRequestKeySet(
  							PGPContextRef context, 
  							PGPKeySetRef arKeySetRef, PGPByte arkClass);
  								
! PGPOptionListRef		PGPORevocationKeySet(PGPContextRef	context,
  							PGPKeySetRef raKeySetRef);
  
! PGPOptionListRef		PGPOKeyGenMasterKey( PGPContextRef context,
  							PGPKeyRef masterKeyRef);
  							
! PGPOptionListRef		PGPOPreferredAlgorithms(
  							PGPContextRef context, 
  							PGPCipherAlgorithm const *prefAlg,
  							PGPUInt32 numAlgs);
  								
! PGPOptionListRef		PGPOKeyGenFast( PGPContextRef context,
  							PGPBoolean fastGen);
  							
! PGPOptionListRef		PGPOKeyGenUseExistingEntropy( PGPContextRef context,
  							PGPBoolean useExistingEntropy);
  							
! PGPOptionListRef		PGPOCommentString( PGPContextRef context,
  							char const *comment);
  
! PGPOptionListRef		PGPOVersionString( PGPContextRef context,
  							char const *version);
  							
! PGPOptionListRef		PGPOFileNameString( PGPContextRef context,
  							char const *fileName);
  							
! PGPOptionListRef		PGPOSigRegularExpression(PGPContextRef context,
  							char const *regularExpression);
  							
! PGPOptionListRef		PGPOExportPrivateKeys( PGPContextRef context,
  							PGPBoolean exportKeys);
  							
! PGPOptionListRef		PGPOExportPrivateSubkeys( PGPContextRef context,
  							PGPBoolean exportSubkeys);
  							
! PGPOptionListRef		PGPOExportFormat(PGPContextRef context,
  							PGPExportFormat exportFormat);
  
! PGPOptionListRef		PGPOExportable( PGPContextRef context,
  							PGPBoolean exportable);
  							
! PGPOptionListRef		PGPOSigTrust( PGPContextRef context,
  							PGPUInt32 trustLevel,
  							PGPUInt32 trustValue);
  
! PGPOptionListRef		PGPOInputFormat( PGPContextRef context,
  							PGPInputFormat inputFormat );
  
! PGPOptionListRef		PGPOOutputFormat( PGPContextRef context,
  							PGPOutputFormat outputFormat );
  
! PGPOptionListRef		PGPOAttributeValue( PGPContextRef context,
  							PGPAttributeValue *attributeValue,
  							PGPUInt32 attributeValueCount);
  
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import reset
  #endif
  	
  PGP_END_C_DECLARATIONS
  
  #endif /* ] Included_pgpOptionList_h */
  
  /*__Editor_settings____
  
  	Local Variables:
  	tab-width: 4
  	End:
  	vi: ts=4 sw=4
  	vim: si
  _____________________*/
--- 180,452 ----
  	kPGPAVAttributeFirstNumber = 2000,
  
  	PGP_ENUM_FORCE( PGPAVAttribute_ )
  } ;
  PGPENUM_TYPEDEF( PGPAVAttribute_, PGPAVAttribute );
  
  typedef struct PGPAttributeValue {
  	PGPAVAttribute    attribute;
  	PGPSize             size;
  	union {
  		PGPBoolean  booleanvalue;
  		PGPUInt32   longvalue;
  		void       *pointervalue;
  	}                   value;          
  	PGPUInt32           unused;
  } PGPAttributeValue ;
  
  
  
  PGP_BEGIN_C_DECLARATIONS
  
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import on
  #endif
  
! PGPError	PGPAPI PGPNewOptionList(PGPContextRef context,
  					PGPOptionListRef *outList);
! PGPError 	PGPAPI PGPAppendOptionList(PGPOptionListRef optionList,
  					PGPOptionListRef firstOption, ...);
! PGPError 	PGPAPI PGPBuildOptionList( PGPContextRef context,
  					PGPOptionListRef *outList,
  					PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPCopyOptionList(PGPOptionListRef optionList,
  					PGPOptionListRef *outList );
! PGPError 	PGPAPI PGPFreeOptionList(PGPOptionListRef optionList);
  
  /*
  **	The following functions are used to create PGPOptionListRef's for
  **	specifying the various options to several SDK functions. The
  **	functions can be used as inline parameters in a temporary manner or
  **	used with PGPBuildOptionList() to create persistent lists.
  */
  
  /*
  ** Special PGPOptionListRef to mark last option passed to those functions
  ** which take variable lists of PGPOptionListRef's:
  */
  
! PGPOptionListRef PGPAPI PGPOLastOption( PGPContextRef context );
  
  /*
  ** Special PGPOptionListRef which is always ignored:
  */
  
! PGPOptionListRef PGPAPI PGPONullOption( PGPContextRef context);
  
  /* Data input (required): */
  
! PGPOptionListRef PGPAPI PGPOInputFile( PGPContextRef context,
  							PGPFileSpecRef fileRef);
! PGPOptionListRef PGPAPI PGPOInputBuffer( PGPContextRef context,
  							void const *buffer, PGPSize bufferSize);
  #if PGP_MACINTOSH
! PGPOptionListRef PGPAPI PGPOInputFileFSSpec( PGPContextRef context,
  							const FSSpec *fileSpec);
  #endif
  	
  /* Data output (optional, generates event if missing): */
  
! PGPOptionListRef PGPAPI PGPOOutputFile( PGPContextRef context,
  							PGPFileSpecRef fileRef);
! PGPOptionListRef PGPAPI PGPOOutputBuffer( PGPContextRef context,
  							void *buffer, PGPSize bufferSize,
  							PGPSize *outputDataLength);
  #if PGP_MACINTOSH
! PGPOptionListRef PGPAPI PGPOOutputFileFSSpec( PGPContextRef context,
  							const FSSpec *fileSpec);
  #endif
  
  /* '*buffer' must be disposed of via PGPFreeData() */
  /* maximum memory usage will be no more than maximumBufferSize */
! PGPOptionListRef PGPAPI PGPOAllocatedOutputBuffer(PGPContextRef context,
  							void **buffer,
  							PGPSize maximumBufferSize,
  							PGPSize *actualBufferSize);
! PGPOptionListRef PGPAPI PGPOAppendOutput( PGPContextRef context,
  							PGPBoolean appendOutput );
! PGPOptionListRef PGPAPI PGPODiscardOutput( PGPContextRef context,
  							PGPBoolean discardOutput );
  
  /* Encrypting and signing */
  
! PGPOptionListRef PGPAPI PGPOEncryptToKey( PGPContextRef context,
  							PGPKeyRef keyRef);
! PGPOptionListRef PGPAPI PGPOEncryptToKeySet( PGPContextRef context,
  							PGPKeySetRef keySetRef);
! PGPOptionListRef PGPAPI PGPOEncryptToUserID( PGPContextRef context,
  							PGPUserIDRef userIDRef);
! PGPOptionListRef PGPAPI PGPOSignWithKey( PGPContextRef context,
  							PGPKeyRef keyRef,
  							PGPOptionListRef firstOption, ...);
! PGPOptionListRef PGPAPI PGPOConventionalEncrypt( PGPContextRef context,
  							PGPOptionListRef firstOption,
  								...);
  
! PGPOptionListRef PGPAPI PGPOPassphraseBuffer( PGPContextRef context,
  							const void *passphrase, PGPSize passphraseLength);
! PGPOptionListRef PGPAPI PGPOPassphrase( PGPContextRef context,
  							const char *passphrase);
! PGPOptionListRef PGPAPI PGPOPasskeyBuffer( PGPContextRef context,
  							const void *passkey, PGPSize passkeyLength);
! PGPOptionListRef PGPAPI PGPOSessionKey( PGPContextRef context,
  							const void *sessionKey, PGPSize sessionKeyLength);
! PGPOptionListRef PGPAPI PGPOAskUserForEntropy( PGPContextRef context,
  							PGPBoolean askUserForEntropy );
! PGPOptionListRef PGPAPI PGPORawPGPInput( PGPContextRef context,
  							PGPBoolean rawPGPInput );
! PGPOptionListRef PGPAPI PGPOCompression( PGPContextRef context,
  							PGPBoolean compression );
  
! PGPOptionListRef PGPAPI PGPOLocalEncoding( PGPContextRef context,
  							PGPLocalEncodingFlags localEncode);
! PGPOptionListRef PGPAPI PGPOOutputLineEndType(PGPContextRef context,
  							PGPLineEndType lineEnd);
! PGPOptionListRef PGPAPI PGPOPGPMIMEEncoding(PGPContextRef context,
  							PGPBoolean mimeEncoding, PGPSize *mimeBodyOffset,
  							char mimeSeparator[ kPGPMimeSeparatorSize ]);
! PGPOptionListRef PGPAPI PGPOOmitMIMEVersion( PGPContextRef context,
  							PGPBoolean omitVersion);
! PGPOptionListRef PGPAPI PGPOX509Encoding( PGPContextRef context,
  							PGPBoolean x509Encoding);
  							
! PGPOptionListRef PGPAPI PGPODetachedSig( PGPContextRef context,
  							PGPOptionListRef firstOption,
  								...);
  
! PGPOptionListRef PGPAPI PGPOCipherAlgorithm( PGPContextRef context,
  							PGPCipherAlgorithm algorithm);
! PGPOptionListRef PGPAPI PGPOHashAlgorithm( PGPContextRef context,
  							PGPHashAlgorithm algorithm);
  
! PGPOptionListRef PGPAPI PGPOFailBelowValidity( PGPContextRef context,
  							PGPValidity minValidity);
! PGPOptionListRef PGPAPI PGPOWarnBelowValidity( PGPContextRef context,
  							PGPValidity minValidity);
  
  
! PGPOptionListRef PGPAPI PGPOEventHandler( PGPContextRef context,
  							PGPEventHandlerProcPtr eventHandler,
  								PGPUserValue eventHandlerData);
! PGPOptionListRef PGPAPI PGPOSendNullEvents( PGPContextRef context,
  							PGPTimeInterval approxInterval);
  	
! PGPOptionListRef PGPAPI PGPOArmorOutput( PGPContextRef context,
  							PGPBoolean armorOutput );
! PGPOptionListRef PGPAPI PGPODataIsASCII( PGPContextRef context,
  							PGPBoolean dataIsASCII );
! PGPOptionListRef PGPAPI PGPOClearSign( PGPContextRef context,
  							PGPBoolean clearSign );
! PGPOptionListRef PGPAPI PGPOForYourEyesOnly( PGPContextRef context,
  							PGPBoolean forYourEyesOnly );
! PGPOptionListRef PGPAPI PGPOKeySetRef( PGPContextRef context,
  							PGPKeySetRef keysetRef);
  
! PGPOptionListRef PGPAPI PGPOExportKeySet( PGPContextRef context,
  							PGPKeySetRef keysetRef);
! PGPOptionListRef PGPAPI PGPOExportKey( PGPContextRef context,
  							PGPKeyRef keyRef);
! PGPOptionListRef PGPAPI PGPOExportUserID( PGPContextRef context,
  							PGPUserIDRef useridRef);
! PGPOptionListRef PGPAPI PGPOExportSig( PGPContextRef context,
  							PGPSigRef sigRef);
  
! PGPOptionListRef PGPAPI PGPOImportKeysTo( PGPContextRef context,
  							PGPKeySetRef keysetRef);
! PGPOptionListRef PGPAPI PGPOSendEventIfKeyFound( PGPContextRef context,
  							PGPBoolean sendEventIfKeyFound );
! PGPOptionListRef PGPAPI PGPOPassThroughIfUnrecognized( PGPContextRef context,
  							PGPBoolean passThroughIfUnrecognized );
! PGPOptionListRef PGPAPI PGPOPassThroughClearSigned( PGPContextRef context,
  							PGPBoolean passThroughClearSigned );
! PGPOptionListRef PGPAPI PGPOPassThroughKeys( PGPContextRef context,
  							PGPBoolean passThroughKeys );
! PGPOptionListRef PGPAPI PGPORecursivelyDecode( PGPContextRef context,
  							PGPBoolean recurse );
  
! PGPOptionListRef PGPAPI PGPOKeyGenParams( PGPContextRef context,
  							PGPPublicKeyAlgorithm pubKeyAlg,
  							PGPUInt32 bits);
  								
! PGPOptionListRef PGPAPI PGPOKeyGenName( PGPContextRef context,
  							const void *name, PGPSize nameLength);
  							
! PGPOptionListRef PGPAPI PGPOCreationDate( PGPContextRef context,
  							PGPTime creationDate);
! PGPOptionListRef PGPAPI PGPOExpiration( PGPContextRef context,
  							PGPUInt32 expirationDays);
  							
! PGPOptionListRef PGPAPI PGPOAdditionalRecipientRequestKeySet(
  							PGPContextRef context, 
  							PGPKeySetRef arKeySetRef, PGPByte arkClass);
  								
! PGPOptionListRef PGPAPI PGPORevocationKeySet(PGPContextRef	context,
  							PGPKeySetRef raKeySetRef);
  
! PGPOptionListRef PGPAPI PGPOKeyGenMasterKey( PGPContextRef context,
  							PGPKeyRef masterKeyRef);
  							
! PGPOptionListRef PGPAPI PGPOPreferredAlgorithms(
  							PGPContextRef context, 
  							PGPCipherAlgorithm const *prefAlg,
  							PGPUInt32 numAlgs);
  								
! PGPOptionListRef PGPAPI PGPOKeyGenFast( PGPContextRef context,
  							PGPBoolean fastGen);
  							
! PGPOptionListRef PGPAPI PGPOKeyGenUseExistingEntropy( PGPContextRef context,
  							PGPBoolean useExistingEntropy);
  							
! PGPOptionListRef PGPAPI PGPOCommentString( PGPContextRef context,
  							char const *comment);
  
! PGPOptionListRef PGPAPI PGPOVersionString( PGPContextRef context,
  							char const *version);
  							
! PGPOptionListRef PGPAPI PGPOFileNameString( PGPContextRef context,
  							char const *fileName);
  							
! PGPOptionListRef PGPAPI PGPOSigRegularExpression(PGPContextRef context,
  							char const *regularExpression);
  							
! PGPOptionListRef PGPAPI PGPOExportPrivateKeys( PGPContextRef context,
  							PGPBoolean exportKeys);
  							
! PGPOptionListRef PGPAPI PGPOExportPrivateSubkeys( PGPContextRef context,
  							PGPBoolean exportSubkeys);
  							
! PGPOptionListRef PGPAPI PGPOExportFormat(PGPContextRef context,
  							PGPExportFormat exportFormat);
  
! PGPOptionListRef PGPAPI PGPOExportable( PGPContextRef context,
  							PGPBoolean exportable);
  							
! PGPOptionListRef PGPAPI PGPOSigTrust( PGPContextRef context,
  							PGPUInt32 trustLevel,
  							PGPUInt32 trustValue);
  
! PGPOptionListRef PGPAPI PGPOInputFormat( PGPContextRef context,
  							PGPInputFormat inputFormat );
  
! PGPOptionListRef PGPAPI PGPOOutputFormat( PGPContextRef context,
  							PGPOutputFormat outputFormat );
  
! PGPOptionListRef PGPAPI PGPOAttributeValue( PGPContextRef context,
  							PGPAttributeValue *attributeValue,
  							PGPUInt32 attributeValueCount);
  
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import reset
  #endif
  	
  PGP_END_C_DECLARATIONS
  
  #endif /* ] Included_pgpOptionList_h */
  
  /*__Editor_settings____
  
  	Local Variables:
  	tab-width: 4
  	End:
  	vi: ts=4 sw=4
  	vim: si
  _____________________*/
