/*************************************************************************
 *
 *  $RCSfile: unoedsrc.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: cl $ $Date: 2001/08/28 12:35:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVX_UNOEDSRC_HXX
#define _SVX_UNOEDSRC_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _SV_COLOR_HXX //autogen
#include <vcl/color.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif

struct ESelection;
class String;
class SfxItemSet;
class SvUShorts;
class SvxTextForwarder;
class SvxFieldItem;

//	SvxEditSource - Hilfsklasse, um eine EditEngine aus einer Zelle,
//					Notiz oder Seitenvorlage zu fuellen

class SvxEditSource
{
public:
							SvxEditSource();
	virtual					~SvxEditSource();

	virtual SvxEditSource*		Clone() const = 0;
	virtual SvxTextForwarder*	GetTextForwarder() = 0;
	virtual void				UpdateData() = 0;
};

//	SvxTextForwarder - enthaelt eine EditEngine oder einen Outliner und
//					   bietet die gemeinsamen Methoden an
//	Die EditEngine-Uno-Objekte rufen nur Methoden dieser Klasse.

class SvxTextForwarder
{
public:
						SvxTextForwarder();
	virtual				~SvxTextForwarder();

	virtual USHORT		GetParagraphCount() const = 0;
	virtual USHORT		GetTextLen( USHORT nParagraph ) const = 0;
	virtual String		GetText( const ESelection& rSel ) const = 0;
	virtual SfxItemSet	GetAttribs( const ESelection& rSel, BOOL bOnlyHardAttrib = 0 ) const = 0;
	virtual	SfxItemSet  GetParaAttribs( USHORT nPara ) const = 0;
	virtual void		SetParaAttribs( USHORT nPara, const SfxItemSet& rSet ) = 0;
	virtual void		GetPortions( USHORT nPara, SvUShorts& rList ) const = 0;

	virtual USHORT		GetItemState( const ESelection& rSel, USHORT nWhich ) const = 0;
	virtual USHORT		GetItemState( USHORT nPara, USHORT nWhich ) const = 0;

	virtual void		QuickInsertText( const String& rText, const ESelection& rSel ) = 0;
	virtual void		QuickInsertField( const SvxFieldItem& rFld, const ESelection& rSel ) = 0;
	virtual void		QuickSetAttribs( const SfxItemSet& rSet, const ESelection& rSel ) = 0;
	virtual void		QuickInsertLineBreak( const ESelection& rSel ) = 0;

	virtual XubString    CalcFieldValue( const SvxFieldItem& rField, USHORT nPara, USHORT nPos, Color*& rpTxtColor, Color*& rpFldColor ) = 0;

	virtual SfxItemPool* GetPool() const = 0;

	virtual BOOL		IsValid() const = 0;
};

#endif

