/*************************************************************************
 *
 *  $RCSfile: frmdiritem.hxx,v $
 *
 *  $Revision: 1.1.4.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 12:57:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_FRMDIRITEM_HXX
#define _SVX_FRMDIRITEM_HXX

// include ---------------------------------------------------------------

#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif

// class SvxFrameDirectionItem ----------------------------------------------

/* [Description]

	This item defines a frame direction, which place the content inside
	a frame. It exist different kind of directions which are used to the
	layout text for Western, CJK and CTL languages.
*/

enum SvxFrameDirection
{
	FRMDIR_HORI_LEFT_TOP,		// horizontal, from left to right, from top to bottom
								// typical for western languages
	FRMDIR_HORI_RIGHT_TOP,		// horizontal, from right to left, from top to bottom
								// typical for ararbic/hebrew languages
	FRMDIR_VERT_TOP_RIGHT,		// vertical, from top to bottom, from right to left
								// typical for asian languages
	FRMDIR_VERT_TOP_LEFT,		// vertical, from top to bottom, from left to right
								// typical for mongol language
	FRMDIR_ENVIRONMENT			// use the value from the environment, can only
								// be used in frames.
};

class SvxFrameDirectionItem : public SfxUInt16Item
{
public:
	TYPEINFO();

	SvxFrameDirectionItem( SvxFrameDirection nValue = FRMDIR_HORI_LEFT_TOP,
							USHORT nWhich = ITEMID_FRAMEDIR );
	virtual ~SvxFrameDirectionItem();

	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const;
	virtual SfxPoolItem*	Create(SvStream &, USHORT) const;
	virtual SvStream& 		Store(SvStream & rStrm, USHORT nIVer) const;
	virtual USHORT			GetVersion( USHORT nFileVersion ) const;
	virtual int 			operator==( const SfxPoolItem& ) const;

	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									String &rText,
                                    const IntlWrapper * = 0 ) const;

	virtual sal_Bool PutValue( const com::sun::star::uno::Any& rVal,
									BYTE nMemberId );
	virtual sal_Bool QueryValue( com::sun::star::uno::Any& rVal,
								BYTE nMemberId ) const;

	inline SvxFrameDirectionItem& operator=( const SvxFrameDirectionItem& rItem )
	{
		SetValue( rItem.GetValue() );
		return *this;
	}
};

#endif // #ifndef _SVX_FRMDIRITEM_HXX

