/*************************************************************************
 *
 *  $RCSfile: b2dmtri.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:30:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _B2D_MTRI_HXX
#define _B2D_MTRI_HXX

#ifndef _B2D_MBASE_HXX
#include <goodies/b2dmbase.hxx>
#endif

//************************************************************
//   InterActionObjectTriangle
//************************************************************

class B2dIAOTriangle : public B2dIAObject
{
	// 2nd and 3rd Position of this IAO (logic and pixel)
	B2dPositionEntity			a2ndPosition;
	B2dPositionEntity			a3rdPosition;

	// Create the Geometry - this is the pixel creator
	virtual void CreateGeometry();

	// Create the BaseRect
	virtual void CreateBaseRect();

	// internal help procedures
	BOOL SimpleCrossTestCut(const Point& rPos, const Point& rStart, const Point& rEnd) const;

protected:
	// Access to 2nd and 3rd Position
	const Point& Get2ndPositionPixel() const { return a2ndPosition.GetPositionPixel(); }
	const Point& Get3rdPositionPixel() const { return a3rdPosition.GetPositionPixel(); }

public:
    TYPEINFO();
	B2dIAOTriangle(B2dIAOManager* pMan, Point aEdge1, Point aEdge2, Point aEdge3, Color aCol = Color(COL_WHITE));
	virtual ~B2dIAOTriangle();

	// Access to 2nd and 3rd Position
	const Point& Get2ndPosition() const { return a2ndPosition.GetPosition(); }
	const Point& Get3rdPosition() const { return a3rdPosition.GetPosition(); }
	void Set2ndPosition(Point aNew);
	void Set3rdPosition(Point aNew);

	// Hittest
	virtual BOOL IsHit(const Point& rPixelPos, UINT16 nTol = 0) const;
};

//************************************************************
//   InterActionObjectBitmapTriangle
//************************************************************

class B2dIAOBitmapTriangle : public B2dIAOTriangle
{
	// BitmapEx containing real graphic
	BitmapEx					aBmpEx;

	// accesses to buffer bitmaps
	BitmapWriteAccess*			aBmpWrite;
	BitmapWriteAccess*			aMaskWrite;

	// remember TopLeft
	Point						aTopLeft;

	// Create the Geometry - this is the pixel creator
	virtual void CreateGeometry();

protected:
	// special pixel creation
	virtual BOOL AddTrianglePixel(const Point& rPos);

public:
    TYPEINFO();
	B2dIAOBitmapTriangle(B2dIAOManager* pMan, Point aEdge1, Point aEdge2, Point aEdge3, Color aCol = Color(COL_WHITE));
	virtual ~B2dIAOBitmapTriangle();
};

#endif          // _B2D_MTRI_HXX
