/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.helper;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Validator
extends HandlerBase {
    private static Writer out;

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: cmd filename");
            System.exit(1);
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            out = new OutputStreamWriter((OutputStream)System.out, "UTF8");
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new File(stringArray[0]), (HandlerBase)new Validator());
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            System.exit(1);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
            System.exit(1);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return new InputSource(string2);
    }

    public void setDocumentLocator(Locator locator) {
        try {
            out.write("** Start validating: ");
            out.write(locator.getSystemId());
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        this.nl();
        this.emit("** Document is valid!");
        try {
            this.nl();
            out.flush();
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private void emit(String string) throws SAXException {
        try {
            out.write(string);
            out.flush();
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }

    private void nl() throws SAXException {
        String string = System.getProperty("line.separator");
        try {
            out.write(string);
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }
}

