/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.help;

import com.sun.star.io.BufferSizeExceededException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XSeekable;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import java.io.IOException;
import java.io.OutputStream;

public final class HelpOutputStream
extends OutputStream {
    int pos = 0;
    private byte[] smallbuffer = new byte[1024];
    private byte[] bigbuffer = null;

    public void write(int n) throws IOException {
        if (this.pos == 1024) {
            this.write(null);
            this.pos = 0;
        }
        this.smallbuffer[this.pos++] = (byte)n;
    }

    public void write(byte[] byArray) throws IOException {
        try {
            if (byArray != null) {
                this.pos = byArray.length;
                this.smallbuffer = byArray;
            }
            int n = this.bigbuffer == null ? 0 : this.bigbuffer.length;
            byte[] byArray2 = new byte[n + this.pos];
            int n2 = 0;
            while (n2 < n) {
                byArray2[n2] = this.bigbuffer[n2];
                ++n2;
            }
            n2 = 0;
            while (n2 < this.pos) {
                byArray2[n2 + n] = this.smallbuffer[n2];
                ++n2;
            }
            this.bigbuffer = byArray2;
        }
        catch (RuntimeException runtimeException) {
            throw new IOException(runtimeException.getMessage());
        }
    }

    public void flush() throws IOException {
        this.write(null);
        this.pos = 0;
    }

    public void close() throws IOException {
    }

    public byte[] getBigBuffer() {
        return this.bigbuffer;
    }

    public void setBigBuffer(byte[] byArray) {
        this.bigbuffer = byArray;
    }

    public void writeToXOutputStream(XOutputStream xOutputStream) throws Exception, RuntimeException, CommandAbortedException {
        try {
            if (this.bigbuffer != null) {
                xOutputStream.writeBytes(this.bigbuffer);
            }
            xOutputStream.closeOutput();
        }
        catch (NotConnectedException notConnectedException) {
            throw new CommandAbortedException(notConnectedException.getMessage());
        }
        catch (BufferSizeExceededException bufferSizeExceededException) {
            throw new CommandAbortedException(bufferSizeExceededException.getMessage());
        }
        catch (com.sun.star.io.IOException iOException) {
            throw new CommandAbortedException(iOException.getMessage());
        }
    }

    public XInputStream getNewInputStream() {
        return new XInputStreamImpl();
    }

    final class XInputStreamImpl
    implements XSeekable,
    XInputStream {
        private int offset;
        private int read;

        XInputStreamImpl() {
            this.read = this.offset = 0;
        }

        public synchronized long getLength() throws com.sun.star.io.IOException, RuntimeException {
            if (HelpOutputStream.this.bigbuffer != null) {
                return HelpOutputStream.this.bigbuffer.length - this.offset;
            }
            return 0L;
        }

        public synchronized long getPosition() throws com.sun.star.io.IOException, RuntimeException {
            return this.read - this.offset;
        }

        public synchronized void seek(long l) throws IllegalArgumentException, com.sun.star.io.IOException, RuntimeException {
            if (HelpOutputStream.this.bigbuffer != null) {
                int n = (int)(l += (long)this.offset);
                if (n < this.offset) {
                    throw new IllegalArgumentException();
                }
                if (n > HelpOutputStream.this.bigbuffer.length) {
                    n = HelpOutputStream.this.bigbuffer.length;
                }
                this.read = n;
            } else {
                this.read = 0;
            }
        }

        public synchronized int available() throws NotConnectedException, com.sun.star.io.IOException, RuntimeException {
            if (HelpOutputStream.this.bigbuffer != null) {
                return HelpOutputStream.this.bigbuffer.length - this.read;
            }
            return 0;
        }

        public void closeInput() throws NotConnectedException, com.sun.star.io.IOException, RuntimeException {
            this.read = -1;
        }

        public synchronized int readBytes(byte[][] byArray, int n) throws NotConnectedException, BufferSizeExceededException, com.sun.star.io.IOException, RuntimeException {
            if (HelpOutputStream.this.bigbuffer != null) {
                if (this.read == -1) {
                    return 0;
                }
                int n2 = 0;
                int n3 = n > HelpOutputStream.this.bigbuffer.length - this.read ? HelpOutputStream.this.bigbuffer.length - this.read : n;
                byArray[0] = new byte[n];
                while (n3 != 0) {
                    byArray[0][n2++] = HelpOutputStream.this.bigbuffer[this.read++];
                    --n3;
                }
                return n2;
            }
            byArray[0] = new byte[0];
            return 0;
        }

        public synchronized int readSomeBytes(byte[][] byArray, int n) throws NotConnectedException, BufferSizeExceededException, com.sun.star.io.IOException, RuntimeException {
            return this.readBytes(byArray, n);
        }

        public synchronized void skipBytes(int n) throws NotConnectedException, BufferSizeExceededException, com.sun.star.io.IOException, RuntimeException {
            this.read += n;
            if (this.read > HelpOutputStream.this.bigbuffer.length) {
                this.read = HelpOutputStream.this.bigbuffer.length;
            }
            if (this.read < this.offset) {
                this.read = this.offset;
            }
        }
    }
}

