/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.help;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.container.XNameAccess;
import com.sun.star.help.HelpContentIdentifier;
import com.sun.star.help.HelpDatabases;
import com.sun.star.help.HelpDynamicResultSet;
import com.sun.star.help.HelpOutputStream;
import com.sun.star.help.HelpProvider;
import com.sun.star.help.HelpResultSet;
import com.sun.star.help.HelpResultSetBase;
import com.sun.star.help.HelpResultSetFactory;
import com.sun.star.help.HelpResultSetForRoot;
import com.sun.star.help.HelpURLParameter;
import com.sun.star.io.XActiveDataSink;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XArray;
import com.sun.star.sdbc.XBlob;
import com.sun.star.sdbc.XClob;
import com.sun.star.sdbc.XRef;
import com.sun.star.sdbc.XRow;
import com.sun.star.ucb.Command;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.CommandInfo;
import com.sun.star.ucb.OpenCommandArgument2;
import com.sun.star.ucb.UnsupportedCommandException;
import com.sun.star.ucb.XCommandEnvironment;
import com.sun.star.ucb.XCommandInfo;
import com.sun.star.ucb.XCommandProcessor;
import com.sun.star.ucb.XContent;
import com.sun.star.ucb.XContentEventListener;
import com.sun.star.ucb.XContentIdentifier;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.Date;
import com.sun.star.util.DateTime;
import com.sun.star.util.Time;
import com.sun.xmlsearch.xml.qe.QueryResults;
import java.io.IOException;
import java.io.InputStream;

public class HelpContent
implements XContent,
XCommandProcessor {
    private int m_nFreeCommandIdentifier;
    private final HelpContentIdentifier m_xIdentifier;
    private final HelpURLParameter m_xParameter;
    private final HelpProvider m_xProvider;
    private HelpOutputStream m_xOutputStream;
    static /* synthetic */ Class class$com$sun$star$io$XOutputStream;
    static /* synthetic */ Class class$com$sun$star$io$XActiveDataSink;

    public HelpContent(HelpProvider helpProvider, HelpContentIdentifier helpContentIdentifier) {
        this.m_xIdentifier = helpContentIdentifier;
        this.m_xProvider = helpProvider;
        this.m_xParameter = this.m_xIdentifier.getParameter();
    }

    public XContentIdentifier getIdentifier() throws RuntimeException {
        return this.m_xIdentifier;
    }

    public String getContentType() throws RuntimeException {
        return "application/vnd.sun.star.xmlhelp";
    }

    public void addContentEventListener(XContentEventListener xContentEventListener) throws RuntimeException {
    }

    public void removeContentEventListener(XContentEventListener xContentEventListener) throws RuntimeException {
    }

    public final synchronized int createCommandIdentifier() throws RuntimeException {
        return this.m_nFreeCommandIdentifier++;
    }

    public final Object execute(Command command, int n, XCommandEnvironment xCommandEnvironment) throws com.sun.star.uno.Exception, RuntimeException, CommandAbortedException {
        Object object = null;
        if (command.Name.equals("open")) {
            QueryResults queryResults;
            XActiveDataSink xActiveDataSink;
            OpenCommandArgument2 openCommandArgument2 = (OpenCommandArgument2)command.Argument;
            XOutputStream xOutputStream = (XOutputStream)UnoRuntime.queryInterface((Class)(class$com$sun$star$io$XOutputStream == null ? (class$com$sun$star$io$XOutputStream = HelpContent.class$("com.sun.star.io.XOutputStream")) : class$com$sun$star$io$XOutputStream), (Object)openCommandArgument2.Sink);
            if (xOutputStream != null) {
                if (this.m_xOutputStream == null) {
                    this.m_xOutputStream = new HelpOutputStream();
                    if (this.m_xParameter.isRoot()) {
                        this.getPicture(HelpDatabases.getCssSheet(), this.m_xOutputStream);
                    } else if (this.m_xParameter.isPicture()) {
                        this.getPicture(this.m_xParameter.getInputFromJarFile(), this.m_xOutputStream);
                    } else if (this.m_xParameter.isActive()) {
                        this.m_xOutputStream.setBigBuffer(this.m_xParameter.getByteArrayText());
                    } else {
                        this.m_xProvider.writeHtmlStream(this.m_xParameter, this.m_xOutputStream);
                    }
                }
                this.m_xOutputStream.writeToXOutputStream(xOutputStream);
            }
            if ((xActiveDataSink = (XActiveDataSink)UnoRuntime.queryInterface((Class)(class$com$sun$star$io$XActiveDataSink == null ? (class$com$sun$star$io$XActiveDataSink = HelpContent.class$("com.sun.star.io.XActiveDataSink")) : class$com$sun$star$io$XActiveDataSink), (Object)openCommandArgument2.Sink)) != null) {
                if (this.m_xOutputStream == null) {
                    this.m_xOutputStream = new HelpOutputStream();
                    if (this.m_xParameter.isRoot()) {
                        this.getPicture(HelpDatabases.getCssSheet(), this.m_xOutputStream);
                    } else if (this.m_xParameter.isPicture()) {
                        this.getPicture(this.m_xParameter.getInputFromJarFile(), this.m_xOutputStream);
                    } else if (this.m_xParameter.isActive()) {
                        this.m_xOutputStream.setBigBuffer(this.m_xParameter.getByteArrayText());
                    } else {
                        this.m_xProvider.writeHtmlStream(this.m_xParameter, this.m_xOutputStream);
                    }
                }
                xActiveDataSink.setInputStream(this.m_xOutputStream.getNewInputStream());
            }
            if (this.m_xParameter.isRoot()) {
                String[] stringArray = HelpDatabases.getModuleList(this.m_xParameter.get_language());
                if (stringArray != null) {
                    object = new HelpDynamicResultSet(new FactoryForRoot(this.m_xProvider, stringArray, openCommandArgument2.Properties, this.m_xParameter), this.m_xProvider.getXMultiServiceFactory());
                }
            } else if (this.m_xParameter.isQuery() && (queryResults = this.m_xProvider.queryResultSet(this.m_xParameter)) != null) {
                object = new HelpDynamicResultSet(new FactoryForQuery(this.m_xProvider, queryResults, openCommandArgument2.Properties, this.m_xParameter), this.m_xProvider.getXMultiServiceFactory());
            }
        } else if (command.Name.equals("getCommandInfo")) {
            object = this.getCommandInfo();
        } else if (command.Name.equals("getPropertySetInfo")) {
            object = this.getPropertySetInfo();
        } else if (command.Name.equals("getPropertyValues")) {
            Property[] propertyArray = (Property[])command.Argument;
            object = this.getPropertyValues(propertyArray);
        } else if (!command.Name.equals("setPropertyValues")) {
            throw new CommandAbortedException();
        }
        return object;
    }

    public final void abort(int n) throws RuntimeException {
    }

    private XCommandInfo getCommandInfo() {
        return new XCommandInfoImpl();
    }

    private XPropertySetInfo getPropertySetInfo() {
        return new XPropertySetInfoImpl(this.m_xParameter.isFile() || this.m_xParameter.isRoot(), this.m_xParameter.isModule(), this.m_xParameter.isFile());
    }

    private XRow getPropertyValues(Property[] propertyArray) {
        Object object;
        Object[] objectArray = new Object[propertyArray.length];
        int n = 0;
        while (n < propertyArray.length) {
            String string = propertyArray[n].Name;
            if ("Title".equals(string)) {
                objectArray[n] = this.m_xParameter.get_title();
            } else if ("IsFolder".equals(string)) {
                objectArray[n] = new Boolean(!this.m_xParameter.isFile() || this.m_xParameter.isRoot());
            } else if ("IsDocument".equals(string)) {
                objectArray[n] = new Boolean(this.m_xParameter.isFile() || this.m_xParameter.isRoot());
            } else if ("ContentType".equals(string)) {
                objectArray[n] = new String("application/vnd.sun.star.help");
            } else if ("MediaType".equals(string) && this.m_xParameter.isPicture()) {
                objectArray[n] = new String("image/gif");
            } else if ("MediaType".equals(string) && this.m_xParameter.isFile()) {
                objectArray[n] = new String("text/html");
            } else if ("MediaType".equals(string) && this.m_xParameter.isRoot()) {
                objectArray[n] = new String("text/css");
            } else if ("KeywordList".equals(string) && this.m_xParameter.isModule()) {
                object = HelpDatabases.getKeyword(this.m_xParameter.get_module(), this.m_xParameter.get_language());
                objectArray[n] = ((HelpDatabases.KeywordInfo)object).getKeywordList();
            } else if ("KeywordRef".equals(string) && this.m_xParameter.isModule()) {
                object = HelpDatabases.getKeyword(this.m_xParameter.get_module(), this.m_xParameter.get_language());
                objectArray[n] = ((HelpDatabases.KeywordInfo)object).getIdList();
            } else if ("KeywordAnchorForRef".equals(string) && this.m_xParameter.isModule()) {
                object = HelpDatabases.getKeyword(this.m_xParameter.get_module(), this.m_xParameter.get_language());
                objectArray[n] = ((HelpDatabases.KeywordInfo)object).getAnchorList();
            } else if ("KeywordTitleForRef".equals(string) && this.m_xParameter.isModule()) {
                object = HelpDatabases.getKeyword(this.m_xParameter.get_module(), this.m_xParameter.get_language());
                objectArray[n] = ((HelpDatabases.KeywordInfo)object).getTitleList();
            } else if ("SearchScopes".equals(string) && this.m_xParameter.isModule()) {
                object = new String[]{"Heading", "FullText"};
                objectArray[n] = object;
            } else {
                objectArray[n] = "AnchorName".equals(string) && this.m_xParameter.isFile() ? this.m_xParameter.get_tag() : null;
            }
            ++n;
        }
        object = new XRowImpl(objectArray);
        return object;
    }

    private final void getPicture(InputStream inputStream, HelpOutputStream helpOutputStream) {
        int n = 0;
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray2)) != -1) {
                n += n2;
                if (n2 == 256) {
                    byte[] byArray3 = byArray2;
                    byArray2 = byArray;
                    byArray = byArray3;
                } else {
                    byArray = new byte[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        byArray[n3] = byArray2[n3];
                        ++n3;
                    }
                }
                helpOutputStream.write(byArray);
            }
            System.out.println(n);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class XRowImpl
    implements XRow {
        private boolean m_bWasNull;
        private Object[] V;

        public XRowImpl(Object[] objectArray) {
            this.V = objectArray;
        }

        public synchronized XArray getArray(int n) throws SQLException, RuntimeException {
            try {
                XArray xArray = (XArray)this.V[--n];
                this.m_bWasNull = xArray == null;
                return xArray;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }

        public synchronized XInputStream getBinaryStream(int n) throws SQLException, RuntimeException {
            XInputStream xInputStream;
            this.m_bWasNull = (xInputStream = (XInputStream)this.V[--n]) == null;
            return xInputStream;
        }

        public synchronized XBlob getBlob(int n) throws SQLException, RuntimeException {
            XBlob xBlob;
            this.m_bWasNull = (xBlob = (XBlob)this.V[--n]) == null;
            return xBlob;
        }

        public synchronized boolean getBoolean(int n) throws SQLException, RuntimeException {
            Boolean bl;
            this.m_bWasNull = (bl = (Boolean)this.V[--n]) == null;
            return bl;
        }

        public synchronized byte getByte(int n) throws SQLException, RuntimeException {
            Byte by;
            this.m_bWasNull = (by = (Byte)this.V[--n]) == null;
            return by;
        }

        public synchronized byte[] getBytes(int n) throws SQLException, RuntimeException {
            byte[] byArray;
            this.m_bWasNull = (byArray = (byte[])this.V[--n]) == null;
            return byArray;
        }

        public synchronized XInputStream getCharacterStream(int n) throws SQLException, RuntimeException {
            XInputStream xInputStream;
            this.m_bWasNull = (xInputStream = (XInputStream)this.V[--n]) == null;
            return xInputStream;
        }

        public synchronized XClob getClob(int n) throws SQLException, RuntimeException {
            XClob xClob;
            this.m_bWasNull = (xClob = (XClob)this.V[--n]) == null;
            return xClob;
        }

        public synchronized Date getDate(int n) throws SQLException, RuntimeException {
            Date date;
            this.m_bWasNull = (date = (Date)this.V[--n]) == null;
            return date;
        }

        public synchronized double getDouble(int n) throws SQLException, RuntimeException {
            Double d;
            this.m_bWasNull = (d = (Double)this.V[--n]) == null;
            return d;
        }

        public synchronized float getFloat(int n) throws SQLException, RuntimeException {
            Float f;
            this.m_bWasNull = (f = (Float)this.V[--n]) == null;
            return f.floatValue();
        }

        public synchronized int getInt(int n) throws SQLException, RuntimeException {
            Integer n2;
            this.m_bWasNull = (n2 = (Integer)this.V[--n]) == null;
            return n2;
        }

        public synchronized long getLong(int n) throws SQLException, RuntimeException {
            Long l;
            this.m_bWasNull = (l = (Long)this.V[--n]) == null;
            return l;
        }

        public synchronized Object getObject(int n, XNameAccess xNameAccess) throws SQLException, RuntimeException {
            Object object;
            this.m_bWasNull = (object = this.V[--n]) == null;
            return object;
        }

        public synchronized XRef getRef(int n) throws SQLException, RuntimeException {
            return null;
        }

        public synchronized short getShort(int n) throws SQLException, RuntimeException {
            Short s;
            this.m_bWasNull = (s = (Short)this.V[--n]) == null;
            return s;
        }

        public synchronized String getString(int n) throws SQLException, RuntimeException {
            String string;
            this.m_bWasNull = (string = (String)this.V[--n]) == null;
            return string;
        }

        public synchronized Time getTime(int n) throws SQLException, RuntimeException {
            Time time;
            this.m_bWasNull = (time = (Time)this.V[--n]) == null;
            return time;
        }

        public synchronized DateTime getTimestamp(int n) throws SQLException, RuntimeException {
            DateTime dateTime;
            this.m_bWasNull = (dateTime = (DateTime)this.V[--n]) == null;
            return dateTime;
        }

        public synchronized boolean wasNull() throws SQLException, RuntimeException {
            return this.m_bWasNull;
        }
    }

    private static final class XPropertySetInfoImpl
    implements XPropertySetInfo {
        boolean m_bWithMediaType;
        boolean m_bModule;
        boolean m_bFile;

        public XPropertySetInfoImpl(boolean bl, boolean bl2, boolean bl3) {
            this.m_bWithMediaType = bl;
            this.m_bModule = bl2;
            this.m_bFile = bl3;
        }

        public Property[] getProperties() throws RuntimeException {
            int n;
            int n2 = n = this.m_bWithMediaType ? 5 : 4;
            if (this.m_bModule) {
                n += 5;
            }
            if (this.m_bFile) {
                ++n;
            }
            Property[] propertyArray = new Property[n];
            try {
                int n3 = 0;
                propertyArray[n3++] = this.getPropertyByName("Title");
                propertyArray[n3++] = this.getPropertyByName("IsDocument");
                propertyArray[n3++] = this.getPropertyByName("IsFolder");
                propertyArray[n3++] = this.getPropertyByName("ContentType");
                if (this.m_bWithMediaType) {
                    propertyArray[n3++] = this.getPropertyByName("MediaType");
                }
                if (this.m_bModule) {
                    propertyArray[n3++] = this.getPropertyByName("KeywordList");
                    propertyArray[n3++] = this.getPropertyByName("KeywordRef");
                    propertyArray[n3++] = this.getPropertyByName("KeywordTitleForRef");
                    propertyArray[n3++] = this.getPropertyByName("KeywordAnchorForRef");
                    propertyArray[n3++] = this.getPropertyByName("SearchScopes");
                }
                if (this.m_bFile) {
                    propertyArray[n3++] = this.getPropertyByName("AnchorName");
                }
            }
            catch (UnknownPropertyException unknownPropertyException) {
                // empty catch block
            }
            return propertyArray;
        }

        public Property getPropertyByName(String string) throws UnknownPropertyException, RuntimeException {
            try {
                if (string.equals("Title")) {
                    return new Property(string, -1, new Type(TypeClass.STRING), 16);
                }
                if (string.equals("IsDocument") || string.equals("IsFolder")) {
                    return new Property(string, -1, new Type(TypeClass.BOOLEAN), 16);
                }
                if (string.equals("ContentType")) {
                    return new Property(string, -1, new Type(TypeClass.STRING), 16);
                }
                if (string.equals("MediaType") && this.m_bWithMediaType) {
                    return new Property(string, -1, new Type(TypeClass.STRING), 16);
                }
                if (string.equals("KeywordList") && this.m_bModule) {
                    return new Property(string, -1, new Type(Class.forName("[Ljava.lang.String;")), 16);
                }
                if (string.equals("KeywordRef") && this.m_bModule) {
                    return new Property(string, -1, new Type(Class.forName("[[Ljava.lang.String;")), 16);
                }
                if (string.equals("KeywordAnchorForRef") && this.m_bModule) {
                    return new Property(string, -1, new Type(Class.forName("[[Ljava.lang.String;")), 16);
                }
                if (string.equals("KeywordTitleForRef") && this.m_bModule) {
                    return new Property(string, -1, new Type(Class.forName("[[Ljava.lang.String;")), 16);
                }
                if (string.equals("SearchScopes") && this.m_bModule) {
                    return new Property(string, -1, new Type(Class.forName("[Ljava.lang.String;")), 16);
                }
                if (string.equals("AnchorName") && this.m_bFile) {
                    return new Property(string, -1, new Type(TypeClass.STRING), 16);
                }
                throw new UnknownPropertyException();
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                throw new RuntimeException(exception.getMessage());
            }
        }

        public boolean hasPropertyByName(String string) throws RuntimeException {
            if (string.equals("Title")) {
                return true;
            }
            if (string.equals("IsFolder")) {
                return true;
            }
            if (string.equals("IsDocument")) {
                return true;
            }
            if (string.equals("ContentType")) {
                return true;
            }
            if (string.equals("MediaType") && this.m_bWithMediaType) {
                return true;
            }
            if (string.equals("KeywordList") && this.m_bModule) {
                return true;
            }
            if (string.equals("KeywordRef") && this.m_bModule) {
                return true;
            }
            if (string.equals("KeywordAnchorForRef") && this.m_bModule) {
                return true;
            }
            if (string.equals("KeywordTitleForRef") && this.m_bModule) {
                return true;
            }
            if (string.equals("SearchScopes") && this.m_bModule) {
                return true;
            }
            return string.equals("AnchorName") && this.m_bFile;
        }
    }

    private static final class XCommandInfoImpl
    implements XCommandInfo {
        XCommandInfoImpl() {
        }

        public CommandInfo getCommandInfoByHandle(int n) throws UnsupportedCommandException, RuntimeException {
            throw new UnsupportedCommandException();
        }

        public CommandInfo getCommandInfoByName(String string) throws UnsupportedCommandException, RuntimeException {
            if (string.equals("getCommandInfo")) {
                return new CommandInfo(string, -1, new Type(TypeClass.VOID));
            }
            if (string.equals("getPropertySetInfo")) {
                return new CommandInfo(string, -1, new Type(TypeClass.VOID));
            }
            if (string.equals("getPropertyValues")) {
                return new CommandInfo(string, -1, new Type(new Property[0].getClass()));
            }
            if (string.equals("setPropertyValues")) {
                return new CommandInfo(string, -1, new Type(new PropertyValue[0].getClass()));
            }
            if (string.equals("open")) {
                return new CommandInfo(string, -1, new Type(new OpenCommandArgument2().getClass()));
            }
            throw new UnsupportedCommandException();
        }

        public CommandInfo[] getCommands() throws RuntimeException {
            CommandInfo[] commandInfoArray = new CommandInfo[5];
            try {
                commandInfoArray[0] = this.getCommandInfoByName("getCommandInfo");
                commandInfoArray[1] = this.getCommandInfoByName("getPropertySetInfo");
                commandInfoArray[2] = this.getCommandInfoByName("getPropertyValues");
                commandInfoArray[3] = this.getCommandInfoByName("setPropertyValues");
                commandInfoArray[4] = this.getCommandInfoByName("open");
            }
            catch (UnsupportedCommandException unsupportedCommandException) {
                // empty catch block
            }
            return commandInfoArray;
        }

        public boolean hasCommandByHandle(int n) throws RuntimeException {
            return false;
        }

        public boolean hasCommandByName(String string) throws RuntimeException {
            if (string.equals("getCommandInfo")) {
                return true;
            }
            if (string.equals("getPropertySetInfo")) {
                return true;
            }
            if (string.equals("getPropertyValues")) {
                return true;
            }
            if (string.equals("setPropertyValues")) {
                return true;
            }
            return string.equals("open");
        }
    }

    private final class FactoryForRoot
    implements HelpResultSetFactory {
        HelpProvider m_xProvider;
        String[] m_xHitData;
        Property[] m_xProperty;
        HelpURLParameter m_xParameter;

        public FactoryForRoot(HelpProvider helpProvider, String[] stringArray, Property[] propertyArray, HelpURLParameter helpURLParameter) {
            this.m_xProvider = helpProvider;
            this.m_xHitData = stringArray;
            this.m_xProperty = propertyArray;
            this.m_xParameter = helpURLParameter;
        }

        public HelpResultSetBase createResultSet() {
            return new HelpResultSetForRoot(this.m_xProvider, this.m_xHitData, this.m_xProperty, this.m_xParameter);
        }
    }

    private final class FactoryForQuery
    implements HelpResultSetFactory {
        HelpProvider m_xProvider;
        QueryResults m_xHitData;
        Property[] m_xProperty;
        HelpURLParameter m_xParameter;

        FactoryForQuery(HelpProvider helpProvider, QueryResults queryResults, Property[] propertyArray, HelpURLParameter helpURLParameter) {
            this.m_xProvider = helpProvider;
            this.m_xHitData = queryResults;
            this.m_xProperty = propertyArray;
            this.m_xParameter = helpURLParameter;
        }

        public HelpResultSetBase createResultSet() {
            return new HelpResultSet(this.m_xProvider, this.m_xHitData, this.m_xProperty, this.m_xParameter);
        }
    }
}

