/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.util;

import com.sun.xmlsearch.db.BtreeDictParameters;
import com.sun.xmlsearch.db.FullBtreeDict;
import com.sun.xmlsearch.db.Schema;
import com.sun.xmlsearch.util.Compressor;
import com.sun.xmlsearch.util.ConceptList;
import com.sun.xmlsearch.util.ConceptLocation;
import com.sun.xmlsearch.util.DocumentCompressor;
import com.sun.xmlsearch.util.IndexAccessor;
import com.sun.xmlsearch.util.IndexInverter;
import com.sun.xmlsearch.util.IntegerArray;
import com.sun.xmlsearch.util.NonnegativeIntegerGenerator;
import com.sun.xmlsearch.util.StreamDecompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Hashtable;

public class Index
extends IndexAccessor {
    protected final boolean _update;
    protected Schema _schema;
    private BtreeDictParameters _dictParams;
    private FullBtreeDict _dict;
    private int _freeID;
    private DocumentCompressor _documentCompressor;
    private IntegerArray _concepts;
    private IntegerArray _offsets;
    private byte[] _allLists;
    protected IntegerArray _microIndexOffsets;
    protected IntegerArray _documents;
    protected IntegerArray _titles;
    protected byte[] _positions;
    private int _positionsCacheSize = 0;
    private int _currentBatchOffset = 0;
    private int _maxDocNumberInCache = -1;
    private boolean _allInCache = false;
    protected RandomAccessFile _positionsFile = null;
    protected RandomAccessFile _offsetsFile = null;
    private Hashtable _cache;

    public Index(String string, boolean bl) {
        super(string);
        this._update = bl;
    }

    public boolean init() throws Exception {
        boolean bl = false;
        if (this._update) {
            this.createIfNeeded();
            this._cache = new Hashtable(15000);
        }
        this._schema = new Schema(this, this._update);
        this._dictParams = new BtreeDictParameters(this._schema, "DICTIONARY");
        if (!this._dictParams.readState()) {
            this._dictParams.setBlockSize(2048);
            this._dictParams.setRoot(0);
            this._dictParams.setFreeID(1);
        } else {
            bl = true;
        }
        this._dict = new FullBtreeDict(this._dictParams, this._update);
        this._freeID = this._dictParams.getFreeID();
        this._documents = new IntegerArray(4096);
        if (bl) {
            this._allLists = this.readByteArray("DOCS");
            this.readDocumentsTable("DOCS.TAB");
            InputStream inputStream = this.getInputStream("OFFSETS");
            this.readOffsetsTables(inputStream);
            inputStream.close();
            this.readPositions();
        } else {
            this._microIndexOffsets = new IntegerArray();
            this._titles = new IntegerArray();
        }
        return true;
    }

    private DocumentCompressor getDocumentCompressor() {
        if (this._documentCompressor == null) {
            this._documentCompressor = new DocumentCompressor();
        }
        return this._documentCompressor;
    }

    public void compress(int n, int n2, ConceptLocation[] conceptLocationArray, int n3, ConceptLocation[] conceptLocationArray2, int n4) throws IOException {
        RandomAccessFile randomAccessFile = this.getPositionsFile();
        long l = randomAccessFile.length();
        randomAccessFile.seek(l);
        this._documents.add(n);
        this._microIndexOffsets.add((int)l);
        this._titles.add(n2);
        this.getDocumentCompressor().writeOutMicroIndex(randomAccessFile, conceptLocationArray, n3, conceptLocationArray2, n4);
    }

    protected void writeOutOffsets() throws IOException {
        Compressor compressor = new Compressor();
        int n = compressor.minimize(this._documents, 8);
        Compressor compressor2 = new Compressor();
        int n2 = compressor2.compressAscending(this._microIndexOffsets);
        Compressor compressor3 = new Compressor();
        int n3 = compressor3.minimize(this._titles, 8);
        int n4 = compressor.byteCount();
        RandomAccessFile randomAccessFile = this.getOffsetsFile();
        randomAccessFile.seek(0L);
        randomAccessFile.write(n);
        compressor.write(randomAccessFile);
        randomAccessFile.write(n2);
        compressor2.write(randomAccessFile);
        randomAccessFile.write(n3);
        compressor3.write(randomAccessFile);
    }

    public void close() throws Exception {
        this._dict.close(this._freeID);
        this._positionsFile.close();
        this._positionsFile = null;
        if (this._update) {
            this.writeOutOffsets();
            this._dictParams.setFreeID(this._freeID);
            this._dictParams.updateSchema();
            this._schema.save();
            IndexInverter indexInverter = new IndexInverter(this);
            indexInverter.invertIndex(this._documents.cardinality(), this._microIndexOffsets);
        }
        if (this._offsetsFile != null) {
            this._offsetsFile.close();
            this._offsetsFile = null;
        }
    }

    public final boolean occursInText(int n) {
        return this._concepts.binarySearch(n) >= 0;
    }

    public final int fetch(String string) throws Exception {
        return this._dict.fetch(string);
    }

    public final String fetch(int n) throws Exception {
        return this._dict.fetch(n);
    }

    public final IntegerArray withPrefix(String string) throws Exception {
        return this._dict.withPrefix(string);
    }

    public final String documentName(int n) throws Exception {
        return this.fetch(this._documents.at(n));
    }

    public final RandomAccessFile getPositionsFile() throws IOException {
        if (this._positionsFile == null) {
            this._positionsFile = this.getRAF("POSITIONS", this._update);
        }
        return this._positionsFile;
    }

    public RandomAccessFile getOffsetsFile() throws IOException {
        if (this._offsetsFile == null) {
            this._offsetsFile = this.getRAF("OFFSETS", this._update);
        }
        return this._offsetsFile;
    }

    public NonnegativeIntegerGenerator getDocumentIterator(int n) {
        int n2 = this._concepts.binarySearch(n);
        if (n2 >= 0) {
            return new ConceptList(this._allLists, this._offsets.at(n2));
        }
        return null;
    }

    public final int getDocumentIndex(int n) {
        return this._microIndexOffsets.at(n) - this._currentBatchOffset;
    }

    private void readMicroindexes(int n) throws IOException {
        this._currentBatchOffset = this._microIndexOffsets.at(n);
        int n2 = this._currentBatchOffset + this._positionsCacheSize;
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        do {
            if (++n4 == this._microIndexOffsets.cardinality()) {
                n5 = (int)this._positionsFile.length();
                continue;
            }
            if (this._microIndexOffsets.at(n4) <= n2) continue;
            n5 = this._microIndexOffsets.at(n4);
        } while (n5 == 0);
        if (n5 > n2) {
            n3 = this._microIndexOffsets.at(n4 - 1);
            this._maxDocNumberInCache = n4 - 2;
        } else {
            n3 = n5;
            this._maxDocNumberInCache = n4 - 1;
        }
        if (this._maxDocNumberInCache < n) {
            this._positionsCacheSize = n5 - this._currentBatchOffset;
            System.out.println("expanding cache to " + this._positionsCacheSize);
            this._positions = new byte[this._positionsCacheSize];
            this.readMicroindexes(n);
            return;
        }
        this._positionsFile.seek(this._currentBatchOffset);
        this._positionsFile.read(this._positions, 0, n3 - this._currentBatchOffset);
    }

    public void reset() {
        this._maxDocNumberInCache = this._allInCache ? this._microIndexOffsets.cardinality() - 1 : -1;
    }

    public byte[] getPositions(int n) throws Exception {
        if (n > this._maxDocNumberInCache) {
            this.readMicroindexes(n);
        }
        return this._positions;
    }

    private void readPositions() throws IOException {
        this.getPositionsFile();
        this._positionsCacheSize = (int)this._positionsFile.length();
        if (this._positionsFile.length() <= (long)this._positionsCacheSize) {
            this._allInCache = true;
            this.reset();
            this._positions = new byte[(int)this._positionsFile.length()];
            this._positionsFile.read(this._positions);
            System.out.println("POS fits in cache");
        }
    }

    private void readDocumentsTable(String string) throws Exception {
        InputStream inputStream = this.getInputStream(string);
        int n = inputStream.read();
        this._concepts = new IntegerArray(4096);
        StreamDecompressor streamDecompressor = new StreamDecompressor(inputStream);
        streamDecompressor.ascDecode(n, this._concepts);
        int n2 = inputStream.read();
        this._offsets = new IntegerArray(this._concepts.cardinality() + 1);
        this._offsets.add(0);
        StreamDecompressor streamDecompressor2 = new StreamDecompressor(inputStream);
        streamDecompressor2.ascDecode(n2, this._offsets);
        inputStream.close();
    }

    protected void readOffsetsTables(InputStream inputStream) throws Exception {
        int n = inputStream.read();
        StreamDecompressor streamDecompressor = new StreamDecompressor(inputStream);
        streamDecompressor.decode(n, this._documents);
        int n2 = inputStream.read();
        this._microIndexOffsets = new IntegerArray(this._documents.cardinality() + 1);
        StreamDecompressor streamDecompressor2 = new StreamDecompressor(inputStream);
        streamDecompressor2.ascDecode(n2, this._microIndexOffsets);
        int n3 = inputStream.read();
        this._titles = new IntegerArray(this._documents.cardinality());
        StreamDecompressor streamDecompressor3 = new StreamDecompressor(inputStream);
        streamDecompressor3.decode(n3, this._titles);
    }

    public int nDocuments() {
        return this._documents.cardinality();
    }

    public void removeSymbol(String string) throws Exception {
        this._cache.remove(string);
        this._dict.store(string, 0);
    }

    public int intern(String string) throws Exception {
        Integer n = (Integer)this._cache.get(string);
        if (n != null) {
            return n;
        }
        int n2 = this._dict.fetch(string);
        if (n2 == 0) {
            n2 = this._freeID++;
            this._dict.store(string, n2);
        }
        this._cache.put(string, new Integer(n2));
        return n2;
    }
}

