/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.util;

import com.sun.xmlsearch.util.Compressor;
import com.sun.xmlsearch.util.ConceptLocation;
import com.sun.xmlsearch.util.IntegerArray;
import java.io.DataOutput;
import java.io.IOException;

public class DocumentCompressor {
    public static final int NConceptsInGroup = 16;
    public static final int BitsInLabel = 4;
    public static final int DefaultSize = 32;
    private int _nGroups;
    private int _nExtents;
    private int _freeComp;
    private int _sizeComp = 32;
    private int _kk;
    private Compressor _currentCompressor = null;
    private Compressor[] _compressors = new Compressor[32];
    private Compressor _kCompr = new Compressor();
    private Compressor _lCompr = new Compressor();
    private Compressor _mCompr = new Compressor();
    private Compressor _posCompressor = new Compressor();
    private IntegerArray _kTable = new IntegerArray();
    private IntegerArray _lTable = new IntegerArray();
    private IntegerArray _maxConcepts = new IntegerArray();
    private IntegerArray _concepts = new IntegerArray();
    private IntegerArray _documents = new IntegerArray();
    private IntegerArray _microIndexOffsets = new IntegerArray();
    private IntegerArray _titles = new IntegerArray();
    private IntegerArray _contextsOffsets = new IntegerArray();
    private IntegerArray _positions = new IntegerArray();
    private IntegerArray _labels = new IntegerArray();

    public void writeOutMicroIndex(DataOutput dataOutput, ConceptLocation[] conceptLocationArray, int n, ConceptLocation[] conceptLocationArray2, int n2) throws IOException {
        this.encode(conceptLocationArray, n, 16);
        if (n2 > 0) {
            this.encodeExtents(conceptLocationArray2, n2);
        }
        this.finalizeEncoding();
        this.writeOut(dataOutput);
    }

    private void encode(ConceptLocation[] conceptLocationArray, int n, int n2) {
        ConceptLocation.sortByConcept(conceptLocationArray, 0, n);
        this._nGroups = 0;
        this._nExtents = 0;
        this._kTable.clear();
        this._lTable.clear();
        this._concepts.clear();
        this._maxConcepts.clear();
        this._kCompr.clear();
        this._lCompr.clear();
        this._mCompr.clear();
        int n3 = 0;
        while (n3 < this._sizeComp) {
            if (this._compressors[n3] != null) {
                this._compressors[n3].clear();
            }
            ++n3;
        }
        this._freeComp = 0;
        this._currentCompressor = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = conceptLocationArray[0].getConcept();
        this.nextCompressor();
        this._concepts.add(n7);
        int n8 = 0;
        while (true) {
            if (n8 < n && conceptLocationArray[n8].getConcept() == n7) {
                conceptLocationArray[n8].setConcept(n4);
                ++n8;
                continue;
            }
            if (n8 == n) {
                if (this._concepts.cardinality() > 0) {
                    ++this._nGroups;
                    this._kTable.add(this._currentCompressor.minimize(this._concepts, 4));
                }
                break;
            }
            if (++n4 == n2) {
                ++this._nGroups;
                this._concepts.popLast();
                this._maxConcepts.add(n7 - n6);
                n6 = n7;
                this._kTable.add(this._currentCompressor.minimize(this._concepts, 4));
                this.encodePositions(conceptLocationArray, n5, n8, 4);
                n5 = n8;
                this.nextCompressor();
                this._concepts.clear();
                n4 = 0;
            }
            this._concepts.add(conceptLocationArray[n8].getConcept() - n7);
            n7 = conceptLocationArray[n8].getConcept();
        }
        this.encodePositions(conceptLocationArray, n5, n8, 4);
    }

    private void encodePositions(ConceptLocation[] conceptLocationArray, int n, int n2, int n3) {
        ConceptLocation.sortByPosition(conceptLocationArray, n, n2);
        this._positions.clear();
        this._labels.clear();
        int n4 = conceptLocationArray[n].getBegin();
        this._positions.add(n4);
        this._labels.add(conceptLocationArray[n].getConcept());
        int n5 = n;
        int n6 = n + 1;
        while (n6 < n2) {
            if (!conceptLocationArray[n5].equals(conceptLocationArray[n6])) {
                n5 = n6;
                this._positions.add(conceptLocationArray[n5].getBegin() - n4);
                n4 = conceptLocationArray[n5].getBegin();
                this._labels.add(conceptLocationArray[n5].getConcept());
            }
            ++n6;
        }
        int n7 = this._posCompressor.minimize(this._positions, 3);
        this._kTable.add(n7);
        this._posCompressor.clear();
        this._posCompressor.encode(this._positions, this._labels, n7, n3);
        this._currentCompressor.concatenate(this._posCompressor);
    }

    private void encodeExtents(ConceptLocation[] conceptLocationArray, int n) {
        int n2 = 0;
        IntegerArray integerArray = new IntegerArray(n);
        IntegerArray integerArray2 = new IntegerArray();
        IntegerArray integerArray3 = new IntegerArray();
        IntegerArray integerArray4 = new IntegerArray();
        this.nextCompressor();
        Compressor compressor = this._currentCompressor;
        int n3 = 0;
        while (n3 < n) {
            if (conceptLocationArray[n3].getConcept() != n2) {
                if (n2 != 0) {
                    ++this._nExtents;
                    this.nextCompressor();
                    integerArray3.add(this._currentCompressor.minimize(integerArray2, 4));
                    integerArray4.add(this._currentCompressor.byteCount());
                }
                integerArray.add(conceptLocationArray[n3].getConcept() - n2);
                n2 = conceptLocationArray[n3].getConcept();
                integerArray2.clear();
                integerArray2.add(conceptLocationArray[n3].getLength());
            } else {
                integerArray2.add(conceptLocationArray[n3].getLength());
            }
            ++n3;
        }
        this.nextCompressor();
        integerArray3.add(this._currentCompressor.minimize(integerArray2, 4));
        integerArray4.add(this._currentCompressor.byteCount());
        Compressor compressor2 = new Compressor();
        integerArray3.add(compressor2.minimize(integerArray4, 4));
        Compressor compressor3 = new Compressor();
        integerArray3.add(compressor3.minimize(integerArray, 4));
        this._kTable.add(compressor.minimize(integerArray3, 4));
        compressor.concatenate(compressor2);
        compressor.concatenate(compressor3);
    }

    private void finalizeEncoding() {
        if (this._nGroups > 1) {
            int n = this._nExtents > 0 ? this._freeComp : this._freeComp - 1;
            int n2 = 0;
            while (n2 < n) {
                this._lTable.add(this._compressors[n2].byteCount());
                ++n2;
            }
            this._kTable.add(this._mCompr.minimize(this._maxConcepts, 3));
            this._kTable.add(this._lCompr.minimize(this._lTable, 3));
            this._kk = this._kCompr.minimize(this._kTable, 3);
            this._kCompr.concatenate(this._lCompr);
            this._kCompr.concatenate(this._mCompr);
        } else if (this._nGroups == 1 && this._nExtents > 0) {
            this._kTable.add(this._compressors[0].byteCount());
            this._kk = this._kCompr.minimize(this._kTable, 3);
        }
    }

    private void writeOut(DataOutput dataOutput) throws IOException {
        if (this._nExtents == 0) {
            if (this._nGroups > 1) {
                dataOutput.write(0x80 | this._kk);
                this._kCompr.write(dataOutput);
                int n = 0;
                while (n < this._freeComp) {
                    this._compressors[n].write(dataOutput);
                    ++n;
                }
            } else {
                dataOutput.write(this._kTable.at(0));
                dataOutput.write(this._kTable.at(1));
                this._compressors[0].write(dataOutput);
            }
        } else {
            dataOutput.write((this._nGroups > 1 ? 192 : 64) | this._kk);
            this._kCompr.write(dataOutput);
            int n = 0;
            while (n < this._freeComp) {
                this._compressors[n].write(dataOutput);
                ++n;
            }
        }
    }

    private Compressor nextCompressor() {
        if (this._freeComp == this._sizeComp) {
            Compressor[] compressorArray = new Compressor[this._sizeComp *= 2];
            System.arraycopy(this._compressors, 0, compressorArray, 0, this._freeComp);
            this._compressors = compressorArray;
        }
        if (this._compressors[this._freeComp] == null) {
            this._compressors[this._freeComp] = new Compressor();
        }
        this._currentCompressor = this._compressors[this._freeComp++];
        return this._currentCompressor;
    }

    private int byteCount() {
        if (this._nGroups == 1 && this._nExtents == 0) {
            return 2 + this._compressors[0].byteCount();
        }
        int n = 1;
        n += this._kCompr.byteCount();
        int n2 = 0;
        while (n2 < this._freeComp) {
            n += this._compressors[n2].byteCount();
            ++n2;
        }
        return n;
    }
}

