@echo off

REM This script asks for variables, which are necessary for building the
REM examples of the Office Development Kit. The script duplicates the template
REM script and inserts the variables into the copied script.
REM The Script was developed for the operating systems Microsoft Windows.

setlocal

set OO_SDK_HOME=
set OFFICE_HOME=
set OO_SDK_MAKE_HOME=
set OO_SDK_CPP_HOME=
set OO_STLPORT_HOME=
set OO_SDK_JAVA_HOME=
set OO_SDK_ANT_HOME=
set SDK_AUTO_DEPLOYMENT=
set OFFICE_PROGRAM_PATH=

REM Enter installation directory of the Office Development Kit.
set OO_SDK_HOME_SUGGESTION=%CD%
set /p OO_SDK_HOME=Enter Office Development Kit (6.0 or higher) directory: [%OO_SDK_HOME_SUGGESTION%] 

if %OO_SDK_HOME%/==/ (
  if exist "%OO_SDK_HOME_SUGGESTION%" (
    set OO_SDK_HOME=%OO_SDK_HOME_SUGGESTION%
  ) else (
    echo Error: Could not find directory "%OO_SDK_HOME_SUGGESTION%" .
    echo Abort.
    exit /b
  )
)

if not exist "%OO_SDK_HOME%\idl" (
  echo Could not find directory "%OO_SDK_HOME%\idl" .
  echo Abort.
  exit /b
)


REM Enter installation directory of the Office program.
REM find "=file://" < "%APPDATA%\sversion.ini" | set /p OFFICE_HOME_SUGGESTION=
set OFFICE_HOME_SUGGESTION=
REM echo OFFICE_HOME_SUGGESTION=%OFFICE_HOME_SUGGESTION%

REM `egrep "=file://" $HOME/.sversionrc | tr -d \\\\r | head -1 | sed -e 's#.*=file://##'`
echo.
echo Enter Office (StarOffice 6.0, StarSuite 6.0, OpenOfice.org 1.0 or higher)
set /p OFFICE_HOME=installation directory: [%OFFICE_HOME_SUGGESTION%] 

if %OFFICE_HOME%/==/ (
  if exist "%OFFICE_HOME_SUGGESTION%" (
    set OFFICE_HOME=%OFFICE_HOME_SUGGESTION%
  ) else (
    echo Error: Could not find directory "%OFFICE_HOME_SUGGESTION%" .
    echo Abort.
    exit /b
  )
)

if not exist %OFFICE_HOME%\program (
  echo Could not find directory "%OFFICE_HOME%\program" .
  echo Abort.
  exit /b
)


REM Enter installation directory of the make program.

REM Search for the program make.
REM progpath=`searchprog "make"`

REM Determine directory name, and convert it to an absolute path (if necessary)
REM progdir=`dirname "$progpath"`
REM case "$progdir" in
REM     /*)	;;		# absolute path; leave unchanged
REM     *)	progdir=`cd "$progdir"; pwd`;;
REM esac

REM set OO_SDK_MAKE_HOME_SUGGESTION=%progdir%
set OO_SDK_MAKE_HOME_SUGGESTION=

echo.
REM echo Enter GNU make (3.79.1 or higher) tools directory: [%OO_SDK_MAKE_HOME_SUGGESTION%] 
set /p OO_SDK_MAKE_HOME=Enter GNU make (3.79.1 or higher) tools directory: [%OO_SDK_MAKE_HOME_SUGGESTION%] 

if %OO_SDK_MAKE_HOME%/==/ (
  if exist "%OO_SDK_MAKE_HOME_SUGGESTION%" (
    set OO_SDK_MAKE_HOME=%OO_SDK_MAKE_HOME_SUGGESTION%
  ) else (
    echo Error: Could not find directory %OO_SDK_MAKE_HOME_SUGGESTION% .
    echo Abort.
    exit /b
  )
)

if not exist %OO_SDK_MAKE_HOME%\make.exe (
  echo Could not find directory %OO_SDK_MAKE_HOME%\make.exe .
  echo Abort.
  exit /b
)


REM Enter installation directory of the C++ program.
REM for cppcommand in "CC" "c++" "g++"
REM do
REM     if [ -z $progdir ]
REM     then
REM         # Search for the c++ compiler.
REM         progpath=`searchprog "$cppcommand"`

REM         # Determine directory name, and convert it to an absolute path (if necessary)
REM         progdir=`dirname "$progpath"`
REM         case "$progdir" in
REM             /*)	;;		# absolute path; leave unchanged
REM             *)	progdir=`cd "$progdir"; pwd`;;
REM         esac
REM     fi
REM done

REM set OO_SDK_CPP_HOME_SUGGESTION=%progdir%
set OO_SDK_CPP_HOME_SUGGESTION=

echo.
REM echo Enter C++ tools directory: [%OO_SDK_CPP_HOME_SUGGESTION%] 
set /p OO_SDK_CPP_HOME=Enter C++ tools directory: [%OO_SDK_CPP_HOME_SUGGESTION%] 

if "%OO_SDK_CPP_HOME%"/==/ (
  if exist "%OO_SDK_CPP_HOME_SUGGESTION%" (
    set OO_SDK_CPP_HOME="%OO_SDK_CPP_HOME_SUGGESTION%"
  ) else (
    echo Error: Could not find directory "%OO_SDK_CPP_HOME_SUGGESTION%" .
REM    echo Abort.
REM    exit /b
  )
)

if not exist "%OO_SDK_CPP_HOME%" (
  echo Could not find directory "%OO_SDK_CPP_HOME%" .
REM  echo Abort.
REM   exit /b
) else (
  echo OO_SDK_CPP_HOME=%OO_SDK_CPP_HOME%
)

REM Enter installation directory of the STLPORT.

set OO_STLPORT_HOME_SUGGESTION=

echo.
set /p OO_STLPORT_HOME=Enter the STLPORT root directory: [%STLPPORT_HOME_SUGGESTION%] 

REM if %OO_STLPORT_HOME%/==/ (
REM   if exist "%OO_STLPORT_HOME_SUGGESTION%" (
REM     set OO_STLPORT_HOME=%OO_STLPORT_HOME_SUGGESTION%
REM   ) else (
REM     echo Error: Could not find directory %OO_STLPORT_HOME_SUGGESTION% .
REM     echo Abort.
REM     exit /b
REM   )
REM )

if "%OO_STLPORT_HOME%"/==/ (
  if not exist "%OO_STLPORT_HOME%" (
    echo Could not find directory %OO_STLPORT_HOME% .
    echo Abort.
    exit /b
  )
)

REM Enter installation directory of the JAVA program.

REM Search for the program javac.
REM progpath=`searchprog "javac"`

REM Determine directory name, and convert it to an absolute path (if necessary)
REM progdir=`dirname "$progpath"`
REM case "$progdir" in
REM     /*)	;;		# absolute path; leave unchanged
REM     *)	progdir=`cd "$progdir"; pwd`;;
REM esac

REM if [ -d $progdir ]
REM then
REM     progdir=`echo "$progdir" | sed 's|/bin||'`
REM fi

REM set OO_SDK_JAVA_HOME_SUGGESTION=%progdir%
set OO_SDK_JAVA_HOME_SUGGESTION=

echo.
REM echo Enter JAVA (1.3.1_02 or higher) tools directory: [%OO_SDK_JAVA_HOME_SUGGESTION%] 
set /p OO_SDK_JAVA_HOME=Enter JAVA (1.3.1_02 or higher) tools directory: [%OO_SDK_JAVA_HOME_SUGGESTION%] 

if %OO_SDK_JAVA_HOME%/==/ (
  if exist "%OO_SDK_JAVA_HOME_SUGGESTION%" (
    set OO_SDK_JAVA_HOME=%OO_SDK_JAVA_HOME_SUGGESTION%
  ) else (
    echo Error: Could not find directory %OO_SDK_JAVA_HOME_SUGGESTION% .
    echo Abort.
    exit /b
  )
)

if not exist %OO_SDK_JAVA_HOME% (
  echo Could not find directory %OO_SDK_JAVA_HOME% .
  echo Abort.
  exit /b
)


REM Enter installation directory of the ANT program.

REM Search for the program ant.
REM progpath=`searchprog "ant"`

REM Determine directory name, and convert it to an absolute path (if necessary)
REM progdir=`dirname "$progpath"`
REM case "$progdir" in
REM     /*)	;;		# absolute path; leave unchanged
REM     *)	progdir=`cd "$progdir"; pwd`;;
REM esac

if "%progpath%" EQU "" (
    set progdir=""
)

if exist %progdir% (
REM    progdir=`echo "$progdir" | sed 's|/bin||'`
)

REM set OO_SDK_ANT_HOME_SUGGESTION=%progdir%
set OO_SDK_ANT_HOME_SUGGESTION=

echo.
REM echo Enter ANT (1.4 or higher) installation directory: [%OO_SDK_ANT_HOME_SUGGESTION%] 
set /p OO_SDK_ANT_HOME=Enter ANT (1.4 or higher) installation directory: [%OO_SDK_ANT_HOME_SUGGESTION%] 

if %OO_SDK_ANT_HOME%/==/ (
  if exist "%OO_SDK_ANT_HOME_SUGGESTION%" (
    set OO_SDK_ANT_HOME=%OO_SDK_ANT_HOME_SUGGESTION%
  ) 
)

if not exist "%OO_SDK_ANT_HOME%" (
  if defined OO_SDK_ANT_HOME (
    echo Could not find directory %OO_SDK_ANT_HOME% .
    echo Abort.
    exit /b
  )
)


REM Automatic deployment?
set SDK_AUTO_DEPLOYMENT_SUGGESTION=YES

echo.
REM echo Automatic deployment (YES/NO): [%SDK_AUTO_DEPLOYMENT_SUGGESTION%] 
set /p SDK_AUTO_DEPLOYMENT=Automatic deployment (YES/NO): [%SDK_AUTO_DEPLOYMENT_SUGGESTION%] 

if %SDK_AUTO_DEPLOYMENT%/==/ (
  set SDK_AUTO_DEPLOYMENT=%SDK_AUTO_DEPLOYMENT_SUGGESTION%
) else (
  if not "%SDK_AUTO_DEPLOYMENT%"=="YES" (
    if not "%SDK_AUTO_DEPLOYMENT%"=="NO" (
      echo Error: The value entered "%SDK_AUTO_DEPLOYMENT%" is invalid.
      echo Abort.
      exit /b
    )
  )
)


echo @echo off > setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM This script sets all enviroment variables, which>> setsdkenv_windows.bat
echo REM are necessary for building the examples of the Office Development Kit.>> setsdkenv_windows.bat
echo REM The Script was developed for the operating systems Windows.>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Installation directory of the Software Development Kit.>> setsdkenv_windows.bat
echo REM Example: set OO_SDK_HOME=D:\api\odk>> setsdkenv_windows.bat
echo set OO_SDK_HOME=%OO_SDK_HOME%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Office installation directory.>> setsdkenv_windows.bat
echo REM Example: set OFFICE_HOME=C:\Programme\StarOffice6.0>> setsdkenv_windows.bat
echo set OFFICE_HOME=%OFFICE_HOME%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Directory of the make command.>> setsdkenv_windows.bat
echo REM Example: set OO_SDK_MAKE_HOME=D:\NextGenerationMake\make>> setsdkenv_windows.bat
echo set OO_SDK_MAKE_HOME=%OO_SDK_MAKE_HOME%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Directory of the C++ tools.>> setsdkenv_windows.bat
echo REM Example:set OO_SDK_CPP_HOME=C:\Programme\Microsoft Visual Studio\VC98\bin>> setsdkenv_windows.bat
echo set OO_SDK_CPP_HOME=%OO_SDK_CPP_HOME%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM STLPORT installation directory.>> setsdkenv_windows.bat
echo REM Example: set OO_STLPORT_HOME=D:\stlport-4.5.3>> setsdkenv_windows.bat
echo set OO_STLPORT_HOME=%OO_STLPORT_HOME%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Java installation directory.>> setsdkenv_windows.bat
echo REM Example: set OO_SDK_JAVA_HOME=C:\Programme\Java\J2SDK_Forte\jdk1.4.0>> setsdkenv_windows.bat
echo set OO_SDK_JAVA_HOME=%OO_SDK_JAVA_HOME%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM ANT installation directory.>> setsdkenv_windows.bat
echo REM Example: set OO_SDK_ANT_HOME=D:\jakarta-ant-1.4>> setsdkenv_windows.bat
echo REM set OO_SDK_ANT_HOME=%OO_SDK_ANT_HOME%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Automatic deployment>> setsdkenv_windows.bat
echo REM Example: set SDK_AUTO_DEPLOYMENT=YES>> setsdkenv_windows.bat
echo set SDK_AUTO_DEPLOYMENT=%SDK_AUTO_DEPLOYMENT%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Check installation path for the StarOffice Development Kit.>> setsdkenv_windows.bat
echo if not defined OO_SDK_HOME goto error>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Check installation path for the office.>> setsdkenv_windows.bat
echo if not defined OFFICE_HOME goto error>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Set library path. >> setsdkenv_windows.bat
echo set LIB=%%OO_SDK_HOME%%\windows\lib;%%OO_SDK_HOME%%\WINexample.out\lib;%%LIB%%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Add directory of the STLPORT library to the library path.>> setsdkenv_windows.bat
echo if defined OO_STLPORT_HOME set LIB=%%OO_STLPORT_HOME%%\lib;%%LIB%%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Set office program path.>> setsdkenv_windows.bat
echo set OFFICE_PROGRAM_PATH=%%OFFICE_HOME%%\program>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Add directory of the SDK tools to the path.>> setsdkenv_windows.bat
echo set PATH=%%OO_SDK_HOME%%\windows\bin;%%OFFICE_HOME%%\program;%%OO_SDK_HOME%%\WINexample.out\bin;%%PATH%%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Add directory of the command make to the path, if necessary.>> setsdkenv_windows.bat
echo if defined OO_SDK_MAKE_HOME set PATH=%%OO_SDK_MAKE_HOME%%;%%PATH%%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Add directory of the C++ tools to the path, if necessary.>> setsdkenv_windows.bat
echo if defined OO_SDK_CPP_HOME set PATH=%%OO_SDK_CPP_HOME%%;%%PATH%%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Add directory of the STLPORT library to the path, if necessary.>> setsdkenv_windows.bat
echo if defined OO_STLPORT_HOME set PATH=%%OO_STLPORT_HOME%%\lib;%%PATH%%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Add directory of the Java tools to the path, if necessary.>> setsdkenv_windows.bat
echo if defined OO_SDK_JAVA_HOME set PATH=%%OO_SDK_JAVA_HOME%%\bin;%%OO_SDK_JAVA_HOME%%\jre\bin;%%PATH%%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Add directory of the ANT tools to the path, if necessary.>> setsdkenv_windows.bat
echo if defined OO_SDK_ANT_HOME set PATH=%%OO_SDK_ANT_HOME%%\bin;%%PATH%%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Set environment for C++ tools, if necessary.>> setsdkenv_windows.bat
echo if defined OO_SDK_CPP_HOME call "%%OO_SDK_CPP_HOME%%\VCVARS32.bat">> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo goto end>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo :error>> setsdkenv_windows.bat
echo Error: Please insert the necessary environment variables into the batch file.>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo :end>> setsdkenv_windows.bat

endlocal
