/*************************************************************************
 *
 *  $RCSfile: SDrawDemo.java,v $
 *
 *  $Revision: 1.2.18.1 $
 *
 *  last change: $Author: jsc $ $Date: 2003/02/17 10:18:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


package com.sun.star.comp.demo;


import com.sun.star.bridge.XUnoUrlResolver;

import com.sun.star.lang.XMultiServiceFactory;

import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XNamingService;
import com.sun.star.lib.uno.helper.WeakBase;

import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XComponentLoader;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;

import com.sun.star.container.XIndexAccess;

import com.sun.star.lang.XComponent;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XTypeProvider;

import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;


public class SDrawDemo extends WeakBase implements XServiceInfo, XInitialization {
	static private final boolean DEBUG = true;

	static final String __serviceName = "com.sun.star.demo.SDrawDemo";

	public static void blabla(XMultiServiceFactory xMSF) throws Exception {
		Object oInterface = xMSF.createInstance( "com.sun.star.frame.Desktop" );
		XDesktop oDesktop = (XDesktop) UnoRuntime.queryInterface( XDesktop.class, oInterface );
		XComponentLoader oCLoader = (XComponentLoader) UnoRuntime.queryInterface(
            XComponentLoader.class, oDesktop );
		PropertyValue [] szEmptyArgs = new PropertyValue [0];
		String doc = "private:factory/sdraw";
		XComponent xDrawDoc = oCLoader.loadComponentFromURL(doc, "_blank", 0, szEmptyArgs );
		
		XDrawPagesSupplier oDPS = (XDrawPagesSupplier) UnoRuntime.queryInterface(
            XDrawPagesSupplier.class,xDrawDoc);
		XDrawPages oDPn = oDPS.getDrawPages();
		XIndexAccess oDPi = (XIndexAccess) UnoRuntime.queryInterface(XIndexAccess.class,oDPn);
		XDrawPage oObj = (XDrawPage) UnoRuntime.queryInterface( XDrawPage.class , oDPi.getByIndex(0) );
		
		//put something on the drawpage
		XShapes oShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class,oObj);
		oShapes.add(createShape(xDrawDoc,2000,1500,1000,1000,"Line",0));
		oShapes.add(createShape(xDrawDoc,3000,4500,15000,1000,"Ellipse",16711680));
		oShapes.add(createShape(xDrawDoc,5000,3500,7500,5000,"Rectangle",6710932));
	
		XShape oShape = createShape(xDrawDoc,15000,17500,2000,12000,"Rectangle", 13421823);
		oShapes.add(oShape);	

		XPropertySet oSPS = (XPropertySet)UnoRuntime.queryInterface( XPropertySet.class, oShape);
		oSPS.setPropertyValue("Shadow",new Boolean(true));
	}
	
  
	public static XShape createShape(XComponent oDoc, int height, int width, int x, int y, String kind, int col) {
		//possible values for kind are 'Ellipse', 'Line' and 'Rectangle'
		Size size = new Size();
		Point position = new Point();
		XShape oShape = null;

		//get MSF
		XMultiServiceFactory oDocMSF = (XMultiServiceFactory) UnoRuntime.queryInterface(
            XMultiServiceFactory.class, oDoc );

		try{
			Object oInt = oDocMSF.createInstance("com.sun.star.drawing."+kind+"Shape");
			oShape = (XShape)UnoRuntime.queryInterface( XShape.class, oInt );
			size.Height = height;
			size.Width = width;
			position.X = x;
			position.Y = y;
			oShape.setSize(size);
			oShape.setPosition(position);

		} catch ( Exception e ) {
			// Some exception occures.FAILED
			System.out.println( "Couldn't create instance "+ e );
		}
	 
		XPropertySet oSPS = (XPropertySet)UnoRuntime.queryInterface( XPropertySet.class, oShape);
     
		try { 
        
			oSPS.setPropertyValue("FillColor",new Integer(col));
      
		} catch (Exception e) {
     
			System.out.println("Can't change colors " + e);     
     
		}


		return oShape;

	}  

	private XMultiServiceFactory _xMultiServiceFactory;
		
	public SDrawDemo(XMultiServiceFactory xMultiServiceFactory) {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".<init>:" + xMultiServiceFactory);
		
		_xMultiServiceFactory = xMultiServiceFactory;

		try {
			blabla(_xMultiServiceFactory);
		}
		catch(Exception exception) {
			System.err.println(getClass().getName() + "<init(XMultiServiceFactory)> - exception:" + exception);
		}
	}
	
	// XInitialization
	public void initialize(Object[] aArguments) throws com.sun.star.uno.Exception, com.sun.star.uno.RuntimeException {
		if(DEBUG) {
			System.err.println("##### " + getClass().getName() + ".initialize;");
			
			for(int i = 0; i < aArguments.length; ++ i)
				System.err.println("##### " + aArguments[i]);
		}
		
		_xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(
            XMultiServiceFactory.class, aArguments[0]);
		
		if(_xMultiServiceFactory == null) {
			XNamingService xNamingService = (XNamingService)UnoRuntime.queryInterface(
                XNamingService.class, aArguments[0]);
			Object smgr = xNamingService.getRegisteredObject("StarOffice.ServiceManager");
			_xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(
                XMultiServiceFactory.class, smgr);
		}
	}
	
	// XServiceInfo
	public String getImplementationName() throws com.sun.star.uno.RuntimeException {
		return getClass().getName();
	}
	
	public boolean supportsService(String serviceName) throws com.sun.star.uno.RuntimeException {
		return __serviceName.equals(serviceName);
	}
	
	public String[] getSupportedServiceNames() throws com.sun.star.uno.RuntimeException {
		return new String[] {__serviceName};
	}
}
