/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.Pipe;
import com.sun.xml.internal.ws.api.pipe.TransportPipeFactory;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.internal.ws.transport.http.client.HttpTransportPipe;
import com.sun.xml.internal.ws.util.ServiceFinder;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;

public abstract class TransportTubeFactory {
    private static final Logger logger = Logger.getLogger(TransportTubeFactory.class.getName());

    public abstract Tube doCreate(@NotNull ClientTubeAssemblerContext var1);

    public static Tube create(@Nullable ClassLoader classLoader, @NotNull ClientTubeAssemblerContext clientTubeAssemblerContext) {
        for (TransportTubeFactory object2 : ServiceFinder.find(TransportTubeFactory.class, classLoader)) {
            Tube tube = object2.doCreate(clientTubeAssemblerContext);
            if (tube == null) continue;
            logger.fine(object2.getClass() + " successfully created " + tube);
            return tube;
        }
        ClientPipeAssemblerContext clientPipeAssemblerContext = new ClientPipeAssemblerContext(clientTubeAssemblerContext.getAddress(), clientTubeAssemblerContext.getWsdlModel(), clientTubeAssemblerContext.getService(), clientTubeAssemblerContext.getBinding(), clientTubeAssemblerContext.getContainer());
        for (TransportPipeFactory transportPipeFactory : ServiceFinder.find(TransportPipeFactory.class, classLoader)) {
            Pipe pipe = transportPipeFactory.doCreate(clientPipeAssemblerContext);
            if (pipe == null) continue;
            logger.fine(transportPipeFactory.getClass() + " successfully created " + pipe);
            return PipeAdapter.adapt(pipe);
        }
        String string = clientTubeAssemblerContext.getAddress().getURI().getScheme();
        if (string != null && (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("https"))) {
            return new HttpTransportPipe(clientTubeAssemblerContext.getCodec());
        }
        throw new WebServiceException("Unsupported endpoint address: " + clientTubeAssemblerContext.getAddress());
    }
}

