/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLStreamFilterImpl
implements XMLStreamReader {
    private StreamFilter fStreamFilter = null;
    private XMLStreamReader fStreamReader = null;
    private int fCurrentEvent;
    private boolean fEventAccepted = false;
    private boolean fStreamAdvancedByHasNext = false;

    public XMLStreamFilterImpl(XMLStreamReader xMLStreamReader, StreamFilter streamFilter) {
        this.fStreamReader = xMLStreamReader;
        this.fStreamFilter = streamFilter;
        try {
            if (this.fStreamFilter.accept(this.fStreamReader)) {
                this.fEventAccepted = true;
            } else {
                this.findNextEvent();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            System.err.println("Error while creating a stream Filter" + xMLStreamException);
        }
    }

    protected void setStreamFilter(StreamFilter streamFilter) {
        this.fStreamFilter = streamFilter;
    }

    public int next() throws XMLStreamException {
        if (this.fStreamAdvancedByHasNext && this.fEventAccepted) {
            this.fStreamAdvancedByHasNext = false;
            return this.fCurrentEvent;
        }
        int n = this.findNextEvent();
        if (n != -1) {
            return n;
        }
        throw new IllegalStateException("The stream reader has reached the end of the document, or there are no more  items to return");
    }

    public int nextTag() throws XMLStreamException {
        if (this.fStreamAdvancedByHasNext && this.fEventAccepted && (this.fCurrentEvent == 1 || this.fCurrentEvent == 1)) {
            this.fStreamAdvancedByHasNext = false;
            return this.fCurrentEvent;
        }
        int n = this.findNextTag();
        if (n != -1) {
            return n;
        }
        throw new IllegalStateException("The stream reader has reached the end of the document, or there are no more  items to return");
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.fStreamReader.hasNext()) {
            if (!this.fEventAccepted) {
                this.fCurrentEvent = this.findNextEvent();
                if (this.fCurrentEvent == -1) {
                    return false;
                }
                this.fStreamAdvancedByHasNext = true;
            }
            return true;
        }
        return false;
    }

    private int findNextEvent() throws XMLStreamException {
        this.fStreamAdvancedByHasNext = false;
        while (this.fStreamReader.hasNext()) {
            this.fCurrentEvent = this.fStreamReader.next();
            if (!this.fStreamFilter.accept(this.fStreamReader)) continue;
            this.fEventAccepted = true;
            return this.fCurrentEvent;
        }
        if (this.fCurrentEvent == 8) {
            return this.fCurrentEvent;
        }
        return -1;
    }

    private int findNextTag() throws XMLStreamException {
        this.fStreamAdvancedByHasNext = false;
        while (this.fStreamReader.hasNext()) {
            this.fCurrentEvent = this.fStreamReader.nextTag();
            if (!this.fStreamFilter.accept(this.fStreamReader)) continue;
            this.fEventAccepted = true;
            return this.fCurrentEvent;
        }
        if (this.fCurrentEvent == 8) {
            return this.fCurrentEvent;
        }
        return -1;
    }

    public void close() throws XMLStreamException {
        this.fStreamReader.close();
    }

    public int getAttributeCount() {
        return this.fStreamReader.getAttributeCount();
    }

    public QName getAttributeName(int n) {
        return this.fStreamReader.getAttributeName(n);
    }

    public String getAttributeNamespace(int n) {
        return this.fStreamReader.getAttributeNamespace(n);
    }

    public String getAttributePrefix(int n) {
        return this.fStreamReader.getAttributePrefix(n);
    }

    public String getAttributeType(int n) {
        return this.fStreamReader.getAttributeType(n);
    }

    public String getAttributeValue(int n) {
        return this.fStreamReader.getAttributeValue(n);
    }

    public String getAttributeValue(String string, String string2) {
        return this.fStreamReader.getAttributeValue(string, string2);
    }

    public String getCharacterEncodingScheme() {
        return this.fStreamReader.getCharacterEncodingScheme();
    }

    public String getElementText() throws XMLStreamException {
        return this.fStreamReader.getElementText();
    }

    public String getEncoding() {
        return this.fStreamReader.getEncoding();
    }

    public int getEventType() {
        return this.fStreamReader.getEventType();
    }

    public String getLocalName() {
        return this.fStreamReader.getLocalName();
    }

    public Location getLocation() {
        return this.fStreamReader.getLocation();
    }

    public QName getName() {
        return this.fStreamReader.getName();
    }

    public NamespaceContext getNamespaceContext() {
        return this.fStreamReader.getNamespaceContext();
    }

    public int getNamespaceCount() {
        return this.fStreamReader.getNamespaceCount();
    }

    public String getNamespacePrefix(int n) {
        return this.fStreamReader.getNamespacePrefix(n);
    }

    public String getNamespaceURI() {
        return this.fStreamReader.getNamespaceURI();
    }

    public String getNamespaceURI(int n) {
        return this.fStreamReader.getNamespaceURI(n);
    }

    public String getNamespaceURI(String string) {
        return this.fStreamReader.getNamespaceURI(string);
    }

    public String getPIData() {
        return this.fStreamReader.getPIData();
    }

    public String getPITarget() {
        return this.fStreamReader.getPITarget();
    }

    public String getPrefix() {
        return this.fStreamReader.getPrefix();
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return this.fStreamReader.getProperty(string);
    }

    public String getText() {
        return this.fStreamReader.getText();
    }

    public char[] getTextCharacters() {
        return this.fStreamReader.getTextCharacters();
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        return this.fStreamReader.getTextCharacters(n, cArray, n2, n3);
    }

    public int getTextLength() {
        return this.fStreamReader.getTextLength();
    }

    public int getTextStart() {
        return this.fStreamReader.getTextStart();
    }

    public String getVersion() {
        return this.fStreamReader.getVersion();
    }

    public boolean hasName() {
        return this.fStreamReader.hasName();
    }

    public boolean hasText() {
        return this.fStreamReader.hasText();
    }

    public boolean isAttributeSpecified(int n) {
        return this.fStreamReader.isAttributeSpecified(n);
    }

    public boolean isCharacters() {
        return this.fStreamReader.isCharacters();
    }

    public boolean isEndElement() {
        return this.fStreamReader.isEndElement();
    }

    public boolean isStandalone() {
        return this.fStreamReader.isStandalone();
    }

    public boolean isStartElement() {
        return this.fStreamReader.isStartElement();
    }

    public boolean isWhiteSpace() {
        return this.fStreamReader.isWhiteSpace();
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        this.fStreamReader.require(n, string, string2);
    }

    public boolean standaloneSet() {
        return this.fStreamReader.standaloneSet();
    }

    public String getAttributeLocalName(int n) {
        return this.fStreamReader.getAttributeLocalName(n);
    }
}

