/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

public class CharArrayWriter
extends Writer {
    protected char[] buf;
    protected int count;

    public CharArrayWriter() {
        this(32);
    }

    public CharArrayWriter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.buf = new char[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) {
        Object object = this.lock;
        synchronized (object) {
            int n2 = this.count + 1;
            if (n2 > this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, n2));
            }
            this.buf[this.count] = (char)n;
            this.count = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            int n3 = this.count + n2;
            if (n3 > this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, n3));
            }
            System.arraycopy(cArray, n, this.buf, this.count, n2);
            this.count = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            int n3 = this.count + n2;
            if (n3 > this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, n3));
            }
            string.getChars(n, n + n2, this.buf, this.count);
            this.count = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer writer) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            writer.write(this.buf, 0, this.count);
        }
    }

    public CharArrayWriter append(CharSequence charSequence) {
        String string = charSequence == null ? "null" : ((Object)charSequence).toString();
        this.write(string, 0, string.length());
        return this;
    }

    public CharArrayWriter append(CharSequence charSequence, int n, int n2) {
        String string = ((Object)(charSequence == null ? "null" : charSequence).subSequence(n, n2)).toString();
        this.write(string, 0, string.length());
        return this;
    }

    public CharArrayWriter append(char c) {
        this.write(c);
        return this;
    }

    public void reset() {
        this.count = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] toCharArray() {
        Object object = this.lock;
        synchronized (object) {
            return Arrays.copyOf(this.buf, this.count);
        }
    }

    public int size() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return new String(this.buf, 0, this.count);
        }
    }

    public void flush() {
    }

    public void close() {
    }
}

