/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AlphaComposite;
import java.awt.Composite;
import sun.font.GlyphList;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.GlyphListPipe;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;

class OGLTextRenderer
extends GlyphListPipe {
    private static final int BYTES_PER_GLYPH_IMAGE = 8;
    private static final int BYTES_PER_GLYPH_POSITION = 8;
    private static final int OFFSET_CONTRAST = 8;
    private static final int OFFSET_RGBORDER = 2;
    private static final int OFFSET_SUBPIXPOS = 1;
    private static final int OFFSET_POSITIONS = 0;

    OGLTextRenderer() {
    }

    private static int createPackedParams(SunGraphics2D sunGraphics2D, GlyphList glyphList) {
        return (glyphList.usePositions() ? 1 : 0) << 0 | (glyphList.isSubPixPos() ? 1 : 0) << 1 | (glyphList.isRGBOrder() ? 1 : 0) << 2 | (sunGraphics2D.lcdTextContrast & 0xFF) << 8;
    }

    private void drawGlyphList(RenderQueue renderQueue, final SunGraphics2D sunGraphics2D, final GlyphList glyphList) {
        RenderBuffer renderBuffer = renderQueue.getBuffer();
        final int n = glyphList.getNumGlyphs();
        int n2 = n * 8;
        int n3 = glyphList.usePositions() ? n * 8 : 0;
        int n4 = 24 + n2 + n3;
        final long[] lArray = glyphList.getImages();
        final float f = glyphList.getX() + 0.5f;
        final float f2 = glyphList.getY() + 0.5f;
        renderQueue.addReference(glyphList.getStrike());
        if (n4 <= renderBuffer.capacity()) {
            if (n4 > renderBuffer.remaining()) {
                renderQueue.flushNow();
            }
            renderQueue.ensureAlignment(20);
            renderBuffer.putInt(40);
            renderBuffer.putInt(n);
            renderBuffer.putInt(OGLTextRenderer.createPackedParams(sunGraphics2D, glyphList));
            renderBuffer.putFloat(f);
            renderBuffer.putFloat(f2);
            renderBuffer.put(lArray, 0, n);
            if (glyphList.usePositions()) {
                float[] fArray = glyphList.getPositions();
                renderBuffer.put(fArray, 0, 2 * n);
            }
        } else {
            renderQueue.flushAndInvokeNow(new Runnable(){

                public void run() {
                    OGLTextRenderer.this.drawGlyphList(n, glyphList.usePositions(), glyphList.isSubPixPos(), glyphList.isRGBOrder(), sunGraphics2D.lcdTextContrast, f, f2, lArray, glyphList.getPositions());
                }
            });
        }
    }

    private native void drawGlyphList(int var1, boolean var2, boolean var3, boolean var4, int var5, float var6, float var7, long[] var8, float[] var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawGlyphList(SunGraphics2D sunGraphics2D, GlyphList glyphList) {
        Composite composite = sunGraphics2D.composite;
        if (composite == AlphaComposite.Src) {
            composite = AlphaComposite.SrcOver;
        }
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            OGLSurfaceData oGLSurfaceData = (OGLSurfaceData)sunGraphics2D.surfaceData;
            OGLContext.validateContext(oGLSurfaceData, oGLSurfaceData, sunGraphics2D.getCompClip(), composite, null, sunGraphics2D.pixel, 0);
            this.drawGlyphList(oGLRenderQueue, sunGraphics2D, glyphList);
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }

    OGLTextRenderer traceWrap() {
        return new Tracer();
    }

    private static class Tracer
    extends OGLTextRenderer {
        private Tracer() {
        }

        protected void drawGlyphList(SunGraphics2D sunGraphics2D, GlyphList glyphList) {
            GraphicsPrimitive.tracePrimitive("OGLDrawGlyphs");
            super.drawGlyphList(sunGraphics2D, glyphList);
        }
    }
}

