/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.geom;

import java.awt.geom.PathIterator;
import java.util.Enumeration;
import java.util.Vector;
import sun.awt.geom.Curve;

public abstract class Crossings {
    public static final boolean debug = false;
    int limit = 0;
    double[] yranges = new double[10];
    double xlo;
    double ylo;
    double xhi;
    double yhi;
    private Vector tmp = new Vector();

    public Crossings(double d, double d2, double d3, double d4) {
        this.xlo = d;
        this.ylo = d2;
        this.xhi = d3;
        this.yhi = d4;
    }

    public final double getXLo() {
        return this.xlo;
    }

    public final double getYLo() {
        return this.ylo;
    }

    public final double getXHi() {
        return this.xhi;
    }

    public final double getYHi() {
        return this.yhi;
    }

    public abstract void record(double var1, double var3, int var5);

    public void print() {
        System.out.println("Crossings [");
        System.out.println("  bounds = [" + this.ylo + ", " + this.yhi + "]");
        for (int i = 0; i < this.limit; i += 2) {
            System.out.println("  [" + this.yranges[i] + ", " + this.yranges[i + 1] + "]");
        }
        System.out.println("]");
    }

    public final boolean isEmpty() {
        return this.limit == 0;
    }

    public abstract boolean covers(double var1, double var3);

    public static Crossings findCrossings(Vector vector, double d, double d2, double d3, double d4) {
        EvenOdd evenOdd = new EvenOdd(d, d2, d3, d4);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Curve curve = (Curve)enumeration.nextElement();
            if (!curve.accumulateCrossings(evenOdd)) continue;
            return null;
        }
        return evenOdd;
    }

    public static Crossings findCrossings(PathIterator pathIterator, double d, double d2, double d3, double d4) {
        Crossings crossings = pathIterator.getWindingRule() == 0 ? new EvenOdd(d, d2, d3, d4) : new NonZero(d, d2, d3, d4);
        double[] dArray = new double[23];
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    if (d6 != d8 && crossings.accumulateLine(d7, d8, d5, d6)) {
                        return null;
                    }
                    d5 = d7 = dArray[0];
                    d6 = d8 = dArray[1];
                    break;
                }
                case 1: {
                    double d9 = dArray[0];
                    double d10 = dArray[1];
                    if (crossings.accumulateLine(d7, d8, d9, d10)) {
                        return null;
                    }
                    d7 = d9;
                    d8 = d10;
                    break;
                }
                case 2: {
                    double d9 = dArray[2];
                    double d10 = dArray[3];
                    if (crossings.accumulateQuad(d7, d8, dArray)) {
                        return null;
                    }
                    d7 = d9;
                    d8 = d10;
                    break;
                }
                case 3: {
                    double d9 = dArray[4];
                    double d10 = dArray[5];
                    if (crossings.accumulateCubic(d7, d8, dArray)) {
                        return null;
                    }
                    d7 = d9;
                    d8 = d10;
                    break;
                }
                case 4: {
                    if (d6 != d8 && crossings.accumulateLine(d7, d8, d5, d6)) {
                        return null;
                    }
                    d7 = d5;
                    d8 = d6;
                }
            }
            pathIterator.next();
        }
        if (d6 != d8 && crossings.accumulateLine(d7, d8, d5, d6)) {
            return null;
        }
        return crossings;
    }

    public boolean accumulateLine(double d, double d2, double d3, double d4) {
        if (d2 <= d4) {
            return this.accumulateLine(d, d2, d3, d4, 1);
        }
        return this.accumulateLine(d3, d4, d, d2, -1);
    }

    public boolean accumulateLine(double d, double d2, double d3, double d4, int n) {
        double d5;
        double d6;
        double d7;
        double d8;
        if (this.yhi <= d2 || this.ylo >= d4) {
            return false;
        }
        if (d >= this.xhi && d3 >= this.xhi) {
            return false;
        }
        if (d2 == d4) {
            return d >= this.xlo || d3 >= this.xlo;
        }
        double d9 = d3 - d;
        double d10 = d4 - d2;
        if (d2 < this.ylo) {
            d8 = d + (this.ylo - d2) * d9 / d10;
            d7 = this.ylo;
        } else {
            d8 = d;
            d7 = d2;
        }
        if (this.yhi < d4) {
            d6 = d + (this.yhi - d2) * d9 / d10;
            d5 = this.yhi;
        } else {
            d6 = d3;
            d5 = d4;
        }
        if (d8 >= this.xhi && d6 >= this.xhi) {
            return false;
        }
        if (d8 > this.xlo || d6 > this.xlo) {
            return true;
        }
        this.record(d7, d5, n);
        return false;
    }

    public boolean accumulateQuad(double d, double d2, double[] dArray) {
        if (d2 < this.ylo && dArray[1] < this.ylo && dArray[3] < this.ylo) {
            return false;
        }
        if (d2 > this.yhi && dArray[1] > this.yhi && dArray[3] > this.yhi) {
            return false;
        }
        if (d > this.xhi && dArray[0] > this.xhi && dArray[2] > this.xhi) {
            return false;
        }
        if (d < this.xlo && dArray[0] < this.xlo && dArray[2] < this.xlo) {
            if (d2 < dArray[3]) {
                this.record(Math.max(d2, this.ylo), Math.min(dArray[3], this.yhi), 1);
            } else if (d2 > dArray[3]) {
                this.record(Math.max(dArray[3], this.ylo), Math.min(d2, this.yhi), -1);
            }
            return false;
        }
        Curve.insertQuad(this.tmp, d, d2, dArray);
        Enumeration enumeration = this.tmp.elements();
        while (enumeration.hasMoreElements()) {
            Curve curve = (Curve)enumeration.nextElement();
            if (!curve.accumulateCrossings(this)) continue;
            return true;
        }
        this.tmp.clear();
        return false;
    }

    public boolean accumulateCubic(double d, double d2, double[] dArray) {
        if (d2 < this.ylo && dArray[1] < this.ylo && dArray[3] < this.ylo && dArray[5] < this.ylo) {
            return false;
        }
        if (d2 > this.yhi && dArray[1] > this.yhi && dArray[3] > this.yhi && dArray[5] > this.yhi) {
            return false;
        }
        if (d > this.xhi && dArray[0] > this.xhi && dArray[2] > this.xhi && dArray[4] > this.xhi) {
            return false;
        }
        if (d < this.xlo && dArray[0] < this.xlo && dArray[2] < this.xlo && dArray[4] < this.xlo) {
            if (d2 <= dArray[5]) {
                this.record(Math.max(d2, this.ylo), Math.min(dArray[5], this.yhi), 1);
            } else {
                this.record(Math.max(dArray[5], this.ylo), Math.min(d2, this.yhi), -1);
            }
            return false;
        }
        Curve.insertCubic(this.tmp, d, d2, dArray);
        Enumeration enumeration = this.tmp.elements();
        while (enumeration.hasMoreElements()) {
            Curve curve = (Curve)enumeration.nextElement();
            if (!curve.accumulateCrossings(this)) continue;
            return true;
        }
        this.tmp.clear();
        return false;
    }

    public static final class EvenOdd
    extends Crossings {
        public EvenOdd(double d, double d2, double d3, double d4) {
            super(d, d2, d3, d4);
        }

        public final boolean covers(double d, double d2) {
            return this.limit == 2 && this.yranges[0] <= d && this.yranges[1] >= d2;
        }

        public void record(double d, double d2, int n) {
            int n2;
            if (d >= d2) {
                return;
            }
            for (n2 = 0; n2 < this.limit && d > this.yranges[n2 + 1]; n2 += 2) {
            }
            int n3 = n2;
            while (n2 < this.limit) {
                double d3;
                double d4;
                double d5;
                double d6;
                double d7 = this.yranges[n2++];
                double d8 = this.yranges[n2++];
                if (d2 < d7) {
                    this.yranges[n3++] = d;
                    this.yranges[n3++] = d2;
                    d = d7;
                    d2 = d8;
                    continue;
                }
                if (d < d7) {
                    d6 = d;
                    d5 = d7;
                } else {
                    d6 = d7;
                    d5 = d;
                }
                if (d2 < d8) {
                    d4 = d2;
                    d3 = d8;
                } else {
                    d4 = d8;
                    d3 = d2;
                }
                if (d5 == d4) {
                    d = d6;
                    d2 = d3;
                } else {
                    if (d5 > d4) {
                        d = d4;
                        d4 = d5;
                        d5 = d;
                    }
                    if (d6 != d5) {
                        this.yranges[n3++] = d6;
                        this.yranges[n3++] = d5;
                    }
                    d = d4;
                    d2 = d3;
                }
                if (!(d >= d2)) continue;
                break;
            }
            if (n3 < n2 && n2 < this.limit) {
                System.arraycopy(this.yranges, n2, this.yranges, n3, this.limit - n2);
            }
            n3 += this.limit - n2;
            if (d < d2) {
                if (n3 >= this.yranges.length) {
                    double[] dArray = new double[n3 + 10];
                    System.arraycopy(this.yranges, 0, dArray, 0, n3);
                    this.yranges = dArray;
                }
                this.yranges[n3++] = d;
                this.yranges[n3++] = d2;
            }
            this.limit = n3;
        }
    }

    public static final class NonZero
    extends Crossings {
        private int[] crosscounts;

        public NonZero(double d, double d2, double d3, double d4) {
            super(d, d2, d3, d4);
            this.crosscounts = new int[this.yranges.length / 2];
        }

        public final boolean covers(double d, double d2) {
            int n = 0;
            while (n < this.limit) {
                double d3;
                double d4 = this.yranges[n++];
                if (d >= (d3 = this.yranges[n++])) continue;
                if (d < d4) {
                    return false;
                }
                if (d2 <= d3) {
                    return true;
                }
                d = d3;
            }
            return d >= d2;
        }

        public void remove(int n) {
            this.limit -= 2;
            int n2 = this.limit - n;
            if (n2 > 0) {
                System.arraycopy(this.yranges, n + 2, this.yranges, n, n2);
                System.arraycopy(this.crosscounts, n / 2 + 1, this.crosscounts, n / 2, n2 / 2);
            }
        }

        public void insert(int n, double d, double d2, int n2) {
            int n3 = this.limit - n;
            double[] dArray = this.yranges;
            int[] nArray = this.crosscounts;
            if (this.limit >= this.yranges.length) {
                this.yranges = new double[this.limit + 10];
                System.arraycopy(dArray, 0, this.yranges, 0, n);
                this.crosscounts = new int[(this.limit + 10) / 2];
                System.arraycopy(nArray, 0, this.crosscounts, 0, n / 2);
            }
            if (n3 > 0) {
                System.arraycopy(dArray, n, this.yranges, n + 2, n3);
                System.arraycopy(nArray, n / 2, this.crosscounts, n / 2 + 1, n3 / 2);
            }
            this.yranges[n + 0] = d;
            this.yranges[n + 1] = d2;
            this.crosscounts[n / 2] = n2;
            this.limit += 2;
        }

        public void record(double d, double d2, int n) {
            int n2;
            if (d >= d2) {
                return;
            }
            for (n2 = 0; n2 < this.limit && d > this.yranges[n2 + 1]; n2 += 2) {
            }
            if (n2 < this.limit) {
                int n3 = this.crosscounts[n2 / 2];
                double d3 = this.yranges[n2 + 0];
                double d4 = this.yranges[n2 + 1];
                if (d4 == d && n3 == n) {
                    if (n2 + 2 == this.limit) {
                        this.yranges[n2 + 1] = d2;
                        return;
                    }
                    this.remove(n2);
                    d = d3;
                    n3 = this.crosscounts[n2 / 2];
                    d3 = this.yranges[n2 + 0];
                    d4 = this.yranges[n2 + 1];
                }
                if (d2 < d3) {
                    this.insert(n2, d, d2, n);
                    return;
                }
                if (d2 == d3 && n3 == n) {
                    this.yranges[n2] = d;
                    return;
                }
                if (d < d3) {
                    this.insert(n2, d, d3, n);
                    n2 += 2;
                    d = d3;
                } else if (d3 < d) {
                    this.insert(n2, d3, d, n3);
                    n2 += 2;
                    d3 = d;
                }
                int n4 = n3 + n;
                double d5 = Math.min(d2, d4);
                if (n4 == 0) {
                    this.remove(n2);
                } else {
                    this.crosscounts[n2 / 2] = n4;
                    this.yranges[n2++] = d;
                    this.yranges[n2++] = d5;
                }
                d = d3 = d5;
                if (d3 < d4) {
                    this.insert(n2, d3, d4, n3);
                }
            }
            if (d < d2) {
                this.insert(n2, d, d2, n);
            }
        }
    }
}

