/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalBagLayout
implements LayoutManager {
    int vgap;

    public VerticalBagLayout() {
        this(0);
    }

    public VerticalBagLayout(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        int n = container.countComponents();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.minimumSize();
            dimension.width = Math.max(dimension2.width, dimension.width);
            dimension.height += dimension2.height + this.vgap;
        }
        Insets insets = container.insets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        int n = container.countComponents();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension2 = component.preferredSize();
            dimension.width = Math.max(dimension2.width, dimension.width);
            dimension.height += dimension2.height + this.vgap;
        }
        Insets insets = container.insets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.insets();
        int n = insets.top;
        int n2 = container.size().height - insets.bottom;
        int n3 = insets.left;
        int n4 = container.size().width - insets.right;
        int n5 = container.countComponents();
        for (int i = 0; i < n5; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            int n6 = component.size().height;
            component.resize(n4 - n3, n6);
            Dimension dimension = component.preferredSize();
            component.reshape(n3, n, n4 - n3, dimension.height);
            n += dimension.height + this.vgap;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[vgap=" + this.vgap + "]";
    }
}

