/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.ipc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.plugin2.ipc.Event;
import sun.plugin2.ipc.NamedPipe;
import sun.plugin2.util.SystemUtil;

public abstract class IPCFactory {
    public static final int KB = 1024;
    public static final int PIPE_BUF_SZ = 4096;
    private static IPCFactory instance;

    protected IPCFactory() {
    }

    public static IPCFactory getFactory() {
        if (instance == null) {
            try {
                String string;
                switch (SystemUtil.getOSType()) {
                    case 1: {
                        string = "sun.plugin2.ipc.windows.WindowsIPCFactory";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "sun.plugin2.ipc.unix.UnixIPCFactory";
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown OS type from SystemUtil.getOSType()");
                    }
                }
                instance = (IPCFactory)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException(exception);
            }
        }
        return instance;
    }

    public abstract Event createEvent(Map var1);

    public abstract NamedPipe createNamedPipe(Map var1);

    public static String mapToString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append((String)map.get(string));
        }
        return stringBuffer.toString();
    }

    public static Map stringToMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        return hashMap;
    }
}

