/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap;

import com.sun.xml.internal.messaging.saaj.util.transform.EfficientStreamingTransformer;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlDataContentHandler
implements DataContentHandler {
    public final String STR_SRC = "javax.xml.transform.stream.StreamSource";
    private static Class streamSourceClass = null;

    public XmlDataContentHandler() throws ClassNotFoundException {
        if (streamSourceClass == null) {
            streamSourceClass = Class.forName("javax.xml.transform.stream.StreamSource");
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{new ActivationDataFlavor(streamSourceClass, "text/xml", "XML"), new ActivationDataFlavor(streamSourceClass, "application/xml", "XML")};
        return dataFlavorArray;
    }

    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws IOException {
        if ((dataFlavor.getMimeType().startsWith("text/xml") || dataFlavor.getMimeType().startsWith("application/xml")) && dataFlavor.getRepresentationClass().getName().equals("javax.xml.transform.stream.StreamSource")) {
            return new StreamSource(dataSource.getInputStream());
        }
        return null;
    }

    public Object getContent(DataSource dataSource) throws IOException {
        return new StreamSource(dataSource.getInputStream());
    }

    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        if (!string.equals("text/xml") && !string.equals("application/xml")) {
            throw new IOException("Invalid content type \"" + string + "\" for XmlDCH");
        }
        try {
            Transformer transformer = EfficientStreamingTransformer.newTransformer();
            StreamResult streamResult = new StreamResult(outputStream);
            if (object instanceof DataSource) {
                transformer.transform((Source)this.getContent((DataSource)object), streamResult);
            } else {
                transformer.transform((Source)object, streamResult);
            }
        }
        catch (Exception exception) {
            throw new IOException("Unable to run the JAXP transformer on a stream " + exception.getMessage());
        }
    }
}

