/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.JsseJce;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

final class MAC {
    static final MAC NULL = new MAC();
    private static final byte[] nullMAC = new byte[0];
    private final CipherSuite.MacAlg macAlg;
    private final int macSize;
    private final Mac mac;
    private final byte[] block;
    private static final int BLOCK_SIZE_SSL = 11;
    private static final int BLOCK_SIZE_TLS = 13;
    private static final int BLOCK_OFFSET_TYPE = 8;
    private static final int BLOCK_OFFSET_VERSION = 9;

    private MAC() {
        this.macSize = 0;
        this.macAlg = CipherSuite.M_NULL;
        this.mac = null;
        this.block = null;
    }

    MAC(CipherSuite.MacAlg macAlg, ProtocolVersion protocolVersion, SecretKey secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
        String string;
        boolean bl;
        this.macAlg = macAlg;
        this.macSize = macAlg.size;
        boolean bl2 = bl = protocolVersion.v >= ProtocolVersion.TLS10.v;
        if (macAlg == CipherSuite.M_MD5) {
            string = bl ? "HmacMD5" : "SslMacMD5";
        } else if (macAlg == CipherSuite.M_SHA) {
            string = bl ? "HmacSHA1" : "SslMacSHA1";
        } else {
            throw new RuntimeException("Unknown Mac " + macAlg);
        }
        this.mac = JsseJce.getMac(string);
        this.mac.init(secretKey);
        if (bl) {
            this.block = new byte[13];
            this.block[9] = protocolVersion.major;
            this.block[10] = protocolVersion.minor;
        } else {
            this.block = new byte[11];
        }
    }

    int MAClen() {
        return this.macSize;
    }

    final byte[] compute(byte by, byte[] byArray, int n, int n2) {
        return this.compute(by, null, byArray, n, n2);
    }

    final byte[] compute(byte by, ByteBuffer byteBuffer) {
        return this.compute(by, byteBuffer, null, 0, byteBuffer.remaining());
    }

    private void incrementSequenceNumber() {
        int n = 7;
        while (n >= 0) {
            int n2 = n--;
            this.block[n2] = (byte)(this.block[n2] + 1);
            if (this.block[n2] == 0) continue;
        }
    }

    private byte[] compute(byte by, ByteBuffer byteBuffer, byte[] byArray, int n, int n2) {
        if (this.macSize == 0) {
            return nullMAC;
        }
        this.block[8] = by;
        this.block[this.block.length - 2] = (byte)(n2 >> 8);
        this.block[this.block.length - 1] = (byte)n2;
        this.mac.update(this.block);
        this.incrementSequenceNumber();
        if (byteBuffer != null) {
            this.mac.update(byteBuffer);
        } else {
            this.mac.update(byArray, n, n2);
        }
        return this.mac.doFinal();
    }
}

