/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsContext;
import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.NameNode;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class NameClassPairEnumeration
implements NamingEnumeration {
    protected Enumeration nodes;
    protected DnsContext ctx;

    NameClassPairEnumeration(DnsContext dnsContext, Hashtable hashtable) {
        this.ctx = dnsContext;
        this.nodes = hashtable != null ? hashtable.elements() : null;
    }

    public void close() {
        this.nodes = null;
        if (this.ctx != null) {
            this.ctx = null;
        }
    }

    public boolean hasMore() {
        boolean bl;
        boolean bl2 = bl = this.nodes != null && this.nodes.hasMoreElements();
        if (!bl) {
            this.close();
        }
        return bl;
    }

    public Object next() throws NamingException {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        NameNode nameNode = (NameNode)this.nodes.nextElement();
        String string = nameNode.isZoneCut() || nameNode.getChildren() != null ? "javax.naming.directory.DirContext" : "java.lang.Object";
        String string2 = nameNode.getLabel();
        Name name = new DnsName().add(string2);
        Name name2 = new CompositeName().add(name.toString());
        NameClassPair nameClassPair = new NameClassPair(name2.toString(), string);
        nameClassPair.setNameInNamespace(this.ctx.fullyQualify(name2).toString());
        return nameClassPair;
    }

    public boolean hasMoreElements() {
        return this.hasMore();
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException("javax.naming.NamingException was thrown: " + namingException.getMessage());
        }
    }
}

