/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public final class CastExpression
extends UnaryExpression {
    static IntHashMap castingTable = new IntHashMap(25);
    private AtomicType targetType;
    private AtomicType targetPrimitiveType;
    private boolean allowEmpty = false;
    private boolean derived = false;
    private boolean upcast = false;

    static void addAllowedCasts(int source, int[] target) {
        castingTable.put(source, target);
    }

    public static boolean isPossibleCast(int source, int target) {
        int[] targets;
        if (source == 632 || source == 15) {
            return true;
        }
        if (source == 635) {
            source = 517;
        }
        if ((targets = (int[])castingTable.get(source)) == null) {
            return false;
        }
        for (int i = 0; i < targets.length; ++i) {
            if (targets[i] != target) continue;
            return true;
        }
        return false;
    }

    public CastExpression(Expression source, AtomicType target, boolean allowEmpty) {
        super(source);
        this.allowEmpty = allowEmpty;
        this.targetType = target;
        this.targetPrimitiveType = (AtomicType)target.getPrimitiveItemType();
        this.derived = this.targetType.getFingerprint() != this.targetPrimitiveType.getFingerprint();
        this.adoptChildExpression(source);
    }

    public AtomicType getTargetPrimitiveType() {
        return this.targetPrimitiveType;
    }

    public AtomicType getTargetType() {
        return this.targetType;
    }

    public boolean allowsEmpty() {
        return this.allowEmpty;
    }

    public boolean targetIsDerived() {
        return this.derived;
    }

    public boolean isUpCast() {
        return this.upcast;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        StaticContext env = visitor.getStaticContext();
        if (this.targetType instanceof BuiltInAtomicType && !env.isAllowedBuiltInType((BuiltInAtomicType)this.targetType)) {
            XPathException err = new XPathException("The type " + this.targetType.getDisplayName() + " is not recognized by a Basic XSLT Processor", this);
            err.setErrorCode("XPST0080");
            err.setIsStaticError(true);
            throw err;
        }
        this.operand = visitor.simplify(this.operand);
        if (Literal.isAtomic(this.operand)) {
            return this.typeCheck(visitor, Type.ITEM_TYPE);
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        int p;
        ItemType sourceType;
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        SequenceType atomicType = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, this.getCardinality());
        RoleLocator role = new RoleLocator(2, (Serializable)((Object)"cast as"), 0);
        this.operand = TypeChecker.staticTypeCheck(this.operand, atomicType, false, role, visitor);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (th.isSubType(sourceType = this.operand.getItemType(th), this.targetType)) {
            this.upcast = true;
            return this;
        }
        if (this.operand instanceof Literal) {
            Value literalOperand = ((Literal)this.operand).getValue();
            if (literalOperand instanceof AtomicValue) {
                AtomicValue av = (AtomicValue)this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext());
                if (av instanceof StringValue) {
                    return new StringLiteral((StringValue)av);
                }
                return new Literal(av);
            }
            if (literalOperand instanceof EmptySequence) {
                if (this.allowEmpty) {
                    return this.operand;
                }
                XPathException err = new XPathException("Cast can never succeed: the operand must not be an empty sequence");
                err.setErrorCode("XPTY0004");
                err.setLocator(this);
                err.setIsTypeError(true);
                throw err;
            }
        }
        if (!CastExpression.isPossibleCast(p = sourceType.getPrimitiveType(), this.targetType.getPrimitiveType())) {
            XPathException err = new XPathException("Casting from " + sourceType + " to " + this.targetType + " can never succeed");
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
        return this;
    }

    public int computeCardinality() {
        return this.allowEmpty & Cardinality.allowsZero(this.operand.getCardinality()) ? 24576 : 16384;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.targetType;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy() {
        return new CastExpression(this.getBaseExpression().copy(), this.targetType, this.allowEmpty);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue value = (AtomicValue)this.operand.evaluateItem(context);
        if (value == null) {
            if (this.allowEmpty) {
                return null;
            }
            XPathException e = new XPathException("Cast does not allow an empty sequence");
            e.setXPathContext(context);
            e.setLocator(this);
            e.setErrorCode("XPTY0004");
            throw e;
        }
        if (this.upcast) {
            AtomicValue result = (AtomicValue)value.convert(this.targetPrimitiveType, false, context);
            if (this.derived) {
                result = (AtomicValue)result.convert(this.targetType, false, context);
            }
            return result;
        }
        ConversionResult result = value.convert(this.targetType, true, context);
        if (result instanceof ValidationFailure) {
            ValidationFailure err = (ValidationFailure)result;
            String code = err.getErrorCode();
            if (code == null) {
                code = "FORG0001";
            }
            this.dynamicError(err.getMessage(), code, context);
            return null;
        }
        return (AtomicValue)result;
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.targetType == ((CastExpression)other).targetType && this.allowEmpty == ((CastExpression)other).allowEmpty;
    }

    public String toString() {
        try {
            NamePool pool = this.getExecutable().getConfiguration().getNamePool();
            return this.targetType.toString(pool) + "(" + this.operand.toString() + ")";
        }
        catch (Exception err) {
            return this.targetType.toString() + "(" + this.operand.toString() + ")";
        }
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("cast");
        out.emitAttribute("as", this.targetType.toString(out.getConfiguration().getNamePool()));
        this.operand.explain(out);
        out.endElement();
    }

    public static AtomicValue castStringToQName(CharSequence operand, AtomicType targetType, StaticContext env) throws XPathException {
        try {
            String uri;
            CharSequence arg = Whitespace.trimWhitespace(operand);
            String[] parts = env.getConfiguration().getNameChecker().getQNameParts(arg);
            if (parts[0].length() == 0) {
                uri = env.getDefaultElementNamespace();
            } else {
                try {
                    uri = env.getURIForPrefix(parts[0]);
                }
                catch (XPathException e) {
                    uri = null;
                }
                if (uri == null) {
                    e = new XPathException("Prefix '" + parts[0] + "' has not been declared");
                    e.setErrorCode("FONS0004");
                    throw e;
                }
            }
            NameChecker checker = env.getConfiguration().getNameChecker();
            TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
            if (targetType.getFingerprint() == 530) {
                return new QNameValue(parts[0], uri, parts[1], BuiltInAtomicType.QNAME, checker);
            }
            if (th.isSubType(targetType, BuiltInAtomicType.QNAME)) {
                QNameValue q = new QNameValue(parts[0], uri, parts[1], targetType, checker);
                ValidationFailure vf = targetType.validate(q, null, checker);
                if (vf != null) {
                    throw vf.makeException();
                }
                q.setTypeLabel(targetType);
                return q;
            }
            NotationValue n = new NotationValue(parts[0], uri, parts[1], checker);
            ValidationFailure vf = targetType.validate(n, null, checker);
            if (vf != null) {
                throw vf.makeException();
            }
            n.setTypeLabel(targetType);
            return n;
        }
        catch (XPathException err) {
            if (err.getErrorCodeLocalPart() == null) {
                err.setErrorCode("FONS0004");
            }
            throw err;
        }
        catch (QNameException err) {
            XPathException e = new XPathException(err);
            e.setErrorCode("FORG0001");
            throw e;
        }
    }

    static {
        int uat = 631;
        int str = 513;
        int flt = 516;
        int dbl = 517;
        int dec = 515;
        int ing = 532;
        int dur = 518;
        int ymd = 633;
        int dtd = 634;
        int dtm = 519;
        int tim = 520;
        int dat = 521;
        int gym = 522;
        int gyr = 523;
        int gmd = 524;
        int gdy = 525;
        int gmo = 526;
        int boo = 514;
        int b64 = 528;
        int hxb = 527;
        int uri = 529;
        int qnm = 530;
        int not = 531;
        int[] t01 = new int[]{631, 513, 516, 517, 515, 532, 518, 633, 634, 519, 520, 521, 522, 523, 524, 525, 526, 514, 528, 527, 529};
        CastExpression.addAllowedCasts(631, t01);
        int[] t02 = new int[]{631, 513, 516, 517, 515, 532, 518, 633, 634, 519, 520, 521, 522, 523, 524, 525, 526, 514, 528, 527, 529, 530, 531};
        CastExpression.addAllowedCasts(513, t02);
        int[] t03 = new int[]{631, 513, 516, 517, 515, 532, 514};
        CastExpression.addAllowedCasts(516, t03);
        CastExpression.addAllowedCasts(517, t03);
        CastExpression.addAllowedCasts(515, t03);
        CastExpression.addAllowedCasts(532, t03);
        int[] t04 = new int[]{631, 513, 518, 633, 634};
        CastExpression.addAllowedCasts(518, t04);
        CastExpression.addAllowedCasts(633, t04);
        CastExpression.addAllowedCasts(634, t04);
        int[] t05 = new int[]{631, 513, 519, 520, 521, 522, 523, 524, 525, 526};
        CastExpression.addAllowedCasts(519, t05);
        int[] t06 = new int[]{631, 513, 520};
        CastExpression.addAllowedCasts(520, t06);
        int[] t07 = new int[]{631, 513, 519, 521, 522, 523, 524, 525, 526};
        CastExpression.addAllowedCasts(521, t07);
        int[] t08 = new int[]{631, 513, 522};
        CastExpression.addAllowedCasts(522, t08);
        int[] t09 = new int[]{631, 513, 523};
        CastExpression.addAllowedCasts(523, t09);
        int[] t10 = new int[]{631, 513, 524};
        CastExpression.addAllowedCasts(524, t10);
        int[] t11 = new int[]{631, 513, 525};
        CastExpression.addAllowedCasts(525, t11);
        int[] t12 = new int[]{631, 513, 526};
        CastExpression.addAllowedCasts(526, t12);
        int[] t13 = new int[]{631, 513, 516, 517, 515, 532, 514};
        CastExpression.addAllowedCasts(514, t13);
        int[] t14 = new int[]{631, 513, 528, 527};
        CastExpression.addAllowedCasts(528, t14);
        CastExpression.addAllowedCasts(527, t14);
        int[] t15 = new int[]{631, 513, 529};
        CastExpression.addAllowedCasts(529, t15);
        int[] t16 = new int[]{631, 513, 530};
        CastExpression.addAllowedCasts(530, t16);
        int[] t17 = new int[]{631, 513, 531};
        CastExpression.addAllowedCasts(531, t17);
    }
}

