<?php

declare(strict_types=1);

/*
 * Copyright (c) 2017-2023 François Kooman <fkooman@tuxed.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/**
 * Decode a token as used by this OAuth Server.
 *
 * @see TOKEN_FORMAT.md
 */
try {
    $payloadOnly = false;
    $tokenToParse = null;
    foreach ($argv as $arg) {
        if ('--payload' === $arg) {
            $payloadOnly = true;

            continue;
        }
        $tokenToParse = $arg;
    }

    if (null === $tokenToParse) {
        throw new Exception('no token provided');
    }

    $explodedToken = explode('.', $tokenToParse, 4);
    if (4 !== count($explodedToken)) {
        throw new Exception('invalid token');
    }

    [$tokenVersion, $keyId, $tokenPayload,] = explode('.', $tokenToParse);
    $tokenPayload = sodium_base642bin($tokenPayload, SODIUM_BASE64_VARIANT_URLSAFE_NO_PADDING);
    if (!$payloadOnly) {
        echo 'Version' . PHP_EOL . "\t" . $tokenVersion . PHP_EOL;
        echo 'Key ID' . PHP_EOL . "\t" . $keyId . PHP_EOL;
        echo 'Payload' . PHP_EOL . "\t" . $tokenPayload . PHP_EOL;

        exit(0);
    }

    echo $tokenPayload;
} catch (Exception $e) {
    echo 'ERROR: ' . $e->getMessage() . PHP_EOL;
    exit(1);
}
