"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityAnalyticsPlugin = void 0;
var _createSecurityAnalyticsCluster = require("./clusters/createSecurityAnalyticsCluster");
var _routes = require("./routes");
var _MetricsRoutes = require("./routes/MetricsRoutes");
var _services = require("./services");
var _LogTypeService = require("./services/LogTypeService");
var _MetricsService = _interopRequireDefault(require("./services/MetricsService"));
var _securityAnalyticsPlugin = require("./clusters/securityAnalyticsPlugin");
var _ThreatIntelService = _interopRequireDefault(require("./services/ThreatIntelService"));
var _ThreatIntel = require("./routes/ThreatIntel");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class SecurityAnalyticsPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
  }
  async setup(core, {
    dataSource
  }) {
    // Create OpenSearch client that aware of SA API endpoints
    const securityAnalyticsClient = (0, _createSecurityAnalyticsCluster.createSecurityAnalyticsCluster)(core);
    const dataSourceEnabled = !!dataSource;
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_securityAnalyticsPlugin.securityAnalyticsPlugin);
    }

    // Initialize services
    const services = {
      detectorsService: new _services.DetectorService(securityAnalyticsClient, dataSourceEnabled),
      correlationService: new _services.CorrelationService(securityAnalyticsClient, dataSourceEnabled),
      indexService: new _services.IndexService(securityAnalyticsClient, dataSourceEnabled),
      findingsService: new _services.FindingsService(securityAnalyticsClient, dataSourceEnabled),
      opensearchService: new _services.OpenSearchService(securityAnalyticsClient, dataSourceEnabled),
      fieldMappingService: new _services.FieldMappingService(securityAnalyticsClient, dataSourceEnabled),
      alertService: new _services.AlertService(securityAnalyticsClient, dataSourceEnabled),
      rulesService: new _services.RulesService(securityAnalyticsClient, dataSourceEnabled),
      notificationsService: new _services.NotificationsService(securityAnalyticsClient, dataSourceEnabled),
      logTypeService: new _LogTypeService.LogTypeService(securityAnalyticsClient, dataSourceEnabled),
      metricsService: new _MetricsService.default(),
      threatIntelService: new _ThreatIntelService.default(securityAnalyticsClient, dataSourceEnabled)
    };

    // Create router
    const router = core.http.createRouter();

    // setup routes
    (0, _routes.setupDetectorRoutes)(services, router);
    (0, _routes.setupCorrelationRoutes)(services, router);
    (0, _routes.setupIndexRoutes)(services, router);
    (0, _routes.setupFindingsRoutes)(services, router);
    (0, _routes.setupOpensearchRoutes)(services, router);
    (0, _routes.setupFieldMappingRoutes)(services, router);
    (0, _routes.setupAlertsRoutes)(services, router);
    (0, _routes.setupRulesRoutes)(services, router);
    (0, _routes.setupNotificationsRoutes)(services, router);
    (0, _routes.setupLogTypeRoutes)(services, router);
    (0, _MetricsRoutes.setupMetricsRoutes)(services, router);
    (0, _ThreatIntel.setupThreatIntelRoutes)(services, router);

    // @ts-ignore
    const config$ = this.initializerContext.config.create();
    return {
      config$
    };
  }
  async start(_core) {
    return {};
  }
}
exports.SecurityAnalyticsPlugin = SecurityAnalyticsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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