/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Fcntl;
import jnr.enxio.channels.NativeDeviceChannel;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import org.jruby.RubyFile;
import org.jruby.platform.Platform;
import org.jruby.util.AppendModeChannel;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.ResourceException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.PosixShim;

class RegularFileResource
implements FileResource {
    private final JRubyFile file;
    private final String filePath;
    private final POSIX posix;
    private transient BasicFileAttributes fileAttributes;

    RegularFileResource(POSIX posix, JRubyFile file2, String filePath) {
        this.file = file2;
        this.filePath = filePath;
        this.posix = posix;
    }

    protected RegularFileResource(POSIX posix, String filename2) {
        this.file = new JRubyFile(filename2);
        this.filePath = filename2;
        this.posix = posix;
    }

    @Override
    public String absolutePath() {
        return RubyFile.canonicalize(this.file.getAbsolutePath());
    }

    @Override
    public String canonicalPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException ioError) {
            return this.file.getAbsolutePath();
        }
    }

    @Override
    public String path() {
        return this.file.getPath();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    public FileTime lastModifiedTime() throws IOException {
        return FileTime.fromMillis(this.file.lastModified());
    }

    public FileTime lastAccessTime() throws IOException {
        return this.readAttributes().lastAccessTime();
    }

    public FileTime creationTime() throws IOException {
        return this.readAttributes().creationTime();
    }

    private BasicFileAttributes readAttributes() throws IOException {
        if (this.fileAttributes != null) {
            return this.fileAttributes;
        }
        Path path2 = FileSystems.getDefault().getPath(this.file.getPath(), new String[0]);
        this.fileAttributes = Files.readAttributes(path2, BasicFileAttributes.class, new LinkOption[0]);
        return this.fileAttributes;
    }

    @Override
    public boolean exists() {
        if (this.file.exists()) {
            String path2 = this.filePath;
            return path2.length() <= 1 || path2.charAt(path2.length() - 1) != '/' || (path2 = this.file.getPathDefault()).length() <= 0 || path2.charAt(path2.length() - 1) == '/' || this.isDirectory();
        }
        return false;
    }

    @Override
    public boolean canExecute() {
        return this.file.canExecute();
    }

    @Override
    public int errno() {
        return this.posix.errno();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isSymLink() {
        try {
            BasicFileAttributes attrs = Files.readAttributes(this.file.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            return attrs != null && attrs.isSymbolicLink();
        }
        catch (IOException | SecurityException | UnsupportedOperationException ex) {
            return false;
        }
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.file.canWrite();
    }

    @Override
    public String[] list() {
        String[] fileList = this.file.list();
        if (fileList == null) {
            return null;
        }
        String[] list2 = new String[fileList.length + 2];
        list2[0] = ".";
        list2[1] = "..";
        System.arraycopy(fileList, 0, list2, 2, fileList.length);
        return list2;
    }

    @Override
    public FileStat stat() {
        FileStat stat2 = this.posix.allocateStat();
        return this.posix.stat(this.file.getAbsolutePath(), stat2) < 0 ? null : stat2;
    }

    @Override
    public FileStat lstat() {
        FileStat stat2 = this.posix.allocateStat();
        String absolutePath = this.file.getAbsolutePath();
        if (!Platform.IS_WINDOWS && this.isSymLink() && this.filePath.endsWith("/")) {
            absolutePath = absolutePath + "/";
        }
        return this.posix.lstat(absolutePath, stat2) < 0 ? null : stat2;
    }

    public String toString() {
        return this.file.toString();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (!this.exists()) {
            throw new ResourceException.NotFound(this.absolutePath());
        }
        if (this.isDirectory()) {
            throw new ResourceException.FileIsDirectory(this.absolutePath());
        }
        return new FileInputStream(this.file);
    }

    @Override
    public Channel openChannel(int flags2, int perm) throws IOException {
        ModeFlags modeFlags = ModeFlags.createModeFlags(flags2);
        if (this.posix.isNative() && !Platform.IS_WINDOWS) {
            int fd = this.posix.open(this.absolutePath(), modeFlags.getFlags(), perm);
            if (fd < 0) {
                this.throwFromErrno(this.posix.errno());
            }
            this.posix.fcntlInt(fd, Fcntl.F_SETFD, this.posix.fcntl(fd, Fcntl.F_GETFD) | 1);
            return new NativeDeviceChannel(fd, true);
        }
        if (modeFlags.isCreate()) {
            boolean fileCreated;
            try {
                fileCreated = this.file.createNewFile();
            }
            catch (IOException ioe) {
                File parent = this.file.getParentFile();
                if (parent != null && parent != this.file && !parent.exists()) {
                    throw new ResourceException.NotFound(this.absolutePath());
                }
                if (!this.file.canWrite()) {
                    throw new ResourceException.PermissionDenied(this.absolutePath());
                }
                throw ioe;
            }
            if (!fileCreated && modeFlags.isExclusive()) {
                throw new ResourceException.FileExists(this.absolutePath());
            }
            Channel channel = this.createChannel(modeFlags);
            if (fileCreated && this.posix != null && (perm &= ~PosixShim.umask(this.posix)) > 0) {
                this.posix.chmod(this.file.getPath(), perm);
            }
            return channel;
        }
        if (this.file.isDirectory()) {
            throw new ResourceException.FileIsDirectory(this.absolutePath());
        }
        if (!this.file.exists() && !JRubyFile.isComPort(this.file.getPath())) {
            throw new ResourceException.NotFound(this.absolutePath());
        }
        return this.createChannel(modeFlags);
    }

    private Channel createChannel(ModeFlags flags2) throws IOException {
        SeekableByteChannel fileChannel;
        boolean addAppendChannel;
        block7: {
            addAppendChannel = false;
            try {
                try {
                    if (flags2.isReadWrite() && flags2.isAppendable()) {
                        addAppendChannel = true;
                    }
                    fileChannel = Files.newByteChannel(this.file.toPath(), flags2.toOpenOptions(!addAppendChannel, true));
                }
                catch (IOException ioe) {
                    if (flags2.isTruncate() && "Illegal seek".equals(ioe.getMessage())) {
                        fileChannel = Files.newByteChannel(this.file.toPath(), flags2.toOpenOptions(!addAppendChannel, false));
                        break block7;
                    }
                    throw ioe;
                }
            }
            catch (FileNotFoundException ex) {
                throw RegularFileResource.mapFileNotFoundOnGetChannel(this, ex);
            }
        }
        if (addAppendChannel) {
            fileChannel = new AppendModeChannel((FileChannel)fileChannel);
        }
        return fileChannel;
    }

    @Override
    public <T> T unwrap(Class<T> type2) {
        if (type2 == File.class || type2 == JRubyFile.class) {
            return (T)this.file;
        }
        throw new UnsupportedOperationException("unwrap: " + type2.getName());
    }

    static IOException mapFileNotFoundOnGetChannel(FileResource file2, FileNotFoundException ex) {
        return file2.exists() ? new ResourceException.PermissionDenied(file2.absolutePath()) : new ResourceException.NotFound(file2.absolutePath());
    }

    private void throwFromErrno(int err) throws IOException {
        Errno errno2 = Errno.valueOf(err);
        switch (errno2) {
            case EACCES: {
                throw new ResourceException.PermissionDenied(this.absolutePath());
            }
            case EEXIST: {
                throw new ResourceException.FileExists(this.absolutePath());
            }
            case EINVAL: {
                throw new ResourceException.InvalidArguments(this.absolutePath());
            }
            case ENOENT: {
                throw new ResourceException.NotFound(this.absolutePath());
            }
            case ELOOP: {
                throw new ResourceException.TooManySymlinks(this.absolutePath());
            }
            case EISDIR: {
                throw new ResourceException.FileIsDirectory(this.absolutePath());
            }
            case ENOTDIR: {
                throw new ResourceException.FileIsNotDirectory(this.absolutePath());
            }
        }
        throw new ResourceException.ErrnoException(errno2, this.absolutePath());
    }
}

