/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.services.Bundle;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.UpdateUnitImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.openide.modules.ModuleInfo;

public class ModuleUpdateUnitImpl
extends UpdateUnitImpl {
    private UpdateUnit visibleAncestor;
    private static String BROAD_CATEGORY = Bundle.broad_category();

    public ModuleUpdateUnitImpl(String string) {
        super(string);
    }

    @Override
    public UpdateManager.TYPE getType() {
        return UpdateManager.TYPE.MODULE;
    }

    @Override
    public boolean isPending() {
        return UpdateUnitFactory.getDefault().isScheduledForRestart(this.getUpdateUnit());
    }

    @Override
    public UpdateUnit getVisibleAncestor() {
        if (this.visibleAncestor == null) {
            assert (this.getInstalled() != null) : this + " is installed";
            ModuleUpdateElementImpl moduleUpdateElementImpl = (ModuleUpdateElementImpl)Trampoline.API.impl(this.getInstalled());
            TreeSet<Module> treeSet = new TreeSet<Module>(new Comparator<Module>(){

                @Override
                public int compare(Module module, Module module2) {
                    return module.getCodeNameBase().compareTo(module2.getCodeNameBase());
                }
            });
            HashSet<Module> hashSet = new HashSet<Module>();
            for (ModuleInfo object2 : moduleUpdateElementImpl.getModuleInfos()) {
                treeSet.addAll(ModuleUpdateUnitImpl.findVisibleAncestor(Utilities.toModule(object2), hashSet));
            }
            Object object3 = moduleUpdateElementImpl.getCategory();
            String string = moduleUpdateElementImpl.getInstallationCluster();
            if (BROAD_CATEGORY.contains((CharSequence)object3)) {
                object3 = null;
            }
            UpdateUnit updateUnit = null;
            UpdateUnit updateUnit2 = null;
            UpdateUnit updateUnit3 = null;
            for (Module module : treeSet) {
                this.visibleAncestor = Utilities.toUpdateUnit(module);
                UpdateElementImpl updateElementImpl = Trampoline.API.impl(this.visibleAncestor.getInstalled());
                String string2 = null;
                String string3 = null;
                if (updateElementImpl instanceof ModuleUpdateElementImpl) {
                    string2 = ((ModuleUpdateElementImpl)updateElementImpl).getInstallationCluster();
                    string3 = updateElementImpl.getCategory();
                }
                if (string != null && string.equals(string2)) {
                    updateUnit2 = this.visibleAncestor;
                    continue;
                }
                if (string3 != null && string3.equals(object3)) {
                    updateUnit3 = this.visibleAncestor;
                    break;
                }
                if (updateUnit != null) continue;
                updateUnit = this.visibleAncestor;
            }
            UpdateUnit updateUnit4 = updateUnit3 != null ? updateUnit3 : (this.visibleAncestor = updateUnit2 != null ? updateUnit2 : updateUnit);
            if (this.visibleAncestor == null && string != null) {
                for (UpdateElement updateElement : UpdateManagerImpl.getInstance().getInstalledKits(string)) {
                    this.visibleAncestor = updateElement.getUpdateUnit();
                    if (!moduleUpdateElementImpl.getRawCategory().equals(updateElement.getCategory())) continue;
                    this.visibleAncestor = updateElement.getUpdateUnit();
                    break;
                }
            }
        }
        return this.visibleAncestor;
    }

    private static Set<Module> findVisibleAncestor(Module module, Set<Module> set) {
        if (!set.add(module)) {
            return Collections.emptySet();
        }
        HashSet<Module> hashSet = new HashSet<Module>();
        ModuleManager moduleManager = module.getManager();
        Set set2 = moduleManager.getModuleInterdependencies(module, !module.isEager(), false, true);
        for (Module module2 : set2) {
            if (!module2.isEnabled() || !Utilities.isKitModule((ModuleInfo)module2)) continue;
            hashSet.add(module2);
        }
        if (hashSet.isEmpty()) {
            for (Module module2 : set2) {
                if (!module2.isEnabled()) continue;
                assert (!module.equals(module2)) : module2 + " cannot depend on itself.";
                if (module.equals(module2)) continue;
                hashSet.addAll(ModuleUpdateUnitImpl.findVisibleAncestor(module2, set));
                if (hashSet.isEmpty()) continue;
                break;
            }
        }
        TreeSet<Module> treeSet = new TreeSet<Module>(new Comparator<Module>(){

            @Override
            public int compare(Module module, Module module2) {
                return module.getCodeNameBase().compareTo(module2.getCodeNameBase());
            }
        });
        treeSet.addAll(hashSet);
        return treeSet;
    }
}

