/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataShadow;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

final class BrokenDataShadow
extends MultiDataObject {
    private URL url;
    private static final boolean CHECK_ONLY_DEFAULT = Boolean.getBoolean("org.openide.loaders.BrokenDataShadow.CHECK_ONLY_DEFAULT");
    private static Map<String, Set<Reference<BrokenDataShadow>>> allDataShadows;
    private static final long serialVersionUID = -3046981691235483810L;

    public BrokenDataShadow(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        try {
            this.url = DataShadow.readURL(fileObject);
        }
        catch (IOException iOException) {
            try {
                this.url = new URL("file", null, "/UNKNOWN");
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger(BrokenDataShadow.class.getName()).log(Level.WARNING, null, malformedURLException);
            }
        }
        BrokenDataShadow.enqueueBrokenDataShadow(this);
    }

    @Override
    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    static synchronized Map<String, Set<Reference<BrokenDataShadow>>> getDataShadowsSet() {
        if (allDataShadows == null) {
            allDataShadows = new HashMap<String, Set<Reference<BrokenDataShadow>>>();
        }
        return allDataShadows;
    }

    private static synchronized void enqueueBrokenDataShadow(BrokenDataShadow brokenDataShadow) {
        Map<String, Set<Reference<BrokenDataShadow>>> map = BrokenDataShadow.getDataShadowsSet();
        String string = brokenDataShadow.getUrl().toExternalForm();
        DataShadow.DSWeakReference<BrokenDataShadow> dSWeakReference = new DataShadow.DSWeakReference<BrokenDataShadow>(brokenDataShadow);
        Set<Reference<BrokenDataShadow>> set = map.get(string);
        if (set == null) {
            set = Collections.singleton(dSWeakReference);
            BrokenDataShadow.getDataShadowsSet().put(string, set);
        } else {
            if (!(set instanceof HashSet)) {
                set = new HashSet<Reference<BrokenDataShadow>>(set);
                BrokenDataShadow.getDataShadowsSet().put(string, set);
            }
            set.add(dSWeakReference);
        }
    }

    private static synchronized List<BrokenDataShadow> getAllDataShadows() {
        if (allDataShadows == null || allDataShadows.isEmpty()) {
            return null;
        }
        ArrayList<BrokenDataShadow> arrayList = new ArrayList<BrokenDataShadow>(allDataShadows.size());
        for (Set<Reference<BrokenDataShadow>> set : allDataShadows.values()) {
            for (Reference<BrokenDataShadow> reference : set) {
                BrokenDataShadow brokenDataShadow = reference.get();
                if (brokenDataShadow == null) continue;
                arrayList.add(brokenDataShadow);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkValidity(EventObject eventObject) {
        Object object = BrokenDataShadow.class;
        synchronized (BrokenDataShadow.class) {
            String string;
            FileObject fileObject;
            if (allDataShadows == null || allDataShadows.isEmpty()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = null;
            if (eventObject instanceof OperationEvent) {
                object = ((OperationEvent)eventObject).getObject();
            }
            if (object != null) {
                fileObject = ((DataObject)object).getPrimaryFile();
            } else if (eventObject instanceof FileEvent) {
                fileObject = ((FileEvent)eventObject).getFile();
            } else {
                return;
            }
            if (!BrokenDataShadow.canCheckValidity(fileObject)) {
                return;
            }
            try {
                string = fileObject.getURL().toExternalForm();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return;
            }
            Set<Reference<BrokenDataShadow>> set = null;
            Object object2 = BrokenDataShadow.class;
            synchronized (BrokenDataShadow.class) {
                if (allDataShadows == null || allDataShadows.isEmpty()) {
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    return;
                }
                if (object != null && (set = allDataShadows.get(string)) == null) {
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var5_7] (shouldn't be in output)
                object2 = BrokenDataShadow.getAllDataShadows();
                if (object2 == null) {
                    return;
                }
                int n = object2.size();
                for (int i = 0; i < n; ++i) {
                    Object e = object2.get(i);
                    ((BrokenDataShadow)e).refresh();
                }
                return;
            }
        }
    }

    private static boolean canCheckValidity(FileObject fileObject) {
        if (CHECK_ONLY_DEFAULT) {
            try {
                return fileObject.getFileSystem().isDefault();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                DataObject.LOG.log(Level.WARNING, fileStateInvalidException.toString(), fileStateInvalidException);
                return false;
            }
        }
        return true;
    }

    private BrokenDataShadow(FileObject fileObject) throws DataObjectExistsException {
        this(fileObject, DataLoaderPool.getShadowLoader());
    }

    @Override
    public boolean isDeleteAllowed() {
        return this.getPrimaryFile().canWrite();
    }

    public void refresh() {
        try {
            if (URLMapper.findFileObject((URL)this.getUrl()) != null) {
                this.setValid(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    @Override
    public boolean isCopyAllowed() {
        return true;
    }

    @Override
    public boolean isMoveAllowed() {
        return this.getPrimaryFile().canWrite();
    }

    @Override
    public boolean isRenameAllowed() {
        return this.getPrimaryFile().canWrite();
    }

    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    @Override
    protected Node createNodeDelegate() {
        return new BrokenShadowNode(this);
    }

    URL getUrl() {
        return this.url;
    }

    private static final class BrokenShadowNode
    extends DataNode {
        private static MessageFormat format;
        private Sheet sheet;
        private static final String ICON_NAME = "org/openide/loaders/brokenShadow.gif";

        public BrokenShadowNode(BrokenDataShadow brokenDataShadow) {
            super(brokenDataShadow, Children.LEAF);
            this.setIconBaseWithExtension(ICON_NAME);
        }

        @Override
        public String getDisplayName() {
            if (format == null) {
                format = new MessageFormat(DataObject.getString("FMT_brokenShadowName"));
            }
            return format.format(this.createArguments());
        }

        @Override
        public Action[] getActions(boolean bl) {
            return new Action[]{SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
        }

        public Node.PropertySet[] getPropertySets() {
            if (this.sheet == null) {
                this.sheet = this.cloneSheet();
            }
            return this.sheet.toArray();
        }

        private Sheet cloneSheet() {
            Node.PropertySet[] propertySetArray = super.getPropertySets();
            Sheet sheet = new Sheet();
            for (int i = 0; i < propertySetArray.length; ++i) {
                Sheet.Set set = new Sheet.Set();
                set.put(propertySetArray[i].getProperties());
                set.setName(propertySetArray[i].getName());
                set.setDisplayName(propertySetArray[i].getDisplayName());
                set.setShortDescription(propertySetArray[i].getShortDescription());
                this.modifySheetSet(set);
                sheet.put(set);
            }
            return sheet;
        }

        private void modifySheetSet(Sheet.Set set) {
            Object object = set.remove("name");
            if (object != null) {
                object = new PropertySupport.Name((Node)this);
                set.put(object);
                object = new Name();
                set.put(object);
            }
        }

        private Object[] createArguments() {
            return new Object[]{this.getDataObject().getName()};
        }

        private final class Name
        extends PropertySupport.ReadWrite<String> {
            public Name() {
                super("BrokenLink", String.class, DataObject.getString("PROP_brokenShadowOriginalName"), DataObject.getString("HINT_brokenShadowOriginalName"));
            }

            public String getValue() {
                BrokenDataShadow brokenDataShadow = (BrokenDataShadow)BrokenShadowNode.this.getDataObject();
                return brokenDataShadow.getUrl().toExternalForm();
            }

            public void setValue(String string) {
                BrokenDataShadow brokenDataShadow = (BrokenDataShadow)BrokenShadowNode.this.getDataObject();
                try {
                    URL uRL = new URL(string);
                    DataShadow.writeOriginal(brokenDataShadow.getPrimaryFile(), uRL);
                    brokenDataShadow.url = uRL;
                }
                catch (IOException iOException) {
                    throw (IllegalArgumentException)new IllegalArgumentException(iOException.toString()).initCause(iOException);
                }
                brokenDataShadow.refresh();
            }
        }
    }
}

