/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.model.ECDSASignatureAlgorithm;

public class GenerateECDSASignatureKeyOutput {
    private final ECDSASignatureAlgorithm signatureAlgorithm;
    private final ByteBuffer verificationKey;
    private final ByteBuffer signingKey;

    protected GenerateECDSASignatureKeyOutput(BuilderImpl builder) {
        this.signatureAlgorithm = builder.signatureAlgorithm();
        this.verificationKey = builder.verificationKey();
        this.signingKey = builder.signingKey();
    }

    public ECDSASignatureAlgorithm signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public ByteBuffer verificationKey() {
        return this.verificationKey;
    }

    public ByteBuffer signingKey() {
        return this.signingKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ECDSASignatureAlgorithm signatureAlgorithm;
        protected ByteBuffer verificationKey;
        protected ByteBuffer signingKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GenerateECDSASignatureKeyOutput model) {
            this.signatureAlgorithm = model.signatureAlgorithm();
            this.verificationKey = model.verificationKey();
            this.signingKey = model.signingKey();
        }

        @Override
        public Builder signatureAlgorithm(ECDSASignatureAlgorithm signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        @Override
        public ECDSASignatureAlgorithm signatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        @Override
        public Builder verificationKey(ByteBuffer verificationKey) {
            this.verificationKey = verificationKey;
            return this;
        }

        @Override
        public ByteBuffer verificationKey() {
            return this.verificationKey;
        }

        @Override
        public Builder signingKey(ByteBuffer signingKey) {
            this.signingKey = signingKey;
            return this;
        }

        @Override
        public ByteBuffer signingKey() {
            return this.signingKey;
        }

        @Override
        public GenerateECDSASignatureKeyOutput build() {
            if (Objects.isNull((Object)this.signatureAlgorithm())) {
                throw new IllegalArgumentException("Missing value for required field `signatureAlgorithm`");
            }
            if (Objects.isNull(this.verificationKey())) {
                throw new IllegalArgumentException("Missing value for required field `verificationKey`");
            }
            if (Objects.isNull(this.signingKey())) {
                throw new IllegalArgumentException("Missing value for required field `signingKey`");
            }
            return new GenerateECDSASignatureKeyOutput(this);
        }
    }

    public static interface Builder {
        public Builder signatureAlgorithm(ECDSASignatureAlgorithm var1);

        public ECDSASignatureAlgorithm signatureAlgorithm();

        public Builder verificationKey(ByteBuffer var1);

        public ByteBuffer verificationKey();

        public Builder signingKey(ByteBuffer var1);

        public ByteBuffer signingKey();

        public GenerateECDSASignatureKeyOutput build();
    }
}

