/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class RawPrivateKeyToStaticPublicKeyInput {
    private final ByteBuffer senderStaticPrivateKey;
    private final ByteBuffer recipientPublicKey;

    protected RawPrivateKeyToStaticPublicKeyInput(BuilderImpl builder) {
        this.senderStaticPrivateKey = builder.senderStaticPrivateKey();
        this.recipientPublicKey = builder.recipientPublicKey();
    }

    public ByteBuffer senderStaticPrivateKey() {
        return this.senderStaticPrivateKey;
    }

    public ByteBuffer recipientPublicKey() {
        return this.recipientPublicKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer senderStaticPrivateKey;
        protected ByteBuffer recipientPublicKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(RawPrivateKeyToStaticPublicKeyInput model) {
            this.senderStaticPrivateKey = model.senderStaticPrivateKey();
            this.recipientPublicKey = model.recipientPublicKey();
        }

        @Override
        public Builder senderStaticPrivateKey(ByteBuffer senderStaticPrivateKey) {
            this.senderStaticPrivateKey = senderStaticPrivateKey;
            return this;
        }

        @Override
        public ByteBuffer senderStaticPrivateKey() {
            return this.senderStaticPrivateKey;
        }

        @Override
        public Builder recipientPublicKey(ByteBuffer recipientPublicKey) {
            this.recipientPublicKey = recipientPublicKey;
            return this;
        }

        @Override
        public ByteBuffer recipientPublicKey() {
            return this.recipientPublicKey;
        }

        @Override
        public RawPrivateKeyToStaticPublicKeyInput build() {
            if (Objects.isNull(this.senderStaticPrivateKey())) {
                throw new IllegalArgumentException("Missing value for required field `senderStaticPrivateKey`");
            }
            if (Objects.isNull(this.recipientPublicKey())) {
                throw new IllegalArgumentException("Missing value for required field `recipientPublicKey`");
            }
            return new RawPrivateKeyToStaticPublicKeyInput(this);
        }
    }

    public static interface Builder {
        public Builder senderStaticPrivateKey(ByteBuffer var1);

        public ByteBuffer senderStaticPrivateKey();

        public Builder recipientPublicKey(ByteBuffer var1);

        public ByteBuffer recipientPublicKey();

        public RawPrivateKeyToStaticPublicKeyInput build();
    }
}

