/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.ClientSupplier;
import software.amazon.cryptography.materialproviders.IClientSupplier;
import software.amazon.cryptography.materialproviders.model.DiscoveryFilter;

public class CreateAwsKmsDiscoveryMultiKeyringInput {
    private final List<String> regions;
    private final DiscoveryFilter discoveryFilter;
    private final IClientSupplier clientSupplier;
    private final List<String> grantTokens;

    protected CreateAwsKmsDiscoveryMultiKeyringInput(BuilderImpl builder) {
        this.regions = builder.regions();
        this.discoveryFilter = builder.discoveryFilter();
        this.clientSupplier = builder.clientSupplier();
        this.grantTokens = builder.grantTokens();
    }

    public List<String> regions() {
        return this.regions;
    }

    public DiscoveryFilter discoveryFilter() {
        return this.discoveryFilter;
    }

    public IClientSupplier clientSupplier() {
        return this.clientSupplier;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected List<String> regions;
        protected DiscoveryFilter discoveryFilter;
        protected IClientSupplier clientSupplier;
        protected List<String> grantTokens;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateAwsKmsDiscoveryMultiKeyringInput model) {
            this.regions = model.regions();
            this.discoveryFilter = model.discoveryFilter();
            this.clientSupplier = model.clientSupplier();
            this.grantTokens = model.grantTokens();
        }

        @Override
        public Builder regions(List<String> regions) {
            this.regions = regions;
            return this;
        }

        @Override
        public List<String> regions() {
            return this.regions;
        }

        @Override
        public Builder discoveryFilter(DiscoveryFilter discoveryFilter) {
            this.discoveryFilter = discoveryFilter;
            return this;
        }

        @Override
        public DiscoveryFilter discoveryFilter() {
            return this.discoveryFilter;
        }

        @Override
        public Builder clientSupplier(IClientSupplier clientSupplier) {
            this.clientSupplier = ClientSupplier.wrap(clientSupplier);
            return this;
        }

        @Override
        public IClientSupplier clientSupplier() {
            return this.clientSupplier;
        }

        @Override
        public Builder grantTokens(List<String> grantTokens) {
            this.grantTokens = grantTokens;
            return this;
        }

        @Override
        public List<String> grantTokens() {
            return this.grantTokens;
        }

        @Override
        public CreateAwsKmsDiscoveryMultiKeyringInput build() {
            if (Objects.isNull(this.regions())) {
                throw new IllegalArgumentException("Missing value for required field `regions`");
            }
            return new CreateAwsKmsDiscoveryMultiKeyringInput(this);
        }
    }

    public static interface Builder {
        public Builder regions(List<String> var1);

        public List<String> regions();

        public Builder discoveryFilter(DiscoveryFilter var1);

        public DiscoveryFilter discoveryFilter();

        public Builder clientSupplier(IClientSupplier var1);

        public IClientSupplier clientSupplier();

        public Builder grantTokens(List<String> var1);

        public List<String> grantTokens();

        public CreateAwsKmsDiscoveryMultiKeyringInput build();
    }
}

